/* projects.c generated by valac 0.40.8, the Vala compiler
 * generated from projects.vala, do not modify */

/*
 * This file is part of GNOME LaTeX.
 *
 * Copyright © 2010-2011 Sébastien Wilmet
 *
 * GNOME LaTeX is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME LaTeX is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME LaTeX.  If not, see <http://www.gnu.org/licenses/>.
 */


#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <tepl/tepl.h>
#include <gobject/gvaluecollector.h>


#define TYPE_PROJECT (project_get_type ())
typedef struct _Project Project;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_PROJECTS (projects_get_type ())
#define PROJECTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROJECTS, Projects))
#define PROJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROJECTS, ProjectsClass))
#define IS_PROJECTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROJECTS))
#define IS_PROJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROJECTS))
#define PROJECTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROJECTS, ProjectsClass))

typedef struct _Projects Projects;
typedef struct _ProjectsClass ProjectsClass;
typedef struct _ProjectsPrivate ProjectsPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_markup_parse_context_unref0(var) ((var == NULL) ? NULL : (var = (g_markup_parse_context_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _projects_unref0(var) ((var == NULL) ? NULL : (var = (projects_unref (var), NULL)))

#define TYPE_GLATEX_APP (glatex_app_get_type ())
#define GLATEX_APP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GLATEX_APP, GlatexApp))
#define GLATEX_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GLATEX_APP, GlatexAppClass))
#define IS_GLATEX_APP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GLATEX_APP))
#define IS_GLATEX_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GLATEX_APP))
#define GLATEX_APP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GLATEX_APP, GlatexAppClass))

typedef struct _GlatexApp GlatexApp;
typedef struct _GlatexAppClass GlatexAppClass;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;
#define _project_free0(var) ((var == NULL) ? NULL : (var = (project_free (var), NULL)))

#define TYPE_DOCUMENT (document_get_type ())
#define DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT, Document))
#define DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT, DocumentClass))
#define IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT))
#define IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT))
#define DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT, DocumentClass))

typedef struct _Document Document;
typedef struct _DocumentClass DocumentClass;
typedef struct _ParamSpecProjects ParamSpecProjects;

struct _Project {
	GFile* directory;
	GFile* main_file;
};

struct _Projects {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ProjectsPrivate * priv;
};

struct _ProjectsClass {
	GTypeClass parent_class;
	void (*finalize) (Projects *self);
};

struct _ProjectsPrivate {
	GeeLinkedList* projects;
	gboolean modified;
};

struct _ParamSpecProjects {
	GParamSpec parent_instance;
};


static gpointer projects_parent_class = NULL;
static Projects* projects_instance;
static Projects* projects_instance = NULL;

GType project_get_type (void) G_GNUC_CONST;
Project* project_dup (const Project* self);
void project_free (Project* self);
void project_copy (const Project* self,
                   Project* dest);
void project_destroy (Project* self);
gpointer projects_ref (gpointer instance);
void projects_unref (gpointer instance);
GParamSpec* param_spec_projects (const gchar* name,
                                 const gchar* nick,
                                 const gchar* blurb,
                                 GType object_type,
                                 GParamFlags flags);
void value_set_projects (GValue* value,
                         gpointer v_object);
void value_take_projects (GValue* value,
                          gpointer v_object);
gpointer value_get_projects (const GValue* value);
GType projects_get_type (void) G_GNUC_CONST;
#define PROJECTS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PROJECTS, ProjectsPrivate))
static Projects* projects_new (void);
static Projects* projects_construct (GType object_type);
static GFile* projects_get_xml_file (Projects* self);
gchar* utils_load_file (GFile* file);
static void projects_parser_start (Projects* self,
                            GMarkupParseContext* context,
                            const gchar* name,
                            gchar** attr_names,
                            int attr_names_length1,
                            gchar** attr_values,
                            int attr_values_length1,
                            GError** error);
static void _projects_parser_start_gmarkup_parser_start_element_func (GMarkupParseContext* context,
                                                               const gchar* element_name,
                                                               gchar** attribute_names,
                                                               gchar** attribute_values,
                                                               gpointer self,
                                                               GError** error);
static void projects_update_all_documents (Projects* self);
static void projects_update_all_menus (Projects* self);
Projects* projects_get_default (void);
Project* projects_get (Projects* self,
                       gint id);
GeeIterator* projects_iterator (Projects* self);
GType glatex_app_get_type (void) G_GNUC_CONST;
GlatexApp* glatex_app_get_instance (void);
GType main_window_get_type (void) G_GNUC_CONST;
void main_window_update_config_project_sensitivity (MainWindow* self);
gboolean projects_add (Projects* self,
                       Project* new_project,
                       GFile* * conflict_file);
static gboolean projects_conflict (Projects* self,
                            GFile* dir1,
                            GFile* dir2);
GType document_get_type (void) G_GNUC_CONST;
GeeList* glatex_app_get_documents (GlatexApp* self);
gint document_get_project_id (Document* self);
GFile* document_get_location (Document* self);
void document_set_project_id (Document* self,
                              gint value);
gboolean projects_change_main_file (Projects* self,
                                    gint num,
                                    GFile* new_main_file);
void projects_delete (Projects* self,
                      gint num);
void projects_clear_all (Projects* self);
void projects_save (Projects* self);
void utils_delete_file (GFile* file);
gboolean utils_save_file (GFile* file,
                          const gchar* contents,
                          gboolean make_backup);
static void projects_finalize (Projects * obj);
static gint _vala_array_length (gpointer array);


static gpointer
_g_object_ref0 (gpointer self)
{
#line 22 "/home/seb/gnome/gnome-latex/src/projects.vala"
	return self ? g_object_ref (self) : NULL;
#line 197 "projects.c"
}


void
project_copy (const Project* self,
              Project* dest)
{
	GFile* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
#line 22 "/home/seb/gnome/gnome-latex/src/projects.vala"
	_tmp0_ = (*self).directory;
#line 22 "/home/seb/gnome/gnome-latex/src/projects.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 22 "/home/seb/gnome/gnome-latex/src/projects.vala"
	_g_object_unref0 ((*dest).directory);
#line 22 "/home/seb/gnome/gnome-latex/src/projects.vala"
	(*dest).directory = _tmp1_;
#line 22 "/home/seb/gnome/gnome-latex/src/projects.vala"
	_tmp2_ = (*self).main_file;
#line 22 "/home/seb/gnome/gnome-latex/src/projects.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 22 "/home/seb/gnome/gnome-latex/src/projects.vala"
	_g_object_unref0 ((*dest).main_file);
#line 22 "/home/seb/gnome/gnome-latex/src/projects.vala"
	(*dest).main_file = _tmp3_;
#line 225 "projects.c"
}


void
project_destroy (Project* self)
{
#line 24 "/home/seb/gnome/gnome-latex/src/projects.vala"
	_g_object_unref0 ((*self).directory);
#line 25 "/home/seb/gnome/gnome-latex/src/projects.vala"
	_g_object_unref0 ((*self).main_file);
#line 236 "projects.c"
}


Project*
project_dup (const Project* self)
{
	Project* dup;
#line 22 "/home/seb/gnome/gnome-latex/src/projects.vala"
	dup = g_new0 (Project, 1);
#line 22 "/home/seb/gnome/gnome-latex/src/projects.vala"
	project_copy (self, dup);
#line 22 "/home/seb/gnome/gnome-latex/src/projects.vala"
	return dup;
#line 250 "projects.c"
}


void
project_free (Project* self)
{
#line 22 "/home/seb/gnome/gnome-latex/src/projects.vala"
	project_destroy (self);
#line 22 "/home/seb/gnome/gnome-latex/src/projects.vala"
	g_free (self);
#line 261 "projects.c"
}


GType
project_get_type (void)
{
	static volatile gsize project_type_id__volatile = 0;
	if (g_once_init_enter (&project_type_id__volatile)) {
		GType project_type_id;
		project_type_id = g_boxed_type_register_static ("Project", (GBoxedCopyFunc) project_dup, (GBoxedFreeFunc) project_free);
		g_once_init_leave (&project_type_id__volatile, project_type_id);
	}
	return project_type_id__volatile;
}


static void
_projects_parser_start_gmarkup_parser_start_element_func (GMarkupParseContext* context,
                                                          const gchar* element_name,
                                                          gchar** attribute_names,
                                                          gchar** attribute_values,
                                                          gpointer self,
                                                          GError** error)
{
#line 50 "/home/seb/gnome/gnome-latex/src/projects.vala"
	projects_parser_start ((Projects*) self, context, element_name, attribute_names, _vala_array_length (attribute_names), attribute_values, _vala_array_length (attribute_values), error);
#line 288 "projects.c"
}


static Projects*
projects_construct (GType object_type)
{
	Projects* self = NULL;
	GeeLinkedList* _tmp0_;
	GFile* file = NULL;
	GFile* _tmp1_;
	GFile* _tmp2_;
	gchar* contents = NULL;
	GFile* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	GError * _inner_error_ = NULL;
#line 35 "/home/seb/gnome/gnome-latex/src/projects.vala"
	self = (Projects*) g_type_create_instance (object_type);
#line 37 "/home/seb/gnome/gnome-latex/src/projects.vala"
	_tmp0_ = gee_linked_list_new (TYPE_PROJECT, (GBoxedCopyFunc) project_dup, (GDestroyNotify) project_free, NULL, NULL, NULL);
#line 37 "/home/seb/gnome/gnome-latex/src/projects.vala"
	_g_object_unref0 (self->priv->projects);
#line 37 "/home/seb/gnome/gnome-latex/src/projects.vala"
	self->priv->projects = _tmp0_;
#line 40 "/home/seb/gnome/gnome-latex/src/projects.vala"
	_tmp1_ = projects_get_xml_file (self);
#line 40 "/home/seb/gnome/gnome-latex/src/projects.vala"
	file = _tmp1_;
#line 41 "/home/seb/gnome/gnome-latex/src/projects.vala"
	_tmp2_ = file;
#line 41 "/home/seb/gnome/gnome-latex/src/projects.vala"
	if (!g_file_query_exists (_tmp2_, NULL)) {
#line 42 "/home/seb/gnome/gnome-latex/src/projects.vala"
		_g_object_unref0 (file);
#line 42 "/home/seb/gnome/gnome-latex/src/projects.vala"
		return self;
#line 325 "projects.c"
	}
#line 44 "/home/seb/gnome/gnome-latex/src/projects.vala"
	_tmp3_ = file;
#line 44 "/home/seb/gnome/gnome-latex/src/projects.vala"
	_tmp4_ = utils_load_file (_tmp3_);
#line 44 "/home/seb/gnome/gnome-latex/src/projects.vala"
	contents = _tmp4_;
#line 45 "/home/seb/gnome/gnome-latex/src/projects.vala"
	_tmp5_ = contents;
#line 45 "/home/seb/gnome/gnome-latex/src/projects.vala"
	if (_tmp5_ == NULL) {
#line 46 "/home/seb/gnome/gnome-latex/src/projects.vala"
		_g_free0 (contents);
#line 46 "/home/seb/gnome/gnome-latex/src/projects.vala"
		_g_object_unref0 (file);
#line 46 "/home/seb/gnome/gnome-latex/src/projects.vala"
		return self;
#line 343 "projects.c"
	}
	{
		GMarkupParser parser = {0};
		GMarkupParser _tmp6_ = {0};
		GMarkupParseContext* context = NULL;
		GMarkupParser _tmp7_;
		GMarkupParseContext* _tmp8_;
		GMarkupParseContext* _tmp9_;
		const gchar* _tmp10_;
#line 50 "/home/seb/gnome/gnome-latex/src/projects.vala"
		_tmp6_.start_element = _projects_parser_start_gmarkup_parser_start_element_func;
#line 50 "/home/seb/gnome/gnome-latex/src/projects.vala"
		_tmp6_.end_element = NULL;
#line 50 "/home/seb/gnome/gnome-latex/src/projects.vala"
		_tmp6_.text = NULL;
#line 50 "/home/seb/gnome/gnome-latex/src/projects.vala"
		_tmp6_.passthrough = NULL;
#line 50 "/home/seb/gnome/gnome-latex/src/projects.vala"
		_tmp6_.error = NULL;
#line 50 "/home/seb/gnome/gnome-latex/src/projects.vala"
		parser = _tmp6_;
#line 51 "/home/seb/gnome/gnome-latex/src/projects.vala"
		_tmp7_ = parser;
#line 51 "/home/seb/gnome/gnome-latex/src/projects.vala"
		_tmp8_ = g_markup_parse_context_new (&_tmp7_, 0, self, NULL);
#line 51 "/home/seb/gnome/gnome-latex/src/projects.vala"
		context = _tmp8_;
#line 52 "/home/seb/gnome/gnome-latex/src/projects.vala"
		_tmp9_ = context;
#line 52 "/home/seb/gnome/gnome-latex/src/projects.vala"
		_tmp10_ = contents;
#line 52 "/home/seb/gnome/gnome-latex/src/projects.vala"
		g_markup_parse_context_parse (_tmp9_, _tmp10_, (gssize) -1, &_inner_error_);
#line 52 "/home/seb/gnome/gnome-latex/src/projects.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 52 "/home/seb/gnome/gnome-latex/src/projects.vala"
			_g_markup_parse_context_unref0 (context);
#line 381 "projects.c"
			goto __catch39_g_error;
		}
#line 54 "/home/seb/gnome/gnome-latex/src/projects.vala"
		projects_update_all_documents (self);
#line 55 "/home/seb/gnome/gnome-latex/src/projects.vala"
		projects_update_all_menus (self);
#line 48 "/home/seb/gnome/gnome-latex/src/projects.vala"
		_g_markup_parse_context_unref0 (context);
#line 390 "projects.c"
	}
	goto __finally39;
	__catch39_g_error:
	{
		GError* e = NULL;
		GError* _tmp11_;
		const gchar* _tmp12_;
#line 48 "/home/seb/gnome/gnome-latex/src/projects.vala"
		e = _inner_error_;
#line 48 "/home/seb/gnome/gnome-latex/src/projects.vala"
		_inner_error_ = NULL;
#line 59 "/home/seb/gnome/gnome-latex/src/projects.vala"
		_tmp11_ = e;
#line 59 "/home/seb/gnome/gnome-latex/src/projects.vala"
		_tmp12_ = _tmp11_->message;
#line 59 "/home/seb/gnome/gnome-latex/src/projects.vala"
		g_warning ("projects.vala:59: Impossible to load the projects: %s", _tmp12_);
#line 48 "/home/seb/gnome/gnome-latex/src/projects.vala"
		_g_error_free0 (e);
#line 410 "projects.c"
	}
	__finally39:
#line 48 "/home/seb/gnome/gnome-latex/src/projects.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 48 "/home/seb/gnome/gnome-latex/src/projects.vala"
		_g_free0 (contents);
#line 48 "/home/seb/gnome/gnome-latex/src/projects.vala"
		_g_object_unref0 (file);
#line 48 "/home/seb/gnome/gnome-latex/src/projects.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 48 "/home/seb/gnome/gnome-latex/src/projects.vala"
		g_clear_error (&_inner_error_);
#line 48 "/home/seb/gnome/gnome-latex/src/projects.vala"
		return NULL;
#line 425 "projects.c"
	}
#line 35 "/home/seb/gnome/gnome-latex/src/projects.vala"
	_g_free0 (contents);
#line 35 "/home/seb/gnome/gnome-latex/src/projects.vala"
	_g_object_unref0 (file);
#line 35 "/home/seb/gnome/gnome-latex/src/projects.vala"
	return self;
#line 433 "projects.c"
}


static Projects*
projects_new (void)
{
#line 35 "/home/seb/gnome/gnome-latex/src/projects.vala"
	return projects_construct (TYPE_PROJECTS);
#line 442 "projects.c"
}


static gpointer
_projects_ref0 (gpointer self)
{
#line 67 "/home/seb/gnome/gnome-latex/src/projects.vala"
	return self ? projects_ref (self) : NULL;
#line 451 "projects.c"
}


Projects*
projects_get_default (void)
{
	Projects* result = NULL;
	Projects* _tmp0_;
	Projects* _tmp2_;
	Projects* _tmp3_;
#line 65 "/home/seb/gnome/gnome-latex/src/projects.vala"
	_tmp0_ = projects_instance;
#line 65 "/home/seb/gnome/gnome-latex/src/projects.vala"
	if (_tmp0_ == NULL) {
#line 466 "projects.c"
		Projects* _tmp1_;
#line 66 "/home/seb/gnome/gnome-latex/src/projects.vala"
		_tmp1_ = projects_new ();
#line 66 "/home/seb/gnome/gnome-latex/src/projects.vala"
		_projects_unref0 (projects_instance);
#line 66 "/home/seb/gnome/gnome-latex/src/projects.vala"
		projects_instance = _tmp1_;
#line 474 "projects.c"
	}
#line 67 "/home/seb/gnome/gnome-latex/src/projects.vala"
	_tmp2_ = projects_instance;
#line 67 "/home/seb/gnome/gnome-latex/src/projects.vala"
	_tmp3_ = _projects_ref0 (_tmp2_);
#line 67 "/home/seb/gnome/gnome-latex/src/projects.vala"
	result = _tmp3_;
#line 67 "/home/seb/gnome/gnome-latex/src/projects.vala"
	return result;
#line 484 "projects.c"
}


Project*
projects_get (Projects* self,
              gint id)
{
	Project* result = NULL;
	gboolean _tmp0_ = FALSE;
	GeeLinkedList* _tmp4_;
	gpointer _tmp5_;
#line 70 "/home/seb/gnome/gnome-latex/src/projects.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 72 "/home/seb/gnome/gnome-latex/src/projects.vala"
	if (id >= 0) {
#line 500 "projects.c"
		GeeLinkedList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
#line 72 "/home/seb/gnome/gnome-latex/src/projects.vala"
		_tmp1_ = self->priv->projects;
#line 72 "/home/seb/gnome/gnome-latex/src/projects.vala"
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
#line 72 "/home/seb/gnome/gnome-latex/src/projects.vala"
		_tmp3_ = _tmp2_;
#line 72 "/home/seb/gnome/gnome-latex/src/projects.vala"
		_tmp0_ = id < _tmp3_;
#line 512 "projects.c"
	} else {
#line 72 "/home/seb/gnome/gnome-latex/src/projects.vala"
		_tmp0_ = FALSE;
#line 516 "projects.c"
	}
#line 72 "/home/seb/gnome/gnome-latex/src/projects.vala"
	g_return_val_if_fail (_tmp0_, NULL);
#line 73 "/home/seb/gnome/gnome-latex/src/projects.vala"
	_tmp4_ = self->priv->projects;
#line 73 "/home/seb/gnome/gnome-latex/src/projects.vala"
	_tmp5_ = gee_abstract_list_get ((GeeAbstractList*) _tmp4_, id);
#line 73 "/home/seb/gnome/gnome-latex/src/projects.vala"
	result = (Project*) _tmp5_;
#line 73 "/home/seb/gnome/gnome-latex/src/projects.vala"
	return result;
#line 528 "projects.c"
}


GeeIterator*
projects_iterator (Projects* self)
{
	GeeIterator* result = NULL;
	GeeLinkedList* _tmp0_;
	GeeIterator* _tmp1_;
#line 76 "/home/seb/gnome/gnome-latex/src/projects.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 78 "/home/seb/gnome/gnome-latex/src/projects.vala"
	_tmp0_ = self->priv->projects;
#line 78 "/home/seb/gnome/gnome-latex/src/projects.vala"
	_tmp1_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp0_);
#line 78 "/home/seb/gnome/gnome-latex/src/projects.vala"
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ITERATOR, GeeIterator);
#line 78 "/home/seb/gnome/gnome-latex/src/projects.vala"
	return result;
#line 548 "projects.c"
}


static void
projects_update_all_menus (Projects* self)
{
	GlatexApp* _tmp0_;
	GlatexApp* _tmp1_;
	GList* _tmp2_;
	GList* _tmp3_;
#line 81 "/home/seb/gnome/gnome-latex/src/projects.vala"
	g_return_if_fail (self != NULL);
#line 83 "/home/seb/gnome/gnome-latex/src/projects.vala"
	_tmp0_ = glatex_app_get_instance ();
#line 83 "/home/seb/gnome/gnome-latex/src/projects.vala"
	_tmp1_ = _tmp0_;
#line 83 "/home/seb/gnome/gnome-latex/src/projects.vala"
	_tmp2_ = gtk_application_get_windows ((GtkApplication*) _tmp1_);
#line 83 "/home/seb/gnome/gnome-latex/src/projects.vala"
	_tmp3_ = _tmp2_;
#line 83 "/home/seb/gnome/gnome-latex/src/projects.vala"
	_g_object_unref0 (_tmp1_);
#line 571 "projects.c"
	{
		GList* window_collection = NULL;
		GList* window_it = NULL;
#line 83 "/home/seb/gnome/gnome-latex/src/projects.vala"
		window_collection = _tmp3_;
#line 83 "/home/seb/gnome/gnome-latex/src/projects.vala"
		for (window_it = window_collection; window_it != NULL; window_it = window_it->next) {
#line 579 "projects.c"
			GtkWindow* _tmp4_;
			GtkWindow* window = NULL;
#line 83 "/home/seb/gnome/gnome-latex/src/projects.vala"
			_tmp4_ = _g_object_ref0 ((GtkWindow*) window_it->data);
#line 83 "/home/seb/gnome/gnome-latex/src/projects.vala"
			window = _tmp4_;
#line 586 "projects.c"
			{
				GtkWindow* _tmp5_;
#line 85 "/home/seb/gnome/gnome-latex/src/projects.vala"
				_tmp5_ = window;
#line 85 "/home/seb/gnome/gnome-latex/src/projects.vala"
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, TYPE_MAIN_WINDOW)) {
#line 593 "projects.c"
					MainWindow* main_window = NULL;
					GtkWindow* _tmp6_;
					MainWindow* _tmp7_;
					MainWindow* _tmp8_;
#line 87 "/home/seb/gnome/gnome-latex/src/projects.vala"
					_tmp6_ = window;
#line 87 "/home/seb/gnome/gnome-latex/src/projects.vala"
					_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, TYPE_MAIN_WINDOW) ? ((MainWindow*) _tmp6_) : NULL);
#line 87 "/home/seb/gnome/gnome-latex/src/projects.vala"
					main_window = _tmp7_;
#line 88 "/home/seb/gnome/gnome-latex/src/projects.vala"
					_tmp8_ = main_window;
#line 88 "/home/seb/gnome/gnome-latex/src/projects.vala"
					main_window_update_config_project_sensitivity (_tmp8_);
#line 85 "/home/seb/gnome/gnome-latex/src/projects.vala"
					_g_object_unref0 (main_window);
#line 610 "projects.c"
				}
#line 83 "/home/seb/gnome/gnome-latex/src/projects.vala"
				_g_object_unref0 (window);
#line 614 "projects.c"
			}
		}
	}
}


gboolean
projects_add (Projects* self,
              Project* new_project,
              GFile* * conflict_file)
{
	GFile* _vala_conflict_file = NULL;
	gboolean result = FALSE;
	GeeLinkedList* _tmp21_;
	Project _tmp22_;
	GeeList* docs = NULL;
	GlatexApp* _tmp23_;
	GlatexApp* _tmp24_;
	GeeList* _tmp25_;
	GeeList* _tmp26_;
#line 94 "/home/seb/gnome/gnome-latex/src/projects.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 94 "/home/seb/gnome/gnome-latex/src/projects.vala"
	g_return_val_if_fail (new_project != NULL, FALSE);
#line 96 "/home/seb/gnome/gnome-latex/src/projects.vala"
	_g_object_unref0 (_vala_conflict_file);
#line 96 "/home/seb/gnome/gnome-latex/src/projects.vala"
	_vala_conflict_file = NULL;
#line 643 "projects.c"
	{
		GeeLinkedList* _project_list = NULL;
		GeeLinkedList* _tmp0_;
		GeeLinkedList* _tmp1_;
		gint _project_size = 0;
		GeeLinkedList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _project_index = 0;
#line 98 "/home/seb/gnome/gnome-latex/src/projects.vala"
		_tmp0_ = self->priv->projects;
#line 98 "/home/seb/gnome/gnome-latex/src/projects.vala"
		_tmp1_ = _g_object_ref0 (_tmp0_);
#line 98 "/home/seb/gnome/gnome-latex/src/projects.vala"
		_project_list = _tmp1_;
#line 98 "/home/seb/gnome/gnome-latex/src/projects.vala"
		_tmp2_ = _project_list;
#line 98 "/home/seb/gnome/gnome-latex/src/projects.vala"
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
#line 98 "/home/seb/gnome/gnome-latex/src/projects.vala"
		_tmp4_ = _tmp3_;
#line 98 "/home/seb/gnome/gnome-latex/src/projects.vala"
		_project_size = _tmp4_;
#line 98 "/home/seb/gnome/gnome-latex/src/projects.vala"
		_project_index = -1;
#line 98 "/home/seb/gnome/gnome-latex/src/projects.vala"
		while (TRUE) {
#line 671 "projects.c"
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			Project project = {0};
			GeeLinkedList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			Project* _tmp11_;
			Project _tmp12_ = {0};
			Project _tmp13_;
			Project _tmp14_;
			GFile* _tmp15_;
			Project _tmp16_;
			GFile* _tmp17_;
#line 98 "/home/seb/gnome/gnome-latex/src/projects.vala"
			_tmp5_ = _project_index;
#line 98 "/home/seb/gnome/gnome-latex/src/projects.vala"
			_project_index = _tmp5_ + 1;
#line 98 "/home/seb/gnome/gnome-latex/src/projects.vala"
			_tmp6_ = _project_index;
#line 98 "/home/seb/gnome/gnome-latex/src/projects.vala"
			_tmp7_ = _project_size;
#line 98 "/home/seb/gnome/gnome-latex/src/projects.vala"
			if (!(_tmp6_ < _tmp7_)) {
#line 98 "/home/seb/gnome/gnome-latex/src/projects.vala"
				break;
#line 698 "projects.c"
			}
#line 98 "/home/seb/gnome/gnome-latex/src/projects.vala"
			_tmp8_ = _project_list;
#line 98 "/home/seb/gnome/gnome-latex/src/projects.vala"
			_tmp9_ = _project_index;
#line 98 "/home/seb/gnome/gnome-latex/src/projects.vala"
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _tmp9_);
#line 98 "/home/seb/gnome/gnome-latex/src/projects.vala"
			_tmp11_ = (Project*) _tmp10_;
#line 98 "/home/seb/gnome/gnome-latex/src/projects.vala"
			project_copy (_tmp11_, &_tmp12_);
#line 98 "/home/seb/gnome/gnome-latex/src/projects.vala"
			_tmp13_ = _tmp12_;
#line 98 "/home/seb/gnome/gnome-latex/src/projects.vala"
			_project_free0 (_tmp11_);
#line 98 "/home/seb/gnome/gnome-latex/src/projects.vala"
			project = _tmp13_;
#line 100 "/home/seb/gnome/gnome-latex/src/projects.vala"
			_tmp14_ = project;
#line 100 "/home/seb/gnome/gnome-latex/src/projects.vala"
			_tmp15_ = _tmp14_.directory;
#line 100 "/home/seb/gnome/gnome-latex/src/projects.vala"
			_tmp16_ = *new_project;
#line 100 "/home/seb/gnome/gnome-latex/src/projects.vala"
			_tmp17_ = _tmp16_.directory;
#line 100 "/home/seb/gnome/gnome-latex/src/projects.vala"
			if (projects_conflict (self, _tmp15_, _tmp17_)) {
#line 726 "projects.c"
				Project _tmp18_;
				GFile* _tmp19_;
				GFile* _tmp20_;
#line 102 "/home/seb/gnome/gnome-latex/src/projects.vala"
				_tmp18_ = project;
#line 102 "/home/seb/gnome/gnome-latex/src/projects.vala"
				_tmp19_ = _tmp18_.directory;
#line 102 "/home/seb/gnome/gnome-latex/src/projects.vala"
				_tmp20_ = _g_object_ref0 (_tmp19_);
#line 102 "/home/seb/gnome/gnome-latex/src/projects.vala"
				_g_object_unref0 (_vala_conflict_file);
#line 102 "/home/seb/gnome/gnome-latex/src/projects.vala"
				_vala_conflict_file = _tmp20_;
#line 103 "/home/seb/gnome/gnome-latex/src/projects.vala"
				result = FALSE;
#line 103 "/home/seb/gnome/gnome-latex/src/projects.vala"
				project_destroy (&project);
#line 103 "/home/seb/gnome/gnome-latex/src/projects.vala"
				_g_object_unref0 (_project_list);
#line 103 "/home/seb/gnome/gnome-latex/src/projects.vala"
				if (conflict_file) {
#line 103 "/home/seb/gnome/gnome-latex/src/projects.vala"
					*conflict_file = _vala_conflict_file;
#line 750 "projects.c"
				} else {
#line 103 "/home/seb/gnome/gnome-latex/src/projects.vala"
					_g_object_unref0 (_vala_conflict_file);
#line 754 "projects.c"
				}
#line 103 "/home/seb/gnome/gnome-latex/src/projects.vala"
				return result;
#line 758 "projects.c"
			}
#line 98 "/home/seb/gnome/gnome-latex/src/projects.vala"
			project_destroy (&project);
#line 762 "projects.c"
		}
#line 98 "/home/seb/gnome/gnome-latex/src/projects.vala"
		_g_object_unref0 (_project_list);
#line 766 "projects.c"
	}
#line 107 "/home/seb/gnome/gnome-latex/src/projects.vala"
	_tmp21_ = self->priv->projects;
#line 107 "/home/seb/gnome/gnome-latex/src/projects.vala"
	_tmp22_ = *new_project;
#line 107 "/home/seb/gnome/gnome-latex/src/projects.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp21_, &_tmp22_);
#line 108 "/home/seb/gnome/gnome-latex/src/projects.vala"
	self->priv->modified = TRUE;
#line 111 "/home/seb/gnome/gnome-latex/src/projects.vala"
	_tmp23_ = glatex_app_get_instance ();
#line 111 "/home/seb/gnome/gnome-latex/src/projects.vala"
	_tmp24_ = _tmp23_;
#line 111 "/home/seb/gnome/gnome-latex/src/projects.vala"
	_tmp25_ = glatex_app_get_documents (_tmp24_);
#line 111 "/home/seb/gnome/gnome-latex/src/projects.vala"
	_tmp26_ = _tmp25_;
#line 111 "/home/seb/gnome/gnome-latex/src/projects.vala"
	_g_object_unref0 (_tmp24_);
#line 111 "/home/seb/gnome/gnome-latex/src/projects.vala"
	docs = _tmp26_;
#line 788 "projects.c"
	{
		GeeList* _doc_list = NULL;
		GeeList* _tmp27_;
		GeeList* _tmp28_;
		gint _doc_size = 0;
		GeeList* _tmp29_;
		gint _tmp30_;
		gint _tmp31_;
		gint _doc_index = 0;
#line 112 "/home/seb/gnome/gnome-latex/src/projects.vala"
		_tmp27_ = docs;
#line 112 "/home/seb/gnome/gnome-latex/src/projects.vala"
		_tmp28_ = _g_object_ref0 (_tmp27_);
#line 112 "/home/seb/gnome/gnome-latex/src/projects.vala"
		_doc_list = _tmp28_;
#line 112 "/home/seb/gnome/gnome-latex/src/projects.vala"
		_tmp29_ = _doc_list;
#line 112 "/home/seb/gnome/gnome-latex/src/projects.vala"
		_tmp30_ = gee_collection_get_size ((GeeCollection*) _tmp29_);
#line 112 "/home/seb/gnome/gnome-latex/src/projects.vala"
		_tmp31_ = _tmp30_;
#line 112 "/home/seb/gnome/gnome-latex/src/projects.vala"
		_doc_size = _tmp31_;
#line 112 "/home/seb/gnome/gnome-latex/src/projects.vala"
		_doc_index = -1;
#line 112 "/home/seb/gnome/gnome-latex/src/projects.vala"
		while (TRUE) {
#line 816 "projects.c"
			gint _tmp32_;
			gint _tmp33_;
			gint _tmp34_;
			Document* doc = NULL;
			GeeList* _tmp35_;
			gint _tmp36_;
			gpointer _tmp37_;
			gboolean _tmp38_ = FALSE;
			Document* _tmp39_;
			gint _tmp40_;
			gint _tmp41_;
			Document* _tmp45_;
			GFile* _tmp46_;
			GFile* _tmp47_;
			Project _tmp48_;
			GFile* _tmp49_;
#line 112 "/home/seb/gnome/gnome-latex/src/projects.vala"
			_tmp32_ = _doc_index;
#line 112 "/home/seb/gnome/gnome-latex/src/projects.vala"
			_doc_index = _tmp32_ + 1;
#line 112 "/home/seb/gnome/gnome-latex/src/projects.vala"
			_tmp33_ = _doc_index;
#line 112 "/home/seb/gnome/gnome-latex/src/projects.vala"
			_tmp34_ = _doc_size;
#line 112 "/home/seb/gnome/gnome-latex/src/projects.vala"
			if (!(_tmp33_ < _tmp34_)) {
#line 112 "/home/seb/gnome/gnome-latex/src/projects.vala"
				break;
#line 845 "projects.c"
			}
#line 112 "/home/seb/gnome/gnome-latex/src/projects.vala"
			_tmp35_ = _doc_list;
#line 112 "/home/seb/gnome/gnome-latex/src/projects.vala"
			_tmp36_ = _doc_index;
#line 112 "/home/seb/gnome/gnome-latex/src/projects.vala"
			_tmp37_ = gee_list_get (_tmp35_, _tmp36_);
#line 112 "/home/seb/gnome/gnome-latex/src/projects.vala"
			doc = (Document*) _tmp37_;
#line 114 "/home/seb/gnome/gnome-latex/src/projects.vala"
			_tmp39_ = doc;
#line 114 "/home/seb/gnome/gnome-latex/src/projects.vala"
			_tmp40_ = document_get_project_id (_tmp39_);
#line 114 "/home/seb/gnome/gnome-latex/src/projects.vala"
			_tmp41_ = _tmp40_;
#line 114 "/home/seb/gnome/gnome-latex/src/projects.vala"
			if (_tmp41_ != -1) {
#line 114 "/home/seb/gnome/gnome-latex/src/projects.vala"
				_tmp38_ = TRUE;
#line 865 "projects.c"
			} else {
				Document* _tmp42_;
				GFile* _tmp43_;
				GFile* _tmp44_;
#line 114 "/home/seb/gnome/gnome-latex/src/projects.vala"
				_tmp42_ = doc;
#line 114 "/home/seb/gnome/gnome-latex/src/projects.vala"
				_tmp43_ = document_get_location (_tmp42_);
#line 114 "/home/seb/gnome/gnome-latex/src/projects.vala"
				_tmp44_ = _tmp43_;
#line 114 "/home/seb/gnome/gnome-latex/src/projects.vala"
				_tmp38_ = _tmp44_ == NULL;
#line 878 "projects.c"
			}
#line 114 "/home/seb/gnome/gnome-latex/src/projects.vala"
			if (_tmp38_) {
#line 115 "/home/seb/gnome/gnome-latex/src/projects.vala"
				_g_object_unref0 (doc);
#line 115 "/home/seb/gnome/gnome-latex/src/projects.vala"
				continue;
#line 886 "projects.c"
			}
#line 117 "/home/seb/gnome/gnome-latex/src/projects.vala"
			_tmp45_ = doc;
#line 117 "/home/seb/gnome/gnome-latex/src/projects.vala"
			_tmp46_ = document_get_location (_tmp45_);
#line 117 "/home/seb/gnome/gnome-latex/src/projects.vala"
			_tmp47_ = _tmp46_;
#line 117 "/home/seb/gnome/gnome-latex/src/projects.vala"
			_tmp48_ = *new_project;
#line 117 "/home/seb/gnome/gnome-latex/src/projects.vala"
			_tmp49_ = _tmp48_.directory;
#line 117 "/home/seb/gnome/gnome-latex/src/projects.vala"
			if (g_file_has_prefix (_tmp47_, _tmp49_)) {
#line 900 "projects.c"
				Document* _tmp50_;
				GeeLinkedList* _tmp51_;
				gint _tmp52_;
				gint _tmp53_;
#line 118 "/home/seb/gnome/gnome-latex/src/projects.vala"
				_tmp50_ = doc;
#line 118 "/home/seb/gnome/gnome-latex/src/projects.vala"
				_tmp51_ = self->priv->projects;
#line 118 "/home/seb/gnome/gnome-latex/src/projects.vala"
				_tmp52_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp51_);
#line 118 "/home/seb/gnome/gnome-latex/src/projects.vala"
				_tmp53_ = _tmp52_;
#line 118 "/home/seb/gnome/gnome-latex/src/projects.vala"
				document_set_project_id (_tmp50_, _tmp53_ - 1);
#line 915 "projects.c"
			}
#line 112 "/home/seb/gnome/gnome-latex/src/projects.vala"
			_g_object_unref0 (doc);
#line 919 "projects.c"
		}
#line 112 "/home/seb/gnome/gnome-latex/src/projects.vala"
		_g_object_unref0 (_doc_list);
#line 923 "projects.c"
	}
#line 121 "/home/seb/gnome/gnome-latex/src/projects.vala"
	projects_update_all_menus (self);
#line 123 "/home/seb/gnome/gnome-latex/src/projects.vala"
	result = TRUE;
#line 123 "/home/seb/gnome/gnome-latex/src/projects.vala"
	_g_object_unref0 (docs);
#line 123 "/home/seb/gnome/gnome-latex/src/projects.vala"
	if (conflict_file) {
#line 123 "/home/seb/gnome/gnome-latex/src/projects.vala"
		*conflict_file = _vala_conflict_file;
#line 935 "projects.c"
	} else {
#line 123 "/home/seb/gnome/gnome-latex/src/projects.vala"
		_g_object_unref0 (_vala_conflict_file);
#line 939 "projects.c"
	}
#line 123 "/home/seb/gnome/gnome-latex/src/projects.vala"
	return result;
#line 943 "projects.c"
}


gboolean
projects_change_main_file (Projects* self,
                           gint num,
                           GFile* new_main_file)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	Project project = {0};
	GeeLinkedList* _tmp4_;
	gpointer _tmp5_;
	Project* _tmp6_;
	Project _tmp7_ = {0};
	Project _tmp8_;
	Project _tmp9_;
	GFile* _tmp10_;
	Project _tmp11_;
	GFile* _tmp12_;
	GFile* _tmp13_;
	GeeLinkedList* _tmp14_;
	Project _tmp15_;
	GeeList* docs = NULL;
	GlatexApp* _tmp16_;
	GlatexApp* _tmp17_;
	GeeList* _tmp18_;
	GeeList* _tmp19_;
#line 127 "/home/seb/gnome/gnome-latex/src/projects.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 127 "/home/seb/gnome/gnome-latex/src/projects.vala"
	g_return_val_if_fail (new_main_file != NULL, FALSE);
#line 129 "/home/seb/gnome/gnome-latex/src/projects.vala"
	if (num >= 0) {
#line 978 "projects.c"
		GeeLinkedList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
#line 129 "/home/seb/gnome/gnome-latex/src/projects.vala"
		_tmp1_ = self->priv->projects;
#line 129 "/home/seb/gnome/gnome-latex/src/projects.vala"
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
#line 129 "/home/seb/gnome/gnome-latex/src/projects.vala"
		_tmp3_ = _tmp2_;
#line 129 "/home/seb/gnome/gnome-latex/src/projects.vala"
		_tmp0_ = num < _tmp3_;
#line 990 "projects.c"
	} else {
#line 129 "/home/seb/gnome/gnome-latex/src/projects.vala"
		_tmp0_ = FALSE;
#line 994 "projects.c"
	}
#line 129 "/home/seb/gnome/gnome-latex/src/projects.vala"
	g_return_val_if_fail (_tmp0_, FALSE);
#line 130 "/home/seb/gnome/gnome-latex/src/projects.vala"
	_tmp4_ = self->priv->projects;
#line 130 "/home/seb/gnome/gnome-latex/src/projects.vala"
	_tmp5_ = gee_abstract_list_get ((GeeAbstractList*) _tmp4_, num);
#line 130 "/home/seb/gnome/gnome-latex/src/projects.vala"
	_tmp6_ = (Project*) _tmp5_;
#line 130 "/home/seb/gnome/gnome-latex/src/projects.vala"
	project_copy (_tmp6_, &_tmp7_);
#line 130 "/home/seb/gnome/gnome-latex/src/projects.vala"
	_tmp8_ = _tmp7_;
#line 130 "/home/seb/gnome/gnome-latex/src/projects.vala"
	_project_free0 (_tmp6_);
#line 130 "/home/seb/gnome/gnome-latex/src/projects.vala"
	project = _tmp8_;
#line 132 "/home/seb/gnome/gnome-latex/src/projects.vala"
	_tmp9_ = project;
#line 132 "/home/seb/gnome/gnome-latex/src/projects.vala"
	_tmp10_ = _tmp9_.main_file;
#line 132 "/home/seb/gnome/gnome-latex/src/projects.vala"
	if (g_file_equal (new_main_file, _tmp10_)) {
#line 133 "/home/seb/gnome/gnome-latex/src/projects.vala"
		result = FALSE;
#line 133 "/home/seb/gnome/gnome-latex/src/projects.vala"
		project_destroy (&project);
#line 133 "/home/seb/gnome/gnome-latex/src/projects.vala"
		return result;
#line 1024 "projects.c"
	}
#line 135 "/home/seb/gnome/gnome-latex/src/projects.vala"
	_tmp11_ = project;
#line 135 "/home/seb/gnome/gnome-latex/src/projects.vala"
	_tmp12_ = _tmp11_.directory;
#line 135 "/home/seb/gnome/gnome-latex/src/projects.vala"
	g_return_val_if_fail (g_file_has_prefix (new_main_file, _tmp12_), FALSE);
#line 137 "/home/seb/gnome/gnome-latex/src/projects.vala"
	_tmp13_ = _g_object_ref0 (new_main_file);
#line 137 "/home/seb/gnome/gnome-latex/src/projects.vala"
	_g_object_unref0 (project.main_file);
#line 137 "/home/seb/gnome/gnome-latex/src/projects.vala"
	project.main_file = _tmp13_;
#line 138 "/home/seb/gnome/gnome-latex/src/projects.vala"
	_tmp14_ = self->priv->projects;
#line 138 "/home/seb/gnome/gnome-latex/src/projects.vala"
	_tmp15_ = project;
#line 138 "/home/seb/gnome/gnome-latex/src/projects.vala"
	gee_abstract_list_set ((GeeAbstractList*) _tmp14_, num, &_tmp15_);
#line 139 "/home/seb/gnome/gnome-latex/src/projects.vala"
	self->priv->modified = TRUE;
#line 142 "/home/seb/gnome/gnome-latex/src/projects.vala"
	_tmp16_ = glatex_app_get_instance ();
#line 142 "/home/seb/gnome/gnome-latex/src/projects.vala"
	_tmp17_ = _tmp16_;
#line 142 "/home/seb/gnome/gnome-latex/src/projects.vala"
	_tmp18_ = glatex_app_get_documents (_tmp17_);
#line 142 "/home/seb/gnome/gnome-latex/src/projects.vala"
	_tmp19_ = _tmp18_;
#line 142 "/home/seb/gnome/gnome-latex/src/projects.vala"
	_g_object_unref0 (_tmp17_);
#line 142 "/home/seb/gnome/gnome-latex/src/projects.vala"
	docs = _tmp19_;
#line 1058 "projects.c"
	{
		GeeList* _doc_list = NULL;
		GeeList* _tmp20_;
		GeeList* _tmp21_;
		gint _doc_size = 0;
		GeeList* _tmp22_;
		gint _tmp23_;
		gint _tmp24_;
		gint _doc_index = 0;
#line 143 "/home/seb/gnome/gnome-latex/src/projects.vala"
		_tmp20_ = docs;
#line 143 "/home/seb/gnome/gnome-latex/src/projects.vala"
		_tmp21_ = _g_object_ref0 (_tmp20_);
#line 143 "/home/seb/gnome/gnome-latex/src/projects.vala"
		_doc_list = _tmp21_;
#line 143 "/home/seb/gnome/gnome-latex/src/projects.vala"
		_tmp22_ = _doc_list;
#line 143 "/home/seb/gnome/gnome-latex/src/projects.vala"
		_tmp23_ = gee_collection_get_size ((GeeCollection*) _tmp22_);
#line 143 "/home/seb/gnome/gnome-latex/src/projects.vala"
		_tmp24_ = _tmp23_;
#line 143 "/home/seb/gnome/gnome-latex/src/projects.vala"
		_doc_size = _tmp24_;
#line 143 "/home/seb/gnome/gnome-latex/src/projects.vala"
		_doc_index = -1;
#line 143 "/home/seb/gnome/gnome-latex/src/projects.vala"
		while (TRUE) {
#line 1086 "projects.c"
			gint _tmp25_;
			gint _tmp26_;
			gint _tmp27_;
			Document* doc = NULL;
			GeeList* _tmp28_;
			gint _tmp29_;
			gpointer _tmp30_;
			Document* _tmp31_;
			gint _tmp32_;
			gint _tmp33_;
#line 143 "/home/seb/gnome/gnome-latex/src/projects.vala"
			_tmp25_ = _doc_index;
#line 143 "/home/seb/gnome/gnome-latex/src/projects.vala"
			_doc_index = _tmp25_ + 1;
#line 143 "/home/seb/gnome/gnome-latex/src/projects.vala"
			_tmp26_ = _doc_index;
#line 143 "/home/seb/gnome/gnome-latex/src/projects.vala"
			_tmp27_ = _doc_size;
#line 143 "/home/seb/gnome/gnome-latex/src/projects.vala"
			if (!(_tmp26_ < _tmp27_)) {
#line 143 "/home/seb/gnome/gnome-latex/src/projects.vala"
				break;
#line 1109 "projects.c"
			}
#line 143 "/home/seb/gnome/gnome-latex/src/projects.vala"
			_tmp28_ = _doc_list;
#line 143 "/home/seb/gnome/gnome-latex/src/projects.vala"
			_tmp29_ = _doc_index;
#line 143 "/home/seb/gnome/gnome-latex/src/projects.vala"
			_tmp30_ = gee_list_get (_tmp28_, _tmp29_);
#line 143 "/home/seb/gnome/gnome-latex/src/projects.vala"
			doc = (Document*) _tmp30_;
#line 145 "/home/seb/gnome/gnome-latex/src/projects.vala"
			_tmp31_ = doc;
#line 145 "/home/seb/gnome/gnome-latex/src/projects.vala"
			_tmp32_ = document_get_project_id (_tmp31_);
#line 145 "/home/seb/gnome/gnome-latex/src/projects.vala"
			_tmp33_ = _tmp32_;
#line 145 "/home/seb/gnome/gnome-latex/src/projects.vala"
			if (_tmp33_ == num) {
#line 1127 "projects.c"
				Document* _tmp34_;
#line 146 "/home/seb/gnome/gnome-latex/src/projects.vala"
				_tmp34_ = doc;
#line 146 "/home/seb/gnome/gnome-latex/src/projects.vala"
				document_set_project_id (_tmp34_, num);
#line 1133 "projects.c"
			}
#line 143 "/home/seb/gnome/gnome-latex/src/projects.vala"
			_g_object_unref0 (doc);
#line 1137 "projects.c"
		}
#line 143 "/home/seb/gnome/gnome-latex/src/projects.vala"
		_g_object_unref0 (_doc_list);
#line 1141 "projects.c"
	}
#line 149 "/home/seb/gnome/gnome-latex/src/projects.vala"
	result = TRUE;
#line 149 "/home/seb/gnome/gnome-latex/src/projects.vala"
	_g_object_unref0 (docs);
#line 149 "/home/seb/gnome/gnome-latex/src/projects.vala"
	project_destroy (&project);
#line 149 "/home/seb/gnome/gnome-latex/src/projects.vala"
	return result;
#line 1151 "projects.c"
}


void
projects_delete (Projects* self,
                 gint num)
{
	gboolean _tmp0_ = FALSE;
	GeeLinkedList* _tmp4_;
	gpointer _tmp5_;
	Project* _tmp6_;
	GeeList* docs = NULL;
	GlatexApp* _tmp7_;
	GlatexApp* _tmp8_;
	GeeList* _tmp9_;
	GeeList* _tmp10_;
#line 152 "/home/seb/gnome/gnome-latex/src/projects.vala"
	g_return_if_fail (self != NULL);
#line 154 "/home/seb/gnome/gnome-latex/src/projects.vala"
	if (num >= 0) {
#line 1172 "projects.c"
		GeeLinkedList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
#line 154 "/home/seb/gnome/gnome-latex/src/projects.vala"
		_tmp1_ = self->priv->projects;
#line 154 "/home/seb/gnome/gnome-latex/src/projects.vala"
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
#line 154 "/home/seb/gnome/gnome-latex/src/projects.vala"
		_tmp3_ = _tmp2_;
#line 154 "/home/seb/gnome/gnome-latex/src/projects.vala"
		_tmp0_ = num < _tmp3_;
#line 1184 "projects.c"
	} else {
#line 154 "/home/seb/gnome/gnome-latex/src/projects.vala"
		_tmp0_ = FALSE;
#line 1188 "projects.c"
	}
#line 154 "/home/seb/gnome/gnome-latex/src/projects.vala"
	g_return_if_fail (_tmp0_);
#line 155 "/home/seb/gnome/gnome-latex/src/projects.vala"
	_tmp4_ = self->priv->projects;
#line 155 "/home/seb/gnome/gnome-latex/src/projects.vala"
	_tmp5_ = gee_abstract_list_remove_at ((GeeAbstractList*) _tmp4_, num);
#line 155 "/home/seb/gnome/gnome-latex/src/projects.vala"
	_tmp6_ = (Project*) _tmp5_;
#line 155 "/home/seb/gnome/gnome-latex/src/projects.vala"
	_project_free0 (_tmp6_);
#line 156 "/home/seb/gnome/gnome-latex/src/projects.vala"
	self->priv->modified = TRUE;
#line 159 "/home/seb/gnome/gnome-latex/src/projects.vala"
	_tmp7_ = glatex_app_get_instance ();
#line 159 "/home/seb/gnome/gnome-latex/src/projects.vala"
	_tmp8_ = _tmp7_;
#line 159 "/home/seb/gnome/gnome-latex/src/projects.vala"
	_tmp9_ = glatex_app_get_documents (_tmp8_);
#line 159 "/home/seb/gnome/gnome-latex/src/projects.vala"
	_tmp10_ = _tmp9_;
#line 159 "/home/seb/gnome/gnome-latex/src/projects.vala"
	_g_object_unref0 (_tmp8_);
#line 159 "/home/seb/gnome/gnome-latex/src/projects.vala"
	docs = _tmp10_;
#line 1214 "projects.c"
	{
		GeeList* _doc_list = NULL;
		GeeList* _tmp11_;
		GeeList* _tmp12_;
		gint _doc_size = 0;
		GeeList* _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		gint _doc_index = 0;
#line 160 "/home/seb/gnome/gnome-latex/src/projects.vala"
		_tmp11_ = docs;
#line 160 "/home/seb/gnome/gnome-latex/src/projects.vala"
		_tmp12_ = _g_object_ref0 (_tmp11_);
#line 160 "/home/seb/gnome/gnome-latex/src/projects.vala"
		_doc_list = _tmp12_;
#line 160 "/home/seb/gnome/gnome-latex/src/projects.vala"
		_tmp13_ = _doc_list;
#line 160 "/home/seb/gnome/gnome-latex/src/projects.vala"
		_tmp14_ = gee_collection_get_size ((GeeCollection*) _tmp13_);
#line 160 "/home/seb/gnome/gnome-latex/src/projects.vala"
		_tmp15_ = _tmp14_;
#line 160 "/home/seb/gnome/gnome-latex/src/projects.vala"
		_doc_size = _tmp15_;
#line 160 "/home/seb/gnome/gnome-latex/src/projects.vala"
		_doc_index = -1;
#line 160 "/home/seb/gnome/gnome-latex/src/projects.vala"
		while (TRUE) {
#line 1242 "projects.c"
			gint _tmp16_;
			gint _tmp17_;
			gint _tmp18_;
			Document* doc = NULL;
			GeeList* _tmp19_;
			gint _tmp20_;
			gpointer _tmp21_;
			Document* _tmp22_;
			gint _tmp23_;
			gint _tmp24_;
#line 160 "/home/seb/gnome/gnome-latex/src/projects.vala"
			_tmp16_ = _doc_index;
#line 160 "/home/seb/gnome/gnome-latex/src/projects.vala"
			_doc_index = _tmp16_ + 1;
#line 160 "/home/seb/gnome/gnome-latex/src/projects.vala"
			_tmp17_ = _doc_index;
#line 160 "/home/seb/gnome/gnome-latex/src/projects.vala"
			_tmp18_ = _doc_size;
#line 160 "/home/seb/gnome/gnome-latex/src/projects.vala"
			if (!(_tmp17_ < _tmp18_)) {
#line 160 "/home/seb/gnome/gnome-latex/src/projects.vala"
				break;
#line 1265 "projects.c"
			}
#line 160 "/home/seb/gnome/gnome-latex/src/projects.vala"
			_tmp19_ = _doc_list;
#line 160 "/home/seb/gnome/gnome-latex/src/projects.vala"
			_tmp20_ = _doc_index;
#line 160 "/home/seb/gnome/gnome-latex/src/projects.vala"
			_tmp21_ = gee_list_get (_tmp19_, _tmp20_);
#line 160 "/home/seb/gnome/gnome-latex/src/projects.vala"
			doc = (Document*) _tmp21_;
#line 162 "/home/seb/gnome/gnome-latex/src/projects.vala"
			_tmp22_ = doc;
#line 162 "/home/seb/gnome/gnome-latex/src/projects.vala"
			_tmp23_ = document_get_project_id (_tmp22_);
#line 162 "/home/seb/gnome/gnome-latex/src/projects.vala"
			_tmp24_ = _tmp23_;
#line 162 "/home/seb/gnome/gnome-latex/src/projects.vala"
			if (_tmp24_ == num) {
#line 1283 "projects.c"
				Document* _tmp25_;
#line 163 "/home/seb/gnome/gnome-latex/src/projects.vala"
				_tmp25_ = doc;
#line 163 "/home/seb/gnome/gnome-latex/src/projects.vala"
				document_set_project_id (_tmp25_, -1);
#line 1289 "projects.c"
			} else {
				Document* _tmp26_;
				gint _tmp27_;
				gint _tmp28_;
#line 164 "/home/seb/gnome/gnome-latex/src/projects.vala"
				_tmp26_ = doc;
#line 164 "/home/seb/gnome/gnome-latex/src/projects.vala"
				_tmp27_ = document_get_project_id (_tmp26_);
#line 164 "/home/seb/gnome/gnome-latex/src/projects.vala"
				_tmp28_ = _tmp27_;
#line 164 "/home/seb/gnome/gnome-latex/src/projects.vala"
				if (_tmp28_ > num) {
#line 1302 "projects.c"
					Document* _tmp29_;
					gint _tmp30_;
					gint _tmp31_;
#line 165 "/home/seb/gnome/gnome-latex/src/projects.vala"
					_tmp29_ = doc;
#line 165 "/home/seb/gnome/gnome-latex/src/projects.vala"
					_tmp30_ = document_get_project_id (_tmp29_);
#line 165 "/home/seb/gnome/gnome-latex/src/projects.vala"
					_tmp31_ = _tmp30_;
#line 165 "/home/seb/gnome/gnome-latex/src/projects.vala"
					document_set_project_id (_tmp29_, _tmp31_ - 1);
#line 1314 "projects.c"
				}
			}
#line 160 "/home/seb/gnome/gnome-latex/src/projects.vala"
			_g_object_unref0 (doc);
#line 1319 "projects.c"
		}
#line 160 "/home/seb/gnome/gnome-latex/src/projects.vala"
		_g_object_unref0 (_doc_list);
#line 1323 "projects.c"
	}
#line 168 "/home/seb/gnome/gnome-latex/src/projects.vala"
	projects_update_all_menus (self);
#line 152 "/home/seb/gnome/gnome-latex/src/projects.vala"
	_g_object_unref0 (docs);
#line 1329 "projects.c"
}


void
projects_clear_all (Projects* self)
{
	GeeLinkedList* _tmp0_;
#line 171 "/home/seb/gnome/gnome-latex/src/projects.vala"
	g_return_if_fail (self != NULL);
#line 173 "/home/seb/gnome/gnome-latex/src/projects.vala"
	_tmp0_ = self->priv->projects;
#line 173 "/home/seb/gnome/gnome-latex/src/projects.vala"
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp0_);
#line 174 "/home/seb/gnome/gnome-latex/src/projects.vala"
	self->priv->modified = TRUE;
#line 175 "/home/seb/gnome/gnome-latex/src/projects.vala"
	projects_update_all_documents (self);
#line 176 "/home/seb/gnome/gnome-latex/src/projects.vala"
	projects_update_all_menus (self);
#line 1349 "projects.c"
}


static void
projects_update_all_documents (Projects* self)
{
	GeeList* docs = NULL;
	GlatexApp* _tmp0_;
	GlatexApp* _tmp1_;
	GeeList* _tmp2_;
	GeeList* _tmp3_;
#line 179 "/home/seb/gnome/gnome-latex/src/projects.vala"
	g_return_if_fail (self != NULL);
#line 181 "/home/seb/gnome/gnome-latex/src/projects.vala"
	_tmp0_ = glatex_app_get_instance ();
#line 181 "/home/seb/gnome/gnome-latex/src/projects.vala"
	_tmp1_ = _tmp0_;
#line 181 "/home/seb/gnome/gnome-latex/src/projects.vala"
	_tmp2_ = glatex_app_get_documents (_tmp1_);
#line 181 "/home/seb/gnome/gnome-latex/src/projects.vala"
	_tmp3_ = _tmp2_;
#line 181 "/home/seb/gnome/gnome-latex/src/projects.vala"
	_g_object_unref0 (_tmp1_);
#line 181 "/home/seb/gnome/gnome-latex/src/projects.vala"
	docs = _tmp3_;
#line 1375 "projects.c"
	{
		GeeList* _doc_list = NULL;
		GeeList* _tmp4_;
		GeeList* _tmp5_;
		gint _doc_size = 0;
		GeeList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _doc_index = 0;
#line 182 "/home/seb/gnome/gnome-latex/src/projects.vala"
		_tmp4_ = docs;
#line 182 "/home/seb/gnome/gnome-latex/src/projects.vala"
		_tmp5_ = _g_object_ref0 (_tmp4_);
#line 182 "/home/seb/gnome/gnome-latex/src/projects.vala"
		_doc_list = _tmp5_;
#line 182 "/home/seb/gnome/gnome-latex/src/projects.vala"
		_tmp6_ = _doc_list;
#line 182 "/home/seb/gnome/gnome-latex/src/projects.vala"
		_tmp7_ = gee_collection_get_size ((GeeCollection*) _tmp6_);
#line 182 "/home/seb/gnome/gnome-latex/src/projects.vala"
		_tmp8_ = _tmp7_;
#line 182 "/home/seb/gnome/gnome-latex/src/projects.vala"
		_doc_size = _tmp8_;
#line 182 "/home/seb/gnome/gnome-latex/src/projects.vala"
		_doc_index = -1;
#line 182 "/home/seb/gnome/gnome-latex/src/projects.vala"
		while (TRUE) {
#line 1403 "projects.c"
			gint _tmp9_;
			gint _tmp10_;
			gint _tmp11_;
			Document* doc = NULL;
			GeeList* _tmp12_;
			gint _tmp13_;
			gpointer _tmp14_;
			Document* _tmp15_;
			Document* _tmp16_;
			GFile* _tmp17_;
			GFile* _tmp18_;
#line 182 "/home/seb/gnome/gnome-latex/src/projects.vala"
			_tmp9_ = _doc_index;
#line 182 "/home/seb/gnome/gnome-latex/src/projects.vala"
			_doc_index = _tmp9_ + 1;
#line 182 "/home/seb/gnome/gnome-latex/src/projects.vala"
			_tmp10_ = _doc_index;
#line 182 "/home/seb/gnome/gnome-latex/src/projects.vala"
			_tmp11_ = _doc_size;
#line 182 "/home/seb/gnome/gnome-latex/src/projects.vala"
			if (!(_tmp10_ < _tmp11_)) {
#line 182 "/home/seb/gnome/gnome-latex/src/projects.vala"
				break;
#line 1427 "projects.c"
			}
#line 182 "/home/seb/gnome/gnome-latex/src/projects.vala"
			_tmp12_ = _doc_list;
#line 182 "/home/seb/gnome/gnome-latex/src/projects.vala"
			_tmp13_ = _doc_index;
#line 182 "/home/seb/gnome/gnome-latex/src/projects.vala"
			_tmp14_ = gee_list_get (_tmp12_, _tmp13_);
#line 182 "/home/seb/gnome/gnome-latex/src/projects.vala"
			doc = (Document*) _tmp14_;
#line 184 "/home/seb/gnome/gnome-latex/src/projects.vala"
			_tmp15_ = doc;
#line 184 "/home/seb/gnome/gnome-latex/src/projects.vala"
			document_set_project_id (_tmp15_, -1);
#line 186 "/home/seb/gnome/gnome-latex/src/projects.vala"
			_tmp16_ = doc;
#line 186 "/home/seb/gnome/gnome-latex/src/projects.vala"
			_tmp17_ = document_get_location (_tmp16_);
#line 186 "/home/seb/gnome/gnome-latex/src/projects.vala"
			_tmp18_ = _tmp17_;
#line 186 "/home/seb/gnome/gnome-latex/src/projects.vala"
			if (_tmp18_ == NULL) {
#line 187 "/home/seb/gnome/gnome-latex/src/projects.vala"
				_g_object_unref0 (doc);
#line 187 "/home/seb/gnome/gnome-latex/src/projects.vala"
				continue;
#line 1453 "projects.c"
			}
			{
				gint i = 0;
#line 189 "/home/seb/gnome/gnome-latex/src/projects.vala"
				i = 0;
#line 1459 "projects.c"
				{
					gboolean _tmp19_ = FALSE;
#line 189 "/home/seb/gnome/gnome-latex/src/projects.vala"
					_tmp19_ = TRUE;
#line 189 "/home/seb/gnome/gnome-latex/src/projects.vala"
					while (TRUE) {
#line 1466 "projects.c"
						gint _tmp21_;
						GeeLinkedList* _tmp22_;
						gint _tmp23_;
						gint _tmp24_;
						Document* _tmp25_;
						GFile* _tmp26_;
						GFile* _tmp27_;
						GeeLinkedList* _tmp28_;
						gint _tmp29_;
						gpointer _tmp30_;
						Project* _tmp31_;
						GFile* _tmp32_;
						gboolean _tmp33_;
#line 189 "/home/seb/gnome/gnome-latex/src/projects.vala"
						if (!_tmp19_) {
#line 1482 "projects.c"
							gint _tmp20_;
#line 189 "/home/seb/gnome/gnome-latex/src/projects.vala"
							_tmp20_ = i;
#line 189 "/home/seb/gnome/gnome-latex/src/projects.vala"
							i = _tmp20_ + 1;
#line 1488 "projects.c"
						}
#line 189 "/home/seb/gnome/gnome-latex/src/projects.vala"
						_tmp19_ = FALSE;
#line 189 "/home/seb/gnome/gnome-latex/src/projects.vala"
						_tmp21_ = i;
#line 189 "/home/seb/gnome/gnome-latex/src/projects.vala"
						_tmp22_ = self->priv->projects;
#line 189 "/home/seb/gnome/gnome-latex/src/projects.vala"
						_tmp23_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp22_);
#line 189 "/home/seb/gnome/gnome-latex/src/projects.vala"
						_tmp24_ = _tmp23_;
#line 189 "/home/seb/gnome/gnome-latex/src/projects.vala"
						if (!(_tmp21_ < _tmp24_)) {
#line 189 "/home/seb/gnome/gnome-latex/src/projects.vala"
							break;
#line 1504 "projects.c"
						}
#line 191 "/home/seb/gnome/gnome-latex/src/projects.vala"
						_tmp25_ = doc;
#line 191 "/home/seb/gnome/gnome-latex/src/projects.vala"
						_tmp26_ = document_get_location (_tmp25_);
#line 191 "/home/seb/gnome/gnome-latex/src/projects.vala"
						_tmp27_ = _tmp26_;
#line 191 "/home/seb/gnome/gnome-latex/src/projects.vala"
						_tmp28_ = self->priv->projects;
#line 191 "/home/seb/gnome/gnome-latex/src/projects.vala"
						_tmp29_ = i;
#line 191 "/home/seb/gnome/gnome-latex/src/projects.vala"
						_tmp30_ = gee_abstract_list_get ((GeeAbstractList*) _tmp28_, _tmp29_);
#line 191 "/home/seb/gnome/gnome-latex/src/projects.vala"
						_tmp31_ = (Project*) _tmp30_;
#line 191 "/home/seb/gnome/gnome-latex/src/projects.vala"
						_tmp32_ = (*_tmp31_).directory;
#line 191 "/home/seb/gnome/gnome-latex/src/projects.vala"
						_tmp33_ = g_file_has_prefix (_tmp27_, _tmp32_);
#line 191 "/home/seb/gnome/gnome-latex/src/projects.vala"
						_project_free0 (_tmp31_);
#line 191 "/home/seb/gnome/gnome-latex/src/projects.vala"
						if (_tmp33_) {
#line 1528 "projects.c"
							Document* _tmp34_;
							gint _tmp35_;
#line 193 "/home/seb/gnome/gnome-latex/src/projects.vala"
							_tmp34_ = doc;
#line 193 "/home/seb/gnome/gnome-latex/src/projects.vala"
							_tmp35_ = i;
#line 193 "/home/seb/gnome/gnome-latex/src/projects.vala"
							document_set_project_id (_tmp34_, _tmp35_);
#line 194 "/home/seb/gnome/gnome-latex/src/projects.vala"
							break;
#line 1539 "projects.c"
						}
					}
				}
			}
#line 182 "/home/seb/gnome/gnome-latex/src/projects.vala"
			_g_object_unref0 (doc);
#line 1546 "projects.c"
		}
#line 182 "/home/seb/gnome/gnome-latex/src/projects.vala"
		_g_object_unref0 (_doc_list);
#line 1550 "projects.c"
	}
#line 179 "/home/seb/gnome/gnome-latex/src/projects.vala"
	_g_object_unref0 (docs);
#line 1554 "projects.c"
}


static void
projects_parser_start (Projects* self,
                       GMarkupParseContext* context,
                       const gchar* name,
                       gchar** attr_names,
                       int attr_names_length1,
                       gchar** attr_values,
                       int attr_values_length1,
                       GError** error)
{
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
#line 203 "/home/seb/gnome/gnome-latex/src/projects.vala"
	static GQuark _tmp1_label0 = 0;
#line 203 "/home/seb/gnome/gnome-latex/src/projects.vala"
	static GQuark _tmp1_label1 = 0;
#line 1574 "projects.c"
	GError * _inner_error_ = NULL;
#line 200 "/home/seb/gnome/gnome-latex/src/projects.vala"
	g_return_if_fail (self != NULL);
#line 200 "/home/seb/gnome/gnome-latex/src/projects.vala"
	g_return_if_fail (context != NULL);
#line 200 "/home/seb/gnome/gnome-latex/src/projects.vala"
	g_return_if_fail (name != NULL);
#line 203 "/home/seb/gnome/gnome-latex/src/projects.vala"
	_tmp0_ = name;
#line 203 "/home/seb/gnome/gnome-latex/src/projects.vala"
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
#line 203 "/home/seb/gnome/gnome-latex/src/projects.vala"
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("projects")))) {
#line 203 "/home/seb/gnome/gnome-latex/src/projects.vala"
		switch (0) {
#line 1590 "projects.c"
			default:
			{
#line 206 "/home/seb/gnome/gnome-latex/src/projects.vala"
				return;
#line 1595 "projects.c"
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("project")))) {
#line 203 "/home/seb/gnome/gnome-latex/src/projects.vala"
		switch (0) {
#line 1601 "projects.c"
			default:
			{
				Project project = {0};
				GeeLinkedList* _tmp25_;
				Project _tmp26_;
#line 209 "/home/seb/gnome/gnome-latex/src/projects.vala"
				memset (&project, 0, sizeof (Project));
#line 1609 "projects.c"
				{
					gint i = 0;
#line 210 "/home/seb/gnome/gnome-latex/src/projects.vala"
					i = 0;
#line 1614 "projects.c"
					{
						gboolean _tmp3_ = FALSE;
#line 210 "/home/seb/gnome/gnome-latex/src/projects.vala"
						_tmp3_ = TRUE;
#line 210 "/home/seb/gnome/gnome-latex/src/projects.vala"
						while (TRUE) {
#line 1621 "projects.c"
							gint _tmp5_;
							gint _tmp6_;
							const gchar* _tmp7_;
							const gchar* _tmp8_;
							GQuark _tmp10_ = 0U;
#line 212 "/home/seb/gnome/gnome-latex/src/projects.vala"
							static GQuark _tmp9_label0 = 0;
#line 212 "/home/seb/gnome/gnome-latex/src/projects.vala"
							static GQuark _tmp9_label1 = 0;
#line 210 "/home/seb/gnome/gnome-latex/src/projects.vala"
							if (!_tmp3_) {
#line 1633 "projects.c"
								gint _tmp4_;
#line 210 "/home/seb/gnome/gnome-latex/src/projects.vala"
								_tmp4_ = i;
#line 210 "/home/seb/gnome/gnome-latex/src/projects.vala"
								i = _tmp4_ + 1;
#line 1639 "projects.c"
							}
#line 210 "/home/seb/gnome/gnome-latex/src/projects.vala"
							_tmp3_ = FALSE;
#line 210 "/home/seb/gnome/gnome-latex/src/projects.vala"
							_tmp5_ = i;
#line 210 "/home/seb/gnome/gnome-latex/src/projects.vala"
							if (!(_tmp5_ < attr_names_length1)) {
#line 210 "/home/seb/gnome/gnome-latex/src/projects.vala"
								break;
#line 1649 "projects.c"
							}
#line 212 "/home/seb/gnome/gnome-latex/src/projects.vala"
							_tmp6_ = i;
#line 212 "/home/seb/gnome/gnome-latex/src/projects.vala"
							_tmp7_ = attr_names[_tmp6_];
#line 212 "/home/seb/gnome/gnome-latex/src/projects.vala"
							_tmp8_ = _tmp7_;
#line 212 "/home/seb/gnome/gnome-latex/src/projects.vala"
							_tmp10_ = (NULL == _tmp8_) ? 0 : g_quark_from_string (_tmp8_);
#line 212 "/home/seb/gnome/gnome-latex/src/projects.vala"
							if (_tmp10_ == ((0 != _tmp9_label0) ? _tmp9_label0 : (_tmp9_label0 = g_quark_from_static_string ("directory")))) {
#line 212 "/home/seb/gnome/gnome-latex/src/projects.vala"
								switch (0) {
#line 1663 "projects.c"
									default:
									{
										gint _tmp11_;
										const gchar* _tmp12_;
										GFile* _tmp13_;
#line 215 "/home/seb/gnome/gnome-latex/src/projects.vala"
										_tmp11_ = i;
#line 215 "/home/seb/gnome/gnome-latex/src/projects.vala"
										_tmp12_ = attr_values[_tmp11_];
#line 215 "/home/seb/gnome/gnome-latex/src/projects.vala"
										_tmp13_ = g_file_new_for_uri (_tmp12_);
#line 215 "/home/seb/gnome/gnome-latex/src/projects.vala"
										_g_object_unref0 (project.directory);
#line 215 "/home/seb/gnome/gnome-latex/src/projects.vala"
										project.directory = _tmp13_;
#line 216 "/home/seb/gnome/gnome-latex/src/projects.vala"
										break;
#line 1681 "projects.c"
									}
								}
							} else if (_tmp10_ == ((0 != _tmp9_label1) ? _tmp9_label1 : (_tmp9_label1 = g_quark_from_static_string ("main_file")))) {
#line 212 "/home/seb/gnome/gnome-latex/src/projects.vala"
								switch (0) {
#line 1687 "projects.c"
									default:
									{
										gint _tmp14_;
										const gchar* _tmp15_;
										GFile* _tmp16_;
#line 218 "/home/seb/gnome/gnome-latex/src/projects.vala"
										_tmp14_ = i;
#line 218 "/home/seb/gnome/gnome-latex/src/projects.vala"
										_tmp15_ = attr_values[_tmp14_];
#line 218 "/home/seb/gnome/gnome-latex/src/projects.vala"
										_tmp16_ = g_file_new_for_uri (_tmp15_);
#line 218 "/home/seb/gnome/gnome-latex/src/projects.vala"
										_g_object_unref0 (project.main_file);
#line 218 "/home/seb/gnome/gnome-latex/src/projects.vala"
										project.main_file = _tmp16_;
#line 219 "/home/seb/gnome/gnome-latex/src/projects.vala"
										break;
#line 1705 "projects.c"
									}
								}
							} else {
#line 212 "/home/seb/gnome/gnome-latex/src/projects.vala"
								switch (0) {
#line 1711 "projects.c"
									default:
									{
										gint _tmp17_;
										const gchar* _tmp18_;
										gchar* _tmp19_;
										gchar* _tmp20_;
										gchar* _tmp21_;
										gchar* _tmp22_;
										GError* _tmp23_;
										GError* _tmp24_;
#line 221 "/home/seb/gnome/gnome-latex/src/projects.vala"
										_tmp17_ = i;
#line 221 "/home/seb/gnome/gnome-latex/src/projects.vala"
										_tmp18_ = attr_names[_tmp17_];
#line 221 "/home/seb/gnome/gnome-latex/src/projects.vala"
										_tmp19_ = g_strconcat ("unknown attribute \"", _tmp18_, NULL);
#line 221 "/home/seb/gnome/gnome-latex/src/projects.vala"
										_tmp20_ = _tmp19_;
#line 221 "/home/seb/gnome/gnome-latex/src/projects.vala"
										_tmp21_ = g_strconcat (_tmp20_, "\"", NULL);
#line 221 "/home/seb/gnome/gnome-latex/src/projects.vala"
										_tmp22_ = _tmp21_;
#line 221 "/home/seb/gnome/gnome-latex/src/projects.vala"
										_tmp23_ = g_error_new_literal (G_MARKUP_ERROR, G_MARKUP_ERROR_UNKNOWN_ATTRIBUTE, _tmp22_);
#line 221 "/home/seb/gnome/gnome-latex/src/projects.vala"
										_tmp24_ = _tmp23_;
#line 221 "/home/seb/gnome/gnome-latex/src/projects.vala"
										_g_free0 (_tmp22_);
#line 221 "/home/seb/gnome/gnome-latex/src/projects.vala"
										_g_free0 (_tmp20_);
#line 221 "/home/seb/gnome/gnome-latex/src/projects.vala"
										_inner_error_ = _tmp24_;
#line 221 "/home/seb/gnome/gnome-latex/src/projects.vala"
										if (_inner_error_->domain == G_MARKUP_ERROR) {
#line 221 "/home/seb/gnome/gnome-latex/src/projects.vala"
											g_propagate_error (error, _inner_error_);
#line 221 "/home/seb/gnome/gnome-latex/src/projects.vala"
											project_destroy (&project);
#line 221 "/home/seb/gnome/gnome-latex/src/projects.vala"
											return;
#line 1752 "projects.c"
										} else {
#line 221 "/home/seb/gnome/gnome-latex/src/projects.vala"
											project_destroy (&project);
#line 221 "/home/seb/gnome/gnome-latex/src/projects.vala"
											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 221 "/home/seb/gnome/gnome-latex/src/projects.vala"
											g_clear_error (&_inner_error_);
#line 221 "/home/seb/gnome/gnome-latex/src/projects.vala"
											return;
#line 1762 "projects.c"
										}
									}
								}
							}
						}
					}
				}
#line 225 "/home/seb/gnome/gnome-latex/src/projects.vala"
				_tmp25_ = self->priv->projects;
#line 225 "/home/seb/gnome/gnome-latex/src/projects.vala"
				_tmp26_ = project;
#line 225 "/home/seb/gnome/gnome-latex/src/projects.vala"
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp25_, &_tmp26_);
#line 226 "/home/seb/gnome/gnome-latex/src/projects.vala"
				project_destroy (&project);
#line 226 "/home/seb/gnome/gnome-latex/src/projects.vala"
				break;
#line 1780 "projects.c"
			}
		}
	} else {
#line 203 "/home/seb/gnome/gnome-latex/src/projects.vala"
		switch (0) {
#line 1786 "projects.c"
			default:
			{
				gchar* _tmp27_;
				gchar* _tmp28_;
				gchar* _tmp29_;
				gchar* _tmp30_;
				GError* _tmp31_;
				GError* _tmp32_;
#line 229 "/home/seb/gnome/gnome-latex/src/projects.vala"
				_tmp27_ = g_strconcat ("unknown element \"", name, NULL);
#line 229 "/home/seb/gnome/gnome-latex/src/projects.vala"
				_tmp28_ = _tmp27_;
#line 229 "/home/seb/gnome/gnome-latex/src/projects.vala"
				_tmp29_ = g_strconcat (_tmp28_, "\"", NULL);
#line 229 "/home/seb/gnome/gnome-latex/src/projects.vala"
				_tmp30_ = _tmp29_;
#line 229 "/home/seb/gnome/gnome-latex/src/projects.vala"
				_tmp31_ = g_error_new_literal (G_MARKUP_ERROR, G_MARKUP_ERROR_UNKNOWN_ELEMENT, _tmp30_);
#line 229 "/home/seb/gnome/gnome-latex/src/projects.vala"
				_tmp32_ = _tmp31_;
#line 229 "/home/seb/gnome/gnome-latex/src/projects.vala"
				_g_free0 (_tmp30_);
#line 229 "/home/seb/gnome/gnome-latex/src/projects.vala"
				_g_free0 (_tmp28_);
#line 229 "/home/seb/gnome/gnome-latex/src/projects.vala"
				_inner_error_ = _tmp32_;
#line 229 "/home/seb/gnome/gnome-latex/src/projects.vala"
				if (_inner_error_->domain == G_MARKUP_ERROR) {
#line 229 "/home/seb/gnome/gnome-latex/src/projects.vala"
					g_propagate_error (error, _inner_error_);
#line 229 "/home/seb/gnome/gnome-latex/src/projects.vala"
					return;
#line 1819 "projects.c"
				} else {
#line 229 "/home/seb/gnome/gnome-latex/src/projects.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 229 "/home/seb/gnome/gnome-latex/src/projects.vala"
					g_clear_error (&_inner_error_);
#line 229 "/home/seb/gnome/gnome-latex/src/projects.vala"
					return;
#line 1827 "projects.c"
				}
			}
		}
	}
}


static GFile*
projects_get_xml_file (Projects* self)
{
	GFile* result = NULL;
	gchar* path = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	GFile* _tmp2_;
#line 234 "/home/seb/gnome/gnome-latex/src/projects.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 236 "/home/seb/gnome/gnome-latex/src/projects.vala"
	_tmp0_ = g_get_user_data_dir ();
#line 236 "/home/seb/gnome/gnome-latex/src/projects.vala"
	_tmp1_ = g_build_filename (_tmp0_, "gnome-latex", "projects.xml", NULL, NULL);
#line 236 "/home/seb/gnome/gnome-latex/src/projects.vala"
	path = _tmp1_;
#line 238 "/home/seb/gnome/gnome-latex/src/projects.vala"
	_tmp2_ = g_file_new_for_path (path);
#line 238 "/home/seb/gnome/gnome-latex/src/projects.vala"
	result = _tmp2_;
#line 238 "/home/seb/gnome/gnome-latex/src/projects.vala"
	_g_free0 (path);
#line 238 "/home/seb/gnome/gnome-latex/src/projects.vala"
	return result;
#line 1859 "projects.c"
}


void
projects_save (Projects* self)
{
	gboolean _tmp0_;
	GFile* file = NULL;
	GFile* _tmp1_;
	GeeLinkedList* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gchar* content = NULL;
	gchar* _tmp6_;
	const gchar* _tmp33_;
	gchar* _tmp34_;
	GFile* _tmp35_;
	const gchar* _tmp36_;
#line 241 "/home/seb/gnome/gnome-latex/src/projects.vala"
	g_return_if_fail (self != NULL);
#line 243 "/home/seb/gnome/gnome-latex/src/projects.vala"
	_tmp0_ = self->priv->modified;
#line 243 "/home/seb/gnome/gnome-latex/src/projects.vala"
	if (!_tmp0_) {
#line 244 "/home/seb/gnome/gnome-latex/src/projects.vala"
		return;
#line 1886 "projects.c"
	}
#line 246 "/home/seb/gnome/gnome-latex/src/projects.vala"
	_tmp1_ = projects_get_xml_file (self);
#line 246 "/home/seb/gnome/gnome-latex/src/projects.vala"
	file = _tmp1_;
#line 249 "/home/seb/gnome/gnome-latex/src/projects.vala"
	_tmp2_ = self->priv->projects;
#line 249 "/home/seb/gnome/gnome-latex/src/projects.vala"
	_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
#line 249 "/home/seb/gnome/gnome-latex/src/projects.vala"
	_tmp4_ = _tmp3_;
#line 249 "/home/seb/gnome/gnome-latex/src/projects.vala"
	if (_tmp4_ == 0) {
#line 1900 "projects.c"
		GFile* _tmp5_;
#line 251 "/home/seb/gnome/gnome-latex/src/projects.vala"
		_tmp5_ = file;
#line 251 "/home/seb/gnome/gnome-latex/src/projects.vala"
		utils_delete_file (_tmp5_);
#line 252 "/home/seb/gnome/gnome-latex/src/projects.vala"
		_g_object_unref0 (file);
#line 252 "/home/seb/gnome/gnome-latex/src/projects.vala"
		return;
#line 1910 "projects.c"
	}
#line 255 "/home/seb/gnome/gnome-latex/src/projects.vala"
	_tmp6_ = g_strdup ("<projects>\n");
#line 255 "/home/seb/gnome/gnome-latex/src/projects.vala"
	content = _tmp6_;
#line 1916 "projects.c"
	{
		GeeLinkedList* _project_list = NULL;
		GeeLinkedList* _tmp7_;
		GeeLinkedList* _tmp8_;
		gint _project_size = 0;
		GeeLinkedList* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		gint _project_index = 0;
#line 256 "/home/seb/gnome/gnome-latex/src/projects.vala"
		_tmp7_ = self->priv->projects;
#line 256 "/home/seb/gnome/gnome-latex/src/projects.vala"
		_tmp8_ = _g_object_ref0 (_tmp7_);
#line 256 "/home/seb/gnome/gnome-latex/src/projects.vala"
		_project_list = _tmp8_;
#line 256 "/home/seb/gnome/gnome-latex/src/projects.vala"
		_tmp9_ = _project_list;
#line 256 "/home/seb/gnome/gnome-latex/src/projects.vala"
		_tmp10_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp9_);
#line 256 "/home/seb/gnome/gnome-latex/src/projects.vala"
		_tmp11_ = _tmp10_;
#line 256 "/home/seb/gnome/gnome-latex/src/projects.vala"
		_project_size = _tmp11_;
#line 256 "/home/seb/gnome/gnome-latex/src/projects.vala"
		_project_index = -1;
#line 256 "/home/seb/gnome/gnome-latex/src/projects.vala"
		while (TRUE) {
#line 1944 "projects.c"
			gint _tmp12_;
			gint _tmp13_;
			gint _tmp14_;
			Project project = {0};
			GeeLinkedList* _tmp15_;
			gint _tmp16_;
			gpointer _tmp17_;
			Project* _tmp18_;
			Project _tmp19_ = {0};
			Project _tmp20_;
			const gchar* _tmp21_;
			Project _tmp22_;
			GFile* _tmp23_;
			gchar* _tmp24_;
			gchar* _tmp25_;
			Project _tmp26_;
			GFile* _tmp27_;
			gchar* _tmp28_;
			gchar* _tmp29_;
			gchar* _tmp30_;
			gchar* _tmp31_;
			gchar* _tmp32_;
#line 256 "/home/seb/gnome/gnome-latex/src/projects.vala"
			_tmp12_ = _project_index;
#line 256 "/home/seb/gnome/gnome-latex/src/projects.vala"
			_project_index = _tmp12_ + 1;
#line 256 "/home/seb/gnome/gnome-latex/src/projects.vala"
			_tmp13_ = _project_index;
#line 256 "/home/seb/gnome/gnome-latex/src/projects.vala"
			_tmp14_ = _project_size;
#line 256 "/home/seb/gnome/gnome-latex/src/projects.vala"
			if (!(_tmp13_ < _tmp14_)) {
#line 256 "/home/seb/gnome/gnome-latex/src/projects.vala"
				break;
#line 1979 "projects.c"
			}
#line 256 "/home/seb/gnome/gnome-latex/src/projects.vala"
			_tmp15_ = _project_list;
#line 256 "/home/seb/gnome/gnome-latex/src/projects.vala"
			_tmp16_ = _project_index;
#line 256 "/home/seb/gnome/gnome-latex/src/projects.vala"
			_tmp17_ = gee_abstract_list_get ((GeeAbstractList*) _tmp15_, _tmp16_);
#line 256 "/home/seb/gnome/gnome-latex/src/projects.vala"
			_tmp18_ = (Project*) _tmp17_;
#line 256 "/home/seb/gnome/gnome-latex/src/projects.vala"
			project_copy (_tmp18_, &_tmp19_);
#line 256 "/home/seb/gnome/gnome-latex/src/projects.vala"
			_tmp20_ = _tmp19_;
#line 256 "/home/seb/gnome/gnome-latex/src/projects.vala"
			_project_free0 (_tmp18_);
#line 256 "/home/seb/gnome/gnome-latex/src/projects.vala"
			project = _tmp20_;
#line 258 "/home/seb/gnome/gnome-latex/src/projects.vala"
			_tmp21_ = content;
#line 258 "/home/seb/gnome/gnome-latex/src/projects.vala"
			_tmp22_ = project;
#line 258 "/home/seb/gnome/gnome-latex/src/projects.vala"
			_tmp23_ = _tmp22_.directory;
#line 258 "/home/seb/gnome/gnome-latex/src/projects.vala"
			_tmp24_ = g_file_get_uri (_tmp23_);
#line 258 "/home/seb/gnome/gnome-latex/src/projects.vala"
			_tmp25_ = _tmp24_;
#line 258 "/home/seb/gnome/gnome-latex/src/projects.vala"
			_tmp26_ = project;
#line 258 "/home/seb/gnome/gnome-latex/src/projects.vala"
			_tmp27_ = _tmp26_.main_file;
#line 258 "/home/seb/gnome/gnome-latex/src/projects.vala"
			_tmp28_ = g_file_get_uri (_tmp27_);
#line 258 "/home/seb/gnome/gnome-latex/src/projects.vala"
			_tmp29_ = _tmp28_;
#line 258 "/home/seb/gnome/gnome-latex/src/projects.vala"
			_tmp30_ = g_strdup_printf ("  <project directory=\"%s\" main_file=\"%s\" />\n", _tmp25_, _tmp29_);
#line 258 "/home/seb/gnome/gnome-latex/src/projects.vala"
			_tmp31_ = _tmp30_;
#line 258 "/home/seb/gnome/gnome-latex/src/projects.vala"
			_tmp32_ = g_strconcat (_tmp21_, _tmp31_, NULL);
#line 258 "/home/seb/gnome/gnome-latex/src/projects.vala"
			_g_free0 (content);
#line 258 "/home/seb/gnome/gnome-latex/src/projects.vala"
			content = _tmp32_;
#line 258 "/home/seb/gnome/gnome-latex/src/projects.vala"
			_g_free0 (_tmp31_);
#line 258 "/home/seb/gnome/gnome-latex/src/projects.vala"
			_g_free0 (_tmp29_);
#line 258 "/home/seb/gnome/gnome-latex/src/projects.vala"
			_g_free0 (_tmp25_);
#line 256 "/home/seb/gnome/gnome-latex/src/projects.vala"
			project_destroy (&project);
#line 2033 "projects.c"
		}
#line 256 "/home/seb/gnome/gnome-latex/src/projects.vala"
		_g_object_unref0 (_project_list);
#line 2037 "projects.c"
	}
#line 261 "/home/seb/gnome/gnome-latex/src/projects.vala"
	_tmp33_ = content;
#line 261 "/home/seb/gnome/gnome-latex/src/projects.vala"
	_tmp34_ = g_strconcat (_tmp33_, "</projects>\n", NULL);
#line 261 "/home/seb/gnome/gnome-latex/src/projects.vala"
	_g_free0 (content);
#line 261 "/home/seb/gnome/gnome-latex/src/projects.vala"
	content = _tmp34_;
#line 263 "/home/seb/gnome/gnome-latex/src/projects.vala"
	_tmp35_ = file;
#line 263 "/home/seb/gnome/gnome-latex/src/projects.vala"
	_tmp36_ = content;
#line 263 "/home/seb/gnome/gnome-latex/src/projects.vala"
	utils_save_file (_tmp35_, _tmp36_, FALSE);
#line 241 "/home/seb/gnome/gnome-latex/src/projects.vala"
	_g_free0 (content);
#line 241 "/home/seb/gnome/gnome-latex/src/projects.vala"
	_g_object_unref0 (file);
#line 2057 "projects.c"
}


static gboolean
projects_conflict (Projects* self,
                   GFile* dir1,
                   GFile* dir2)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
#line 267 "/home/seb/gnome/gnome-latex/src/projects.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 267 "/home/seb/gnome/gnome-latex/src/projects.vala"
	g_return_val_if_fail (dir1 != NULL, FALSE);
#line 267 "/home/seb/gnome/gnome-latex/src/projects.vala"
	g_return_val_if_fail (dir2 != NULL, FALSE);
#line 269 "/home/seb/gnome/gnome-latex/src/projects.vala"
	if (g_file_has_prefix (dir1, dir2)) {
#line 269 "/home/seb/gnome/gnome-latex/src/projects.vala"
		_tmp1_ = TRUE;
#line 2079 "projects.c"
	} else {
#line 269 "/home/seb/gnome/gnome-latex/src/projects.vala"
		_tmp1_ = g_file_has_prefix (dir2, dir1);
#line 2083 "projects.c"
	}
#line 269 "/home/seb/gnome/gnome-latex/src/projects.vala"
	if (_tmp1_) {
#line 269 "/home/seb/gnome/gnome-latex/src/projects.vala"
		_tmp0_ = TRUE;
#line 2089 "projects.c"
	} else {
#line 269 "/home/seb/gnome/gnome-latex/src/projects.vala"
		_tmp0_ = g_file_equal (dir1, dir2);
#line 2093 "projects.c"
	}
#line 269 "/home/seb/gnome/gnome-latex/src/projects.vala"
	result = _tmp0_;
#line 269 "/home/seb/gnome/gnome-latex/src/projects.vala"
	return result;
#line 2099 "projects.c"
}


static void
value_projects_init (GValue* value)
{
#line 28 "/home/seb/gnome/gnome-latex/src/projects.vala"
	value->data[0].v_pointer = NULL;
#line 2108 "projects.c"
}


static void
value_projects_free_value (GValue* value)
{
#line 28 "/home/seb/gnome/gnome-latex/src/projects.vala"
	if (value->data[0].v_pointer) {
#line 28 "/home/seb/gnome/gnome-latex/src/projects.vala"
		projects_unref (value->data[0].v_pointer);
#line 2119 "projects.c"
	}
}


static void
value_projects_copy_value (const GValue* src_value,
                           GValue* dest_value)
{
#line 28 "/home/seb/gnome/gnome-latex/src/projects.vala"
	if (src_value->data[0].v_pointer) {
#line 28 "/home/seb/gnome/gnome-latex/src/projects.vala"
		dest_value->data[0].v_pointer = projects_ref (src_value->data[0].v_pointer);
#line 2132 "projects.c"
	} else {
#line 28 "/home/seb/gnome/gnome-latex/src/projects.vala"
		dest_value->data[0].v_pointer = NULL;
#line 2136 "projects.c"
	}
}


static gpointer
value_projects_peek_pointer (const GValue* value)
{
#line 28 "/home/seb/gnome/gnome-latex/src/projects.vala"
	return value->data[0].v_pointer;
#line 2146 "projects.c"
}


static gchar*
value_projects_collect_value (GValue* value,
                              guint n_collect_values,
                              GTypeCValue* collect_values,
                              guint collect_flags)
{
#line 28 "/home/seb/gnome/gnome-latex/src/projects.vala"
	if (collect_values[0].v_pointer) {
#line 2158 "projects.c"
		Projects * object;
		object = collect_values[0].v_pointer;
#line 28 "/home/seb/gnome/gnome-latex/src/projects.vala"
		if (object->parent_instance.g_class == NULL) {
#line 28 "/home/seb/gnome/gnome-latex/src/projects.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2165 "projects.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 28 "/home/seb/gnome/gnome-latex/src/projects.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2169 "projects.c"
		}
#line 28 "/home/seb/gnome/gnome-latex/src/projects.vala"
		value->data[0].v_pointer = projects_ref (object);
#line 2173 "projects.c"
	} else {
#line 28 "/home/seb/gnome/gnome-latex/src/projects.vala"
		value->data[0].v_pointer = NULL;
#line 2177 "projects.c"
	}
#line 28 "/home/seb/gnome/gnome-latex/src/projects.vala"
	return NULL;
#line 2181 "projects.c"
}


static gchar*
value_projects_lcopy_value (const GValue* value,
                            guint n_collect_values,
                            GTypeCValue* collect_values,
                            guint collect_flags)
{
	Projects ** object_p;
	object_p = collect_values[0].v_pointer;
#line 28 "/home/seb/gnome/gnome-latex/src/projects.vala"
	if (!object_p) {
#line 28 "/home/seb/gnome/gnome-latex/src/projects.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 2197 "projects.c"
	}
#line 28 "/home/seb/gnome/gnome-latex/src/projects.vala"
	if (!value->data[0].v_pointer) {
#line 28 "/home/seb/gnome/gnome-latex/src/projects.vala"
		*object_p = NULL;
#line 2203 "projects.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 28 "/home/seb/gnome/gnome-latex/src/projects.vala"
		*object_p = value->data[0].v_pointer;
#line 2207 "projects.c"
	} else {
#line 28 "/home/seb/gnome/gnome-latex/src/projects.vala"
		*object_p = projects_ref (value->data[0].v_pointer);
#line 2211 "projects.c"
	}
#line 28 "/home/seb/gnome/gnome-latex/src/projects.vala"
	return NULL;
#line 2215 "projects.c"
}


GParamSpec*
param_spec_projects (const gchar* name,
                     const gchar* nick,
                     const gchar* blurb,
                     GType object_type,
                     GParamFlags flags)
{
	ParamSpecProjects* spec;
#line 28 "/home/seb/gnome/gnome-latex/src/projects.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_PROJECTS), NULL);
#line 28 "/home/seb/gnome/gnome-latex/src/projects.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 28 "/home/seb/gnome/gnome-latex/src/projects.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 28 "/home/seb/gnome/gnome-latex/src/projects.vala"
	return G_PARAM_SPEC (spec);
#line 2235 "projects.c"
}


gpointer
value_get_projects (const GValue* value)
{
#line 28 "/home/seb/gnome/gnome-latex/src/projects.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PROJECTS), NULL);
#line 28 "/home/seb/gnome/gnome-latex/src/projects.vala"
	return value->data[0].v_pointer;
#line 2246 "projects.c"
}


void
value_set_projects (GValue* value,
                    gpointer v_object)
{
	Projects * old;
#line 28 "/home/seb/gnome/gnome-latex/src/projects.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PROJECTS));
#line 28 "/home/seb/gnome/gnome-latex/src/projects.vala"
	old = value->data[0].v_pointer;
#line 28 "/home/seb/gnome/gnome-latex/src/projects.vala"
	if (v_object) {
#line 28 "/home/seb/gnome/gnome-latex/src/projects.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PROJECTS));
#line 28 "/home/seb/gnome/gnome-latex/src/projects.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 28 "/home/seb/gnome/gnome-latex/src/projects.vala"
		value->data[0].v_pointer = v_object;
#line 28 "/home/seb/gnome/gnome-latex/src/projects.vala"
		projects_ref (value->data[0].v_pointer);
#line 2269 "projects.c"
	} else {
#line 28 "/home/seb/gnome/gnome-latex/src/projects.vala"
		value->data[0].v_pointer = NULL;
#line 2273 "projects.c"
	}
#line 28 "/home/seb/gnome/gnome-latex/src/projects.vala"
	if (old) {
#line 28 "/home/seb/gnome/gnome-latex/src/projects.vala"
		projects_unref (old);
#line 2279 "projects.c"
	}
}


void
value_take_projects (GValue* value,
                     gpointer v_object)
{
	Projects * old;
#line 28 "/home/seb/gnome/gnome-latex/src/projects.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PROJECTS));
#line 28 "/home/seb/gnome/gnome-latex/src/projects.vala"
	old = value->data[0].v_pointer;
#line 28 "/home/seb/gnome/gnome-latex/src/projects.vala"
	if (v_object) {
#line 28 "/home/seb/gnome/gnome-latex/src/projects.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PROJECTS));
#line 28 "/home/seb/gnome/gnome-latex/src/projects.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 28 "/home/seb/gnome/gnome-latex/src/projects.vala"
		value->data[0].v_pointer = v_object;
#line 2301 "projects.c"
	} else {
#line 28 "/home/seb/gnome/gnome-latex/src/projects.vala"
		value->data[0].v_pointer = NULL;
#line 2305 "projects.c"
	}
#line 28 "/home/seb/gnome/gnome-latex/src/projects.vala"
	if (old) {
#line 28 "/home/seb/gnome/gnome-latex/src/projects.vala"
		projects_unref (old);
#line 2311 "projects.c"
	}
}


static void
projects_class_init (ProjectsClass * klass)
{
#line 28 "/home/seb/gnome/gnome-latex/src/projects.vala"
	projects_parent_class = g_type_class_peek_parent (klass);
#line 28 "/home/seb/gnome/gnome-latex/src/projects.vala"
	((ProjectsClass *) klass)->finalize = projects_finalize;
#line 28 "/home/seb/gnome/gnome-latex/src/projects.vala"
	g_type_class_add_private (klass, sizeof (ProjectsPrivate));
#line 2325 "projects.c"
}


static void
projects_instance_init (Projects * self)
{
#line 28 "/home/seb/gnome/gnome-latex/src/projects.vala"
	self->priv = PROJECTS_GET_PRIVATE (self);
#line 33 "/home/seb/gnome/gnome-latex/src/projects.vala"
	self->priv->modified = FALSE;
#line 28 "/home/seb/gnome/gnome-latex/src/projects.vala"
	self->ref_count = 1;
#line 2338 "projects.c"
}


static void
projects_finalize (Projects * obj)
{
	Projects * self;
#line 28 "/home/seb/gnome/gnome-latex/src/projects.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PROJECTS, Projects);
#line 28 "/home/seb/gnome/gnome-latex/src/projects.vala"
	g_signal_handlers_destroy (self);
#line 32 "/home/seb/gnome/gnome-latex/src/projects.vala"
	_g_object_unref0 (self->priv->projects);
#line 2352 "projects.c"
}


GType
projects_get_type (void)
{
	static volatile gsize projects_type_id__volatile = 0;
	if (g_once_init_enter (&projects_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_projects_init, value_projects_free_value, value_projects_copy_value, value_projects_peek_pointer, "p", value_projects_collect_value, "p", value_projects_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ProjectsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) projects_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Projects), 0, (GInstanceInitFunc) projects_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType projects_type_id;
		projects_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Projects", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&projects_type_id__volatile, projects_type_id);
	}
	return projects_type_id__volatile;
}


gpointer
projects_ref (gpointer instance)
{
	Projects * self;
	self = instance;
#line 28 "/home/seb/gnome/gnome-latex/src/projects.vala"
	g_atomic_int_inc (&self->ref_count);
#line 28 "/home/seb/gnome/gnome-latex/src/projects.vala"
	return instance;
#line 2381 "projects.c"
}


void
projects_unref (gpointer instance)
{
	Projects * self;
	self = instance;
#line 28 "/home/seb/gnome/gnome-latex/src/projects.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 28 "/home/seb/gnome/gnome-latex/src/projects.vala"
		PROJECTS_GET_CLASS (self)->finalize (self);
#line 28 "/home/seb/gnome/gnome-latex/src/projects.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 2396 "projects.c"
	}
}


static gint
_vala_array_length (gpointer array)
{
	int length;
	length = 0;
#line 183 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	if (array) {
#line 183 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		while (((gpointer*) array)[length]) {
#line 183 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
			length++;
#line 2412 "projects.c"
		}
	}
#line 183 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	return length;
#line 2417 "projects.c"
}



