/* main_window.c generated by valac 0.40.8, the Vala compiler
 * generated from main_window.vala, do not modify */

/*
 * This file is part of GNOME LaTeX.
 *
 * Copyright © 2010-2015, 2017 Sébastien Wilmet
 *
 * GNOME LaTeX is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME LaTeX is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME LaTeX.  If not, see <http://www.gnu.org/licenses/>.
 */


#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <tepl/tepl.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>
#include "config.h"
#include <amtk/amtk.h>
#include <gio/gio.h>
#include <latexila.h>
#include <gee.h>
#include <gtksourceview/gtksource.h>


#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;
typedef struct _MainWindowPrivate MainWindowPrivate;

#define TYPE_DOCUMENTS_PANEL (documents_panel_get_type ())
#define DOCUMENTS_PANEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENTS_PANEL, DocumentsPanel))
#define DOCUMENTS_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENTS_PANEL, DocumentsPanelClass))
#define IS_DOCUMENTS_PANEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENTS_PANEL))
#define IS_DOCUMENTS_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENTS_PANEL))
#define DOCUMENTS_PANEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENTS_PANEL, DocumentsPanelClass))

typedef struct _DocumentsPanel DocumentsPanel;
typedef struct _DocumentsPanelClass DocumentsPanelClass;

#define TYPE_CUSTOM_STATUSBAR (custom_statusbar_get_type ())
#define CUSTOM_STATUSBAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CUSTOM_STATUSBAR, CustomStatusbar))
#define CUSTOM_STATUSBAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CUSTOM_STATUSBAR, CustomStatusbarClass))
#define IS_CUSTOM_STATUSBAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CUSTOM_STATUSBAR))
#define IS_CUSTOM_STATUSBAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CUSTOM_STATUSBAR))
#define CUSTOM_STATUSBAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CUSTOM_STATUSBAR, CustomStatusbarClass))

typedef struct _CustomStatusbar CustomStatusbar;
typedef struct _CustomStatusbarClass CustomStatusbarClass;

#define TYPE_GOTO_LINE (goto_line_get_type ())
#define GOTO_LINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GOTO_LINE, GotoLine))
#define GOTO_LINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GOTO_LINE, GotoLineClass))
#define IS_GOTO_LINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GOTO_LINE))
#define IS_GOTO_LINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GOTO_LINE))
#define GOTO_LINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GOTO_LINE, GotoLineClass))

typedef struct _GotoLine GotoLine;
typedef struct _GotoLineClass GotoLineClass;

#define TYPE_SEARCH_AND_REPLACE (search_and_replace_get_type ())
#define SEARCH_AND_REPLACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SEARCH_AND_REPLACE, SearchAndReplace))
#define SEARCH_AND_REPLACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SEARCH_AND_REPLACE, SearchAndReplaceClass))
#define IS_SEARCH_AND_REPLACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SEARCH_AND_REPLACE))
#define IS_SEARCH_AND_REPLACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SEARCH_AND_REPLACE))
#define SEARCH_AND_REPLACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SEARCH_AND_REPLACE, SearchAndReplaceClass))

typedef struct _SearchAndReplace SearchAndReplace;
typedef struct _SearchAndReplaceClass SearchAndReplaceClass;

#define TYPE_MAIN_WINDOW_FILE (main_window_file_get_type ())
#define MAIN_WINDOW_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW_FILE, MainWindowFile))
#define MAIN_WINDOW_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW_FILE, MainWindowFileClass))
#define IS_MAIN_WINDOW_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW_FILE))
#define IS_MAIN_WINDOW_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW_FILE))
#define MAIN_WINDOW_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW_FILE, MainWindowFileClass))

typedef struct _MainWindowFile MainWindowFile;
typedef struct _MainWindowFileClass MainWindowFileClass;

#define TYPE_MAIN_WINDOW_EDIT (main_window_edit_get_type ())
#define MAIN_WINDOW_EDIT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW_EDIT, MainWindowEdit))
#define MAIN_WINDOW_EDIT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW_EDIT, MainWindowEditClass))
#define IS_MAIN_WINDOW_EDIT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW_EDIT))
#define IS_MAIN_WINDOW_EDIT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW_EDIT))
#define MAIN_WINDOW_EDIT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW_EDIT, MainWindowEditClass))

typedef struct _MainWindowEdit MainWindowEdit;
typedef struct _MainWindowEditClass MainWindowEditClass;

#define TYPE_MAIN_WINDOW_BUILD_TOOLS (main_window_build_tools_get_type ())
#define MAIN_WINDOW_BUILD_TOOLS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW_BUILD_TOOLS, MainWindowBuildTools))
#define MAIN_WINDOW_BUILD_TOOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW_BUILD_TOOLS, MainWindowBuildToolsClass))
#define IS_MAIN_WINDOW_BUILD_TOOLS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW_BUILD_TOOLS))
#define IS_MAIN_WINDOW_BUILD_TOOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW_BUILD_TOOLS))
#define MAIN_WINDOW_BUILD_TOOLS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW_BUILD_TOOLS, MainWindowBuildToolsClass))

typedef struct _MainWindowBuildTools MainWindowBuildTools;
typedef struct _MainWindowBuildToolsClass MainWindowBuildToolsClass;

#define TYPE_MAIN_WINDOW_STRUCTURE (main_window_structure_get_type ())
#define MAIN_WINDOW_STRUCTURE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW_STRUCTURE, MainWindowStructure))
#define MAIN_WINDOW_STRUCTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW_STRUCTURE, MainWindowStructureClass))
#define IS_MAIN_WINDOW_STRUCTURE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW_STRUCTURE))
#define IS_MAIN_WINDOW_STRUCTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW_STRUCTURE))
#define MAIN_WINDOW_STRUCTURE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW_STRUCTURE, MainWindowStructureClass))

typedef struct _MainWindowStructure MainWindowStructure;
typedef struct _MainWindowStructureClass MainWindowStructureClass;

#define TYPE_MAIN_WINDOW_DOCUMENTS (main_window_documents_get_type ())
#define MAIN_WINDOW_DOCUMENTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW_DOCUMENTS, MainWindowDocuments))
#define MAIN_WINDOW_DOCUMENTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW_DOCUMENTS, MainWindowDocumentsClass))
#define IS_MAIN_WINDOW_DOCUMENTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW_DOCUMENTS))
#define IS_MAIN_WINDOW_DOCUMENTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW_DOCUMENTS))
#define MAIN_WINDOW_DOCUMENTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW_DOCUMENTS, MainWindowDocumentsClass))

typedef struct _MainWindowDocuments MainWindowDocuments;
typedef struct _MainWindowDocumentsClass MainWindowDocumentsClass;

#define TYPE_MAIN_WINDOW_TOOLS (main_window_tools_get_type ())
#define MAIN_WINDOW_TOOLS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW_TOOLS, MainWindowTools))
#define MAIN_WINDOW_TOOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW_TOOLS, MainWindowToolsClass))
#define IS_MAIN_WINDOW_TOOLS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW_TOOLS))
#define IS_MAIN_WINDOW_TOOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW_TOOLS))
#define MAIN_WINDOW_TOOLS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW_TOOLS, MainWindowToolsClass))

typedef struct _MainWindowTools MainWindowTools;
typedef struct _MainWindowToolsClass MainWindowToolsClass;
enum  {
	MAIN_WINDOW_0_PROPERTY,
	MAIN_WINDOW_ACTIVE_TAB_PROPERTY,
	MAIN_WINDOW_ACTIVE_VIEW_PROPERTY,
	MAIN_WINDOW_ACTIVE_DOCUMENT_PROPERTY,
	MAIN_WINDOW_NUM_PROPERTIES
};
static GParamSpec* main_window_properties[MAIN_WINDOW_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _main_window_file_unref0(var) ((var == NULL) ? NULL : (var = (main_window_file_unref (var), NULL)))
#define _main_window_edit_unref0(var) ((var == NULL) ? NULL : (var = (main_window_edit_unref (var), NULL)))
#define _main_window_build_tools_unref0(var) ((var == NULL) ? NULL : (var = (main_window_build_tools_unref (var), NULL)))
#define _main_window_structure_unref0(var) ((var == NULL) ? NULL : (var = (main_window_structure_unref (var), NULL)))
#define _main_window_documents_unref0(var) ((var == NULL) ? NULL : (var = (main_window_documents_unref (var), NULL)))
#define _main_window_tools_unref0(var) ((var == NULL) ? NULL : (var = (main_window_tools_unref (var), NULL)))

#define TYPE_GLATEX_APP (glatex_app_get_type ())
#define GLATEX_APP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GLATEX_APP, GlatexApp))
#define GLATEX_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GLATEX_APP, GlatexAppClass))
#define IS_GLATEX_APP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GLATEX_APP))
#define IS_GLATEX_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GLATEX_APP))
#define GLATEX_APP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GLATEX_APP, GlatexAppClass))

typedef struct _GlatexApp GlatexApp;
typedef struct _GlatexAppClass GlatexAppClass;

#define TYPE_SIDE_PANEL (side_panel_get_type ())
#define SIDE_PANEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SIDE_PANEL, SidePanel))
#define SIDE_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SIDE_PANEL, SidePanelClass))
#define IS_SIDE_PANEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SIDE_PANEL))
#define IS_SIDE_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SIDE_PANEL))
#define SIDE_PANEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SIDE_PANEL, SidePanelClass))

typedef struct _SidePanel SidePanel;
typedef struct _SidePanelClass SidePanelClass;

#define TYPE_BOTTOM_PANEL (bottom_panel_get_type ())
#define BOTTOM_PANEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BOTTOM_PANEL, BottomPanel))
#define BOTTOM_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BOTTOM_PANEL, BottomPanelClass))
#define IS_BOTTOM_PANEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BOTTOM_PANEL))
#define IS_BOTTOM_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BOTTOM_PANEL))
#define BOTTOM_PANEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BOTTOM_PANEL, BottomPanelClass))

typedef struct _BottomPanel BottomPanel;
typedef struct _BottomPanelClass BottomPanelClass;

#define TYPE_DOCUMENT_TAB (document_tab_get_type ())
#define DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_TAB, DocumentTab))
#define DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_TAB, DocumentTabClass))
#define IS_DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_TAB))
#define IS_DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_TAB))
#define DOCUMENT_TAB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_TAB, DocumentTabClass))

typedef struct _DocumentTab DocumentTab;
typedef struct _DocumentTabClass DocumentTabClass;

#define TYPE_LATEX_MENU (latex_menu_get_type ())
#define LATEX_MENU(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LATEX_MENU, LatexMenu))
#define LATEX_MENU_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LATEX_MENU, LatexMenuClass))
#define IS_LATEX_MENU(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LATEX_MENU))
#define IS_LATEX_MENU_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LATEX_MENU))
#define LATEX_MENU_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LATEX_MENU, LatexMenuClass))

typedef struct _LatexMenu LatexMenu;
typedef struct _LatexMenuClass LatexMenuClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_SYMBOLS_VIEW (symbols_view_get_type ())
#define SYMBOLS_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SYMBOLS_VIEW, SymbolsView))
#define SYMBOLS_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SYMBOLS_VIEW, SymbolsViewClass))
#define IS_SYMBOLS_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SYMBOLS_VIEW))
#define IS_SYMBOLS_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SYMBOLS_VIEW))
#define SYMBOLS_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SYMBOLS_VIEW, SymbolsViewClass))

typedef struct _SymbolsView SymbolsView;
typedef struct _SymbolsViewClass SymbolsViewClass;

#define TYPE_FILE_BROWSER (file_browser_get_type ())
#define FILE_BROWSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FILE_BROWSER, FileBrowser))
#define FILE_BROWSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FILE_BROWSER, FileBrowserClass))
#define IS_FILE_BROWSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FILE_BROWSER))
#define IS_FILE_BROWSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FILE_BROWSER))
#define FILE_BROWSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FILE_BROWSER, FileBrowserClass))

typedef struct _FileBrowser FileBrowser;
typedef struct _FileBrowserClass FileBrowserClass;

#define TYPE_STRUCTURE (structure_get_type ())
#define STRUCTURE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_STRUCTURE, Structure))
#define STRUCTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_STRUCTURE, StructureClass))
#define IS_STRUCTURE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_STRUCTURE))
#define IS_STRUCTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_STRUCTURE))
#define STRUCTURE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_STRUCTURE, StructureClass))

typedef struct _Structure Structure;
typedef struct _StructureClass StructureClass;

#define TYPE_DOCUMENT (document_get_type ())
#define DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT, Document))
#define DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT, DocumentClass))
#define IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT))
#define IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT))
#define DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT, DocumentClass))

typedef struct _Document Document;
typedef struct _DocumentClass DocumentClass;

#define TYPE_DOCUMENT_VIEW (document_view_get_type ())
#define DOCUMENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_VIEW, DocumentView))
#define DOCUMENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_VIEW, DocumentViewClass))
#define IS_DOCUMENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_VIEW))
#define IS_DOCUMENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_VIEW))
#define DOCUMENT_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_VIEW, DocumentViewClass))

typedef struct _DocumentView DocumentView;
typedef struct _DocumentViewClass DocumentViewClass;
typedef struct _Block23Data Block23Data;
typedef struct _DocumentPrivate DocumentPrivate;
typedef struct _Block24Data Block24Data;

struct _MainWindow {
	GtkApplicationWindow parent_instance;
	MainWindowPrivate * priv;
	gchar* default_location;
};

struct _MainWindowClass {
	GtkApplicationWindowClass parent_class;
};

struct _MainWindowPrivate {
	DocumentsPanel* _documents_panel;
	CustomStatusbar* _statusbar;
	GotoLine* _goto_line;
	SearchAndReplace* _search_and_replace;
	GtkPaned* _main_hpaned;
	GtkPaned* _vpaned;
	GtkUIManager* _ui_manager;
	GtkActionGroup* _action_group;
	GtkActionGroup* _latex_action_group;
	MainWindowFile* _main_window_file;
	MainWindowEdit* _main_window_edit;
	MainWindowBuildTools* _main_window_build_tools;
	MainWindowStructure* _main_window_structure;
	MainWindowDocuments* _main_window_documents;
	MainWindowTools* _main_window_tools;
	guint _tip_message_cid;
};

struct _Block23Data {
	int _ref_count_;
	MainWindow* self;
	DocumentTab* tab;
	GtkInfoBar* infobar;
};

struct _Document {
	TeplBuffer parent_instance;
	DocumentPrivate * priv;
	DocumentTab* tab;
};

struct _DocumentClass {
	TeplBufferClass parent_class;
};

struct _Block24Data {
	int _ref_count_;
	MainWindow* self;
	DocumentTab* tab;
};


static gpointer main_window_parent_class = NULL;

GType main_window_get_type (void) G_GNUC_CONST;
GType documents_panel_get_type (void) G_GNUC_CONST;
GType custom_statusbar_get_type (void) G_GNUC_CONST;
GType goto_line_get_type (void) G_GNUC_CONST;
GType search_and_replace_get_type (void) G_GNUC_CONST;
gpointer main_window_file_ref (gpointer instance);
void main_window_file_unref (gpointer instance);
GParamSpec* param_spec_main_window_file (const gchar* name,
                                         const gchar* nick,
                                         const gchar* blurb,
                                         GType object_type,
                                         GParamFlags flags);
void value_set_main_window_file (GValue* value,
                                 gpointer v_object);
void value_take_main_window_file (GValue* value,
                                  gpointer v_object);
gpointer value_get_main_window_file (const GValue* value);
GType main_window_file_get_type (void) G_GNUC_CONST;
gpointer main_window_edit_ref (gpointer instance);
void main_window_edit_unref (gpointer instance);
GParamSpec* param_spec_main_window_edit (const gchar* name,
                                         const gchar* nick,
                                         const gchar* blurb,
                                         GType object_type,
                                         GParamFlags flags);
void value_set_main_window_edit (GValue* value,
                                 gpointer v_object);
void value_take_main_window_edit (GValue* value,
                                  gpointer v_object);
gpointer value_get_main_window_edit (const GValue* value);
GType main_window_edit_get_type (void) G_GNUC_CONST;
gpointer main_window_build_tools_ref (gpointer instance);
void main_window_build_tools_unref (gpointer instance);
GParamSpec* param_spec_main_window_build_tools (const gchar* name,
                                                const gchar* nick,
                                                const gchar* blurb,
                                                GType object_type,
                                                GParamFlags flags);
void value_set_main_window_build_tools (GValue* value,
                                        gpointer v_object);
void value_take_main_window_build_tools (GValue* value,
                                         gpointer v_object);
gpointer value_get_main_window_build_tools (const GValue* value);
GType main_window_build_tools_get_type (void) G_GNUC_CONST;
gpointer main_window_structure_ref (gpointer instance);
void main_window_structure_unref (gpointer instance);
GParamSpec* param_spec_main_window_structure (const gchar* name,
                                              const gchar* nick,
                                              const gchar* blurb,
                                              GType object_type,
                                              GParamFlags flags);
void value_set_main_window_structure (GValue* value,
                                      gpointer v_object);
void value_take_main_window_structure (GValue* value,
                                       gpointer v_object);
gpointer value_get_main_window_structure (const GValue* value);
GType main_window_structure_get_type (void) G_GNUC_CONST;
gpointer main_window_documents_ref (gpointer instance);
void main_window_documents_unref (gpointer instance);
GParamSpec* param_spec_main_window_documents (const gchar* name,
                                              const gchar* nick,
                                              const gchar* blurb,
                                              GType object_type,
                                              GParamFlags flags);
void value_set_main_window_documents (GValue* value,
                                      gpointer v_object);
void value_take_main_window_documents (GValue* value,
                                       gpointer v_object);
gpointer value_get_main_window_documents (const GValue* value);
GType main_window_documents_get_type (void) G_GNUC_CONST;
gpointer main_window_tools_ref (gpointer instance);
void main_window_tools_unref (gpointer instance);
GParamSpec* param_spec_main_window_tools (const gchar* name,
                                          const gchar* nick,
                                          const gchar* blurb,
                                          GType object_type,
                                          GParamFlags flags);
void value_set_main_window_tools (GValue* value,
                                  gpointer v_object);
void value_take_main_window_tools (GValue* value,
                                   gpointer v_object);
gpointer value_get_main_window_tools (const GValue* value);
GType main_window_tools_get_type (void) G_GNUC_CONST;
#define MAIN_WINDOW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_MAIN_WINDOW, MainWindowPrivate))
void main_window_on_view_zoom_in (MainWindow* self);
static void _main_window_on_view_zoom_in_gtk_action_callback (GtkAction* action,
                                                       gpointer self);
void main_window_on_view_zoom_out (MainWindow* self);
static void _main_window_on_view_zoom_out_gtk_action_callback (GtkAction* action,
                                                        gpointer self);
void main_window_on_view_zoom_reset (MainWindow* self);
static void _main_window_on_view_zoom_reset_gtk_action_callback (GtkAction* action,
                                                          gpointer self);
void main_window_on_search_find (MainWindow* self);
static void _main_window_on_search_find_gtk_action_callback (GtkAction* action,
                                                      gpointer self);
void main_window_on_search_replace (MainWindow* self);
static void _main_window_on_search_replace_gtk_action_callback (GtkAction* action,
                                                         gpointer self);
void main_window_on_search_goto_line (MainWindow* self);
static void _main_window_on_search_goto_line_gtk_action_callback (GtkAction* action,
                                                           gpointer self);
void main_window_on_search_forward (MainWindow* self);
static void _main_window_on_search_forward_gtk_action_callback (GtkAction* action,
                                                         gpointer self);
void main_window_on_projects_new (MainWindow* self);
static void _main_window_on_projects_new_gtk_action_callback (GtkAction* action,
                                                       gpointer self);
void main_window_on_projects_config_current (MainWindow* self);
static void _main_window_on_projects_config_current_gtk_action_callback (GtkAction* action,
                                                                  gpointer self);
void main_window_on_projects_manage (MainWindow* self);
static void _main_window_on_projects_manage_gtk_action_callback (GtkAction* action,
                                                          gpointer self);
void main_window_on_help_latex_reference (MainWindow* self);
static void _main_window_on_help_latex_reference_gtk_action_callback (GtkAction* action,
                                                               gpointer self);
GType glatex_app_get_type (void) G_GNUC_CONST;
MainWindow* main_window_new (GlatexApp* app);
MainWindow* main_window_construct (GType object_type,
                                   GlatexApp* app);
static void main_window_initialize_ui_manager (MainWindow* self);
MainWindowFile* main_window_file_new (MainWindow* main_window,
                                      GtkUIManager* ui_manager);
MainWindowFile* main_window_file_construct (GType object_type,
                                            MainWindow* main_window,
                                            GtkUIManager* ui_manager);
MainWindowEdit* main_window_edit_new (MainWindow* main_window,
                                      GtkUIManager* ui_manager);
MainWindowEdit* main_window_edit_construct (GType object_type,
                                            MainWindow* main_window,
                                            GtkUIManager* ui_manager);
MainWindowBuildTools* main_window_build_tools_new (MainWindow* main_window,
                                                   GtkUIManager* ui_manager);
MainWindowBuildTools* main_window_build_tools_construct (GType object_type,
                                                         MainWindow* main_window,
                                                         GtkUIManager* ui_manager);
MainWindowDocuments* main_window_documents_new (MainWindow* main_window,
                                                GtkUIManager* ui_manager);
MainWindowDocuments* main_window_documents_construct (GType object_type,
                                                      MainWindow* main_window,
                                                      GtkUIManager* ui_manager);
MainWindowStructure* main_window_structure_new (GtkUIManager* ui_manager);
MainWindowStructure* main_window_structure_construct (GType object_type,
                                                      GtkUIManager* ui_manager);
MainWindowTools* main_window_tools_new (MainWindow* main_window,
                                        GtkUIManager* ui_manager);
MainWindowTools* main_window_tools_construct (GType object_type,
                                              MainWindow* main_window,
                                              GtkUIManager* ui_manager);
static void main_window_show_images_in_menu (MainWindow* self);
static void main_window_update_file_actions_sensitivity (MainWindow* self);
static GtkToolbar* main_window_get_main_toolbar (MainWindow* self);
static GtkToolbar* main_window_get_edit_toolbar (MainWindow* self);
GType side_panel_get_type (void) G_GNUC_CONST;
static SidePanel* main_window_get_side_panel (MainWindow* self);
static void main_window_init_documents_panel (MainWindow* self);
GotoLine* goto_line_new (MainWindow* main_window);
GotoLine* goto_line_construct (GType object_type,
                               MainWindow* main_window);
SearchAndReplace* search_and_replace_new (MainWindow* main_window);
SearchAndReplace* search_and_replace_construct (GType object_type,
                                                MainWindow* main_window);
GtkWidget* search_and_replace_get_widget (SearchAndReplace* self);
GType bottom_panel_get_type (void) G_GNUC_CONST;
static BottomPanel* main_window_get_bottom_panel (MainWindow* self);
void main_window_build_tools_set_bottom_panel (MainWindowBuildTools* self,
                                               BottomPanel* bottom_panel);
CustomStatusbar* custom_statusbar_new (void);
CustomStatusbar* custom_statusbar_construct (GType object_type);
static void __lambda82_ (MainWindow* self);
void main_window_update_config_project_sensitivity (MainWindow* self);
static void main_window_update_cursor_position_statusbar (MainWindow* self);
GType document_tab_get_type (void) G_GNUC_CONST;
DocumentTab* main_window_get_active_tab (MainWindow* self);
void search_and_replace_hide (SearchAndReplace* self);
static void ___lambda82__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void __lambda83_ (MainWindow* self);
static void ___lambda83__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void __lambda84_ (MainWindow* self);
static void ___lambda84__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void main_window_support_drag_and_drop (MainWindow* self);
static gboolean __lambda86_ (MainWindow* self);
gboolean main_window_quit (MainWindow* self);
static gboolean ___lambda86__gtk_widget_delete_event (GtkWidget* _sender,
                                               GdkEventAny* event,
                                               gpointer self);
static void main_window_restore_state (MainWindow* self);
static void main_window_show_or_hide_widgets (MainWindow* self);
void finance_show_dialog (GtkWindow* parent_window,
                          gboolean startup);
LatexMenu* latex_menu_new (MainWindow* main_window);
LatexMenu* latex_menu_construct (GType object_type,
                                 MainWindow* main_window);
GType latex_menu_get_type (void) G_GNUC_CONST;
GlatexApp* glatex_app_get_instance (void);
static void __lambda65_ (MainWindow* self,
                  GtkAction* action,
                  GtkWidget* p);
static void main_window_on_menu_item_select (MainWindow* self,
                                      GtkMenuItem* proxy);
static void _main_window_on_menu_item_select_gtk_menu_item_select (GtkMenuItem* _sender,
                                                            gpointer self);
static void main_window_on_menu_item_deselect (MainWindow* self,
                                        GtkMenuItem* proxy);
static void _main_window_on_menu_item_deselect_gtk_menu_item_deselect (GtkMenuItem* _sender,
                                                                gpointer self);
static void ___lambda65__gtk_ui_manager_connect_proxy (GtkUIManager* _sender,
                                                GtkAction* action,
                                                GtkWidget* proxy,
                                                gpointer self);
static void __lambda66_ (MainWindow* self,
                  GtkAction* action,
                  GtkWidget* p);
static void ___lambda66__gtk_ui_manager_disconnect_proxy (GtkUIManager* _sender,
                                                   GtkAction* action,
                                                   GtkWidget* proxy,
                                                   gpointer self);
GtkToolItem* main_window_file_get_toolbar_open_button (MainWindowFile* self);
SidePanel* side_panel_new (void);
SidePanel* side_panel_construct (GType object_type);
GType symbols_view_get_type (void) G_GNUC_CONST;
SymbolsView* symbols_view_new (MainWindow* main_window);
SymbolsView* symbols_view_construct (GType object_type,
                                     MainWindow* main_window);
void side_panel_add_component (SidePanel* self,
                               const gchar* name,
                               const gchar* icon_name,
                               GtkGrid* component);
GType file_browser_get_type (void) G_GNUC_CONST;
FileBrowser* file_browser_new (MainWindow* main_window);
FileBrowser* file_browser_construct (GType object_type,
                                     MainWindow* main_window);
GType structure_get_type (void) G_GNUC_CONST;
Structure* structure_new (MainWindow* main_window);
Structure* structure_construct (GType object_type,
                                MainWindow* main_window);
void main_window_structure_set_structure (MainWindowStructure* self,
                                          Structure* structure);
void side_panel_restore_state (SidePanel* self);
DocumentsPanel* documents_panel_new (MainWindow* main_window);
DocumentsPanel* documents_panel_construct (GType object_type,
                                           MainWindow* main_window);
void main_window_documents_set_documents_panel (MainWindowDocuments* self,
                                                DocumentsPanel* documents_panel);
static void __lambda81_ (MainWindow* self,
                  GdkEventButton* event);
static void ___lambda81__documents_panel_right_click (DocumentsPanel* _sender,
                                               GdkEventButton* event,
                                               gpointer self);
void main_window_build_tools_set_build_view (MainWindowBuildTools* self,
                                             LatexilaBuildView* build_view);
BottomPanel* bottom_panel_new (LatexilaBuildView* build_view,
                               GtkToolbar* toolbar);
BottomPanel* bottom_panel_construct (GType object_type,
                                     LatexilaBuildView* build_view,
                                     GtkToolbar* toolbar);
static void __lambda85_ (MainWindow* self,
                  GdkDragContext* dc,
                  gint x,
                  gint y,
                  GtkSelectionData* selection_data,
                  guint info,
                  guint time);
static void _vala_array_add5 (GFile** * array,
                       int* length,
                       int* size,
                       GFile* value);
void glatex_app_open_documents (GlatexApp* self,
                                GFile** files,
                                int files_length1);
static void ___lambda85__gtk_widget_drag_data_received (GtkWidget* _sender,
                                                 GdkDragContext* context,
                                                 gint x,
                                                 gint y,
                                                 GtkSelectionData* selection_data,
                                                 guint info,
                                                 guint time_,
                                                 gpointer self);
MainWindowStructure* main_window_get_main_window_structure (MainWindow* self);
GType document_get_type (void) G_GNUC_CONST;
GeeList* main_window_get_documents (MainWindow* self);
Document* document_tab_get_document (DocumentTab* self);
GeeList* main_window_get_unsaved_documents (MainWindow* self);
GType document_view_get_type (void) G_GNUC_CONST;
GeeList* main_window_get_views (MainWindow* self);
DocumentView* document_tab_get_document_view (DocumentTab* self);
DocumentTab* main_window_open_document (MainWindow* self,
                                        GFile* location,
                                        gboolean jump_to);
static Block23Data* block23_data_ref (Block23Data* _data23_);
static void block23_data_unref (void * _userdata_);
GFile* document_get_location (Document* self);
void main_window_set_active_tab (MainWindow* self,
                                 DocumentTab* value);
static DocumentTab* main_window_create_tab_from_location (MainWindow* self,
                                                   GFile* location,
                                                   gboolean jump_to);
void document_set_readonly (Document* self,
                            gboolean value);
static void ______lambda41_ (Block23Data* _data23_,
                      gint response_id);
TeplView* tepl_tab_get_view (TeplTab* self);
static void _______lambda41__gtk_info_bar_response (GtkInfoBar* _sender,
                                             gint response_id,
                                             gpointer self);
DocumentTab* main_window_create_tab (MainWindow* self,
                                     gboolean jump_to);
DocumentTab* document_tab_new (void);
DocumentTab* document_tab_construct (GType object_type);
static DocumentTab* main_window_process_create_tab (MainWindow* self,
                                             DocumentTab* tab,
                                             gboolean jump_to);
DocumentTab* document_tab_new_from_location (GFile* location);
DocumentTab* document_tab_construct_from_location (GType object_type,
                                                   GFile* location);
void main_window_create_tab_with_view (MainWindow* self,
                                       DocumentView* view);
DocumentTab* document_tab_new_with_view (DocumentView* document_view);
DocumentTab* document_tab_construct_with_view (GType object_type,
                                               DocumentView* document_view);
static Block24Data* block24_data_ref (Block24Data* _data24_);
static void block24_data_unref (void * _userdata_);
static void __lambda15_ (Block24Data* _data24_);
gboolean main_window_close_tab (MainWindow* self,
                                DocumentTab* tab,
                                gboolean force_close);
static void ___lambda15__tepl_tab_close_request (TeplTab* _sender,
                                          gpointer self);
static void __lambda18_ (Block24Data* _data24_);
static void main_window_sync_name (MainWindow* self,
                            DocumentTab* tab);
void main_window_build_tools_update_sensitivity (MainWindowBuildTools* self);
static void ___lambda18__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void __lambda34_ (Block24Data* _data24_);
static void ___lambda34__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void __lambda35_ (MainWindow* self);
static void ___lambda35__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void __lambda36_ (Block24Data* _data24_);
static void ___lambda36__gtk_text_buffer_modified_changed (GtkTextBuffer* _sender,
                                                    gpointer self);
static void __lambda37_ (Block24Data* _data24_);
static void ___lambda37__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void _main_window_update_cursor_position_statusbar_tepl_buffer_tepl_cursor_moved (TeplBuffer* _sender,
                                                                                  gpointer self);
void documents_panel_add_tab (DocumentsPanel* self,
                              DocumentTab* tab,
                              gint position,
                              gboolean jump_to);
void main_window_edit_update_sensitivity (MainWindowEdit* self);
void main_window_tools_update_sensitivity (MainWindowTools* self);
gboolean main_window_save_document (MainWindow* self,
                                    Document* doc,
                                    gboolean force_save_as);
void documents_panel_remove_tab (DocumentsPanel* self,
                                 DocumentTab* tab);
void main_window_documents_update_document_name (MainWindowDocuments* self,
                                                 DocumentTab* tab);
void document_save (Document* self,
                    gboolean check_file_changed_on_disk,
                    gboolean force);
Document* main_window_get_active_document (MainWindow* self);
void main_window_structure_refresh (MainWindowStructure* self);
void document_set_location (Document* self,
                            GFile* value);
gboolean main_window_close_all_documents (MainWindow* self);
void documents_panel_remove_all_tabs (DocumentsPanel* self);
void dialogs_close_several_unsaved_documents (MainWindow* window,
                                              GeeList* unsaved_docs);
void main_window_remove_all_tabs (MainWindow* self);
DocumentView* main_window_get_active_view (MainWindow* self);
void custom_statusbar_set_cursor_position (CustomStatusbar* self,
                                           gint line,
                                           gint col);
void main_window_save_state (MainWindow* self);
void main_window_structure_save_state (MainWindowStructure* self);
void main_window_build_tools_save_state (MainWindowBuildTools* self);
void main_window_jump_to_file_position (MainWindow* self,
                                        GFile* file,
                                        gint start_line,
                                        gint end_line);
void utils_flush_queue (void);
TeplTab* tepl_tab_group_get_active_tab (TeplTabGroup* self);
void main_window_file_update_sensitivity (MainWindowFile* self);
gint document_get_project_id (Document* self);
static void _vala_array_add6 (gchar** * array,
                       int* length,
                       int* size,
                       gchar* value);
void document_view_enlarge_font (DocumentView* self);
void document_view_shrink_font (DocumentView* self);
void document_view_set_font_from_settings (DocumentView* self);
void search_and_replace_show_search (SearchAndReplace* self);
void search_and_replace_show_search_and_replace (SearchAndReplace* self);
void goto_line_show (GotoLine* self);
GFile* document_get_main_file (Document* self);
void project_dialogs_new_project (MainWindow* main_window);
gboolean project_dialogs_configure_project (GtkWindow* main_window,
                                            gint project_id);
void project_dialogs_manage_projects (MainWindow* main_window);
static void main_window_finalize (GObject * obj);
static void _vala_main_window_get_property (GObject * object,
                                     guint property_id,
                                     GValue * value,
                                     GParamSpec * pspec);
static void _vala_main_window_set_property (GObject * object,
                                     guint property_id,
                                     const GValue * value,
                                     GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static const GtkActionEntry MAIN_WINDOW__action_entries[19] = {{"FileQuit", "application-exit", N_ ("_Quit"), "<Control>Q", N_ ("Quit the program")}, {"View", NULL, N_ ("_View")}, {"ViewZoomIn", "zoom-in", N_ ("Zoom _In"), "<Control>plus", N_ ("Enlarge the font"), (GCallback) _main_window_on_view_zoom_in_gtk_action_callback}, {"ViewZoomOut", "zoom-out", N_ ("Zoom _Out"), "<Control>minus", N_ ("Shrink the font"), (GCallback) _main_window_on_view_zoom_out_gtk_action_callback}, {"ViewZoomReset", "zoom-original", N_ ("_Reset Zoom"), "<Control>0", N_ ("Reset the size of the font"), (GCallback) _main_window_on_view_zoom_reset_gtk_action_callback}, {"Search", NULL, N_ ("_Search")}, {"SearchFind", "edit-find", N_ ("_Find"), "<Control>F", N_ ("Search for text"), (GCallback) _main_window_on_search_find_gtk_action_callback}, {"SearchReplace", "edit-find-replace", N_ ("Find and _Replace"), "<Control>H", N_ ("Search for and replace text"), (GCallback) _main_window_on_search_replace_gtk_action_callback}, {"SearchGoToLine", "go-jump", N_ ("_Go to Line…"), "<Control>L", N_ ("Go to a specific line"), (GCallback) _main_window_on_search_goto_line_gtk_action_callback}, {"SearchForward", NULL, N_ ("_Jump to PDF"), "<Control><Alt>F", N_ ("Jump to the associated position in the PDF file. Another shortcut: Ctr" \
"l+click, which works in both directions."), (GCallback) _main_window_on_search_forward_gtk_action_callback}, {"Projects", NULL, N_ ("_Projects")}, {"ProjectsNew", "document-new", N_ ("_New Project"), "", N_ ("Create a new project"), (GCallback) _main_window_on_projects_new_gtk_action_callback}, {"ProjectsConfigCurrent", "document-properties", N_ ("_Configure Current Project"), NULL, N_ ("Change the main file of the current project"), (GCallback) _main_window_on_projects_config_current_gtk_action_callback}, {"ProjectsManage", "preferences-system", N_ ("_Manage Projects"), NULL, N_ ("Manage Projects"), (GCallback) _main_window_on_projects_manage_gtk_action_callback}, {"Help", NULL, N_ ("_Help")}, {"HelpContents", "help-browser", N_ ("_Contents"), "<Release>F1", N_ ("Open the GNOME LaTeX documentation")}, {"HelpLatexReference", NULL, N_ ("_LaTeX Reference"), NULL, N_ ("The Kile LaTeX Reference"), (GCallback) _main_window_on_help_latex_reference_gtk_action_callback}, {"HelpFinance", NULL, "GNOME LaTeX _Fundraising", NULL, "Donate to demonstrate your appreciation of GNOME LaTeX and help its fu" \
"ture development"}, {"HelpAbout", "help-about", N_ ("_About"), NULL, N_ ("About GNOME LaTeX")}};
static const GtkToggleActionEntry MAIN_WINDOW__toggle_action_entries[4] = {{"ViewMainToolbar", NULL, N_ ("_Main Toolbar"), NULL, N_ ("Show or hide the main toolbar"), (GCallback) NULL}, {"ViewEditToolbar", NULL, N_ ("_Edit Toolbar"), NULL, N_ ("Show or hide the edit toolbar"), (GCallback) NULL}, {"ViewSidePanel", NULL, N_ ("_Side panel"), "<Release>F12", N_ ("Show or hide the side panel"), (GCallback) NULL}, {"ViewBottomPanel", NULL, N_ ("_Bottom panel"), NULL, N_ ("Show or hide the bottom panel"), (GCallback) NULL}};

static void
_main_window_on_view_zoom_in_gtk_action_callback (GtkAction* action,
                                                  gpointer self)
{
#line 26 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	main_window_on_view_zoom_in ((MainWindow*) self);
#line 767 "main_window.c"
}


static void
_main_window_on_view_zoom_out_gtk_action_callback (GtkAction* action,
                                                   gpointer self)
{
#line 26 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	main_window_on_view_zoom_out ((MainWindow*) self);
#line 777 "main_window.c"
}


static void
_main_window_on_view_zoom_reset_gtk_action_callback (GtkAction* action,
                                                     gpointer self)
{
#line 26 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	main_window_on_view_zoom_reset ((MainWindow*) self);
#line 787 "main_window.c"
}


static void
_main_window_on_search_find_gtk_action_callback (GtkAction* action,
                                                 gpointer self)
{
#line 26 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	main_window_on_search_find ((MainWindow*) self);
#line 797 "main_window.c"
}


static void
_main_window_on_search_replace_gtk_action_callback (GtkAction* action,
                                                    gpointer self)
{
#line 26 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	main_window_on_search_replace ((MainWindow*) self);
#line 807 "main_window.c"
}


static void
_main_window_on_search_goto_line_gtk_action_callback (GtkAction* action,
                                                      gpointer self)
{
#line 26 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	main_window_on_search_goto_line ((MainWindow*) self);
#line 817 "main_window.c"
}


static void
_main_window_on_search_forward_gtk_action_callback (GtkAction* action,
                                                    gpointer self)
{
#line 26 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	main_window_on_search_forward ((MainWindow*) self);
#line 827 "main_window.c"
}


static void
_main_window_on_projects_new_gtk_action_callback (GtkAction* action,
                                                  gpointer self)
{
#line 26 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	main_window_on_projects_new ((MainWindow*) self);
#line 837 "main_window.c"
}


static void
_main_window_on_projects_config_current_gtk_action_callback (GtkAction* action,
                                                             gpointer self)
{
#line 26 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	main_window_on_projects_config_current ((MainWindow*) self);
#line 847 "main_window.c"
}


static void
_main_window_on_projects_manage_gtk_action_callback (GtkAction* action,
                                                     gpointer self)
{
#line 26 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	main_window_on_projects_manage ((MainWindow*) self);
#line 857 "main_window.c"
}


static void
_main_window_on_help_latex_reference_gtk_action_callback (GtkAction* action,
                                                          gpointer self)
{
#line 26 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	main_window_on_help_latex_reference ((MainWindow*) self);
#line 867 "main_window.c"
}


/*************************************************************************/
static gpointer
_g_object_ref0 (gpointer self)
{
#line 157 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	return self ? g_object_ref (self) : NULL;
#line 877 "main_window.c"
}


static void
__lambda82_ (MainWindow* self)
{
	DocumentTab* _tmp0_;
	DocumentTab* _tmp1_;
#line 267 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	main_window_update_file_actions_sensitivity (self);
#line 268 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	main_window_update_config_project_sensitivity (self);
#line 269 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	main_window_update_cursor_position_statusbar (self);
#line 271 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp0_ = main_window_get_active_tab (self);
#line 271 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp1_ = _tmp0_;
#line 271 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	if (_tmp1_ == NULL) {
#line 898 "main_window.c"
		GotoLine* _tmp2_;
		SearchAndReplace* _tmp3_;
#line 273 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		_tmp2_ = self->priv->_goto_line;
#line 273 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		gtk_widget_hide ((GtkWidget*) _tmp2_);
#line 274 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		_tmp3_ = self->priv->_search_and_replace;
#line 274 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		search_and_replace_hide (_tmp3_);
#line 909 "main_window.c"
	}
#line 277 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	g_object_notify ((GObject*) self, "active-tab");
#line 913 "main_window.c"
}


static void
___lambda82__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
#line 265 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	__lambda82_ ((MainWindow*) self);
#line 924 "main_window.c"
}


static void
__lambda83_ (MainWindow* self)
{
#line 282 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	g_object_notify ((GObject*) self, "active-view");
#line 933 "main_window.c"
}


static void
___lambda83__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
#line 280 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	__lambda83_ ((MainWindow*) self);
#line 944 "main_window.c"
}


static void
__lambda84_ (MainWindow* self)
{
#line 287 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	g_object_notify ((GObject*) self, "active-document");
#line 953 "main_window.c"
}


static void
___lambda84__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
#line 285 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	__lambda84_ ((MainWindow*) self);
#line 964 "main_window.c"
}


static gboolean
__lambda86_ (MainWindow* self)
{
	gboolean result = FALSE;
#line 299 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	main_window_quit (self);
#line 302 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	result = TRUE;
#line 302 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	return result;
#line 978 "main_window.c"
}


static gboolean
___lambda86__gtk_widget_delete_event (GtkWidget* _sender,
                                      GdkEventAny* event,
                                      gpointer self)
{
	gboolean result;
	result = __lambda86_ ((MainWindow*) self);
#line 297 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	return result;
#line 991 "main_window.c"
}


MainWindow*
main_window_construct (GType object_type,
                       GlatexApp* app)
{
	MainWindow * self = NULL;
	TeplApplicationWindow* tepl_window = NULL;
	TeplApplicationWindow* _tmp0_;
	TeplApplicationWindow* _tmp1_;
	GtkUIManager* _tmp2_;
	MainWindowFile* _tmp3_;
	GtkUIManager* _tmp4_;
	MainWindowEdit* _tmp5_;
	GtkUIManager* _tmp6_;
	MainWindowBuildTools* _tmp7_;
	GtkUIManager* _tmp8_;
	MainWindowDocuments* _tmp9_;
	GtkUIManager* _tmp10_;
	MainWindowStructure* _tmp11_;
	GtkUIManager* _tmp12_;
	MainWindowTools* _tmp13_;
	GtkGrid* main_vgrid = NULL;
	GtkGrid* _tmp14_;
	GtkWidget* menu = NULL;
	GtkUIManager* _tmp15_;
	GtkWidget* _tmp16_;
	GtkWidget* _tmp17_;
	GtkPaned* menu_paned = NULL;
	GtkPaned* _tmp18_;
	GtkViewport* viewport = NULL;
	GtkViewport* _tmp19_;
	GdkRGBA transparent = {0};
	GdkRGBA _tmp20_;
	GtkToolbar* main_toolbar = NULL;
	GtkToolbar* _tmp21_;
	GtkToolbar* edit_toolbar = NULL;
	GtkToolbar* _tmp22_;
	GtkPaned* _tmp23_;
	GtkPaned* _tmp24_;
	GtkPaned* _tmp25_;
	SidePanel* side_panel = NULL;
	SidePanel* _tmp26_;
	GtkPaned* _tmp27_;
	GtkPaned* _tmp28_;
	GtkPaned* _tmp29_;
	GtkPaned* _tmp30_;
	GtkPaned* _tmp31_;
	GtkGrid* docs_vgrid = NULL;
	GtkGrid* _tmp32_;
	DocumentsPanel* _tmp33_;
	GotoLine* _tmp34_;
	GotoLine* _tmp35_;
	SearchAndReplace* _tmp36_;
	SearchAndReplace* _tmp37_;
	GtkWidget* _tmp38_;
	GtkWidget* _tmp39_;
	BottomPanel* bottom_panel = NULL;
	BottomPanel* _tmp40_;
	MainWindowBuildTools* _tmp41_;
	GtkPaned* _tmp42_;
	GtkPaned* _tmp43_;
	CustomStatusbar* _tmp44_;
	CustomStatusbar* _tmp45_;
	CustomStatusbar* _tmp46_;
	CustomStatusbar* _tmp47_;
	DocumentsPanel* _tmp48_;
#line 152 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	g_return_val_if_fail (app != NULL, NULL);
#line 154 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	self = (MainWindow*) g_object_new (object_type, "application", app, NULL);
#line 157 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp0_ = tepl_application_window_get_from_gtk_application_window ((GtkApplicationWindow*) self);
#line 157 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 157 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	tepl_window = _tmp1_;
#line 162 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	main_window_initialize_ui_manager (self);
#line 164 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp2_ = self->priv->_ui_manager;
#line 164 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp3_ = main_window_file_new (self, _tmp2_);
#line 164 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_main_window_file_unref0 (self->priv->_main_window_file);
#line 164 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	self->priv->_main_window_file = _tmp3_;
#line 165 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp4_ = self->priv->_ui_manager;
#line 165 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp5_ = main_window_edit_new (self, _tmp4_);
#line 165 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_main_window_edit_unref0 (self->priv->_main_window_edit);
#line 165 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	self->priv->_main_window_edit = _tmp5_;
#line 166 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp6_ = self->priv->_ui_manager;
#line 166 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp7_ = main_window_build_tools_new (self, _tmp6_);
#line 166 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_main_window_build_tools_unref0 (self->priv->_main_window_build_tools);
#line 166 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	self->priv->_main_window_build_tools = _tmp7_;
#line 167 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp8_ = self->priv->_ui_manager;
#line 167 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp9_ = main_window_documents_new (self, _tmp8_);
#line 167 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_main_window_documents_unref0 (self->priv->_main_window_documents);
#line 167 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	self->priv->_main_window_documents = _tmp9_;
#line 168 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp10_ = self->priv->_ui_manager;
#line 168 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp11_ = main_window_structure_new (_tmp10_);
#line 168 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_main_window_structure_unref0 (self->priv->_main_window_structure);
#line 168 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	self->priv->_main_window_structure = _tmp11_;
#line 169 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp12_ = self->priv->_ui_manager;
#line 169 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp13_ = main_window_tools_new (self, _tmp12_);
#line 169 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_main_window_tools_unref0 (self->priv->_main_window_tools);
#line 169 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	self->priv->_main_window_tools = _tmp13_;
#line 171 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	main_window_show_images_in_menu (self);
#line 172 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	main_window_update_file_actions_sensitivity (self);
#line 176 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp14_ = (GtkGrid*) gtk_grid_new ();
#line 176 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	g_object_ref_sink (_tmp14_);
#line 176 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	main_vgrid = _tmp14_;
#line 177 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	gtk_orientable_set_orientation ((GtkOrientable*) main_vgrid, GTK_ORIENTATION_VERTICAL);
#line 178 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	gtk_widget_show ((GtkWidget*) main_vgrid);
#line 179 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) main_vgrid);
#line 183 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp15_ = self->priv->_ui_manager;
#line 183 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp16_ = gtk_ui_manager_get_widget (_tmp15_, "/MainMenu");
#line 183 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp17_ = _g_object_ref0 (_tmp16_);
#line 183 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	menu = _tmp17_;
#line 186 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp18_ = (GtkPaned*) gtk_paned_new (GTK_ORIENTATION_HORIZONTAL);
#line 186 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	g_object_ref_sink (_tmp18_);
#line 186 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	menu_paned = _tmp18_;
#line 187 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp19_ = (GtkViewport*) gtk_viewport_new (NULL, NULL);
#line 187 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	g_object_ref_sink (_tmp19_);
#line 187 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	viewport = _tmp19_;
#line 188 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	gtk_viewport_set_shadow_type (viewport, GTK_SHADOW_NONE);
#line 189 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	memset (&transparent, 0, sizeof (GdkRGBA));
#line 190 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	transparent.alpha = 0.0;
#line 191 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp20_ = transparent;
#line 191 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	gtk_widget_override_background_color ((GtkWidget*) viewport, GTK_STATE_FLAG_NORMAL, &_tmp20_);
#line 192 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	gtk_container_add ((GtkContainer*) viewport, menu);
#line 193 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	gtk_paned_add1 (menu_paned, (GtkWidget*) viewport);
#line 194 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	gtk_widget_show_all ((GtkWidget*) menu_paned);
#line 195 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	gtk_container_add ((GtkContainer*) main_vgrid, (GtkWidget*) menu_paned);
#line 199 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp21_ = main_window_get_main_toolbar (self);
#line 199 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	main_toolbar = _tmp21_;
#line 200 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp22_ = main_window_get_edit_toolbar (self);
#line 200 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	edit_toolbar = _tmp22_;
#line 201 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	gtk_container_add ((GtkContainer*) main_vgrid, (GtkWidget*) main_toolbar);
#line 202 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	gtk_container_add ((GtkContainer*) main_vgrid, (GtkWidget*) edit_toolbar);
#line 209 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp23_ = (GtkPaned*) gtk_paned_new (GTK_ORIENTATION_HORIZONTAL);
#line 209 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	g_object_ref_sink (_tmp23_);
#line 209 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_g_object_unref0 (self->priv->_main_hpaned);
#line 209 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	self->priv->_main_hpaned = _tmp23_;
#line 210 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp24_ = self->priv->_main_hpaned;
#line 210 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	gtk_widget_show ((GtkWidget*) _tmp24_);
#line 211 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp25_ = self->priv->_main_hpaned;
#line 211 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	gtk_container_add ((GtkContainer*) main_vgrid, (GtkWidget*) _tmp25_);
#line 215 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp26_ = main_window_get_side_panel (self);
#line 215 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	side_panel = _tmp26_;
#line 216 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp27_ = self->priv->_main_hpaned;
#line 216 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	gtk_paned_pack1 (_tmp27_, (GtkWidget*) side_panel, FALSE, FALSE);
#line 223 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp28_ = (GtkPaned*) gtk_paned_new (GTK_ORIENTATION_VERTICAL);
#line 223 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	g_object_ref_sink (_tmp28_);
#line 223 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_g_object_unref0 (self->priv->_vpaned);
#line 223 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	self->priv->_vpaned = _tmp28_;
#line 224 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp29_ = self->priv->_vpaned;
#line 224 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	gtk_widget_show ((GtkWidget*) _tmp29_);
#line 225 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp30_ = self->priv->_main_hpaned;
#line 225 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp31_ = self->priv->_vpaned;
#line 225 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	gtk_paned_add2 (_tmp30_, (GtkWidget*) _tmp31_);
#line 229 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp32_ = (GtkGrid*) gtk_grid_new ();
#line 229 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	g_object_ref_sink (_tmp32_);
#line 229 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	docs_vgrid = _tmp32_;
#line 230 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	gtk_orientable_set_orientation ((GtkOrientable*) docs_vgrid, GTK_ORIENTATION_VERTICAL);
#line 231 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	gtk_grid_set_row_spacing (docs_vgrid, (guint) 2);
#line 232 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	gtk_widget_show ((GtkWidget*) docs_vgrid);
#line 235 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	main_window_init_documents_panel (self);
#line 236 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp33_ = self->priv->_documents_panel;
#line 236 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	gtk_container_add ((GtkContainer*) docs_vgrid, (GtkWidget*) _tmp33_);
#line 239 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp34_ = goto_line_new (self);
#line 239 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	g_object_ref_sink (_tmp34_);
#line 239 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_g_object_unref0 (self->priv->_goto_line);
#line 239 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	self->priv->_goto_line = _tmp34_;
#line 240 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp35_ = self->priv->_goto_line;
#line 240 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	gtk_container_add ((GtkContainer*) docs_vgrid, (GtkWidget*) _tmp35_);
#line 243 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp36_ = search_and_replace_new (self);
#line 243 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_g_object_unref0 (self->priv->_search_and_replace);
#line 243 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	self->priv->_search_and_replace = _tmp36_;
#line 244 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp37_ = self->priv->_search_and_replace;
#line 244 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp38_ = search_and_replace_get_widget (_tmp37_);
#line 244 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp39_ = _tmp38_;
#line 244 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	gtk_container_add ((GtkContainer*) docs_vgrid, _tmp39_);
#line 244 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_g_object_unref0 (_tmp39_);
#line 248 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp40_ = main_window_get_bottom_panel (self);
#line 248 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	bottom_panel = _tmp40_;
#line 249 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp41_ = self->priv->_main_window_build_tools;
#line 249 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	main_window_build_tools_set_bottom_panel (_tmp41_, bottom_panel);
#line 252 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp42_ = self->priv->_vpaned;
#line 252 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	gtk_paned_pack1 (_tmp42_, (GtkWidget*) docs_vgrid, TRUE, TRUE);
#line 253 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp43_ = self->priv->_vpaned;
#line 253 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	gtk_paned_pack2 (_tmp43_, (GtkWidget*) bottom_panel, FALSE, FALSE);
#line 257 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp44_ = custom_statusbar_new ();
#line 257 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	g_object_ref_sink (_tmp44_);
#line 257 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_g_object_unref0 (self->priv->_statusbar);
#line 257 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	self->priv->_statusbar = _tmp44_;
#line 258 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp45_ = self->priv->_statusbar;
#line 258 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	gtk_widget_show_all ((GtkWidget*) _tmp45_);
#line 259 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp46_ = self->priv->_statusbar;
#line 259 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	gtk_container_add ((GtkContainer*) main_vgrid, (GtkWidget*) _tmp46_);
#line 261 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp47_ = self->priv->_statusbar;
#line 261 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	self->priv->_tip_message_cid = gtk_statusbar_get_context_id ((GtkStatusbar*) _tmp47_, "tip_message");
#line 265 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	g_signal_connect_object ((GObject*) tepl_window, "notify::active-tab", (GCallback) ___lambda82__g_object_notify, self, 0);
#line 280 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	g_signal_connect_object ((GObject*) tepl_window, "notify::active-view", (GCallback) ___lambda83__g_object_notify, self, 0);
#line 285 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	g_signal_connect_object ((GObject*) tepl_window, "notify::active-buffer", (GCallback) ___lambda84__g_object_notify, self, 0);
#line 290 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp48_ = self->priv->_documents_panel;
#line 290 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	tepl_application_window_set_tab_group (tepl_window, (TeplTabGroup*) _tmp48_);
#line 291 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	tepl_application_window_set_handle_title (tepl_window, TRUE);
#line 295 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	main_window_support_drag_and_drop (self);
#line 297 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	g_signal_connect_object ((GtkWidget*) self, "delete-event", (GCallback) ___lambda86__gtk_widget_delete_event, self, 0);
#line 305 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	main_window_restore_state (self);
#line 306 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	main_window_show_or_hide_widgets (self);
#line 307 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	gtk_widget_show ((GtkWidget*) self);
#line 309 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	finance_show_dialog ((GtkWindow*) self, TRUE);
#line 152 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_g_object_unref0 (bottom_panel);
#line 152 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_g_object_unref0 (docs_vgrid);
#line 152 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_g_object_unref0 (side_panel);
#line 152 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_g_object_unref0 (edit_toolbar);
#line 152 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_g_object_unref0 (main_toolbar);
#line 152 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_g_object_unref0 (viewport);
#line 152 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_g_object_unref0 (menu_paned);
#line 152 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_g_object_unref0 (menu);
#line 152 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_g_object_unref0 (main_vgrid);
#line 152 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_g_object_unref0 (tepl_window);
#line 152 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	return self;
#line 1356 "main_window.c"
}


MainWindow*
main_window_new (GlatexApp* app)
{
#line 152 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	return main_window_construct (TYPE_MAIN_WINDOW, app);
#line 1365 "main_window.c"
}


static void
main_window_show_images_in_menu (MainWindow* self)
{
	GtkUIManager* _tmp0_;
	GList* _tmp1_;
#line 314 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	g_return_if_fail (self != NULL);
#line 316 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp0_ = self->priv->_ui_manager;
#line 316 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp1_ = gtk_ui_manager_get_action_groups (_tmp0_);
#line 1380 "main_window.c"
	{
		GList* action_group_collection = NULL;
		GList* action_group_it = NULL;
#line 316 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		action_group_collection = _tmp1_;
#line 316 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		for (action_group_it = action_group_collection; action_group_it != NULL; action_group_it = action_group_it->next) {
#line 1388 "main_window.c"
			GtkActionGroup* _tmp2_;
			GtkActionGroup* action_group = NULL;
#line 316 "/home/seb/gnome/gnome-latex/src/main_window.vala"
			_tmp2_ = _g_object_ref0 ((GtkActionGroup*) action_group_it->data);
#line 316 "/home/seb/gnome/gnome-latex/src/main_window.vala"
			action_group = _tmp2_;
#line 1395 "main_window.c"
			{
				GtkActionGroup* _tmp3_;
				GList* _tmp4_;
#line 318 "/home/seb/gnome/gnome-latex/src/main_window.vala"
				_tmp3_ = action_group;
#line 318 "/home/seb/gnome/gnome-latex/src/main_window.vala"
				_tmp4_ = gtk_action_group_list_actions (_tmp3_);
#line 1403 "main_window.c"
				{
					GList* action_collection = NULL;
					GList* action_it = NULL;
#line 318 "/home/seb/gnome/gnome-latex/src/main_window.vala"
					action_collection = _tmp4_;
#line 318 "/home/seb/gnome/gnome-latex/src/main_window.vala"
					for (action_it = action_collection; action_it != NULL; action_it = action_it->next) {
#line 1411 "main_window.c"
						GtkAction* _tmp5_;
						GtkAction* action = NULL;
#line 318 "/home/seb/gnome/gnome-latex/src/main_window.vala"
						_tmp5_ = _g_object_ref0 ((GtkAction*) action_it->data);
#line 318 "/home/seb/gnome/gnome-latex/src/main_window.vala"
						action = _tmp5_;
#line 1418 "main_window.c"
						{
							GtkAction* _tmp6_;
#line 320 "/home/seb/gnome/gnome-latex/src/main_window.vala"
							_tmp6_ = action;
#line 320 "/home/seb/gnome/gnome-latex/src/main_window.vala"
							gtk_action_set_always_show_image (_tmp6_, TRUE);
#line 318 "/home/seb/gnome/gnome-latex/src/main_window.vala"
							_g_object_unref0 (action);
#line 1427 "main_window.c"
						}
					}
#line 318 "/home/seb/gnome/gnome-latex/src/main_window.vala"
					(action_collection == NULL) ? NULL : (action_collection = (g_list_free (action_collection), NULL));
#line 1432 "main_window.c"
				}
#line 316 "/home/seb/gnome/gnome-latex/src/main_window.vala"
				_g_object_unref0 (action_group);
#line 1436 "main_window.c"
			}
		}
	}
}


static void
_main_window_on_menu_item_select_gtk_menu_item_select (GtkMenuItem* _sender,
                                                       gpointer self)
{
#line 367 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	main_window_on_menu_item_select ((MainWindow*) self, _sender);
#line 1449 "main_window.c"
}


static void
_main_window_on_menu_item_deselect_gtk_menu_item_deselect (GtkMenuItem* _sender,
                                                           gpointer self)
{
#line 368 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	main_window_on_menu_item_deselect ((MainWindow*) self, _sender);
#line 1459 "main_window.c"
}


static void
__lambda65_ (MainWindow* self,
             GtkAction* action,
             GtkWidget* p)
{
#line 362 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	g_return_if_fail (action != NULL);
#line 362 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	g_return_if_fail (p != NULL);
#line 364 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	if (G_TYPE_CHECK_INSTANCE_TYPE (p, gtk_menu_item_get_type ())) {
#line 1474 "main_window.c"
		GtkMenuItem* proxy = NULL;
		GtkMenuItem* _tmp0_;
		GtkMenuItem* _tmp1_;
		GtkMenuItem* _tmp2_;
#line 366 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (p, gtk_menu_item_get_type ()) ? ((GtkMenuItem*) p) : NULL);
#line 366 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		proxy = _tmp0_;
#line 367 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		_tmp1_ = proxy;
#line 367 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		g_signal_connect_object (_tmp1_, "select", (GCallback) _main_window_on_menu_item_select_gtk_menu_item_select, self, 0);
#line 368 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		_tmp2_ = proxy;
#line 368 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		g_signal_connect_object (_tmp2_, "deselect", (GCallback) _main_window_on_menu_item_deselect_gtk_menu_item_deselect, self, 0);
#line 364 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		_g_object_unref0 (proxy);
#line 1493 "main_window.c"
	}
}


static void
___lambda65__gtk_ui_manager_connect_proxy (GtkUIManager* _sender,
                                           GtkAction* action,
                                           GtkWidget* proxy,
                                           gpointer self)
{
#line 362 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	__lambda65_ ((MainWindow*) self, action, proxy);
#line 1506 "main_window.c"
}


static void
__lambda66_ (MainWindow* self,
             GtkAction* action,
             GtkWidget* p)
{
#line 372 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	g_return_if_fail (action != NULL);
#line 372 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	g_return_if_fail (p != NULL);
#line 374 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	if (G_TYPE_CHECK_INSTANCE_TYPE (p, gtk_menu_item_get_type ())) {
#line 1521 "main_window.c"
		GtkMenuItem* proxy = NULL;
		GtkMenuItem* _tmp0_;
		GtkMenuItem* _tmp1_;
		guint _tmp2_;
		GtkMenuItem* _tmp3_;
		guint _tmp4_;
#line 376 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (p, gtk_menu_item_get_type ()) ? ((GtkMenuItem*) p) : NULL);
#line 376 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		proxy = _tmp0_;
#line 377 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		_tmp1_ = proxy;
#line 377 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		g_signal_parse_name ("select", gtk_menu_item_get_type (), &_tmp2_, NULL, FALSE);
#line 377 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		g_signal_handlers_disconnect_matched (_tmp1_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _main_window_on_menu_item_select_gtk_menu_item_select, self);
#line 378 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		_tmp3_ = proxy;
#line 378 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		g_signal_parse_name ("deselect", gtk_menu_item_get_type (), &_tmp4_, NULL, FALSE);
#line 378 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		g_signal_handlers_disconnect_matched (_tmp3_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp4_, 0, NULL, (GCallback) _main_window_on_menu_item_deselect_gtk_menu_item_deselect, self);
#line 374 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		_g_object_unref0 (proxy);
#line 1546 "main_window.c"
	}
}


static void
___lambda66__gtk_ui_manager_disconnect_proxy (GtkUIManager* _sender,
                                              GtkAction* action,
                                              GtkWidget* proxy,
                                              gpointer self)
{
#line 372 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	__lambda66_ ((MainWindow*) self, action, proxy);
#line 1559 "main_window.c"
}


static void
main_window_initialize_ui_manager (MainWindow* self)
{
	GtkActionGroup* _tmp0_;
	GtkActionGroup* _tmp1_;
	GtkActionGroup* _tmp2_;
	GtkActionGroup* _tmp3_;
	LatexMenu* _tmp4_;
	GtkUIManager* _tmp5_;
	GtkUIManager* _tmp6_;
	GtkActionGroup* _tmp7_;
	GtkUIManager* _tmp8_;
	GtkActionGroup* _tmp9_;
	GtkUIManager* _tmp13_;
	GtkAccelGroup* _tmp14_;
	GlatexApp* app = NULL;
	GlatexApp* _tmp15_;
	GtkActionGroup* _tmp16_;
	GtkActionGroup* _tmp17_;
	GtkActionGroup* _tmp18_;
	GtkActionGroup* _tmp19_;
	GtkUIManager* _tmp20_;
	GtkUIManager* _tmp21_;
	GError * _inner_error_ = NULL;
#line 325 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	g_return_if_fail (self != NULL);
#line 327 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp0_ = gtk_action_group_new ("ActionGroup");
#line 327 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_g_object_unref0 (self->priv->_action_group);
#line 327 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	self->priv->_action_group = _tmp0_;
#line 328 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp1_ = self->priv->_action_group;
#line 328 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	gtk_action_group_set_translation_domain (_tmp1_, GETTEXT_PACKAGE);
#line 329 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp2_ = self->priv->_action_group;
#line 329 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	gtk_action_group_add_actions (_tmp2_, MAIN_WINDOW__action_entries, (guint) G_N_ELEMENTS (MAIN_WINDOW__action_entries), self);
#line 330 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp3_ = self->priv->_action_group;
#line 330 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	gtk_action_group_add_toggle_actions (_tmp3_, MAIN_WINDOW__toggle_action_entries, (guint) G_N_ELEMENTS (MAIN_WINDOW__toggle_action_entries), self);
#line 332 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp4_ = latex_menu_new (self);
#line 332 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_g_object_unref0 (self->priv->_latex_action_group);
#line 332 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	self->priv->_latex_action_group = (GtkActionGroup*) _tmp4_;
#line 334 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp5_ = gtk_ui_manager_new ();
#line 334 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_g_object_unref0 (self->priv->_ui_manager);
#line 334 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	self->priv->_ui_manager = _tmp5_;
#line 335 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp6_ = self->priv->_ui_manager;
#line 335 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp7_ = self->priv->_action_group;
#line 335 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	gtk_ui_manager_insert_action_group (_tmp6_, _tmp7_, 0);
#line 336 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp8_ = self->priv->_ui_manager;
#line 336 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp9_ = self->priv->_latex_action_group;
#line 336 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	gtk_ui_manager_insert_action_group (_tmp8_, _tmp9_, 0);
#line 1631 "main_window.c"
	{
		gchar* path = NULL;
		gchar* _tmp10_;
		GtkUIManager* _tmp11_;
#line 340 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		_tmp10_ = g_build_filename (DATA_DIR, "ui", "ui.xml", NULL);
#line 340 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		path = _tmp10_;
#line 341 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		_tmp11_ = self->priv->_ui_manager;
#line 341 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		gtk_ui_manager_add_ui_from_file (_tmp11_, path, &_inner_error_);
#line 341 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 341 "/home/seb/gnome/gnome-latex/src/main_window.vala"
			_g_free0 (path);
#line 1648 "main_window.c"
			goto __catch31_g_error;
		}
#line 338 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		_g_free0 (path);
#line 1653 "main_window.c"
	}
	goto __finally31;
	__catch31_g_error:
	{
		GError* err = NULL;
		const gchar* _tmp12_;
#line 338 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		err = _inner_error_;
#line 338 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		_inner_error_ = NULL;
#line 345 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		_tmp12_ = err->message;
#line 345 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		g_error ("main_window.vala:345: %s", _tmp12_);
#line 338 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		_g_error_free0 (err);
#line 1670 "main_window.c"
	}
	__finally31:
#line 338 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 338 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 338 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		g_clear_error (&_inner_error_);
#line 338 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		return;
#line 1681 "main_window.c"
	}
#line 348 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp13_ = self->priv->_ui_manager;
#line 348 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp14_ = gtk_ui_manager_get_accel_group (_tmp13_);
#line 348 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	gtk_window_add_accel_group ((GtkWindow*) self, _tmp14_);
#line 350 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp15_ = glatex_app_get_instance ();
#line 350 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	app = _tmp15_;
#line 351 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp16_ = self->priv->_action_group;
#line 351 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	amtk_utils_bind_g_action_to_gtk_action ((GActionMap*) app, "quit", _tmp16_, "FileQuit");
#line 353 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp17_ = self->priv->_action_group;
#line 353 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	amtk_utils_bind_g_action_to_gtk_action ((GActionMap*) app, "help", _tmp17_, "HelpContents");
#line 355 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp18_ = self->priv->_action_group;
#line 355 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	amtk_utils_bind_g_action_to_gtk_action ((GActionMap*) app, "fundraising", _tmp18_, "HelpFinance");
#line 357 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp19_ = self->priv->_action_group;
#line 357 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	amtk_utils_bind_g_action_to_gtk_action ((GActionMap*) app, "about", _tmp19_, "HelpAbout");
#line 362 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp20_ = self->priv->_ui_manager;
#line 362 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	g_signal_connect_object (_tmp20_, "connect-proxy", (GCallback) ___lambda65__gtk_ui_manager_connect_proxy, self, 0);
#line 372 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp21_ = self->priv->_ui_manager;
#line 372 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	g_signal_connect_object (_tmp21_, "disconnect-proxy", (GCallback) ___lambda66__gtk_ui_manager_disconnect_proxy, self, 0);
#line 325 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_g_object_unref0 (app);
#line 1719 "main_window.c"
}


static void
main_window_on_menu_item_select (MainWindow* self,
                                 GtkMenuItem* proxy)
{
	GtkAction* action = NULL;
	GtkAction* _tmp0_;
	GtkAction* _tmp1_;
	GtkAction* _tmp2_;
	GtkAction* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
#line 383 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	g_return_if_fail (self != NULL);
#line 383 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	g_return_if_fail (proxy != NULL);
#line 385 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp0_ = gtk_activatable_get_related_action ((GtkActivatable*) proxy);
#line 385 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 385 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	action = _tmp1_;
#line 386 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp2_ = action;
#line 386 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	g_return_if_fail (_tmp2_ != NULL);
#line 387 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp3_ = action;
#line 387 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp4_ = gtk_action_get_tooltip (_tmp3_);
#line 387 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp5_ = _tmp4_;
#line 387 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	if (_tmp5_ != NULL) {
#line 1756 "main_window.c"
		CustomStatusbar* _tmp6_;
		guint _tmp7_;
		GtkAction* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
#line 388 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		_tmp6_ = self->priv->_statusbar;
#line 388 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		_tmp7_ = self->priv->_tip_message_cid;
#line 388 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		_tmp8_ = action;
#line 388 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		_tmp9_ = gtk_action_get_tooltip (_tmp8_);
#line 388 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		_tmp10_ = _tmp9_;
#line 388 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		gtk_statusbar_push ((GtkStatusbar*) _tmp6_, _tmp7_, _tmp10_);
#line 1774 "main_window.c"
	}
#line 383 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_g_object_unref0 (action);
#line 1778 "main_window.c"
}


static void
main_window_on_menu_item_deselect (MainWindow* self,
                                   GtkMenuItem* proxy)
{
	CustomStatusbar* _tmp0_;
	guint _tmp1_;
#line 391 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	g_return_if_fail (self != NULL);
#line 391 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	g_return_if_fail (proxy != NULL);
#line 393 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp0_ = self->priv->_statusbar;
#line 393 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp1_ = self->priv->_tip_message_cid;
#line 393 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	gtk_statusbar_pop ((GtkStatusbar*) _tmp0_, _tmp1_);
#line 1798 "main_window.c"
}


static GtkToolbar*
main_window_get_main_toolbar (MainWindow* self)
{
	GtkToolbar* result = NULL;
	GtkToolbar* main_toolbar = NULL;
	GtkUIManager* _tmp0_;
	GtkWidget* _tmp1_;
	GtkToolbar* _tmp2_;
	GtkToolItem* open_button = NULL;
	MainWindowFile* _tmp3_;
	GtkToolItem* _tmp4_;
	GtkStyleContext* context = NULL;
	GtkStyleContext* _tmp5_;
	GtkStyleContext* _tmp6_;
	GtkToggleAction* action = NULL;
	GtkActionGroup* _tmp7_;
	GtkAction* _tmp8_;
	GtkToggleAction* _tmp9_;
#line 396 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 398 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp0_ = self->priv->_ui_manager;
#line 398 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp1_ = gtk_ui_manager_get_widget (_tmp0_, "/MainToolbar");
#line 398 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, gtk_toolbar_get_type ()) ? ((GtkToolbar*) _tmp1_) : NULL);
#line 398 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	main_toolbar = _tmp2_;
#line 399 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp3_ = self->priv->_main_window_file;
#line 399 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp4_ = main_window_file_get_toolbar_open_button (_tmp3_);
#line 399 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	open_button = _tmp4_;
#line 400 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	gtk_toolbar_insert (main_toolbar, open_button, 1);
#line 402 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	gtk_toolbar_set_style (main_toolbar, GTK_TOOLBAR_ICONS);
#line 403 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp5_ = gtk_widget_get_style_context ((GtkWidget*) main_toolbar);
#line 403 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp6_ = _g_object_ref0 (_tmp5_);
#line 403 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	context = _tmp6_;
#line 404 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	gtk_style_context_add_class (context, GTK_STYLE_CLASS_PRIMARY_TOOLBAR);
#line 406 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	gtk_widget_show_all ((GtkWidget*) main_toolbar);
#line 408 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp7_ = self->priv->_action_group;
#line 408 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp8_ = gtk_action_group_get_action (_tmp7_, "ViewMainToolbar");
#line 408 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, gtk_toggle_action_get_type ()) ? ((GtkToggleAction*) _tmp8_) : NULL);
#line 408 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	action = _tmp9_;
#line 410 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	gtk_toggle_action_set_active (action, TRUE);
#line 412 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	g_object_bind_property_with_closures ((GObject*) main_toolbar, "visible", (GObject*) action, "active", G_BINDING_BIDIRECTIONAL, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
#line 415 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	result = main_toolbar;
#line 415 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_g_object_unref0 (action);
#line 415 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_g_object_unref0 (context);
#line 415 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_g_object_unref0 (open_button);
#line 415 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	return result;
#line 1872 "main_window.c"
}


static GtkToolbar*
main_window_get_edit_toolbar (MainWindow* self)
{
	GtkToolbar* result = NULL;
	GtkToolbar* edit_toolbar = NULL;
	GtkUIManager* _tmp0_;
	GtkWidget* _tmp1_;
	GtkToolbar* _tmp2_;
	GtkStyleContext* context = NULL;
	GtkStyleContext* _tmp3_;
	GtkStyleContext* _tmp4_;
	GtkToggleAction* action = NULL;
	GtkActionGroup* _tmp5_;
	GtkAction* _tmp6_;
	GtkToggleAction* _tmp7_;
#line 418 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 420 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp0_ = self->priv->_ui_manager;
#line 420 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp1_ = gtk_ui_manager_get_widget (_tmp0_, "/EditToolbar");
#line 420 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, gtk_toolbar_get_type ()) ? ((GtkToolbar*) _tmp1_) : NULL);
#line 420 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	edit_toolbar = _tmp2_;
#line 421 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	gtk_toolbar_set_style (edit_toolbar, GTK_TOOLBAR_ICONS);
#line 423 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp3_ = gtk_widget_get_style_context ((GtkWidget*) edit_toolbar);
#line 423 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 423 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	context = _tmp4_;
#line 424 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	gtk_style_context_add_class (context, "gnome-latex-edit-toolbar");
#line 426 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	gtk_widget_show_all ((GtkWidget*) edit_toolbar);
#line 428 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp5_ = self->priv->_action_group;
#line 428 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp6_ = gtk_action_group_get_action (_tmp5_, "ViewEditToolbar");
#line 428 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, gtk_toggle_action_get_type ()) ? ((GtkToggleAction*) _tmp6_) : NULL);
#line 428 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	action = _tmp7_;
#line 430 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	gtk_toggle_action_set_active (action, TRUE);
#line 432 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	g_object_bind_property_with_closures ((GObject*) edit_toolbar, "visible", (GObject*) action, "active", G_BINDING_BIDIRECTIONAL, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
#line 435 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	result = edit_toolbar;
#line 435 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_g_object_unref0 (action);
#line 435 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_g_object_unref0 (context);
#line 435 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	return result;
#line 1933 "main_window.c"
}


static SidePanel*
main_window_get_side_panel (MainWindow* self)
{
	SidePanel* result = NULL;
	SidePanel* side_panel = NULL;
	SidePanel* _tmp0_;
	GtkToggleAction* action = NULL;
	GtkActionGroup* _tmp1_;
	GtkAction* _tmp2_;
	GtkToggleAction* _tmp3_;
	SymbolsView* symbols = NULL;
	SymbolsView* _tmp4_;
	FileBrowser* file_browser = NULL;
	FileBrowser* _tmp5_;
	Structure* structure = NULL;
	Structure* _tmp6_;
	MainWindowStructure* _tmp7_;
#line 438 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 440 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp0_ = side_panel_new ();
#line 440 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	g_object_ref_sink (_tmp0_);
#line 440 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	side_panel = _tmp0_;
#line 441 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	gtk_widget_show ((GtkWidget*) side_panel);
#line 444 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp1_ = self->priv->_action_group;
#line 444 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp2_ = gtk_action_group_get_action (_tmp1_, "ViewSidePanel");
#line 444 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, gtk_toggle_action_get_type ()) ? ((GtkToggleAction*) _tmp2_) : NULL);
#line 444 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	action = _tmp3_;
#line 445 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	gtk_toggle_action_set_active (action, TRUE);
#line 447 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	g_object_bind_property_with_closures ((GObject*) side_panel, "visible", (GObject*) action, "active", G_BINDING_BIDIRECTIONAL, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
#line 451 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp4_ = symbols_view_new (self);
#line 451 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	g_object_ref_sink (_tmp4_);
#line 451 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	symbols = _tmp4_;
#line 452 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	side_panel_add_component (side_panel, _ ("Symbols"), "symbol_greek", (GtkGrid*) symbols);
#line 455 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp5_ = file_browser_new (self);
#line 455 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	g_object_ref_sink (_tmp5_);
#line 455 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	file_browser = _tmp5_;
#line 456 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	side_panel_add_component (side_panel, _ ("File Browser"), "document-open", (GtkGrid*) file_browser);
#line 459 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp6_ = structure_new (self);
#line 459 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	g_object_ref_sink (_tmp6_);
#line 459 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	structure = _tmp6_;
#line 460 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp7_ = self->priv->_main_window_structure;
#line 460 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	main_window_structure_set_structure (_tmp7_, structure);
#line 461 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	side_panel_add_component (side_panel, _ ("Structure"), GTK_STOCK_INDEX, (GtkGrid*) structure);
#line 463 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	side_panel_restore_state (side_panel);
#line 465 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	result = side_panel;
#line 465 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_g_object_unref0 (structure);
#line 465 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_g_object_unref0 (file_browser);
#line 465 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_g_object_unref0 (symbols);
#line 465 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_g_object_unref0 (action);
#line 465 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	return result;
#line 2018 "main_window.c"
}


static void
__lambda81_ (MainWindow* self,
             GdkEventButton* event)
{
	GtkMenu* popup_menu = NULL;
	GtkUIManager* _tmp0_;
	GtkWidget* _tmp1_;
	GtkMenu* _tmp2_;
#line 475 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	g_return_if_fail (event != NULL);
#line 477 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp0_ = self->priv->_ui_manager;
#line 477 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp1_ = gtk_ui_manager_get_widget (_tmp0_, "/NotebookPopup");
#line 477 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, gtk_menu_get_type ()) ? ((GtkMenu*) _tmp1_) : NULL);
#line 477 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	popup_menu = _tmp2_;
#line 478 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	gtk_menu_popup_at_pointer (popup_menu, (GdkEvent*) event);
#line 475 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_g_object_unref0 (popup_menu);
#line 2044 "main_window.c"
}


static void
___lambda81__documents_panel_right_click (DocumentsPanel* _sender,
                                          GdkEventButton* event,
                                          gpointer self)
{
#line 475 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	__lambda81_ ((MainWindow*) self, event);
#line 2055 "main_window.c"
}


static void
main_window_init_documents_panel (MainWindow* self)
{
	DocumentsPanel* _tmp0_;
	DocumentsPanel* _tmp1_;
	MainWindowDocuments* _tmp2_;
	DocumentsPanel* _tmp3_;
	DocumentsPanel* _tmp4_;
#line 468 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	g_return_if_fail (self != NULL);
#line 470 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp0_ = documents_panel_new (self);
#line 470 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	g_object_ref_sink (_tmp0_);
#line 470 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_g_object_unref0 (self->priv->_documents_panel);
#line 470 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	self->priv->_documents_panel = _tmp0_;
#line 471 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp1_ = self->priv->_documents_panel;
#line 471 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	gtk_widget_show_all ((GtkWidget*) _tmp1_);
#line 473 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp2_ = self->priv->_main_window_documents;
#line 473 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp3_ = self->priv->_documents_panel;
#line 473 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	main_window_documents_set_documents_panel (_tmp2_, _tmp3_);
#line 475 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp4_ = self->priv->_documents_panel;
#line 475 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	g_signal_connect_object (_tmp4_, "right-click", (GCallback) ___lambda81__documents_panel_right_click, self, 0);
#line 2091 "main_window.c"
}


static BottomPanel*
main_window_get_bottom_panel (MainWindow* self)
{
	BottomPanel* result = NULL;
	LatexilaBuildView* build_view = NULL;
	LatexilaBuildView* _tmp0_;
	MainWindowBuildTools* _tmp1_;
	GtkToolbar* build_toolbar = NULL;
	GtkUIManager* _tmp2_;
	GtkWidget* _tmp3_;
	GtkToolbar* _tmp4_;
	BottomPanel* bottom_panel = NULL;
	BottomPanel* _tmp5_;
	GtkToggleAction* action = NULL;
	GtkActionGroup* _tmp6_;
	GtkAction* _tmp7_;
	GtkToggleAction* _tmp8_;
#line 482 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 484 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp0_ = latexila_build_view_new ();
#line 484 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	g_object_ref_sink (_tmp0_);
#line 484 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	build_view = _tmp0_;
#line 485 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp1_ = self->priv->_main_window_build_tools;
#line 485 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	main_window_build_tools_set_build_view (_tmp1_, build_view);
#line 487 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp2_ = self->priv->_ui_manager;
#line 487 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp3_ = gtk_ui_manager_get_widget (_tmp2_, "/BuildToolbar");
#line 487 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, gtk_toolbar_get_type ()) ? ((GtkToolbar*) _tmp3_) : NULL);
#line 487 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	build_toolbar = _tmp4_;
#line 488 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	gtk_toolbar_set_style (build_toolbar, GTK_TOOLBAR_ICONS);
#line 489 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	gtk_toolbar_set_icon_size (build_toolbar, GTK_ICON_SIZE_MENU);
#line 490 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	gtk_orientable_set_orientation ((GtkOrientable*) build_toolbar, GTK_ORIENTATION_VERTICAL);
#line 492 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp5_ = bottom_panel_new (build_view, build_toolbar);
#line 492 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	g_object_ref_sink (_tmp5_);
#line 492 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	bottom_panel = _tmp5_;
#line 495 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp6_ = self->priv->_action_group;
#line 495 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp7_ = gtk_action_group_get_action (_tmp6_, "ViewBottomPanel");
#line 495 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, gtk_toggle_action_get_type ()) ? ((GtkToggleAction*) _tmp7_) : NULL);
#line 495 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	action = _tmp8_;
#line 497 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	gtk_toggle_action_set_active (action, FALSE);
#line 499 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	g_object_bind_property_with_closures ((GObject*) bottom_panel, "visible", (GObject*) action, "active", G_BINDING_BIDIRECTIONAL, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
#line 502 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	result = bottom_panel;
#line 502 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_g_object_unref0 (action);
#line 502 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_g_object_unref0 (build_toolbar);
#line 502 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_g_object_unref0 (build_view);
#line 502 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	return result;
#line 2166 "main_window.c"
}


static void
main_window_restore_state (MainWindow* self)
{
	GSettings* settings = NULL;
	GSettings* _tmp0_;
	gint width = 0;
	gint height = 0;
	GSettings* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	GdkWindowState state = 0;
	GSettings* _tmp4_;
	GdkWindowState _tmp5_;
	GdkWindowState _tmp6_;
	GtkPaned* _tmp7_;
	GSettings* _tmp8_;
	GtkPaned* _tmp9_;
	GSettings* _tmp10_;
#line 505 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	g_return_if_fail (self != NULL);
#line 507 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp0_ = g_settings_new ("org.gnome.gnome-latex.state.window");
#line 507 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	settings = _tmp0_;
#line 513 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp1_ = settings;
#line 513 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	g_settings_get (_tmp1_, "size", "(ii)", &width, &height);
#line 514 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp2_ = width;
#line 514 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp3_ = height;
#line 514 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	gtk_window_set_default_size ((GtkWindow*) self, _tmp2_, _tmp3_);
#line 516 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp4_ = settings;
#line 516 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	state = (GdkWindowState) g_settings_get_int (_tmp4_, "state");
#line 517 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp5_ = state;
#line 517 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	if ((_tmp5_ & GDK_WINDOW_STATE_MAXIMIZED) == GDK_WINDOW_STATE_MAXIMIZED) {
#line 518 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		gtk_window_maximize ((GtkWindow*) self);
#line 2214 "main_window.c"
	} else {
#line 520 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		gtk_window_unmaximize ((GtkWindow*) self);
#line 2218 "main_window.c"
	}
#line 522 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp6_ = state;
#line 522 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	if ((_tmp6_ & GDK_WINDOW_STATE_STICKY) == GDK_WINDOW_STATE_STICKY) {
#line 523 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		gtk_window_stick ((GtkWindow*) self);
#line 2226 "main_window.c"
	} else {
#line 525 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		gtk_window_unstick ((GtkWindow*) self);
#line 2230 "main_window.c"
	}
#line 529 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp7_ = self->priv->_main_hpaned;
#line 529 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp8_ = settings;
#line 529 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	gtk_paned_set_position (_tmp7_, g_settings_get_int (_tmp8_, "side-panel-size"));
#line 530 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp9_ = self->priv->_vpaned;
#line 530 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp10_ = settings;
#line 530 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	gtk_paned_set_position (_tmp9_, g_settings_get_int (_tmp10_, "vertical-paned-position"));
#line 505 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_g_object_unref0 (settings);
#line 2246 "main_window.c"
}


static void
_vala_array_add5 (GFile** * array,
                  int* length,
                  int* size,
                  GFile* value)
{
#line 546 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	if ((*length) == (*size)) {
#line 546 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 546 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		*array = g_renew (GFile*, *array, (*size) + 1);
#line 2262 "main_window.c"
	}
#line 546 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	(*array)[(*length)++] = value;
#line 546 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	(*array)[*length] = NULL;
#line 2268 "main_window.c"
}


static void
__lambda85_ (MainWindow* self,
             GdkDragContext* dc,
             gint x,
             gint y,
             GtkSelectionData* selection_data,
             guint info,
             guint time)
{
	GlatexApp* app = NULL;
	GlatexApp* _tmp0_;
	GFile** files = NULL;
	GFile** _tmp1_;
	gint files_length1;
	gint _files_size_;
	gchar** _tmp2_;
	gchar** _tmp3_;
	GlatexApp* _tmp11_;
	GFile** _tmp12_;
	gint _tmp12__length1;
#line 538 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	g_return_if_fail (dc != NULL);
#line 538 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	g_return_if_fail (selection_data != NULL);
#line 540 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp0_ = glatex_app_get_instance ();
#line 540 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	app = _tmp0_;
#line 542 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp1_ = g_new0 (GFile*, 0 + 1);
#line 542 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	files = _tmp1_;
#line 542 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	files_length1 = 0;
#line 542 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_files_size_ = files_length1;
#line 543 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp3_ = _tmp2_ = gtk_selection_data_get_uris (selection_data);
#line 2310 "main_window.c"
	{
		gchar** uri_collection = NULL;
		gint uri_collection_length1 = 0;
		gint _uri_collection_size_ = 0;
		gint uri_it = 0;
#line 543 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		uri_collection = _tmp3_;
#line 543 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		uri_collection_length1 = _vala_array_length (_tmp2_);
#line 543 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		for (uri_it = 0; uri_it < _vala_array_length (_tmp2_); uri_it = uri_it + 1) {
#line 2322 "main_window.c"
			gchar* _tmp4_;
			gchar* uri = NULL;
#line 543 "/home/seb/gnome/gnome-latex/src/main_window.vala"
			_tmp4_ = g_strdup (uri_collection[uri_it]);
#line 543 "/home/seb/gnome/gnome-latex/src/main_window.vala"
			uri = _tmp4_;
#line 2329 "main_window.c"
			{
				const gchar* _tmp5_;
				gint _tmp6_;
				gint _tmp7_;
#line 545 "/home/seb/gnome/gnome-latex/src/main_window.vala"
				_tmp5_ = uri;
#line 545 "/home/seb/gnome/gnome-latex/src/main_window.vala"
				_tmp6_ = strlen (_tmp5_);
#line 545 "/home/seb/gnome/gnome-latex/src/main_window.vala"
				_tmp7_ = _tmp6_;
#line 545 "/home/seb/gnome/gnome-latex/src/main_window.vala"
				if (0 < _tmp7_) {
#line 2342 "main_window.c"
					GFile** _tmp8_;
					gint _tmp8__length1;
					const gchar* _tmp9_;
					GFile* _tmp10_;
#line 546 "/home/seb/gnome/gnome-latex/src/main_window.vala"
					_tmp8_ = files;
#line 546 "/home/seb/gnome/gnome-latex/src/main_window.vala"
					_tmp8__length1 = files_length1;
#line 546 "/home/seb/gnome/gnome-latex/src/main_window.vala"
					_tmp9_ = uri;
#line 546 "/home/seb/gnome/gnome-latex/src/main_window.vala"
					_tmp10_ = g_file_new_for_uri (_tmp9_);
#line 546 "/home/seb/gnome/gnome-latex/src/main_window.vala"
					_vala_array_add5 (&files, &files_length1, &_files_size_, _tmp10_);
#line 2357 "main_window.c"
				}
#line 543 "/home/seb/gnome/gnome-latex/src/main_window.vala"
				_g_free0 (uri);
#line 2361 "main_window.c"
			}
		}
#line 543 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		uri_collection = (_vala_array_free (uri_collection, uri_collection_length1, (GDestroyNotify) g_free), NULL);
#line 2366 "main_window.c"
	}
#line 549 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp11_ = app;
#line 549 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp12_ = files;
#line 549 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp12__length1 = files_length1;
#line 549 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	glatex_app_open_documents (_tmp11_, _tmp12_, _tmp12__length1);
#line 550 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	gtk_drag_finish (dc, TRUE, TRUE, (guint32) time);
#line 538 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	files = (_vala_array_free (files, files_length1, (GDestroyNotify) g_object_unref), NULL);
#line 538 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_g_object_unref0 (app);
#line 2382 "main_window.c"
}


static void
___lambda85__gtk_widget_drag_data_received (GtkWidget* _sender,
                                            GdkDragContext* context,
                                            gint x,
                                            gint y,
                                            GtkSelectionData* selection_data,
                                            guint info,
                                            guint time_,
                                            gpointer self)
{
#line 538 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	__lambda85_ ((MainWindow*) self, context, x, y, selection_data, info, time_);
#line 2398 "main_window.c"
}


static void
main_window_support_drag_and_drop (MainWindow* self)
{
	GtkTargetEntry* _tmp0_;
	GtkTargetEntry* _tmp1_;
	gint _tmp1__length1;
#line 534 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	g_return_if_fail (self != NULL);
#line 536 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp0_ = g_new0 (GtkTargetEntry, 0);
#line 536 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp1_ = _tmp0_;
#line 536 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp1__length1 = 0;
#line 536 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	gtk_drag_dest_set ((GtkWidget*) self, GTK_DEST_DEFAULT_ALL, _tmp1_, 0, GDK_ACTION_COPY);
#line 536 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp1_ = (g_free (_tmp1_), NULL);
#line 537 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	gtk_drag_dest_add_uri_targets ((GtkWidget*) self);
#line 538 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	g_signal_connect_object ((GtkWidget*) self, "drag-data-received", (GCallback) ___lambda85__gtk_widget_drag_data_received, self, 0);
#line 2424 "main_window.c"
}


static void
main_window_show_or_hide_widgets (MainWindow* self)
{
	GSettings* settings = NULL;
	GSettings* _tmp0_;
	GtkToggleAction* action = NULL;
	GtkActionGroup* _tmp1_;
	GtkAction* _tmp2_;
	GtkToggleAction* _tmp3_;
	GtkToggleAction* _tmp4_;
	GtkActionGroup* _tmp5_;
	GtkAction* _tmp6_;
	GtkToggleAction* _tmp7_;
	GtkToggleAction* _tmp8_;
	GtkActionGroup* _tmp9_;
	GtkAction* _tmp10_;
	GtkToggleAction* _tmp11_;
	GtkToggleAction* _tmp12_;
	GtkActionGroup* _tmp13_;
	GtkAction* _tmp14_;
	GtkToggleAction* _tmp15_;
	GtkToggleAction* _tmp16_;
#line 554 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	g_return_if_fail (self != NULL);
#line 556 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp0_ = g_settings_new ("org.gnome.gnome-latex.preferences.ui");
#line 556 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	settings = _tmp0_;
#line 558 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp1_ = self->priv->_action_group;
#line 558 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp2_ = gtk_action_group_get_action (_tmp1_, "ViewMainToolbar");
#line 558 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, gtk_toggle_action_get_type ()) ? ((GtkToggleAction*) _tmp2_) : NULL);
#line 558 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	action = _tmp3_;
#line 560 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp4_ = action;
#line 560 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	gtk_toggle_action_set_active (_tmp4_, g_settings_get_boolean (settings, "main-toolbar-visible"));
#line 562 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp5_ = self->priv->_action_group;
#line 562 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp6_ = gtk_action_group_get_action (_tmp5_, "ViewEditToolbar");
#line 562 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, gtk_toggle_action_get_type ()) ? ((GtkToggleAction*) _tmp6_) : NULL);
#line 562 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_g_object_unref0 (action);
#line 562 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	action = _tmp7_;
#line 563 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp8_ = action;
#line 563 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	gtk_toggle_action_set_active (_tmp8_, g_settings_get_boolean (settings, "edit-toolbar-visible"));
#line 565 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp9_ = self->priv->_action_group;
#line 565 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp10_ = gtk_action_group_get_action (_tmp9_, "ViewSidePanel");
#line 565 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp11_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp10_, gtk_toggle_action_get_type ()) ? ((GtkToggleAction*) _tmp10_) : NULL);
#line 565 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_g_object_unref0 (action);
#line 565 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	action = _tmp11_;
#line 566 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp12_ = action;
#line 566 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	gtk_toggle_action_set_active (_tmp12_, g_settings_get_boolean (settings, "side-panel-visible"));
#line 568 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp13_ = self->priv->_action_group;
#line 568 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp14_ = gtk_action_group_get_action (_tmp13_, "ViewBottomPanel");
#line 568 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp15_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp14_, gtk_toggle_action_get_type ()) ? ((GtkToggleAction*) _tmp14_) : NULL);
#line 568 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_g_object_unref0 (action);
#line 568 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	action = _tmp15_;
#line 569 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp16_ = action;
#line 569 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	gtk_toggle_action_set_active (_tmp16_, g_settings_get_boolean (settings, "bottom-panel-visible"));
#line 554 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_g_object_unref0 (action);
#line 554 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_g_object_unref0 (settings);
#line 2514 "main_window.c"
}


/*************************************************************************/
static gpointer
_main_window_structure_ref0 (gpointer self)
{
#line 577 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	return self ? main_window_structure_ref (self) : NULL;
#line 2524 "main_window.c"
}


MainWindowStructure*
main_window_get_main_window_structure (MainWindow* self)
{
	MainWindowStructure* result = NULL;
	MainWindowStructure* _tmp0_;
	MainWindowStructure* _tmp1_;
#line 575 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 577 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp0_ = self->priv->_main_window_structure;
#line 577 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp1_ = _main_window_structure_ref0 (_tmp0_);
#line 577 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	result = _tmp1_;
#line 577 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	return result;
#line 2544 "main_window.c"
}


/*************************************************************************/
GeeList*
main_window_get_documents (MainWindow* self)
{
	GeeList* result = NULL;
	GeeList* all_documents = NULL;
	GeeLinkedList* _tmp0_;
	gint nb_documents = 0;
	DocumentsPanel* _tmp1_;
#line 583 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 585 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp0_ = gee_linked_list_new (TYPE_DOCUMENT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 585 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	all_documents = (GeeList*) _tmp0_;
#line 586 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp1_ = self->priv->_documents_panel;
#line 586 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	nb_documents = gtk_notebook_get_n_pages ((GtkNotebook*) _tmp1_);
#line 2567 "main_window.c"
	{
		gint i = 0;
#line 587 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		i = 0;
#line 2572 "main_window.c"
		{
			gboolean _tmp2_ = FALSE;
#line 587 "/home/seb/gnome/gnome-latex/src/main_window.vala"
			_tmp2_ = TRUE;
#line 587 "/home/seb/gnome/gnome-latex/src/main_window.vala"
			while (TRUE) {
#line 2579 "main_window.c"
				gint _tmp4_;
				gint _tmp5_;
				DocumentTab* tab = NULL;
				DocumentsPanel* _tmp6_;
				gint _tmp7_;
				GtkWidget* _tmp8_;
				DocumentTab* _tmp9_;
				GeeList* _tmp10_;
				DocumentTab* _tmp11_;
				Document* _tmp12_;
				Document* _tmp13_;
#line 587 "/home/seb/gnome/gnome-latex/src/main_window.vala"
				if (!_tmp2_) {
#line 2593 "main_window.c"
					gint _tmp3_;
#line 587 "/home/seb/gnome/gnome-latex/src/main_window.vala"
					_tmp3_ = i;
#line 587 "/home/seb/gnome/gnome-latex/src/main_window.vala"
					i = _tmp3_ + 1;
#line 2599 "main_window.c"
				}
#line 587 "/home/seb/gnome/gnome-latex/src/main_window.vala"
				_tmp2_ = FALSE;
#line 587 "/home/seb/gnome/gnome-latex/src/main_window.vala"
				_tmp4_ = i;
#line 587 "/home/seb/gnome/gnome-latex/src/main_window.vala"
				_tmp5_ = nb_documents;
#line 587 "/home/seb/gnome/gnome-latex/src/main_window.vala"
				if (!(_tmp4_ < _tmp5_)) {
#line 587 "/home/seb/gnome/gnome-latex/src/main_window.vala"
					break;
#line 2611 "main_window.c"
				}
#line 589 "/home/seb/gnome/gnome-latex/src/main_window.vala"
				_tmp6_ = self->priv->_documents_panel;
#line 589 "/home/seb/gnome/gnome-latex/src/main_window.vala"
				_tmp7_ = i;
#line 589 "/home/seb/gnome/gnome-latex/src/main_window.vala"
				_tmp8_ = gtk_notebook_get_nth_page ((GtkNotebook*) _tmp6_, _tmp7_);
#line 589 "/home/seb/gnome/gnome-latex/src/main_window.vala"
				_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, TYPE_DOCUMENT_TAB) ? ((DocumentTab*) _tmp8_) : NULL);
#line 589 "/home/seb/gnome/gnome-latex/src/main_window.vala"
				tab = _tmp9_;
#line 590 "/home/seb/gnome/gnome-latex/src/main_window.vala"
				_tmp10_ = all_documents;
#line 590 "/home/seb/gnome/gnome-latex/src/main_window.vala"
				_tmp11_ = tab;
#line 590 "/home/seb/gnome/gnome-latex/src/main_window.vala"
				_tmp12_ = document_tab_get_document (_tmp11_);
#line 590 "/home/seb/gnome/gnome-latex/src/main_window.vala"
				_tmp13_ = _tmp12_;
#line 590 "/home/seb/gnome/gnome-latex/src/main_window.vala"
				gee_collection_add ((GeeCollection*) _tmp10_, _tmp13_);
#line 587 "/home/seb/gnome/gnome-latex/src/main_window.vala"
				_g_object_unref0 (tab);
#line 2635 "main_window.c"
			}
		}
	}
#line 593 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	result = all_documents;
#line 593 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	return result;
#line 2643 "main_window.c"
}


GeeList*
main_window_get_unsaved_documents (MainWindow* self)
{
	GeeList* result = NULL;
	GeeList* unsaved_documents = NULL;
	GeeLinkedList* _tmp0_;
#line 596 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 598 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp0_ = gee_linked_list_new (TYPE_DOCUMENT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 598 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	unsaved_documents = (GeeList*) _tmp0_;
#line 2659 "main_window.c"
	{
		GeeList* _doc_list = NULL;
		GeeList* _tmp1_;
		gint _doc_size = 0;
		GeeList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _doc_index = 0;
#line 599 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		_tmp1_ = main_window_get_documents (self);
#line 599 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		_doc_list = _tmp1_;
#line 599 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		_tmp2_ = _doc_list;
#line 599 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		_tmp3_ = gee_collection_get_size ((GeeCollection*) _tmp2_);
#line 599 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		_tmp4_ = _tmp3_;
#line 599 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		_doc_size = _tmp4_;
#line 599 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		_doc_index = -1;
#line 599 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		while (TRUE) {
#line 2684 "main_window.c"
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			Document* doc = NULL;
			GeeList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			Document* _tmp11_;
#line 599 "/home/seb/gnome/gnome-latex/src/main_window.vala"
			_tmp5_ = _doc_index;
#line 599 "/home/seb/gnome/gnome-latex/src/main_window.vala"
			_doc_index = _tmp5_ + 1;
#line 599 "/home/seb/gnome/gnome-latex/src/main_window.vala"
			_tmp6_ = _doc_index;
#line 599 "/home/seb/gnome/gnome-latex/src/main_window.vala"
			_tmp7_ = _doc_size;
#line 599 "/home/seb/gnome/gnome-latex/src/main_window.vala"
			if (!(_tmp6_ < _tmp7_)) {
#line 599 "/home/seb/gnome/gnome-latex/src/main_window.vala"
				break;
#line 2705 "main_window.c"
			}
#line 599 "/home/seb/gnome/gnome-latex/src/main_window.vala"
			_tmp8_ = _doc_list;
#line 599 "/home/seb/gnome/gnome-latex/src/main_window.vala"
			_tmp9_ = _doc_index;
#line 599 "/home/seb/gnome/gnome-latex/src/main_window.vala"
			_tmp10_ = gee_list_get (_tmp8_, _tmp9_);
#line 599 "/home/seb/gnome/gnome-latex/src/main_window.vala"
			doc = (Document*) _tmp10_;
#line 601 "/home/seb/gnome/gnome-latex/src/main_window.vala"
			_tmp11_ = doc;
#line 601 "/home/seb/gnome/gnome-latex/src/main_window.vala"
			if (gtk_text_buffer_get_modified ((GtkTextBuffer*) _tmp11_)) {
#line 2719 "main_window.c"
				GeeList* _tmp12_;
				Document* _tmp13_;
#line 602 "/home/seb/gnome/gnome-latex/src/main_window.vala"
				_tmp12_ = unsaved_documents;
#line 602 "/home/seb/gnome/gnome-latex/src/main_window.vala"
				_tmp13_ = doc;
#line 602 "/home/seb/gnome/gnome-latex/src/main_window.vala"
				gee_collection_add ((GeeCollection*) _tmp12_, _tmp13_);
#line 2728 "main_window.c"
			}
#line 599 "/home/seb/gnome/gnome-latex/src/main_window.vala"
			_g_object_unref0 (doc);
#line 2732 "main_window.c"
		}
#line 599 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		_g_object_unref0 (_doc_list);
#line 2736 "main_window.c"
	}
#line 605 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	result = unsaved_documents;
#line 605 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	return result;
#line 2742 "main_window.c"
}


GeeList*
main_window_get_views (MainWindow* self)
{
	GeeList* result = NULL;
	GeeList* all_views = NULL;
	GeeLinkedList* _tmp0_;
	DocumentsPanel* _tmp1_;
	gint nb_documents = 0;
	DocumentsPanel* _tmp2_;
#line 608 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 610 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp0_ = gee_linked_list_new (TYPE_DOCUMENT_VIEW, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 610 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	all_views = (GeeList*) _tmp0_;
#line 612 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp1_ = self->priv->_documents_panel;
#line 612 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	if (_tmp1_ == NULL) {
#line 613 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		result = all_views;
#line 613 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		return result;
#line 2769 "main_window.c"
	}
#line 615 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp2_ = self->priv->_documents_panel;
#line 615 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	nb_documents = gtk_notebook_get_n_pages ((GtkNotebook*) _tmp2_);
#line 2775 "main_window.c"
	{
		gint i = 0;
#line 617 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		i = 0;
#line 2780 "main_window.c"
		{
			gboolean _tmp3_ = FALSE;
#line 617 "/home/seb/gnome/gnome-latex/src/main_window.vala"
			_tmp3_ = TRUE;
#line 617 "/home/seb/gnome/gnome-latex/src/main_window.vala"
			while (TRUE) {
#line 2787 "main_window.c"
				gint _tmp5_;
				gint _tmp6_;
				DocumentTab* tab = NULL;
				DocumentsPanel* _tmp7_;
				gint _tmp8_;
				GtkWidget* _tmp9_;
				DocumentTab* _tmp10_;
				GeeList* _tmp11_;
				DocumentTab* _tmp12_;
				DocumentView* _tmp13_;
				DocumentView* _tmp14_;
#line 617 "/home/seb/gnome/gnome-latex/src/main_window.vala"
				if (!_tmp3_) {
#line 2801 "main_window.c"
					gint _tmp4_;
#line 617 "/home/seb/gnome/gnome-latex/src/main_window.vala"
					_tmp4_ = i;
#line 617 "/home/seb/gnome/gnome-latex/src/main_window.vala"
					i = _tmp4_ + 1;
#line 2807 "main_window.c"
				}
#line 617 "/home/seb/gnome/gnome-latex/src/main_window.vala"
				_tmp3_ = FALSE;
#line 617 "/home/seb/gnome/gnome-latex/src/main_window.vala"
				_tmp5_ = i;
#line 617 "/home/seb/gnome/gnome-latex/src/main_window.vala"
				_tmp6_ = nb_documents;
#line 617 "/home/seb/gnome/gnome-latex/src/main_window.vala"
				if (!(_tmp5_ < _tmp6_)) {
#line 617 "/home/seb/gnome/gnome-latex/src/main_window.vala"
					break;
#line 2819 "main_window.c"
				}
#line 619 "/home/seb/gnome/gnome-latex/src/main_window.vala"
				_tmp7_ = self->priv->_documents_panel;
#line 619 "/home/seb/gnome/gnome-latex/src/main_window.vala"
				_tmp8_ = i;
#line 619 "/home/seb/gnome/gnome-latex/src/main_window.vala"
				_tmp9_ = gtk_notebook_get_nth_page ((GtkNotebook*) _tmp7_, _tmp8_);
#line 619 "/home/seb/gnome/gnome-latex/src/main_window.vala"
				_tmp10_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, TYPE_DOCUMENT_TAB) ? ((DocumentTab*) _tmp9_) : NULL);
#line 619 "/home/seb/gnome/gnome-latex/src/main_window.vala"
				tab = _tmp10_;
#line 620 "/home/seb/gnome/gnome-latex/src/main_window.vala"
				_tmp11_ = all_views;
#line 620 "/home/seb/gnome/gnome-latex/src/main_window.vala"
				_tmp12_ = tab;
#line 620 "/home/seb/gnome/gnome-latex/src/main_window.vala"
				_tmp13_ = document_tab_get_document_view (_tmp12_);
#line 620 "/home/seb/gnome/gnome-latex/src/main_window.vala"
				_tmp14_ = _tmp13_;
#line 620 "/home/seb/gnome/gnome-latex/src/main_window.vala"
				gee_collection_add ((GeeCollection*) _tmp11_, _tmp14_);
#line 617 "/home/seb/gnome/gnome-latex/src/main_window.vala"
				_g_object_unref0 (tab);
#line 2843 "main_window.c"
			}
		}
	}
#line 623 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	result = all_views;
#line 623 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	return result;
#line 2851 "main_window.c"
}


static Block23Data*
block23_data_ref (Block23Data* _data23_)
{
#line 636 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	g_atomic_int_inc (&_data23_->_ref_count_);
#line 636 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	return _data23_;
#line 2862 "main_window.c"
}


static void
block23_data_unref (void * _userdata_)
{
	Block23Data* _data23_;
	_data23_ = (Block23Data*) _userdata_;
#line 636 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	if (g_atomic_int_dec_and_test (&_data23_->_ref_count_)) {
#line 2873 "main_window.c"
		MainWindow* self;
#line 636 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		self = _data23_->self;
#line 636 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		_g_object_unref0 (_data23_->infobar);
#line 636 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		_g_object_unref0 (_data23_->tab);
#line 636 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		_g_object_unref0 (self);
#line 636 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		g_slice_free (Block23Data, _data23_);
#line 2885 "main_window.c"
	}
}


static void
______lambda41_ (Block23Data* _data23_,
                 gint response_id)
{
	MainWindow* self;
	GtkInfoBar* _tmp3_;
	DocumentTab* _tmp4_;
	TeplView* _tmp5_;
	TeplView* _tmp6_;
#line 665 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	self = _data23_->self;
#line 667 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	if (response_id == ((gint) GTK_RESPONSE_YES)) {
#line 2903 "main_window.c"
		DocumentTab* _tmp0_;
		Document* _tmp1_;
		Document* _tmp2_;
#line 668 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		_tmp0_ = _data23_->tab;
#line 668 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		_tmp1_ = document_tab_get_document (_tmp0_);
#line 668 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		_tmp2_ = _tmp1_;
#line 668 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		document_set_readonly (_tmp2_, FALSE);
#line 2915 "main_window.c"
	}
#line 669 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp3_ = _data23_->infobar;
#line 669 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	gtk_widget_destroy ((GtkWidget*) _tmp3_);
#line 670 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp4_ = _data23_->tab;
#line 670 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp5_ = tepl_tab_get_view ((TeplTab*) _tmp4_);
#line 670 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp6_ = _tmp5_;
#line 670 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	gtk_widget_grab_focus ((GtkWidget*) _tmp6_);
#line 2929 "main_window.c"
}


static void
_______lambda41__gtk_info_bar_response (GtkInfoBar* _sender,
                                        gint response_id,
                                        gpointer self)
{
#line 665 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	______lambda41_ (self, response_id);
#line 2940 "main_window.c"
}


DocumentTab*
main_window_open_document (MainWindow* self,
                           GFile* location,
                           gboolean jump_to)
{
	DocumentTab* result = NULL;
	GlatexApp* _tmp0_;
	GlatexApp* _tmp1_;
	GList* _tmp2_;
	GList* _tmp3_;
	DocumentTab* _tmp52_;
#line 626 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 626 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	g_return_val_if_fail (location != NULL, NULL);
#line 629 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp0_ = glatex_app_get_instance ();
#line 629 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp1_ = _tmp0_;
#line 629 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp2_ = gtk_application_get_windows ((GtkApplication*) _tmp1_);
#line 629 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp3_ = _tmp2_;
#line 629 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_g_object_unref0 (_tmp1_);
#line 2969 "main_window.c"
	{
		GList* window_collection = NULL;
		GList* window_it = NULL;
#line 629 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		window_collection = _tmp3_;
#line 629 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		for (window_it = window_collection; window_it != NULL; window_it = window_it->next) {
#line 2977 "main_window.c"
			GtkWindow* _tmp4_;
			GtkWindow* window = NULL;
#line 629 "/home/seb/gnome/gnome-latex/src/main_window.vala"
			_tmp4_ = _g_object_ref0 ((GtkWindow*) window_it->data);
#line 629 "/home/seb/gnome/gnome-latex/src/main_window.vala"
			window = _tmp4_;
#line 2984 "main_window.c"
			{
				GtkWindow* _tmp5_;
				MainWindow* w = NULL;
				GtkWindow* _tmp6_;
				MainWindow* _tmp7_;
#line 631 "/home/seb/gnome/gnome-latex/src/main_window.vala"
				_tmp5_ = window;
#line 631 "/home/seb/gnome/gnome-latex/src/main_window.vala"
				if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, TYPE_MAIN_WINDOW)) {
#line 632 "/home/seb/gnome/gnome-latex/src/main_window.vala"
					_g_object_unref0 (window);
#line 632 "/home/seb/gnome/gnome-latex/src/main_window.vala"
					continue;
#line 2998 "main_window.c"
				}
#line 634 "/home/seb/gnome/gnome-latex/src/main_window.vala"
				_tmp6_ = window;
#line 634 "/home/seb/gnome/gnome-latex/src/main_window.vala"
				_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, TYPE_MAIN_WINDOW) ? ((MainWindow*) _tmp6_) : NULL);
#line 634 "/home/seb/gnome/gnome-latex/src/main_window.vala"
				w = _tmp7_;
#line 3006 "main_window.c"
				{
					GeeList* _doc_list = NULL;
					MainWindow* _tmp8_;
					GeeList* _tmp9_;
					gint _doc_size = 0;
					GeeList* _tmp10_;
					gint _tmp11_;
					gint _tmp12_;
					gint _doc_index = 0;
#line 636 "/home/seb/gnome/gnome-latex/src/main_window.vala"
					_tmp8_ = w;
#line 636 "/home/seb/gnome/gnome-latex/src/main_window.vala"
					_tmp9_ = main_window_get_documents (_tmp8_);
#line 636 "/home/seb/gnome/gnome-latex/src/main_window.vala"
					_doc_list = _tmp9_;
#line 636 "/home/seb/gnome/gnome-latex/src/main_window.vala"
					_tmp10_ = _doc_list;
#line 636 "/home/seb/gnome/gnome-latex/src/main_window.vala"
					_tmp11_ = gee_collection_get_size ((GeeCollection*) _tmp10_);
#line 636 "/home/seb/gnome/gnome-latex/src/main_window.vala"
					_tmp12_ = _tmp11_;
#line 636 "/home/seb/gnome/gnome-latex/src/main_window.vala"
					_doc_size = _tmp12_;
#line 636 "/home/seb/gnome/gnome-latex/src/main_window.vala"
					_doc_index = -1;
#line 636 "/home/seb/gnome/gnome-latex/src/main_window.vala"
					while (TRUE) {
#line 3034 "main_window.c"
						Block23Data* _data23_;
						gint _tmp13_;
						gint _tmp14_;
						gint _tmp15_;
						Document* doc = NULL;
						GeeList* _tmp16_;
						gint _tmp17_;
						gpointer _tmp18_;
						gboolean _tmp19_ = FALSE;
						Document* _tmp20_;
						GFile* _tmp21_;
						GFile* _tmp22_;
						MainWindow* _tmp26_;
						DocumentTab* _tmp32_;
						DocumentTab* _tmp33_;
						Document* _tmp34_;
						Document* _tmp35_;
						gchar* primary_msg = NULL;
						gchar* _tmp36_;
						gchar* _tmp37_;
						gchar* _tmp38_;
						gchar* _tmp39_;
						gchar* secondary_msg = NULL;
						gchar* _tmp40_;
						const gchar* _tmp41_;
						const gchar* _tmp42_;
						TeplInfoBar* _tmp43_;
						GtkInfoBar* _tmp44_;
						GtkInfoBar* _tmp45_;
						DocumentTab* _tmp46_;
						GtkInfoBar* _tmp47_;
						GtkInfoBar* _tmp48_;
						GtkInfoBar* _tmp49_;
						DocumentTab* _tmp50_;
						DocumentTab* _tmp51_;
#line 636 "/home/seb/gnome/gnome-latex/src/main_window.vala"
						_data23_ = g_slice_new0 (Block23Data);
#line 636 "/home/seb/gnome/gnome-latex/src/main_window.vala"
						_data23_->_ref_count_ = 1;
#line 636 "/home/seb/gnome/gnome-latex/src/main_window.vala"
						_data23_->self = g_object_ref (self);
#line 636 "/home/seb/gnome/gnome-latex/src/main_window.vala"
						_tmp13_ = _doc_index;
#line 636 "/home/seb/gnome/gnome-latex/src/main_window.vala"
						_doc_index = _tmp13_ + 1;
#line 636 "/home/seb/gnome/gnome-latex/src/main_window.vala"
						_tmp14_ = _doc_index;
#line 636 "/home/seb/gnome/gnome-latex/src/main_window.vala"
						_tmp15_ = _doc_size;
#line 636 "/home/seb/gnome/gnome-latex/src/main_window.vala"
						if (!(_tmp14_ < _tmp15_)) {
#line 636 "/home/seb/gnome/gnome-latex/src/main_window.vala"
							block23_data_unref (_data23_);
#line 636 "/home/seb/gnome/gnome-latex/src/main_window.vala"
							_data23_ = NULL;
#line 636 "/home/seb/gnome/gnome-latex/src/main_window.vala"
							break;
#line 3092 "main_window.c"
						}
#line 636 "/home/seb/gnome/gnome-latex/src/main_window.vala"
						_tmp16_ = _doc_list;
#line 636 "/home/seb/gnome/gnome-latex/src/main_window.vala"
						_tmp17_ = _doc_index;
#line 636 "/home/seb/gnome/gnome-latex/src/main_window.vala"
						_tmp18_ = gee_list_get (_tmp16_, _tmp17_);
#line 636 "/home/seb/gnome/gnome-latex/src/main_window.vala"
						doc = (Document*) _tmp18_;
#line 638 "/home/seb/gnome/gnome-latex/src/main_window.vala"
						_tmp20_ = doc;
#line 638 "/home/seb/gnome/gnome-latex/src/main_window.vala"
						_tmp21_ = document_get_location (_tmp20_);
#line 638 "/home/seb/gnome/gnome-latex/src/main_window.vala"
						_tmp22_ = _tmp21_;
#line 638 "/home/seb/gnome/gnome-latex/src/main_window.vala"
						if (_tmp22_ == NULL) {
#line 638 "/home/seb/gnome/gnome-latex/src/main_window.vala"
							_tmp19_ = TRUE;
#line 3112 "main_window.c"
						} else {
							Document* _tmp23_;
							GFile* _tmp24_;
							GFile* _tmp25_;
#line 638 "/home/seb/gnome/gnome-latex/src/main_window.vala"
							_tmp23_ = doc;
#line 638 "/home/seb/gnome/gnome-latex/src/main_window.vala"
							_tmp24_ = document_get_location (_tmp23_);
#line 638 "/home/seb/gnome/gnome-latex/src/main_window.vala"
							_tmp25_ = _tmp24_;
#line 638 "/home/seb/gnome/gnome-latex/src/main_window.vala"
							_tmp19_ = !g_file_equal (location, _tmp25_);
#line 3125 "main_window.c"
						}
#line 638 "/home/seb/gnome/gnome-latex/src/main_window.vala"
						if (_tmp19_) {
#line 639 "/home/seb/gnome/gnome-latex/src/main_window.vala"
							_g_object_unref0 (doc);
#line 639 "/home/seb/gnome/gnome-latex/src/main_window.vala"
							block23_data_unref (_data23_);
#line 639 "/home/seb/gnome/gnome-latex/src/main_window.vala"
							_data23_ = NULL;
#line 639 "/home/seb/gnome/gnome-latex/src/main_window.vala"
							continue;
#line 3137 "main_window.c"
						}
#line 642 "/home/seb/gnome/gnome-latex/src/main_window.vala"
						_tmp26_ = w;
#line 642 "/home/seb/gnome/gnome-latex/src/main_window.vala"
						if (self == _tmp26_) {
#line 3143 "main_window.c"
							Document* _tmp29_;
							DocumentTab* _tmp30_;
							DocumentTab* _tmp31_;
#line 644 "/home/seb/gnome/gnome-latex/src/main_window.vala"
							if (jump_to) {
#line 3149 "main_window.c"
								Document* _tmp27_;
								DocumentTab* _tmp28_;
#line 645 "/home/seb/gnome/gnome-latex/src/main_window.vala"
								_tmp27_ = doc;
#line 645 "/home/seb/gnome/gnome-latex/src/main_window.vala"
								_tmp28_ = _tmp27_->tab;
#line 645 "/home/seb/gnome/gnome-latex/src/main_window.vala"
								main_window_set_active_tab (self, _tmp28_);
#line 3158 "main_window.c"
							}
#line 646 "/home/seb/gnome/gnome-latex/src/main_window.vala"
							_tmp29_ = doc;
#line 646 "/home/seb/gnome/gnome-latex/src/main_window.vala"
							_tmp30_ = _tmp29_->tab;
#line 646 "/home/seb/gnome/gnome-latex/src/main_window.vala"
							_tmp31_ = _g_object_ref0 (_tmp30_);
#line 646 "/home/seb/gnome/gnome-latex/src/main_window.vala"
							result = _tmp31_;
#line 646 "/home/seb/gnome/gnome-latex/src/main_window.vala"
							_g_object_unref0 (doc);
#line 646 "/home/seb/gnome/gnome-latex/src/main_window.vala"
							block23_data_unref (_data23_);
#line 646 "/home/seb/gnome/gnome-latex/src/main_window.vala"
							_data23_ = NULL;
#line 646 "/home/seb/gnome/gnome-latex/src/main_window.vala"
							_g_object_unref0 (_doc_list);
#line 646 "/home/seb/gnome/gnome-latex/src/main_window.vala"
							_g_object_unref0 (w);
#line 646 "/home/seb/gnome/gnome-latex/src/main_window.vala"
							_g_object_unref0 (window);
#line 646 "/home/seb/gnome/gnome-latex/src/main_window.vala"
							return result;
#line 3182 "main_window.c"
						}
#line 650 "/home/seb/gnome/gnome-latex/src/main_window.vala"
						_tmp32_ = main_window_create_tab_from_location (self, location, jump_to);
#line 650 "/home/seb/gnome/gnome-latex/src/main_window.vala"
						_data23_->tab = _tmp32_;
#line 651 "/home/seb/gnome/gnome-latex/src/main_window.vala"
						_tmp33_ = _data23_->tab;
#line 651 "/home/seb/gnome/gnome-latex/src/main_window.vala"
						_tmp34_ = document_tab_get_document (_tmp33_);
#line 651 "/home/seb/gnome/gnome-latex/src/main_window.vala"
						_tmp35_ = _tmp34_;
#line 651 "/home/seb/gnome/gnome-latex/src/main_window.vala"
						document_set_readonly (_tmp35_, TRUE);
#line 653 "/home/seb/gnome/gnome-latex/src/main_window.vala"
						_tmp36_ = g_file_get_parse_name (location);
#line 653 "/home/seb/gnome/gnome-latex/src/main_window.vala"
						_tmp37_ = _tmp36_;
#line 653 "/home/seb/gnome/gnome-latex/src/main_window.vala"
						_tmp38_ = g_strdup_printf (_ ("This file (%s) is already opened in another GNOME LaTeX window."), _tmp37_);
#line 653 "/home/seb/gnome/gnome-latex/src/main_window.vala"
						_tmp39_ = _tmp38_;
#line 653 "/home/seb/gnome/gnome-latex/src/main_window.vala"
						_g_free0 (_tmp37_);
#line 653 "/home/seb/gnome/gnome-latex/src/main_window.vala"
						primary_msg = _tmp39_;
#line 656 "/home/seb/gnome/gnome-latex/src/main_window.vala"
						_tmp40_ = g_strdup (_ ("GNOME LaTeX opened this instance of the file in a non-editable way. Do" \
" you want to edit it anyway?"));
#line 656 "/home/seb/gnome/gnome-latex/src/main_window.vala"
						secondary_msg = _tmp40_;
#line 658 "/home/seb/gnome/gnome-latex/src/main_window.vala"
						_tmp41_ = primary_msg;
#line 658 "/home/seb/gnome/gnome-latex/src/main_window.vala"
						_tmp42_ = secondary_msg;
#line 658 "/home/seb/gnome/gnome-latex/src/main_window.vala"
						_tmp43_ = tepl_info_bar_new_simple (GTK_MESSAGE_WARNING, _tmp41_, _tmp42_);
#line 658 "/home/seb/gnome/gnome-latex/src/main_window.vala"
						g_object_ref_sink (_tmp43_);
#line 658 "/home/seb/gnome/gnome-latex/src/main_window.vala"
						_data23_->infobar = (GtkInfoBar*) _tmp43_;
#line 660 "/home/seb/gnome/gnome-latex/src/main_window.vala"
						_tmp44_ = _data23_->infobar;
#line 660 "/home/seb/gnome/gnome-latex/src/main_window.vala"
						gtk_info_bar_add_button (_tmp44_, _ ("Edit Anyway"), (gint) GTK_RESPONSE_YES);
#line 661 "/home/seb/gnome/gnome-latex/src/main_window.vala"
						_tmp45_ = _data23_->infobar;
#line 661 "/home/seb/gnome/gnome-latex/src/main_window.vala"
						gtk_info_bar_add_button (_tmp45_, _ ("Don’t Edit"), (gint) GTK_RESPONSE_NO);
#line 662 "/home/seb/gnome/gnome-latex/src/main_window.vala"
						_tmp46_ = _data23_->tab;
#line 662 "/home/seb/gnome/gnome-latex/src/main_window.vala"
						_tmp47_ = _data23_->infobar;
#line 662 "/home/seb/gnome/gnome-latex/src/main_window.vala"
						tepl_tab_add_info_bar ((TeplTab*) _tmp46_, _tmp47_);
#line 663 "/home/seb/gnome/gnome-latex/src/main_window.vala"
						_tmp48_ = _data23_->infobar;
#line 663 "/home/seb/gnome/gnome-latex/src/main_window.vala"
						gtk_widget_show ((GtkWidget*) _tmp48_);
#line 665 "/home/seb/gnome/gnome-latex/src/main_window.vala"
						_tmp49_ = _data23_->infobar;
#line 665 "/home/seb/gnome/gnome-latex/src/main_window.vala"
						g_signal_connect_data (_tmp49_, "response", (GCallback) _______lambda41__gtk_info_bar_response, block23_data_ref (_data23_), (GClosureNotify) block23_data_unref, 0);
#line 673 "/home/seb/gnome/gnome-latex/src/main_window.vala"
						_tmp50_ = _data23_->tab;
#line 673 "/home/seb/gnome/gnome-latex/src/main_window.vala"
						_tmp51_ = _g_object_ref0 (_tmp50_);
#line 673 "/home/seb/gnome/gnome-latex/src/main_window.vala"
						result = _tmp51_;
#line 673 "/home/seb/gnome/gnome-latex/src/main_window.vala"
						_g_free0 (secondary_msg);
#line 673 "/home/seb/gnome/gnome-latex/src/main_window.vala"
						_g_free0 (primary_msg);
#line 673 "/home/seb/gnome/gnome-latex/src/main_window.vala"
						_g_object_unref0 (doc);
#line 673 "/home/seb/gnome/gnome-latex/src/main_window.vala"
						block23_data_unref (_data23_);
#line 673 "/home/seb/gnome/gnome-latex/src/main_window.vala"
						_data23_ = NULL;
#line 673 "/home/seb/gnome/gnome-latex/src/main_window.vala"
						_g_object_unref0 (_doc_list);
#line 673 "/home/seb/gnome/gnome-latex/src/main_window.vala"
						_g_object_unref0 (w);
#line 673 "/home/seb/gnome/gnome-latex/src/main_window.vala"
						_g_object_unref0 (window);
#line 673 "/home/seb/gnome/gnome-latex/src/main_window.vala"
						return result;
#line 3268 "main_window.c"
					}
#line 636 "/home/seb/gnome/gnome-latex/src/main_window.vala"
					_g_object_unref0 (_doc_list);
#line 3272 "main_window.c"
				}
#line 629 "/home/seb/gnome/gnome-latex/src/main_window.vala"
				_g_object_unref0 (w);
#line 629 "/home/seb/gnome/gnome-latex/src/main_window.vala"
				_g_object_unref0 (window);
#line 3278 "main_window.c"
			}
		}
	}
#line 677 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp52_ = main_window_create_tab_from_location (self, location, jump_to);
#line 677 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	result = _tmp52_;
#line 677 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	return result;
#line 3288 "main_window.c"
}


DocumentTab*
main_window_create_tab (MainWindow* self,
                        gboolean jump_to)
{
	DocumentTab* result = NULL;
	DocumentTab* tab = NULL;
	DocumentTab* _tmp0_;
	DocumentTab* _tmp1_;
#line 680 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 682 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp0_ = document_tab_new ();
#line 682 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	g_object_ref_sink (_tmp0_);
#line 682 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	tab = _tmp0_;
#line 683 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp1_ = main_window_process_create_tab (self, tab, jump_to);
#line 683 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	result = _tmp1_;
#line 683 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_g_object_unref0 (tab);
#line 683 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	return result;
#line 3316 "main_window.c"
}


static DocumentTab*
main_window_create_tab_from_location (MainWindow* self,
                                      GFile* location,
                                      gboolean jump_to)
{
	DocumentTab* result = NULL;
	DocumentTab* tab = NULL;
	DocumentTab* _tmp0_;
	DocumentTab* _tmp1_;
#line 686 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 686 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	g_return_val_if_fail (location != NULL, NULL);
#line 688 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp0_ = document_tab_new_from_location (location);
#line 688 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	g_object_ref_sink (_tmp0_);
#line 688 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	tab = _tmp0_;
#line 689 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp1_ = main_window_process_create_tab (self, tab, jump_to);
#line 689 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	result = _tmp1_;
#line 689 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_g_object_unref0 (tab);
#line 689 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	return result;
#line 3347 "main_window.c"
}


void
main_window_create_tab_with_view (MainWindow* self,
                                  DocumentView* view)
{
	DocumentTab* tab = NULL;
	DocumentTab* _tmp0_;
	DocumentTab* _tmp1_;
	DocumentTab* _tmp2_;
#line 692 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	g_return_if_fail (self != NULL);
#line 692 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	g_return_if_fail (view != NULL);
#line 694 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp0_ = document_tab_new_with_view (view);
#line 694 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	g_object_ref_sink (_tmp0_);
#line 694 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	tab = _tmp0_;
#line 695 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp1_ = main_window_process_create_tab (self, tab, TRUE);
#line 695 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp2_ = _tmp1_;
#line 695 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_g_object_unref0 (_tmp2_);
#line 692 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_g_object_unref0 (tab);
#line 3377 "main_window.c"
}


static Block24Data*
block24_data_ref (Block24Data* _data24_)
{
#line 698 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	g_atomic_int_inc (&_data24_->_ref_count_);
#line 698 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	return _data24_;
#line 3388 "main_window.c"
}


static void
block24_data_unref (void * _userdata_)
{
	Block24Data* _data24_;
	_data24_ = (Block24Data*) _userdata_;
#line 698 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	if (g_atomic_int_dec_and_test (&_data24_->_ref_count_)) {
#line 3399 "main_window.c"
		MainWindow* self;
#line 698 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		self = _data24_->self;
#line 698 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		_g_object_unref0 (_data24_->tab);
#line 698 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		_g_object_unref0 (self);
#line 698 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		g_slice_free (Block24Data, _data24_);
#line 3409 "main_window.c"
	}
}


static void
__lambda15_ (Block24Data* _data24_)
{
	MainWindow* self;
#line 703 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	self = _data24_->self;
#line 704 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	main_window_close_tab (self, _data24_->tab, FALSE);
#line 705 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	g_signal_stop_emission_by_name (_data24_->tab, "close-request");
#line 3424 "main_window.c"
}


static void
___lambda15__tepl_tab_close_request (TeplTab* _sender,
                                     gpointer self)
{
#line 703 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	__lambda15_ (self);
#line 3434 "main_window.c"
}


static void
__lambda18_ (Block24Data* _data24_)
{
	MainWindow* self;
	MainWindowBuildTools* _tmp0_;
#line 710 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	self = _data24_->self;
#line 712 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	main_window_sync_name (self, _data24_->tab);
#line 713 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp0_ = self->priv->_main_window_build_tools;
#line 713 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	main_window_build_tools_update_sensitivity (_tmp0_);
#line 3451 "main_window.c"
}


static void
___lambda18__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
#line 710 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	__lambda18_ (self);
#line 3462 "main_window.c"
}


static void
__lambda34_ (Block24Data* _data24_)
{
	MainWindow* self;
#line 716 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	self = _data24_->self;
#line 718 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	main_window_sync_name (self, _data24_->tab);
#line 3474 "main_window.c"
}


static void
___lambda34__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
#line 716 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	__lambda34_ (self);
#line 3485 "main_window.c"
}


static void
__lambda35_ (MainWindow* self)
{
	MainWindowBuildTools* _tmp0_;
#line 723 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp0_ = self->priv->_main_window_build_tools;
#line 723 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	main_window_build_tools_update_sensitivity (_tmp0_);
#line 3497 "main_window.c"
}


static void
___lambda35__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
#line 721 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	__lambda35_ ((MainWindow*) self);
#line 3508 "main_window.c"
}


static void
__lambda36_ (Block24Data* _data24_)
{
	MainWindow* self;
#line 726 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	self = _data24_->self;
#line 726 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	main_window_sync_name (self, _data24_->tab);
#line 3520 "main_window.c"
}


static void
___lambda36__gtk_text_buffer_modified_changed (GtkTextBuffer* _sender,
                                               gpointer self)
{
#line 726 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	__lambda36_ (self);
#line 3530 "main_window.c"
}


static void
__lambda37_ (Block24Data* _data24_)
{
	MainWindow* self;
#line 727 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	self = _data24_->self;
#line 727 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	main_window_sync_name (self, _data24_->tab);
#line 3542 "main_window.c"
}


static void
___lambda37__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
#line 727 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	__lambda37_ (self);
#line 3553 "main_window.c"
}


static void
_main_window_update_cursor_position_statusbar_tepl_buffer_tepl_cursor_moved (TeplBuffer* _sender,
                                                                             gpointer self)
{
#line 728 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	main_window_update_cursor_position_statusbar ((MainWindow*) self);
#line 3563 "main_window.c"
}


static DocumentTab*
main_window_process_create_tab (MainWindow* self,
                                DocumentTab* tab,
                                gboolean jump_to)
{
	DocumentTab* result = NULL;
	Block24Data* _data24_;
	DocumentTab* _tmp0_;
	Document* doc = NULL;
	Document* _tmp1_;
	Document* _tmp2_;
	Document* _tmp3_;
	Document* _tmp4_;
	Document* _tmp5_;
	Document* _tmp6_;
	Document* _tmp7_;
	Document* _tmp8_;
	Document* _tmp9_;
	DocumentsPanel* _tmp10_;
	MainWindowEdit* _tmp11_;
	MainWindowTools* _tmp12_;
	DocumentTab* _tmp13_;
#line 698 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 698 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_data24_ = g_slice_new0 (Block24Data);
#line 698 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_data24_->_ref_count_ = 1;
#line 698 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_data24_->self = g_object_ref (self);
#line 698 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp0_ = _g_object_ref0 (tab);
#line 698 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_g_object_unref0 (_data24_->tab);
#line 698 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_data24_->tab = _tmp0_;
#line 700 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	if (_data24_->tab == NULL) {
#line 701 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		result = NULL;
#line 701 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		block24_data_unref (_data24_);
#line 701 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		_data24_ = NULL;
#line 701 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		return result;
#line 3613 "main_window.c"
	}
#line 703 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	g_signal_connect_data ((TeplTab*) _data24_->tab, "close-request", (GCallback) ___lambda15__tepl_tab_close_request, block24_data_ref (_data24_), (GClosureNotify) block24_data_unref, 0);
#line 708 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp1_ = document_tab_get_document (_data24_->tab);
#line 708 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp2_ = _tmp1_;
#line 708 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 708 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	doc = _tmp3_;
#line 710 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp4_ = doc;
#line 710 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	g_signal_connect_data ((GObject*) _tmp4_, "notify::location", (GCallback) ___lambda18__g_object_notify, block24_data_ref (_data24_), (GClosureNotify) block24_data_unref, 0);
#line 716 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp5_ = doc;
#line 716 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	g_signal_connect_data ((GObject*) _tmp5_, "notify::tepl-short-title", (GCallback) ___lambda34__g_object_notify, block24_data_ref (_data24_), (GClosureNotify) block24_data_unref, 0);
#line 721 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp6_ = doc;
#line 721 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	g_signal_connect_object ((GObject*) _tmp6_, "notify::project-id", (GCallback) ___lambda35__g_object_notify, self, 0);
#line 726 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp7_ = doc;
#line 726 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	g_signal_connect_data ((GtkTextBuffer*) _tmp7_, "modified-changed", (GCallback) ___lambda36__gtk_text_buffer_modified_changed, block24_data_ref (_data24_), (GClosureNotify) block24_data_unref, 0);
#line 727 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp8_ = doc;
#line 727 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	g_signal_connect_data ((GObject*) _tmp8_, "notify::readonly", (GCallback) ___lambda37__g_object_notify, block24_data_ref (_data24_), (GClosureNotify) block24_data_unref, 0);
#line 728 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp9_ = doc;
#line 728 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	g_signal_connect_object ((TeplBuffer*) _tmp9_, "tepl-cursor-moved", (GCallback) _main_window_update_cursor_position_statusbar_tepl_buffer_tepl_cursor_moved, self, 0);
#line 730 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	gtk_widget_show ((GtkWidget*) _data24_->tab);
#line 733 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp10_ = self->priv->_documents_panel;
#line 733 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	documents_panel_add_tab (_tmp10_, _data24_->tab, -1, jump_to);
#line 735 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp11_ = self->priv->_main_window_edit;
#line 735 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	main_window_edit_update_sensitivity (_tmp11_);
#line 736 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp12_ = self->priv->_main_window_tools;
#line 736 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	main_window_tools_update_sensitivity (_tmp12_);
#line 738 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	if (!gtk_widget_get_visible ((GtkWidget*) self)) {
#line 739 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		gtk_window_present ((GtkWindow*) self);
#line 3667 "main_window.c"
	}
#line 741 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp13_ = _g_object_ref0 (_data24_->tab);
#line 741 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	result = _tmp13_;
#line 741 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_g_object_unref0 (doc);
#line 741 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	block24_data_unref (_data24_);
#line 741 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_data24_ = NULL;
#line 741 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	return result;
#line 3681 "main_window.c"
}


gboolean
main_window_close_tab (MainWindow* self,
                       DocumentTab* tab,
                       gboolean force_close)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	DocumentsPanel* _tmp20_;
#line 745 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 745 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	g_return_val_if_fail (tab != NULL, FALSE);
#line 750 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	if (!force_close) {
#line 3699 "main_window.c"
		TeplBuffer* _tmp1_;
#line 750 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		_tmp1_ = tepl_tab_get_buffer ((TeplTab*) tab);
#line 750 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		_tmp0_ = gtk_text_buffer_get_modified ((GtkTextBuffer*) _tmp1_);
#line 3705 "main_window.c"
	} else {
#line 750 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		_tmp0_ = FALSE;
#line 3709 "main_window.c"
	}
#line 750 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	if (_tmp0_) {
#line 3713 "main_window.c"
		GtkDialog* dialog = NULL;
		TeplBuffer* _tmp2_;
		TeplFile* _tmp3_;
		const gchar* _tmp4_;
		GtkMessageDialog* _tmp5_;
		GtkDialog* _tmp6_;
		Document* _tmp7_;
		Document* _tmp8_;
		GFile* _tmp9_;
		GFile* _tmp10_;
		GtkDialog* _tmp19_;
#line 752 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		_tmp2_ = tepl_tab_get_buffer ((TeplTab*) tab);
#line 752 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		_tmp3_ = tepl_buffer_get_file (_tmp2_);
#line 752 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		_tmp4_ = tepl_file_get_short_name (_tmp3_);
#line 752 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		_tmp5_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) self, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_QUESTION, GTK_BUTTONS_NONE, _ ("Save changes to document “%s” before closing?"), _tmp4_);
#line 752 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		g_object_ref_sink (_tmp5_);
#line 752 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		dialog = (GtkDialog*) _tmp5_;
#line 759 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		_tmp6_ = dialog;
#line 759 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		gtk_dialog_add_buttons (_tmp6_, _ ("Close _without Saving"), GTK_RESPONSE_CLOSE, _ ("_Cancel"), GTK_RESPONSE_CANCEL, NULL);
#line 762 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		_tmp7_ = document_tab_get_document (tab);
#line 762 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		_tmp8_ = _tmp7_;
#line 762 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		_tmp9_ = document_get_location (_tmp8_);
#line 762 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		_tmp10_ = _tmp9_;
#line 762 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		if (_tmp10_ == NULL) {
#line 3751 "main_window.c"
			GtkDialog* _tmp11_;
#line 763 "/home/seb/gnome/gnome-latex/src/main_window.vala"
			_tmp11_ = dialog;
#line 763 "/home/seb/gnome/gnome-latex/src/main_window.vala"
			gtk_dialog_add_button (_tmp11_, _ ("Save _As"), (gint) GTK_RESPONSE_ACCEPT);
#line 3757 "main_window.c"
		} else {
			GtkDialog* _tmp12_;
#line 765 "/home/seb/gnome/gnome-latex/src/main_window.vala"
			_tmp12_ = dialog;
#line 765 "/home/seb/gnome/gnome-latex/src/main_window.vala"
			gtk_dialog_add_button (_tmp12_, _ ("_Save"), (gint) GTK_RESPONSE_ACCEPT);
#line 3764 "main_window.c"
		}
#line 767 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		while (TRUE) {
#line 3768 "main_window.c"
			gint res = 0;
			GtkDialog* _tmp13_;
			gint _tmp14_;
#line 769 "/home/seb/gnome/gnome-latex/src/main_window.vala"
			_tmp13_ = dialog;
#line 769 "/home/seb/gnome/gnome-latex/src/main_window.vala"
			res = gtk_dialog_run (_tmp13_);
#line 771 "/home/seb/gnome/gnome-latex/src/main_window.vala"
			_tmp14_ = res;
#line 771 "/home/seb/gnome/gnome-latex/src/main_window.vala"
			if (_tmp14_ == ((gint) GTK_RESPONSE_CLOSE)) {
#line 772 "/home/seb/gnome/gnome-latex/src/main_window.vala"
				break;
#line 3782 "main_window.c"
			} else {
				gint _tmp15_;
#line 775 "/home/seb/gnome/gnome-latex/src/main_window.vala"
				_tmp15_ = res;
#line 775 "/home/seb/gnome/gnome-latex/src/main_window.vala"
				if (_tmp15_ == ((gint) GTK_RESPONSE_ACCEPT)) {
#line 3789 "main_window.c"
					Document* _tmp16_;
					Document* _tmp17_;
#line 777 "/home/seb/gnome/gnome-latex/src/main_window.vala"
					_tmp16_ = document_tab_get_document (tab);
#line 777 "/home/seb/gnome/gnome-latex/src/main_window.vala"
					_tmp17_ = _tmp16_;
#line 777 "/home/seb/gnome/gnome-latex/src/main_window.vala"
					if (main_window_save_document (self, _tmp17_, FALSE)) {
#line 778 "/home/seb/gnome/gnome-latex/src/main_window.vala"
						break;
#line 3800 "main_window.c"
					}
#line 779 "/home/seb/gnome/gnome-latex/src/main_window.vala"
					continue;
#line 3804 "main_window.c"
				} else {
					GtkDialog* _tmp18_;
#line 785 "/home/seb/gnome/gnome-latex/src/main_window.vala"
					_tmp18_ = dialog;
#line 785 "/home/seb/gnome/gnome-latex/src/main_window.vala"
					gtk_widget_destroy ((GtkWidget*) _tmp18_);
#line 786 "/home/seb/gnome/gnome-latex/src/main_window.vala"
					result = FALSE;
#line 786 "/home/seb/gnome/gnome-latex/src/main_window.vala"
					_g_object_unref0 (dialog);
#line 786 "/home/seb/gnome/gnome-latex/src/main_window.vala"
					return result;
#line 3817 "main_window.c"
				}
			}
		}
#line 790 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		_tmp19_ = dialog;
#line 790 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		gtk_widget_destroy ((GtkWidget*) _tmp19_);
#line 750 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		_g_object_unref0 (dialog);
#line 3827 "main_window.c"
	}
#line 793 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp20_ = self->priv->_documents_panel;
#line 793 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	documents_panel_remove_tab (_tmp20_, tab);
#line 794 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	result = TRUE;
#line 794 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	return result;
#line 3837 "main_window.c"
}


static void
main_window_sync_name (MainWindow* self,
                       DocumentTab* tab)
{
	MainWindowDocuments* _tmp0_;
#line 797 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	g_return_if_fail (self != NULL);
#line 797 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	g_return_if_fail (tab != NULL);
#line 799 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp0_ = self->priv->_main_window_documents;
#line 799 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	main_window_documents_update_document_name (_tmp0_, tab);
#line 3854 "main_window.c"
}


gboolean
main_window_save_document (MainWindow* self,
                           Document* doc,
                           gboolean force_save_as)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	GtkFileChooserDialog* file_chooser = NULL;
	GtkFileChooserDialog* _tmp6_;
	GtkFileChooserDialog* _tmp7_;
	GtkFileChooserDialog* _tmp8_;
	gchar* short_name = NULL;
	TeplFile* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	GFile* _tmp12_;
	GFile* _tmp13_;
	const gchar* _tmp20_;
	GFile* _tmp23_;
	GFile* _tmp24_;
	gint response = 0;
	GtkFileChooserDialog* _tmp29_;
	gint _tmp30_;
	GtkFileChooserDialog* _tmp34_;
	gchar* _tmp35_;
	GtkFileChooserDialog* _tmp36_;
	GFile* _tmp37_;
	GFile* _tmp38_;
	GError * _inner_error_ = NULL;
#line 803 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 803 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	g_return_val_if_fail (doc != NULL, FALSE);
#line 805 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	if (!force_save_as) {
#line 3893 "main_window.c"
		GFile* _tmp1_;
		GFile* _tmp2_;
#line 805 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		_tmp1_ = document_get_location (doc);
#line 805 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		_tmp2_ = _tmp1_;
#line 805 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		_tmp0_ = _tmp2_ != NULL;
#line 3902 "main_window.c"
	} else {
#line 805 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		_tmp0_ = FALSE;
#line 3906 "main_window.c"
	}
#line 805 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	if (_tmp0_) {
#line 3910 "main_window.c"
		Document* _tmp3_;
		Document* _tmp4_;
#line 807 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		document_save (doc, TRUE, FALSE);
#line 809 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		_tmp3_ = main_window_get_active_document (self);
#line 809 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		_tmp4_ = _tmp3_;
#line 809 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		if (doc == _tmp4_) {
#line 3921 "main_window.c"
			MainWindowStructure* _tmp5_;
#line 810 "/home/seb/gnome/gnome-latex/src/main_window.vala"
			_tmp5_ = self->priv->_main_window_structure;
#line 810 "/home/seb/gnome/gnome-latex/src/main_window.vala"
			main_window_structure_refresh (_tmp5_);
#line 3927 "main_window.c"
		}
#line 812 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		result = TRUE;
#line 812 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		return result;
#line 3933 "main_window.c"
	}
#line 815 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp6_ = (GtkFileChooserDialog*) gtk_file_chooser_dialog_new (_ ("Save File"), (GtkWindow*) self, GTK_FILE_CHOOSER_ACTION_SAVE, _ ("_Cancel"), GTK_RESPONSE_CANCEL, _ ("_Save"), GTK_RESPONSE_ACCEPT, NULL);
#line 815 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	g_object_ref_sink (_tmp6_);
#line 815 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	file_chooser = _tmp6_;
#line 821 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp7_ = file_chooser;
#line 821 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	gtk_file_chooser_set_do_overwrite_confirmation ((GtkFileChooser*) _tmp7_, TRUE);
#line 822 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp8_ = file_chooser;
#line 822 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	gtk_file_chooser_set_local_only ((GtkFileChooser*) _tmp8_, FALSE);
#line 824 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp9_ = tepl_buffer_get_file ((TeplBuffer*) doc);
#line 824 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp10_ = tepl_file_get_short_name (_tmp9_);
#line 824 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp11_ = g_strdup (_tmp10_);
#line 824 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	short_name = _tmp11_;
#line 825 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp12_ = document_get_location (doc);
#line 825 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp13_ = _tmp12_;
#line 825 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	if (_tmp13_ == NULL) {
#line 3963 "main_window.c"
		GtkFileChooserDialog* _tmp14_;
		const gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
#line 826 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		_tmp14_ = file_chooser;
#line 826 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		_tmp15_ = short_name;
#line 826 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		_tmp16_ = g_strconcat (_tmp15_, ".tex", NULL);
#line 826 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		_tmp17_ = _tmp16_;
#line 826 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		gtk_file_chooser_set_current_name ((GtkFileChooser*) _tmp14_, _tmp17_);
#line 826 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		_g_free0 (_tmp17_);
#line 3980 "main_window.c"
	} else {
		GtkFileChooserDialog* _tmp18_;
		const gchar* _tmp19_;
#line 828 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		_tmp18_ = file_chooser;
#line 828 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		_tmp19_ = short_name;
#line 828 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		gtk_file_chooser_set_current_name ((GtkFileChooser*) _tmp18_, _tmp19_);
#line 3990 "main_window.c"
	}
#line 830 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp20_ = self->default_location;
#line 830 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	if (_tmp20_ != NULL) {
#line 3996 "main_window.c"
		GtkFileChooserDialog* _tmp21_;
		const gchar* _tmp22_;
#line 831 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		_tmp21_ = file_chooser;
#line 831 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		_tmp22_ = self->default_location;
#line 831 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		gtk_file_chooser_set_current_folder ((GtkFileChooser*) _tmp21_, _tmp22_);
#line 4005 "main_window.c"
	}
#line 833 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp23_ = document_get_location (doc);
#line 833 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp24_ = _tmp23_;
#line 833 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	if (_tmp24_ != NULL) {
#line 4013 "main_window.c"
		{
			GtkFileChooserDialog* _tmp25_;
			GFile* _tmp26_;
			GFile* _tmp27_;
#line 838 "/home/seb/gnome/gnome-latex/src/main_window.vala"
			_tmp25_ = file_chooser;
#line 838 "/home/seb/gnome/gnome-latex/src/main_window.vala"
			_tmp26_ = document_get_location (doc);
#line 838 "/home/seb/gnome/gnome-latex/src/main_window.vala"
			_tmp27_ = _tmp26_;
#line 838 "/home/seb/gnome/gnome-latex/src/main_window.vala"
			gtk_file_chooser_set_file ((GtkFileChooser*) _tmp25_, _tmp27_, &_inner_error_);
#line 838 "/home/seb/gnome/gnome-latex/src/main_window.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 4028 "main_window.c"
				goto __catch32_g_error;
			}
		}
		goto __finally32;
		__catch32_g_error:
		{
			GError* e = NULL;
#line 835 "/home/seb/gnome/gnome-latex/src/main_window.vala"
			e = _inner_error_;
#line 835 "/home/seb/gnome/gnome-latex/src/main_window.vala"
			_inner_error_ = NULL;
#line 835 "/home/seb/gnome/gnome-latex/src/main_window.vala"
			_g_error_free0 (e);
#line 4042 "main_window.c"
		}
		__finally32:
#line 835 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 4047 "main_window.c"
			gboolean _tmp28_ = FALSE;
#line 835 "/home/seb/gnome/gnome-latex/src/main_window.vala"
			_g_free0 (short_name);
#line 835 "/home/seb/gnome/gnome-latex/src/main_window.vala"
			_g_object_unref0 (file_chooser);
#line 835 "/home/seb/gnome/gnome-latex/src/main_window.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 835 "/home/seb/gnome/gnome-latex/src/main_window.vala"
			g_clear_error (&_inner_error_);
#line 835 "/home/seb/gnome/gnome-latex/src/main_window.vala"
			return _tmp28_;
#line 4059 "main_window.c"
		}
	}
#line 843 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp29_ = file_chooser;
#line 843 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	response = gtk_dialog_run ((GtkDialog*) _tmp29_);
#line 844 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp30_ = response;
#line 844 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	if (_tmp30_ == ((gint) GTK_RESPONSE_ACCEPT)) {
#line 4070 "main_window.c"
		GtkFileChooserDialog* _tmp31_;
		GFile* _tmp32_;
		GFile* _tmp33_;
#line 845 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		_tmp31_ = file_chooser;
#line 845 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		_tmp32_ = gtk_file_chooser_get_file ((GtkFileChooser*) _tmp31_);
#line 845 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		_tmp33_ = _tmp32_;
#line 845 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		document_set_location (doc, _tmp33_);
#line 845 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		_g_object_unref0 (_tmp33_);
#line 4084 "main_window.c"
	}
#line 847 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp34_ = file_chooser;
#line 847 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp35_ = gtk_file_chooser_get_current_folder ((GtkFileChooser*) _tmp34_);
#line 847 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_g_free0 (self->default_location);
#line 847 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	self->default_location = _tmp35_;
#line 848 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp36_ = file_chooser;
#line 848 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	gtk_widget_destroy ((GtkWidget*) _tmp36_);
#line 850 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp37_ = document_get_location (doc);
#line 850 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp38_ = _tmp37_;
#line 850 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	if (_tmp38_ != NULL) {
#line 4104 "main_window.c"
		Document* _tmp39_;
		Document* _tmp40_;
#line 853 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		document_save (doc, FALSE, TRUE);
#line 855 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		_tmp39_ = main_window_get_active_document (self);
#line 855 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		_tmp40_ = _tmp39_;
#line 855 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		if (doc == _tmp40_) {
#line 4115 "main_window.c"
			MainWindowStructure* _tmp41_;
#line 856 "/home/seb/gnome/gnome-latex/src/main_window.vala"
			_tmp41_ = self->priv->_main_window_structure;
#line 856 "/home/seb/gnome/gnome-latex/src/main_window.vala"
			main_window_structure_refresh (_tmp41_);
#line 4121 "main_window.c"
		}
#line 858 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		result = TRUE;
#line 858 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		_g_free0 (short_name);
#line 858 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		_g_object_unref0 (file_chooser);
#line 858 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		return result;
#line 4131 "main_window.c"
	}
#line 860 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	result = FALSE;
#line 860 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_g_free0 (short_name);
#line 860 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_g_object_unref0 (file_chooser);
#line 860 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	return result;
#line 4141 "main_window.c"
}


gboolean
main_window_close_all_documents (MainWindow* self)
{
	gboolean result = FALSE;
	GeeList* unsaved_documents = NULL;
	GeeList* _tmp0_;
	GeeList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
#line 864 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 866 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp0_ = main_window_get_unsaved_documents (self);
#line 866 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	unsaved_documents = _tmp0_;
#line 869 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp1_ = unsaved_documents;
#line 869 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp2_ = gee_collection_get_size ((GeeCollection*) _tmp1_);
#line 869 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp3_ = _tmp2_;
#line 869 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	if (_tmp3_ == 0) {
#line 4168 "main_window.c"
		DocumentsPanel* _tmp4_;
#line 871 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		_tmp4_ = self->priv->_documents_panel;
#line 871 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		documents_panel_remove_all_tabs (_tmp4_);
#line 872 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		result = TRUE;
#line 872 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		_g_object_unref0 (unsaved_documents);
#line 872 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		return result;
#line 4180 "main_window.c"
	} else {
		GeeList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
#line 876 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		_tmp5_ = unsaved_documents;
#line 876 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		_tmp6_ = gee_collection_get_size ((GeeCollection*) _tmp5_);
#line 876 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		_tmp7_ = _tmp6_;
#line 876 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		if (_tmp7_ == 1) {
#line 4193 "main_window.c"
			Document* doc = NULL;
			GeeList* _tmp8_;
			gpointer _tmp9_;
			Document* _tmp10_;
			DocumentTab* _tmp11_;
			Document* _tmp12_;
			DocumentTab* _tmp13_;
#line 878 "/home/seb/gnome/gnome-latex/src/main_window.vala"
			_tmp8_ = unsaved_documents;
#line 878 "/home/seb/gnome/gnome-latex/src/main_window.vala"
			_tmp9_ = gee_list_first (_tmp8_);
#line 878 "/home/seb/gnome/gnome-latex/src/main_window.vala"
			doc = (Document*) _tmp9_;
#line 879 "/home/seb/gnome/gnome-latex/src/main_window.vala"
			_tmp10_ = doc;
#line 879 "/home/seb/gnome/gnome-latex/src/main_window.vala"
			_tmp11_ = _tmp10_->tab;
#line 879 "/home/seb/gnome/gnome-latex/src/main_window.vala"
			main_window_set_active_tab (self, _tmp11_);
#line 880 "/home/seb/gnome/gnome-latex/src/main_window.vala"
			_tmp12_ = doc;
#line 880 "/home/seb/gnome/gnome-latex/src/main_window.vala"
			_tmp13_ = _tmp12_->tab;
#line 880 "/home/seb/gnome/gnome-latex/src/main_window.vala"
			if (main_window_close_tab (self, _tmp13_, FALSE)) {
#line 4219 "main_window.c"
				DocumentsPanel* _tmp14_;
#line 882 "/home/seb/gnome/gnome-latex/src/main_window.vala"
				_tmp14_ = self->priv->_documents_panel;
#line 882 "/home/seb/gnome/gnome-latex/src/main_window.vala"
				documents_panel_remove_all_tabs (_tmp14_);
#line 883 "/home/seb/gnome/gnome-latex/src/main_window.vala"
				result = TRUE;
#line 883 "/home/seb/gnome/gnome-latex/src/main_window.vala"
				_g_object_unref0 (doc);
#line 883 "/home/seb/gnome/gnome-latex/src/main_window.vala"
				_g_object_unref0 (unsaved_documents);
#line 883 "/home/seb/gnome/gnome-latex/src/main_window.vala"
				return result;
#line 4233 "main_window.c"
			}
#line 876 "/home/seb/gnome/gnome-latex/src/main_window.vala"
			_g_object_unref0 (doc);
#line 4237 "main_window.c"
		} else {
			GeeList* _tmp15_;
			DocumentsPanel* _tmp16_;
#line 890 "/home/seb/gnome/gnome-latex/src/main_window.vala"
			_tmp15_ = unsaved_documents;
#line 890 "/home/seb/gnome/gnome-latex/src/main_window.vala"
			dialogs_close_several_unsaved_documents (self, _tmp15_);
#line 891 "/home/seb/gnome/gnome-latex/src/main_window.vala"
			_tmp16_ = self->priv->_documents_panel;
#line 891 "/home/seb/gnome/gnome-latex/src/main_window.vala"
			if (gtk_notebook_get_n_pages ((GtkNotebook*) _tmp16_) == 0) {
#line 892 "/home/seb/gnome/gnome-latex/src/main_window.vala"
				result = TRUE;
#line 892 "/home/seb/gnome/gnome-latex/src/main_window.vala"
				_g_object_unref0 (unsaved_documents);
#line 892 "/home/seb/gnome/gnome-latex/src/main_window.vala"
				return result;
#line 4255 "main_window.c"
			}
		}
	}
#line 895 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	result = FALSE;
#line 895 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_g_object_unref0 (unsaved_documents);
#line 895 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	return result;
#line 4265 "main_window.c"
}


void
main_window_remove_all_tabs (MainWindow* self)
{
	DocumentsPanel* _tmp0_;
#line 898 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	g_return_if_fail (self != NULL);
#line 900 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp0_ = self->priv->_documents_panel;
#line 900 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	documents_panel_remove_all_tabs (_tmp0_);
#line 4279 "main_window.c"
}


static void
main_window_update_cursor_position_statusbar (MainWindow* self)
{
	DocumentView* _tmp0_;
	DocumentView* _tmp1_;
	GtkTextIter iter = {0};
	Document* _tmp3_;
	Document* _tmp4_;
	Document* _tmp5_;
	Document* _tmp6_;
	GtkTextMark* _tmp7_;
	GtkTextIter _tmp8_ = {0};
	gint row = 0;
	gint col = 0;
	DocumentView* _tmp9_;
	DocumentView* _tmp10_;
	GtkTextIter _tmp11_;
	CustomStatusbar* _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
#line 903 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	g_return_if_fail (self != NULL);
#line 905 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp0_ = main_window_get_active_view (self);
#line 905 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp1_ = _tmp0_;
#line 905 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	if (_tmp1_ == NULL) {
#line 4311 "main_window.c"
		CustomStatusbar* _tmp2_;
#line 907 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		_tmp2_ = self->priv->_statusbar;
#line 907 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		custom_statusbar_set_cursor_position (_tmp2_, -1, -1);
#line 908 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		return;
#line 4319 "main_window.c"
	}
#line 912 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp3_ = main_window_get_active_document (self);
#line 912 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp4_ = _tmp3_;
#line 912 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp5_ = main_window_get_active_document (self);
#line 912 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp6_ = _tmp5_;
#line 912 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp7_ = gtk_text_buffer_get_insert ((GtkTextBuffer*) _tmp6_);
#line 912 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) _tmp4_, &_tmp8_, _tmp7_);
#line 912 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	iter = _tmp8_;
#line 913 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	row = (gint) gtk_text_iter_get_line (&iter);
#line 914 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp9_ = main_window_get_active_view (self);
#line 914 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp10_ = _tmp9_;
#line 914 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp11_ = iter;
#line 914 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	col = (gint) gtk_source_view_get_visual_column ((GtkSourceView*) _tmp10_, &_tmp11_);
#line 915 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp12_ = self->priv->_statusbar;
#line 915 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp13_ = row;
#line 915 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp14_ = col;
#line 915 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	custom_statusbar_set_cursor_position (_tmp12_, _tmp13_ + 1, _tmp14_ + 1);
#line 4353 "main_window.c"
}


void
main_window_save_state (MainWindow* self)
{
	GSettings* settings_window = NULL;
	GSettings* _tmp0_;
	GdkWindowState state = 0;
	GdkWindow* _tmp1_;
	gint width = 0;
	gint height = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	GtkPaned* _tmp4_;
	GtkPaned* _tmp5_;
	MainWindowStructure* _tmp6_;
	GSettings* settings_ui = NULL;
	GSettings* _tmp7_;
	GtkToggleAction* action = NULL;
	GtkActionGroup* _tmp8_;
	GtkAction* _tmp9_;
	GtkToggleAction* _tmp10_;
	GtkToggleAction* _tmp11_;
	gboolean _tmp12_;
	gboolean _tmp13_;
	GtkActionGroup* _tmp14_;
	GtkAction* _tmp15_;
	GtkToggleAction* _tmp16_;
	GtkToggleAction* _tmp17_;
	gboolean _tmp18_;
	gboolean _tmp19_;
	GtkActionGroup* _tmp20_;
	GtkAction* _tmp21_;
	GtkToggleAction* _tmp22_;
	GtkToggleAction* _tmp23_;
	gboolean _tmp24_;
	gboolean _tmp25_;
	GtkActionGroup* _tmp26_;
	GtkAction* _tmp27_;
	GtkToggleAction* _tmp28_;
	GtkToggleAction* _tmp29_;
	gboolean _tmp30_;
	gboolean _tmp31_;
	MainWindowBuildTools* _tmp32_;
#line 918 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	g_return_if_fail (self != NULL);
#line 921 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp0_ = g_settings_new ("org.gnome.gnome-latex.state.window");
#line 921 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	settings_window = _tmp0_;
#line 923 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp1_ = gtk_widget_get_window ((GtkWidget*) self);
#line 923 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	state = gdk_window_get_state (_tmp1_);
#line 924 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	g_settings_set_int (settings_window, "state", (gint) state);
#line 929 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	gtk_window_get_size ((GtkWindow*) self, &_tmp2_, &_tmp3_);
#line 929 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	width = _tmp2_;
#line 929 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	height = _tmp3_;
#line 930 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	g_settings_set (settings_window, "size", "(ii)", width, height);
#line 932 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp4_ = self->priv->_main_hpaned;
#line 932 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	g_settings_set_int (settings_window, "side-panel-size", gtk_paned_get_position (_tmp4_));
#line 933 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp5_ = self->priv->_vpaned;
#line 933 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	g_settings_set_int (settings_window, "vertical-paned-position", gtk_paned_get_position (_tmp5_));
#line 935 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp6_ = self->priv->_main_window_structure;
#line 935 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	main_window_structure_save_state (_tmp6_);
#line 938 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp7_ = g_settings_new ("org.gnome.gnome-latex.preferences.ui");
#line 938 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	settings_ui = _tmp7_;
#line 944 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp8_ = self->priv->_action_group;
#line 944 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp9_ = gtk_action_group_get_action (_tmp8_, "ViewMainToolbar");
#line 944 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp10_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_toggle_action_get_type (), GtkToggleAction));
#line 944 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	action = _tmp10_;
#line 945 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp11_ = action;
#line 945 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp12_ = gtk_toggle_action_get_active (_tmp11_);
#line 945 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp13_ = _tmp12_;
#line 945 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	g_settings_set_boolean (settings_ui, "main-toolbar-visible", _tmp13_);
#line 947 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp14_ = self->priv->_action_group;
#line 947 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp15_ = gtk_action_group_get_action (_tmp14_, "ViewEditToolbar");
#line 947 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp16_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, gtk_toggle_action_get_type (), GtkToggleAction));
#line 947 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_g_object_unref0 (action);
#line 947 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	action = _tmp16_;
#line 948 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp17_ = action;
#line 948 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp18_ = gtk_toggle_action_get_active (_tmp17_);
#line 948 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp19_ = _tmp18_;
#line 948 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	g_settings_set_boolean (settings_ui, "edit-toolbar-visible", _tmp19_);
#line 950 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp20_ = self->priv->_action_group;
#line 950 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp21_ = gtk_action_group_get_action (_tmp20_, "ViewSidePanel");
#line 950 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp22_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, gtk_toggle_action_get_type (), GtkToggleAction));
#line 950 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_g_object_unref0 (action);
#line 950 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	action = _tmp22_;
#line 951 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp23_ = action;
#line 951 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp24_ = gtk_toggle_action_get_active (_tmp23_);
#line 951 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp25_ = _tmp24_;
#line 951 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	g_settings_set_boolean (settings_ui, "side-panel-visible", _tmp25_);
#line 953 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp26_ = self->priv->_action_group;
#line 953 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp27_ = gtk_action_group_get_action (_tmp26_, "ViewBottomPanel");
#line 953 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp28_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, gtk_toggle_action_get_type (), GtkToggleAction));
#line 953 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_g_object_unref0 (action);
#line 953 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	action = _tmp28_;
#line 954 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp29_ = action;
#line 954 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp30_ = gtk_toggle_action_get_active (_tmp29_);
#line 954 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp31_ = _tmp30_;
#line 954 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	g_settings_set_boolean (settings_ui, "bottom-panel-visible", _tmp31_);
#line 956 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp32_ = self->priv->_main_window_build_tools;
#line 956 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	main_window_build_tools_save_state (_tmp32_);
#line 918 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_g_object_unref0 (action);
#line 918 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_g_object_unref0 (settings_ui);
#line 918 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_g_object_unref0 (settings_window);
#line 4515 "main_window.c"
}


void
main_window_jump_to_file_position (MainWindow* self,
                                   GFile* file,
                                   gint start_line,
                                   gint end_line)
{
	gboolean _tmp0_ = FALSE;
	DocumentTab* tab = NULL;
	DocumentTab* _tmp1_;
	TeplView* _tmp2_;
	TeplView* _tmp3_;
#line 961 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	g_return_if_fail (self != NULL);
#line 961 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	g_return_if_fail (file != NULL);
#line 963 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	if (start_line >= 0) {
#line 963 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		_tmp0_ = end_line >= 0;
#line 4538 "main_window.c"
	} else {
#line 963 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		_tmp0_ = FALSE;
#line 4542 "main_window.c"
	}
#line 963 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	g_return_if_fail (_tmp0_);
#line 965 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp1_ = main_window_open_document (self, file, TRUE);
#line 965 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	tab = _tmp1_;
#line 968 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	utils_flush_queue ();
#line 970 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp2_ = tepl_tab_get_view ((TeplTab*) tab);
#line 970 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp3_ = _tmp2_;
#line 970 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	tepl_view_select_lines (_tmp3_, start_line, end_line);
#line 961 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_g_object_unref0 (tab);
#line 4560 "main_window.c"
}


/*************************************************************************/
static void
main_window_update_file_actions_sensitivity (MainWindow* self)
{
	TeplApplicationWindow* tepl_window = NULL;
	TeplApplicationWindow* _tmp0_;
	TeplApplicationWindow* _tmp1_;
	gboolean sensitive = FALSE;
	TeplApplicationWindow* _tmp2_;
	TeplTab* _tmp3_;
	TeplTab* _tmp4_;
	gchar** file_actions = NULL;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar** _tmp13_;
	gint file_actions_length1;
	gint _file_actions_size_;
	gchar** _tmp14_;
	gint _tmp14__length1;
	GtkActionGroup* _tmp22_;
	gboolean _tmp23_;
	MainWindowFile* _tmp24_;
	MainWindowEdit* _tmp25_;
	MainWindowBuildTools* _tmp26_;
	MainWindowTools* _tmp27_;
#line 976 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	g_return_if_fail (self != NULL);
#line 978 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp0_ = tepl_application_window_get_from_gtk_application_window ((GtkApplicationWindow*) self);
#line 978 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 978 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	tepl_window = _tmp1_;
#line 980 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp2_ = tepl_window;
#line 980 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp3_ = tepl_tab_group_get_active_tab ((TeplTabGroup*) _tmp2_);
#line 980 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp4_ = _tmp3_;
#line 980 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	sensitive = _tmp4_ != NULL;
#line 983 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp5_ = g_strdup ("ViewZoomIn");
#line 983 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp6_ = g_strdup ("ViewZoomOut");
#line 983 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp7_ = g_strdup ("ViewZoomReset");
#line 983 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp8_ = g_strdup ("SearchFind");
#line 983 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp9_ = g_strdup ("SearchReplace");
#line 983 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp10_ = g_strdup ("SearchGoToLine");
#line 983 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp11_ = g_strdup ("SearchForward");
#line 983 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp12_ = g_strdup ("ProjectsConfigCurrent");
#line 983 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp13_ = g_new0 (gchar*, 8 + 1);
#line 983 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp13_[0] = _tmp5_;
#line 983 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp13_[1] = _tmp6_;
#line 983 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp13_[2] = _tmp7_;
#line 983 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp13_[3] = _tmp8_;
#line 983 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp13_[4] = _tmp9_;
#line 983 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp13_[5] = _tmp10_;
#line 983 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp13_[6] = _tmp11_;
#line 983 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp13_[7] = _tmp12_;
#line 983 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	file_actions = _tmp13_;
#line 983 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	file_actions_length1 = 8;
#line 983 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_file_actions_size_ = file_actions_length1;
#line 995 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp14_ = file_actions;
#line 995 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp14__length1 = file_actions_length1;
#line 4655 "main_window.c"
	{
		gchar** file_action_collection = NULL;
		gint file_action_collection_length1 = 0;
		gint _file_action_collection_size_ = 0;
		gint file_action_it = 0;
#line 995 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		file_action_collection = _tmp14_;
#line 995 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		file_action_collection_length1 = _tmp14__length1;
#line 995 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		for (file_action_it = 0; file_action_it < _tmp14__length1; file_action_it = file_action_it + 1) {
#line 4667 "main_window.c"
			gchar* _tmp15_;
			gchar* file_action = NULL;
#line 995 "/home/seb/gnome/gnome-latex/src/main_window.vala"
			_tmp15_ = g_strdup (file_action_collection[file_action_it]);
#line 995 "/home/seb/gnome/gnome-latex/src/main_window.vala"
			file_action = _tmp15_;
#line 4674 "main_window.c"
			{
				GtkAction* action = NULL;
				GtkActionGroup* _tmp16_;
				const gchar* _tmp17_;
				GtkAction* _tmp18_;
				GtkAction* _tmp19_;
				GtkAction* _tmp20_;
				gboolean _tmp21_;
#line 997 "/home/seb/gnome/gnome-latex/src/main_window.vala"
				_tmp16_ = self->priv->_action_group;
#line 997 "/home/seb/gnome/gnome-latex/src/main_window.vala"
				_tmp17_ = file_action;
#line 997 "/home/seb/gnome/gnome-latex/src/main_window.vala"
				_tmp18_ = gtk_action_group_get_action (_tmp16_, _tmp17_);
#line 997 "/home/seb/gnome/gnome-latex/src/main_window.vala"
				_tmp19_ = _g_object_ref0 (_tmp18_);
#line 997 "/home/seb/gnome/gnome-latex/src/main_window.vala"
				action = _tmp19_;
#line 998 "/home/seb/gnome/gnome-latex/src/main_window.vala"
				_tmp20_ = action;
#line 998 "/home/seb/gnome/gnome-latex/src/main_window.vala"
				_tmp21_ = sensitive;
#line 998 "/home/seb/gnome/gnome-latex/src/main_window.vala"
				gtk_action_set_sensitive (_tmp20_, _tmp21_);
#line 995 "/home/seb/gnome/gnome-latex/src/main_window.vala"
				_g_object_unref0 (action);
#line 995 "/home/seb/gnome/gnome-latex/src/main_window.vala"
				_g_free0 (file_action);
#line 4703 "main_window.c"
			}
		}
	}
#line 1001 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp22_ = self->priv->_latex_action_group;
#line 1001 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp23_ = sensitive;
#line 1001 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	gtk_action_group_set_sensitive (_tmp22_, _tmp23_);
#line 1003 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp24_ = self->priv->_main_window_file;
#line 1003 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	main_window_file_update_sensitivity (_tmp24_);
#line 1004 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp25_ = self->priv->_main_window_edit;
#line 1004 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	main_window_edit_update_sensitivity (_tmp25_);
#line 1005 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp26_ = self->priv->_main_window_build_tools;
#line 1005 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	main_window_build_tools_update_sensitivity (_tmp26_);
#line 1006 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp27_ = self->priv->_main_window_tools;
#line 1006 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	main_window_tools_update_sensitivity (_tmp27_);
#line 976 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	file_actions = (_vala_array_free (file_actions, file_actions_length1, (GDestroyNotify) g_free), NULL);
#line 976 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_g_object_unref0 (tepl_window);
#line 4733 "main_window.c"
}


void
main_window_update_config_project_sensitivity (MainWindow* self)
{
	GtkAction* action = NULL;
	GtkActionGroup* _tmp0_;
	GtkAction* _tmp1_;
	GtkAction* _tmp2_;
	gboolean _tmp3_ = FALSE;
	DocumentTab* _tmp4_;
	DocumentTab* _tmp5_;
	GtkAction* _tmp10_;
#line 1009 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	g_return_if_fail (self != NULL);
#line 1011 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp0_ = self->priv->_action_group;
#line 1011 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp1_ = gtk_action_group_get_action (_tmp0_, "ProjectsConfigCurrent");
#line 1011 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 1011 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	action = _tmp2_;
#line 1012 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp4_ = main_window_get_active_tab (self);
#line 1012 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp5_ = _tmp4_;
#line 1012 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	if (_tmp5_ != NULL) {
#line 4764 "main_window.c"
		Document* _tmp6_;
		Document* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
#line 1012 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		_tmp6_ = main_window_get_active_document (self);
#line 1012 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		_tmp7_ = _tmp6_;
#line 1012 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		_tmp8_ = document_get_project_id (_tmp7_);
#line 1012 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		_tmp9_ = _tmp8_;
#line 1012 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		_tmp3_ = _tmp9_ != -1;
#line 4779 "main_window.c"
	} else {
#line 1012 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		_tmp3_ = FALSE;
#line 4783 "main_window.c"
	}
#line 1012 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp10_ = action;
#line 1012 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	gtk_action_set_sensitive (_tmp10_, _tmp3_);
#line 1009 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_g_object_unref0 (action);
#line 4791 "main_window.c"
}


static void
_vala_array_add6 (gchar** * array,
                  int* length,
                  int* size,
                  gchar* value)
{
#line 1024 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	if ((*length) == (*size)) {
#line 1024 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 1024 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 4807 "main_window.c"
	}
#line 1024 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	(*array)[(*length)++] = value;
#line 1024 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	(*array)[*length] = NULL;
#line 4813 "main_window.c"
}


gboolean
main_window_quit (MainWindow* self)
{
	gboolean result = FALSE;
	gchar** list_uris = NULL;
	gchar** _tmp0_;
	gint list_uris_length1;
	gint _list_uris_size_;
	GSettings* settings = NULL;
	GSettings* _tmp19_;
	GSettings* _tmp20_;
	gchar** _tmp21_;
	gint _tmp21__length1;
#line 1017 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1020 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp0_ = g_new0 (gchar*, 0 + 1);
#line 1020 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	list_uris = _tmp0_;
#line 1020 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	list_uris_length1 = 0;
#line 1020 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_list_uris_size_ = list_uris_length1;
#line 4840 "main_window.c"
	{
		GeeList* _doc_list = NULL;
		GeeList* _tmp1_;
		gint _doc_size = 0;
		GeeList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _doc_index = 0;
#line 1021 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		_tmp1_ = main_window_get_documents (self);
#line 1021 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		_doc_list = _tmp1_;
#line 1021 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		_tmp2_ = _doc_list;
#line 1021 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		_tmp3_ = gee_collection_get_size ((GeeCollection*) _tmp2_);
#line 1021 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		_tmp4_ = _tmp3_;
#line 1021 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		_doc_size = _tmp4_;
#line 1021 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		_doc_index = -1;
#line 1021 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		while (TRUE) {
#line 4865 "main_window.c"
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			Document* doc = NULL;
			GeeList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			Document* _tmp11_;
			GFile* _tmp12_;
			GFile* _tmp13_;
#line 1021 "/home/seb/gnome/gnome-latex/src/main_window.vala"
			_tmp5_ = _doc_index;
#line 1021 "/home/seb/gnome/gnome-latex/src/main_window.vala"
			_doc_index = _tmp5_ + 1;
#line 1021 "/home/seb/gnome/gnome-latex/src/main_window.vala"
			_tmp6_ = _doc_index;
#line 1021 "/home/seb/gnome/gnome-latex/src/main_window.vala"
			_tmp7_ = _doc_size;
#line 1021 "/home/seb/gnome/gnome-latex/src/main_window.vala"
			if (!(_tmp6_ < _tmp7_)) {
#line 1021 "/home/seb/gnome/gnome-latex/src/main_window.vala"
				break;
#line 4888 "main_window.c"
			}
#line 1021 "/home/seb/gnome/gnome-latex/src/main_window.vala"
			_tmp8_ = _doc_list;
#line 1021 "/home/seb/gnome/gnome-latex/src/main_window.vala"
			_tmp9_ = _doc_index;
#line 1021 "/home/seb/gnome/gnome-latex/src/main_window.vala"
			_tmp10_ = gee_list_get (_tmp8_, _tmp9_);
#line 1021 "/home/seb/gnome/gnome-latex/src/main_window.vala"
			doc = (Document*) _tmp10_;
#line 1023 "/home/seb/gnome/gnome-latex/src/main_window.vala"
			_tmp11_ = doc;
#line 1023 "/home/seb/gnome/gnome-latex/src/main_window.vala"
			_tmp12_ = document_get_location (_tmp11_);
#line 1023 "/home/seb/gnome/gnome-latex/src/main_window.vala"
			_tmp13_ = _tmp12_;
#line 1023 "/home/seb/gnome/gnome-latex/src/main_window.vala"
			if (_tmp13_ != NULL) {
#line 4906 "main_window.c"
				gchar** _tmp14_;
				gint _tmp14__length1;
				Document* _tmp15_;
				GFile* _tmp16_;
				GFile* _tmp17_;
				gchar* _tmp18_;
#line 1024 "/home/seb/gnome/gnome-latex/src/main_window.vala"
				_tmp14_ = list_uris;
#line 1024 "/home/seb/gnome/gnome-latex/src/main_window.vala"
				_tmp14__length1 = list_uris_length1;
#line 1024 "/home/seb/gnome/gnome-latex/src/main_window.vala"
				_tmp15_ = doc;
#line 1024 "/home/seb/gnome/gnome-latex/src/main_window.vala"
				_tmp16_ = document_get_location (_tmp15_);
#line 1024 "/home/seb/gnome/gnome-latex/src/main_window.vala"
				_tmp17_ = _tmp16_;
#line 1024 "/home/seb/gnome/gnome-latex/src/main_window.vala"
				_tmp18_ = g_file_get_uri (_tmp17_);
#line 1024 "/home/seb/gnome/gnome-latex/src/main_window.vala"
				_vala_array_add6 (&list_uris, &list_uris_length1, &_list_uris_size_, _tmp18_);
#line 4927 "main_window.c"
			}
#line 1021 "/home/seb/gnome/gnome-latex/src/main_window.vala"
			_g_object_unref0 (doc);
#line 4931 "main_window.c"
		}
#line 1021 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		_g_object_unref0 (_doc_list);
#line 4935 "main_window.c"
	}
#line 1027 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp19_ = g_settings_new ("org.gnome.gnome-latex.state.window");
#line 1027 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	settings = _tmp19_;
#line 1028 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp20_ = settings;
#line 1028 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp21_ = list_uris;
#line 1028 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp21__length1 = list_uris_length1;
#line 1028 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	g_settings_set_strv (_tmp20_, "documents", _tmp21_);
#line 1030 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	if (main_window_close_all_documents (self)) {
#line 1032 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		main_window_save_state (self);
#line 1033 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		gtk_widget_destroy ((GtkWidget*) self);
#line 1034 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		result = TRUE;
#line 1034 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		_g_object_unref0 (settings);
#line 1034 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		list_uris = (_vala_array_free (list_uris, list_uris_length1, (GDestroyNotify) g_free), NULL);
#line 1034 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		return result;
#line 4963 "main_window.c"
	}
#line 1037 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	result = FALSE;
#line 1037 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_g_object_unref0 (settings);
#line 1037 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	list_uris = (_vala_array_free (list_uris, list_uris_length1, (GDestroyNotify) g_free), NULL);
#line 1037 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	return result;
#line 4973 "main_window.c"
}


/*************************************************************************/
void
main_window_on_view_zoom_in (MainWindow* self)
{
	DocumentTab* _tmp0_;
	DocumentTab* _tmp1_;
	DocumentView* _tmp2_;
	DocumentView* _tmp3_;
#line 1045 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	g_return_if_fail (self != NULL);
#line 1047 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp0_ = main_window_get_active_tab (self);
#line 1047 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp1_ = _tmp0_;
#line 1047 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	g_return_if_fail (_tmp1_ != NULL);
#line 1048 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp2_ = main_window_get_active_view (self);
#line 1048 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp3_ = _tmp2_;
#line 1048 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	document_view_enlarge_font (_tmp3_);
#line 4999 "main_window.c"
}


void
main_window_on_view_zoom_out (MainWindow* self)
{
	DocumentTab* _tmp0_;
	DocumentTab* _tmp1_;
	DocumentView* _tmp2_;
	DocumentView* _tmp3_;
#line 1051 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	g_return_if_fail (self != NULL);
#line 1053 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp0_ = main_window_get_active_tab (self);
#line 1053 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp1_ = _tmp0_;
#line 1053 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	g_return_if_fail (_tmp1_ != NULL);
#line 1054 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp2_ = main_window_get_active_view (self);
#line 1054 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp3_ = _tmp2_;
#line 1054 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	document_view_shrink_font (_tmp3_);
#line 5024 "main_window.c"
}


void
main_window_on_view_zoom_reset (MainWindow* self)
{
	DocumentTab* _tmp0_;
	DocumentTab* _tmp1_;
	DocumentView* _tmp2_;
	DocumentView* _tmp3_;
#line 1057 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	g_return_if_fail (self != NULL);
#line 1059 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp0_ = main_window_get_active_tab (self);
#line 1059 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp1_ = _tmp0_;
#line 1059 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	g_return_if_fail (_tmp1_ != NULL);
#line 1060 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp2_ = main_window_get_active_view (self);
#line 1060 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp3_ = _tmp2_;
#line 1060 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	document_view_set_font_from_settings (_tmp3_);
#line 5049 "main_window.c"
}


void
main_window_on_search_find (MainWindow* self)
{
	DocumentTab* _tmp0_;
	DocumentTab* _tmp1_;
	SearchAndReplace* _tmp2_;
#line 1065 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	g_return_if_fail (self != NULL);
#line 1067 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp0_ = main_window_get_active_tab (self);
#line 1067 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp1_ = _tmp0_;
#line 1067 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	g_return_if_fail (_tmp1_ != NULL);
#line 1068 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp2_ = self->priv->_search_and_replace;
#line 1068 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	search_and_replace_show_search (_tmp2_);
#line 5071 "main_window.c"
}


void
main_window_on_search_replace (MainWindow* self)
{
	DocumentTab* _tmp0_;
	DocumentTab* _tmp1_;
	SearchAndReplace* _tmp2_;
#line 1071 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	g_return_if_fail (self != NULL);
#line 1073 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp0_ = main_window_get_active_tab (self);
#line 1073 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp1_ = _tmp0_;
#line 1073 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	g_return_if_fail (_tmp1_ != NULL);
#line 1074 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp2_ = self->priv->_search_and_replace;
#line 1074 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	search_and_replace_show_search_and_replace (_tmp2_);
#line 5093 "main_window.c"
}


void
main_window_on_search_goto_line (MainWindow* self)
{
	DocumentTab* _tmp0_;
	DocumentTab* _tmp1_;
	GotoLine* _tmp2_;
#line 1077 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	g_return_if_fail (self != NULL);
#line 1079 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp0_ = main_window_get_active_tab (self);
#line 1079 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp1_ = _tmp0_;
#line 1079 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	g_return_if_fail (_tmp1_ != NULL);
#line 1080 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp2_ = self->priv->_goto_line;
#line 1080 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	goto_line_show (_tmp2_);
#line 5115 "main_window.c"
}


void
main_window_on_search_forward (MainWindow* self)
{
	DocumentTab* _tmp0_;
	DocumentTab* _tmp1_;
	LatexilaSynctex* synctex = NULL;
	LatexilaSynctex* _tmp2_;
	LatexilaSynctex* _tmp3_;
	Document* _tmp4_;
	Document* _tmp5_;
	Document* _tmp6_;
	Document* _tmp7_;
	GFile* _tmp8_;
	GFile* _tmp9_;
	Document* _tmp10_;
	Document* _tmp11_;
	GFile* _tmp12_;
	GFile* _tmp13_;
#line 1083 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	g_return_if_fail (self != NULL);
#line 1085 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp0_ = main_window_get_active_tab (self);
#line 1085 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp1_ = _tmp0_;
#line 1085 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	g_return_if_fail (_tmp1_ != NULL);
#line 1087 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp2_ = latexila_synctex_get_instance ();
#line 1087 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 1087 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	synctex = _tmp3_;
#line 1088 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp4_ = main_window_get_active_document (self);
#line 1088 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp5_ = _tmp4_;
#line 1088 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp6_ = main_window_get_active_document (self);
#line 1088 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp7_ = _tmp6_;
#line 1088 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp8_ = document_get_location (_tmp7_);
#line 1088 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp9_ = _tmp8_;
#line 1088 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp10_ = main_window_get_active_document (self);
#line 1088 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp11_ = _tmp10_;
#line 1088 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp12_ = document_get_main_file (_tmp11_);
#line 1088 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp13_ = _tmp12_;
#line 1088 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	latexila_synctex_forward_search (synctex, (GtkTextBuffer*) _tmp5_, _tmp9_, _tmp13_, (guint) GDK_CURRENT_TIME);
#line 1088 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_g_object_unref0 (_tmp13_);
#line 1083 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_g_object_unref0 (synctex);
#line 5177 "main_window.c"
}


void
main_window_on_projects_new (MainWindow* self)
{
#line 1094 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	g_return_if_fail (self != NULL);
#line 1096 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	project_dialogs_new_project (self);
#line 5188 "main_window.c"
}


void
main_window_on_projects_config_current (MainWindow* self)
{
	DocumentTab* _tmp0_;
	DocumentTab* _tmp1_;
	Document* _tmp2_;
	Document* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	Document* _tmp6_;
	Document* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
#line 1099 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	g_return_if_fail (self != NULL);
#line 1101 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp0_ = main_window_get_active_tab (self);
#line 1101 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp1_ = _tmp0_;
#line 1101 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	g_return_if_fail (_tmp1_ != NULL);
#line 1102 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp2_ = main_window_get_active_document (self);
#line 1102 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp3_ = _tmp2_;
#line 1102 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp4_ = document_get_project_id (_tmp3_);
#line 1102 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp5_ = _tmp4_;
#line 1102 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	g_return_if_fail (_tmp5_ != -1);
#line 1103 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp6_ = main_window_get_active_document (self);
#line 1103 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp7_ = _tmp6_;
#line 1103 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp8_ = document_get_project_id (_tmp7_);
#line 1103 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp9_ = _tmp8_;
#line 1103 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	project_dialogs_configure_project ((GtkWindow*) self, _tmp9_);
#line 5233 "main_window.c"
}


void
main_window_on_projects_manage (MainWindow* self)
{
#line 1106 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	g_return_if_fail (self != NULL);
#line 1108 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	project_dialogs_manage_projects (self);
#line 5244 "main_window.c"
}


void
main_window_on_help_latex_reference (MainWindow* self)
{
	GError * _inner_error_ = NULL;
#line 1113 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	g_return_if_fail (self != NULL);
#line 5254 "main_window.c"
	{
		gchar* uri = NULL;
		gchar* _tmp0_;
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		const gchar* _tmp4_;
#line 1117 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		_tmp0_ = g_build_filename (DATA_DIR, "latexhelp.html", NULL, NULL);
#line 1117 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		_tmp1_ = _tmp0_;
#line 1117 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		_tmp2_ = g_filename_to_uri (_tmp1_, NULL, &_inner_error_);
#line 1117 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		_tmp3_ = _tmp2_;
#line 1117 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		_g_free0 (_tmp1_);
#line 1117 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		uri = _tmp3_;
#line 1117 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 5276 "main_window.c"
			goto __catch33_g_error;
		}
#line 1119 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		_tmp4_ = uri;
#line 1119 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		latexila_utils_show_uri ((GtkWidget*) self, _tmp4_, (guint32) GDK_CURRENT_TIME, &_inner_error_);
#line 1119 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1119 "/home/seb/gnome/gnome-latex/src/main_window.vala"
			_g_free0 (uri);
#line 5287 "main_window.c"
			goto __catch33_g_error;
		}
#line 1115 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		_g_free0 (uri);
#line 5292 "main_window.c"
	}
	goto __finally33;
	__catch33_g_error:
	{
		GError* e = NULL;
		GError* _tmp5_;
		const gchar* _tmp6_;
#line 1115 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		e = _inner_error_;
#line 1115 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		_inner_error_ = NULL;
#line 1123 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		_tmp5_ = e;
#line 1123 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		_tmp6_ = _tmp5_->message;
#line 1123 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		g_warning ("main_window.vala:1123: Impossible to open the LaTeX reference: %s", _tmp6_);
#line 1115 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		_g_error_free0 (e);
#line 5312 "main_window.c"
	}
	__finally33:
#line 1115 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1115 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1115 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		g_clear_error (&_inner_error_);
#line 1115 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		return;
#line 5323 "main_window.c"
	}
}


DocumentTab*
main_window_get_active_tab (MainWindow* self)
{
	DocumentTab* result;
	TeplApplicationWindow* tepl_window = NULL;
	TeplApplicationWindow* _tmp0_;
	TeplApplicationWindow* _tmp1_;
	TeplTab* _tmp2_;
#line 114 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 116 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp0_ = tepl_application_window_get_from_gtk_application_window ((GtkApplicationWindow*) self);
#line 116 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 116 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	tepl_window = _tmp1_;
#line 118 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp2_ = tepl_tab_group_get_active_tab ((TeplTabGroup*) tepl_window);
#line 118 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	result = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, TYPE_DOCUMENT_TAB) ? ((DocumentTab*) _tmp2_) : NULL;
#line 118 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_g_object_unref0 (tepl_window);
#line 118 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	return result;
#line 5352 "main_window.c"
}


void
main_window_set_active_tab (MainWindow* self,
                            DocumentTab* value)
{
	TeplApplicationWindow* tepl_window = NULL;
	TeplApplicationWindow* _tmp0_;
	TeplApplicationWindow* _tmp1_;
#line 121 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	g_return_if_fail (self != NULL);
#line 123 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp0_ = tepl_application_window_get_from_gtk_application_window ((GtkApplicationWindow*) self);
#line 123 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 123 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	tepl_window = _tmp1_;
#line 125 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	tepl_tab_group_set_active_tab ((TeplTabGroup*) tepl_window, (TeplTab*) value);
#line 121 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_g_object_unref0 (tepl_window);
#line 121 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	g_object_notify_by_pspec ((GObject *) self, main_window_properties[MAIN_WINDOW_ACTIVE_TAB_PROPERTY]);
#line 5377 "main_window.c"
}


DocumentView*
main_window_get_active_view (MainWindow* self)
{
	DocumentView* result;
	TeplApplicationWindow* tepl_window = NULL;
	TeplApplicationWindow* _tmp0_;
	TeplApplicationWindow* _tmp1_;
	TeplView* _tmp2_;
#line 131 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 133 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp0_ = tepl_application_window_get_from_gtk_application_window ((GtkApplicationWindow*) self);
#line 133 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 133 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	tepl_window = _tmp1_;
#line 135 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp2_ = tepl_tab_group_get_active_view ((TeplTabGroup*) tepl_window);
#line 135 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	result = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, TYPE_DOCUMENT_VIEW) ? ((DocumentView*) _tmp2_) : NULL;
#line 135 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_g_object_unref0 (tepl_window);
#line 135 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	return result;
#line 5405 "main_window.c"
}


Document*
main_window_get_active_document (MainWindow* self)
{
	Document* result;
	TeplApplicationWindow* tepl_window = NULL;
	TeplApplicationWindow* _tmp0_;
	TeplApplicationWindow* _tmp1_;
	TeplBuffer* _tmp2_;
#line 141 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 143 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp0_ = tepl_application_window_get_from_gtk_application_window ((GtkApplicationWindow*) self);
#line 143 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 143 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	tepl_window = _tmp1_;
#line 145 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp2_ = tepl_tab_group_get_active_buffer ((TeplTabGroup*) tepl_window);
#line 145 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	result = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, TYPE_DOCUMENT) ? ((Document*) _tmp2_) : NULL;
#line 145 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_g_object_unref0 (tepl_window);
#line 145 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	return result;
#line 5433 "main_window.c"
}


static void
main_window_class_init (MainWindowClass * klass)
{
#line 22 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	main_window_parent_class = g_type_class_peek_parent (klass);
#line 22 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	g_type_class_add_private (klass, sizeof (MainWindowPrivate));
#line 22 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_main_window_get_property;
#line 22 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_main_window_set_property;
#line 22 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	G_OBJECT_CLASS (klass)->finalize = main_window_finalize;
#line 5450 "main_window.c"
	/*************************************************************************/
#line 22 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAIN_WINDOW_ACTIVE_TAB_PROPERTY, main_window_properties[MAIN_WINDOW_ACTIVE_TAB_PROPERTY] = g_param_spec_object ("active-tab", "active-tab", "active-tab", TYPE_DOCUMENT_TAB, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 22 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAIN_WINDOW_ACTIVE_VIEW_PROPERTY, main_window_properties[MAIN_WINDOW_ACTIVE_VIEW_PROPERTY] = g_param_spec_object ("active-view", "active-view", "active-view", TYPE_DOCUMENT_VIEW, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 22 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAIN_WINDOW_ACTIVE_DOCUMENT_PROPERTY, main_window_properties[MAIN_WINDOW_ACTIVE_DOCUMENT_PROPERTY] = g_param_spec_object ("active-document", "active-document", "active-document", TYPE_DOCUMENT, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 5458 "main_window.c"
}


static void
main_window_instance_init (MainWindow * self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
#line 22 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	self->priv = MAIN_WINDOW_GET_PRIVATE (self);
#line 87 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp0_ = g_get_home_dir ();
#line 87 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 87 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	self->default_location = _tmp1_;
#line 5475 "main_window.c"
}


static void
main_window_finalize (GObject * obj)
{
	MainWindow * self;
#line 22 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MAIN_WINDOW, MainWindow);
#line 87 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_g_free0 (self->default_location);
#line 88 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_g_object_unref0 (self->priv->_documents_panel);
#line 89 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_g_object_unref0 (self->priv->_statusbar);
#line 90 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_g_object_unref0 (self->priv->_goto_line);
#line 91 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_g_object_unref0 (self->priv->_search_and_replace);
#line 92 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_g_object_unref0 (self->priv->_main_hpaned);
#line 93 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_g_object_unref0 (self->priv->_vpaned);
#line 95 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_g_object_unref0 (self->priv->_ui_manager);
#line 96 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_g_object_unref0 (self->priv->_action_group);
#line 97 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_g_object_unref0 (self->priv->_latex_action_group);
#line 99 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_main_window_file_unref0 (self->priv->_main_window_file);
#line 100 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_main_window_edit_unref0 (self->priv->_main_window_edit);
#line 101 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_main_window_build_tools_unref0 (self->priv->_main_window_build_tools);
#line 102 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_main_window_structure_unref0 (self->priv->_main_window_structure);
#line 103 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_main_window_documents_unref0 (self->priv->_main_window_documents);
#line 104 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	_main_window_tools_unref0 (self->priv->_main_window_tools);
#line 22 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	G_OBJECT_CLASS (main_window_parent_class)->finalize (obj);
#line 5519 "main_window.c"
}


GType
main_window_get_type (void)
{
	static volatile gsize main_window_type_id__volatile = 0;
	if (g_once_init_enter (&main_window_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MainWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) main_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MainWindow), 0, (GInstanceInitFunc) main_window_instance_init, NULL };
		GType main_window_type_id;
		main_window_type_id = g_type_register_static (gtk_application_window_get_type (), "MainWindow", &g_define_type_info, 0);
		g_once_init_leave (&main_window_type_id__volatile, main_window_type_id);
	}
	return main_window_type_id__volatile;
}


static void
_vala_main_window_get_property (GObject * object,
                                guint property_id,
                                GValue * value,
                                GParamSpec * pspec)
{
	MainWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_MAIN_WINDOW, MainWindow);
#line 22 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	switch (property_id) {
#line 22 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		case MAIN_WINDOW_ACTIVE_TAB_PROPERTY:
#line 22 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		g_value_set_object (value, main_window_get_active_tab (self));
#line 22 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		break;
#line 22 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		case MAIN_WINDOW_ACTIVE_VIEW_PROPERTY:
#line 22 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		g_value_set_object (value, main_window_get_active_view (self));
#line 22 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		break;
#line 22 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		case MAIN_WINDOW_ACTIVE_DOCUMENT_PROPERTY:
#line 22 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		g_value_set_object (value, main_window_get_active_document (self));
#line 22 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		break;
#line 5565 "main_window.c"
		default:
#line 22 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 22 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		break;
#line 5571 "main_window.c"
	}
}


static void
_vala_main_window_set_property (GObject * object,
                                guint property_id,
                                const GValue * value,
                                GParamSpec * pspec)
{
	MainWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_MAIN_WINDOW, MainWindow);
#line 22 "/home/seb/gnome/gnome-latex/src/main_window.vala"
	switch (property_id) {
#line 22 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		case MAIN_WINDOW_ACTIVE_TAB_PROPERTY:
#line 22 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		main_window_set_active_tab (self, g_value_get_object (value));
#line 22 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		break;
#line 5592 "main_window.c"
		default:
#line 22 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 22 "/home/seb/gnome/gnome-latex/src/main_window.vala"
		break;
#line 5598 "main_window.c"
	}
}


static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
#line 27 "/home/seb/gnome/gnome-latex/src/build_tools_preferences.vala"
	if ((array != NULL) && (destroy_func != NULL)) {
#line 5610 "main_window.c"
		int i;
#line 27 "/home/seb/gnome/gnome-latex/src/build_tools_preferences.vala"
		for (i = 0; i < array_length; i = i + 1) {
#line 27 "/home/seb/gnome/gnome-latex/src/build_tools_preferences.vala"
			if (((gpointer*) array)[i] != NULL) {
#line 27 "/home/seb/gnome/gnome-latex/src/build_tools_preferences.vala"
				destroy_func (((gpointer*) array)[i]);
#line 5618 "main_window.c"
			}
		}
	}
}


static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
#line 27 "/home/seb/gnome/gnome-latex/src/build_tools_preferences.vala"
	_vala_array_destroy (array, array_length, destroy_func);
#line 27 "/home/seb/gnome/gnome-latex/src/build_tools_preferences.vala"
	g_free (array);
#line 5634 "main_window.c"
}


static gint
_vala_array_length (gpointer array)
{
	int length;
	length = 0;
#line 27 "/home/seb/gnome/gnome-latex/src/build_tools_preferences.vala"
	if (array) {
#line 27 "/home/seb/gnome/gnome-latex/src/build_tools_preferences.vala"
		while (((gpointer*) array)[length]) {
#line 27 "/home/seb/gnome/gnome-latex/src/build_tools_preferences.vala"
			length++;
#line 5649 "main_window.c"
		}
	}
#line 27 "/home/seb/gnome/gnome-latex/src/build_tools_preferences.vala"
	return length;
#line 5654 "main_window.c"
}



