/* utils.c generated by valac 0.39.2.21-6056, the Vala compiler
 * generated from utils.vala, do not modify */

/*
 * This file is part of GNOME LaTeX.
 *
 * Copyright © 2010-2012 Sébastien Wilmet
 *
 * GNOME LaTeX is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME LaTeX is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME LaTeX.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <latexila.h>
#include <gtk/gtk.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_bytes_unref0(var) ((var == NULL) ? NULL : (var = (g_bytes_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define __vala_GtkTreePath_free0(var) ((var == NULL) ? NULL : (var = (_vala_GtkTreePath_free (var), NULL)))



gchar* utils_str_middle_truncate (const gchar* str, 
                                  guint max_length);
gboolean utils_char_is_escaped (const gchar* text, 
                                glong char_index);
const gchar* utils_get_string_from_resource (const gchar* resource_path);
gchar* utils_uri_get_dirname (const gchar* uri);
gchar* utils_get_dirname_for_display (GFile* location);
void utils_delete_file (GFile* file);
gboolean utils_save_file (GFile* file, 
                          const gchar* contents, 
                          gboolean make_backup);
gchar* utils_load_file (GFile* file);
gchar* utils_get_relative_path (GFile* origin, 
                                GFile* target, 
                                GFile* common_dir);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
GtkScrolledWindow* utils_add_scrollbar (GtkWidget* child);
gboolean utils_tree_model_iter_prev (GtkTreeModel* model, 
                                     GtkTreeIter* iter);
static void _vala_GtkTreePath_free (GtkTreePath* self);
gint utils_get_selected_row (GtkTreeView* view, 
                             GtkTreeIter* iter);
GtkWindow* utils_get_toplevel_window (GtkWidget* widget);
void utils_flush_queue (void);


/*************************************************************************/
static gchar*
string_slice (const gchar* self, 
              glong start, 
              glong end)
{
	gchar* result = NULL;
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gchar* _tmp8_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		glong _tmp2_;
		_tmp2_ = string_length;
		start = _tmp2_ + start;
	}
	if (end < ((glong) 0)) {
		glong _tmp3_;
		_tmp3_ = string_length;
		end = _tmp3_ + end;
	}
	if (start >= ((glong) 0)) {
		glong _tmp5_;
		_tmp5_ = string_length;
		_tmp4_ = start <= _tmp5_;
	} else {
		_tmp4_ = FALSE;
	}
	g_return_val_if_fail (_tmp4_, NULL);
	if (end >= ((glong) 0)) {
		glong _tmp7_;
		_tmp7_ = string_length;
		_tmp6_ = end <= _tmp7_;
	} else {
		_tmp6_ = FALSE;
	}
	g_return_val_if_fail (_tmp6_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp8_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp8_;
	return result;
}


gchar*
utils_str_middle_truncate (const gchar* str, 
                           guint max_length)
{
	gchar* result = NULL;
	gint _tmp0_;
	gint _tmp1_;
	guint half_length = 0U;
	gint l = 0;
	gint _tmp3_;
	gint _tmp4_;
	guint _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gint _tmp10_;
	guint _tmp11_;
	gint _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	g_return_val_if_fail (str != NULL, NULL);
	_tmp0_ = strlen (str);
	_tmp1_ = _tmp0_;
	if (((guint) _tmp1_) <= max_length) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (str);
		result = _tmp2_;
		return result;
	}
	half_length = (max_length - 4) / 2;
	_tmp3_ = strlen (str);
	_tmp4_ = _tmp3_;
	l = _tmp4_;
	_tmp5_ = half_length;
	_tmp6_ = string_slice (str, (glong) 0, (glong) _tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strconcat (_tmp7_, "...", NULL);
	_tmp9_ = _tmp8_;
	_tmp10_ = l;
	_tmp11_ = half_length;
	_tmp12_ = l;
	_tmp13_ = string_slice (str, (glong) (_tmp10_ - _tmp11_), (glong) _tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = g_strconcat (_tmp9_, _tmp14_, NULL);
	_tmp16_ = _tmp15_;
	_g_free0 (_tmp14_);
	_g_free0 (_tmp9_);
	_g_free0 (_tmp7_);
	result = _tmp16_;
	return result;
}


static gboolean
string_get_prev_char (const gchar* self, 
                      gint* index, 
                      gunichar* c)
{
	gunichar _vala_c = 0U;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (0 < (*index)) {
		gchar* _tmp0_;
		_tmp0_ = g_utf8_prev_char (((gchar*) self) + (*index));
		*index = (gint) (_tmp0_ - ((gchar*) self));
		_vala_c = g_utf8_get_char (((gchar*) self) + (*index));
		result = TRUE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	} else {
		_vala_c = (gunichar) 0;
		result = FALSE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	}
	if (c) {
		*c = _vala_c;
	}
}


gboolean
utils_char_is_escaped (const gchar* text, 
                       glong char_index)
{
	gboolean result = FALSE;
	gint _tmp0_;
	gint _tmp1_;
	gboolean escaped = FALSE;
	gint index = 0;
	gunichar cur_char = 0U;
	g_return_val_if_fail (text != NULL, FALSE);
	_tmp0_ = strlen (text);
	_tmp1_ = _tmp0_;
	g_return_val_if_fail (char_index < ((glong) _tmp1_), FALSE);
	escaped = FALSE;
	index = (gint) char_index;
	while (TRUE) {
		gunichar _tmp2_ = 0U;
		gboolean _tmp3_;
		gunichar _tmp4_;
		gboolean _tmp5_;
		_tmp3_ = string_get_prev_char (text, &index, &_tmp2_);
		cur_char = _tmp2_;
		if (!_tmp3_) {
			break;
		}
		_tmp4_ = cur_char;
		if (_tmp4_ != ((gunichar) '\\')) {
			break;
		}
		_tmp5_ = escaped;
		escaped = !_tmp5_;
	}
	result = escaped;
	return result;
}


const gchar*
utils_get_string_from_resource (const gchar* resource_path)
{
	const gchar* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (resource_path != NULL, NULL);
	{
		GBytes* bytes = NULL;
		GBytes* _tmp0_;
		gsize _tmp1_;
		guint8* _tmp2_;
		_tmp0_ = g_resources_lookup_data (resource_path, 0, &_inner_error_);
		bytes = _tmp0_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch46_g_error;
		}
		_tmp2_ = g_bytes_get_data (bytes, &_tmp1_);
		result = (const gchar*) _tmp2_;
		_g_bytes_unref0 (bytes);
		return result;
	}
	goto __finally46;
	__catch46_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_warning ("utils.vala:64: Failed to load data from resource '%s': %s", resource_path, _tmp4_);
		result = NULL;
		_g_error_free0 (e);
		return result;
	}
	__finally46:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return NULL;
}


/*************************************************************************/
gchar*
utils_uri_get_dirname (const gchar* uri)
{
	gchar* result = NULL;
	gchar* dir = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_val_if_fail (uri != NULL, NULL);
	g_return_val_if_fail (uri != NULL, NULL);
	_tmp0_ = g_path_get_dirname (uri);
	dir = _tmp0_;
	_tmp1_ = dir;
	if (g_strcmp0 (_tmp1_, ".") == 0) {
		result = NULL;
		_g_free0 (dir);
		return result;
	}
	_tmp2_ = dir;
	_tmp3_ = latexila_utils_replace_home_dir_with_tilde (_tmp2_);
	result = _tmp3_;
	_g_free0 (dir);
	return result;
}


gchar*
utils_get_dirname_for_display (GFile* location)
{
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (location != NULL, NULL);
	{
		GMount* mount = NULL;
		GMount* _tmp0_;
		gchar* mount_name = NULL;
		GMount* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_;
		gchar* dirname = NULL;
		gchar* _tmp6_;
		gboolean _tmp7_ = FALSE;
		const gchar* _tmp8_;
		const gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		const gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		_tmp0_ = g_file_find_enclosing_mount (location, NULL, &_inner_error_);
		mount = _tmp0_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch47_g_error;
		}
		_tmp1_ = mount;
		_tmp2_ = g_mount_get_name (_tmp1_);
		mount_name = _tmp2_;
		_tmp4_ = g_file_get_path (location);
		_tmp3_ = _tmp4_;
		if (_tmp3_ == NULL) {
			gchar* _tmp5_;
			_tmp5_ = g_file_get_uri (location);
			_g_free0 (_tmp3_);
			_tmp3_ = _tmp5_;
		}
		_tmp6_ = utils_uri_get_dirname (_tmp3_);
		dirname = _tmp6_;
		_tmp8_ = dirname;
		if (_tmp8_ == NULL) {
			_tmp7_ = TRUE;
		} else {
			const gchar* _tmp9_;
			_tmp9_ = dirname;
			_tmp7_ = g_strcmp0 (_tmp9_, ".") == 0;
		}
		if (_tmp7_) {
			result = mount_name;
			_g_free0 (dirname);
			_g_free0 (_tmp3_);
			_g_object_unref0 (mount);
			return result;
		}
		_tmp10_ = mount_name;
		_tmp11_ = g_strconcat (_tmp10_, " ", NULL);
		_tmp12_ = _tmp11_;
		_tmp13_ = dirname;
		_tmp14_ = g_strconcat (_tmp12_, _tmp13_, NULL);
		_tmp15_ = _tmp14_;
		_g_free0 (_tmp12_);
		result = _tmp15_;
		_g_free0 (dirname);
		_g_free0 (_tmp3_);
		_g_free0 (mount_name);
		_g_object_unref0 (mount);
		return result;
	}
	goto __finally47;
	__catch47_g_error:
	{
		GError* e = NULL;
		gchar* _tmp16_ = NULL;
		gchar* _tmp17_;
		gchar* _tmp19_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp17_ = g_file_get_path (location);
		_tmp16_ = _tmp17_;
		if (_tmp16_ == NULL) {
			gchar* _tmp18_;
			_tmp18_ = g_file_get_uri (location);
			_g_free0 (_tmp16_);
			_tmp16_ = _tmp18_;
		}
		_tmp19_ = utils_uri_get_dirname (_tmp16_);
		result = _tmp19_;
		_g_free0 (_tmp16_);
		_g_error_free0 (e);
		return result;
	}
	__finally47:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return NULL;
}


void
utils_delete_file (GFile* file)
{
	GError * _inner_error_ = NULL;
	g_return_if_fail (file != NULL);
	if (!g_file_query_exists (file, NULL)) {
		return;
	}
	{
		g_file_delete (file, NULL, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch48_g_error;
		}
	}
	goto __finally48;
	__catch48_g_error:
	{
		GError* e = NULL;
		gchar* _tmp0_;
		gchar* _tmp1_;
		GError* _tmp2_;
		const gchar* _tmp3_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp0_ = g_file_get_parse_name (file);
		_tmp1_ = _tmp0_;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		g_warning ("utils.vala:120: Delete file '%s' failed: %s", _tmp1_, _tmp3_);
		_g_free0 (_tmp1_);
		_g_error_free0 (e);
	}
	__finally48:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static guint8*
string_get_data (const gchar* self, 
                 int* result_length1)
{
	guint8* result;
	guint8* res = NULL;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	guint8* _tmp3_;
	gint _tmp3__length1;
	guint8* _tmp4_;
	gint _tmp4__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res_length1;
	_tmp3_ = res;
	_tmp3__length1 = res_length1;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _tmp3__length1;
	if (result_length1) {
		*result_length1 = _tmp4__length1;
	}
	result = _tmp4_;
	return result;
}


gboolean
utils_save_file (GFile* file, 
                 const gchar* contents, 
                 gboolean make_backup)
{
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (file != NULL, FALSE);
	g_return_val_if_fail (contents != NULL, FALSE);
	{
		guint8* _tmp0_;
		gint _tmp0__length1;
		guint8* _tmp1_;
		gint _tmp1__length1;
		latexila_utils_create_parent_directories (file, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch49_g_error;
		}
		_tmp0_ = string_get_data (contents, &_tmp0__length1);
		_tmp1_ = _tmp0_;
		_tmp1__length1 = _tmp0__length1;
		g_file_replace_contents (file, _tmp1_, (gsize) _tmp1__length1, NULL, make_backup, G_FILE_CREATE_NONE, NULL, NULL, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch49_g_error;
		}
	}
	goto __finally49;
	__catch49_g_error:
	{
		GError* e = NULL;
		gchar* _tmp2_;
		gchar* _tmp3_;
		GError* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = g_file_get_parse_name (file);
		_tmp3_ = _tmp2_;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_warning ("utils.vala:135: Failed to save the file '%s': %s", _tmp3_, _tmp5_);
		_g_free0 (_tmp3_);
		result = FALSE;
		_g_error_free0 (e);
		return result;
	}
	__finally49:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gboolean _tmp6_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return _tmp6_;
	}
	result = TRUE;
	return result;
}


gchar*
utils_load_file (GFile* file)
{
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (file != NULL, NULL);
	{
		guint8* chars = NULL;
		gint chars_length1 = 0;
		gint _chars_size_ = 0;
		guint8* _tmp0_ = NULL;
		gsize _tmp1_;
		guint8* _tmp2_;
		gint _tmp2__length1;
		g_file_load_contents (file, NULL, &_tmp0_, &_tmp1_, NULL, &_inner_error_);
		chars = (g_free (chars), NULL);
		chars = _tmp0_;
		chars_length1 = _tmp1_;
		_chars_size_ = chars_length1;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			chars = (g_free (chars), NULL);
			goto __catch50_g_error;
		}
		_tmp2_ = chars;
		_tmp2__length1 = chars_length1;
		chars = NULL;
		chars_length1 = 0;
		result = (gchar*) _tmp2_;
		chars = (g_free (chars), NULL);
		return result;
	}
	goto __finally50;
	__catch50_g_error:
	{
		GError* e = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GError* _tmp5_;
		const gchar* _tmp6_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = g_file_get_parse_name (file);
		_tmp4_ = _tmp3_;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		g_warning ("utils.vala:154: Failed to load the file '%s': %s", _tmp4_, _tmp6_);
		_g_free0 (_tmp4_);
		result = NULL;
		_g_error_free0 (e);
		return result;
	}
	__finally50:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return NULL;
}


static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}


static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}


gchar*
utils_get_relative_path (GFile* origin, 
                         GFile* target, 
                         GFile* common_dir)
{
	gchar* result = NULL;
	GFile* origin_dir = NULL;
	GFile* target_parent = NULL;
	GFile* _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
	GFile* _tmp5_;
	GFile* _tmp6_;
	GList* target_dirs = NULL;
	GList* origin_dirs = NULL;
	guint dir_index = 0U;
	guint nb_common_dirs = 0U;
	guint _tmp38_;
	gchar* relative_path = NULL;
	gchar* _tmp39_;
	guint nb_remaining_origin_dirs = 0U;
	GList* _tmp40_;
	guint _tmp41_;
	const gchar* _tmp64_;
	gchar* _tmp65_;
	gchar* _tmp66_;
	gchar* _tmp67_;
	g_return_val_if_fail (origin != NULL, NULL);
	g_return_val_if_fail (target != NULL, NULL);
	g_return_val_if_fail (common_dir != NULL, NULL);
	if (g_file_equal (origin, common_dir)) {
		GFile* _tmp0_;
		_tmp0_ = _g_object_ref0 (origin);
		_g_object_unref0 (origin_dir);
		origin_dir = _tmp0_;
	} else {
		GFile* _tmp1_;
		_tmp1_ = g_file_get_parent (origin);
		_g_object_unref0 (origin_dir);
		origin_dir = _tmp1_;
	}
	_tmp2_ = g_file_get_parent (target);
	target_parent = _tmp2_;
	_tmp3_ = origin_dir;
	g_return_val_if_fail (_tmp3_ != NULL, NULL);
	_tmp4_ = target_parent;
	g_return_val_if_fail (_tmp4_ != NULL, NULL);
	_tmp5_ = target_parent;
	_tmp6_ = origin_dir;
	if (g_file_equal (_tmp5_, _tmp6_)) {
		gchar* _tmp7_;
		_tmp7_ = g_file_get_basename (target);
		result = _tmp7_;
		_g_object_unref0 (target_parent);
		_g_object_unref0 (origin_dir);
		return result;
	}
	target_dirs = NULL;
	origin_dirs = NULL;
	while (TRUE) {
		gboolean _tmp8_ = FALSE;
		GFile* _tmp9_;
		GFile* _tmp11_;
		GFile* _tmp12_;
		GFile* _tmp13_;
		GFile* _tmp14_;
		_tmp9_ = target_parent;
		if (_tmp9_ != NULL) {
			GFile* _tmp10_;
			_tmp10_ = target_parent;
			_tmp8_ = !g_file_equal (_tmp10_, common_dir);
		} else {
			_tmp8_ = FALSE;
		}
		if (!_tmp8_) {
			break;
		}
		_tmp11_ = target_parent;
		_tmp12_ = _g_object_ref0 (_tmp11_);
		target_dirs = g_list_prepend (target_dirs, _tmp12_);
		_tmp13_ = target_parent;
		_tmp14_ = g_file_get_parent (_tmp13_);
		_g_object_unref0 (target_parent);
		target_parent = _tmp14_;
	}
	while (TRUE) {
		gboolean _tmp15_ = FALSE;
		GFile* _tmp16_;
		GFile* _tmp18_;
		GFile* _tmp19_;
		GFile* _tmp20_;
		GFile* _tmp21_;
		_tmp16_ = origin_dir;
		if (_tmp16_ != NULL) {
			GFile* _tmp17_;
			_tmp17_ = origin_dir;
			_tmp15_ = !g_file_equal (_tmp17_, common_dir);
		} else {
			_tmp15_ = FALSE;
		}
		if (!_tmp15_) {
			break;
		}
		_tmp18_ = origin_dir;
		_tmp19_ = _g_object_ref0 (_tmp18_);
		origin_dirs = g_list_prepend (origin_dirs, _tmp19_);
		_tmp20_ = origin_dir;
		_tmp21_ = g_file_get_parent (_tmp20_);
		_g_object_unref0 (origin_dir);
		origin_dir = _tmp21_;
	}
	dir_index = (guint) 0;
	while (TRUE) {
		gboolean _tmp22_ = FALSE;
		guint _tmp23_;
		GList* _tmp24_;
		GFile* cur_target_dir = NULL;
		GList* _tmp27_;
		guint _tmp28_;
		gconstpointer _tmp29_;
		GFile* _tmp30_;
		GFile* cur_origin_dir = NULL;
		GList* _tmp31_;
		guint _tmp32_;
		gconstpointer _tmp33_;
		GFile* _tmp34_;
		GFile* _tmp35_;
		GFile* _tmp36_;
		guint _tmp37_;
		_tmp23_ = dir_index;
		_tmp24_ = target_dirs;
		if (_tmp23_ < g_list_length (_tmp24_)) {
			guint _tmp25_;
			GList* _tmp26_;
			_tmp25_ = dir_index;
			_tmp26_ = origin_dirs;
			_tmp22_ = _tmp25_ < g_list_length (_tmp26_);
		} else {
			_tmp22_ = FALSE;
		}
		if (!_tmp22_) {
			break;
		}
		_tmp27_ = target_dirs;
		_tmp28_ = dir_index;
		_tmp29_ = g_list_nth_data (_tmp27_, _tmp28_);
		_tmp30_ = _g_object_ref0 ((GFile*) _tmp29_);
		cur_target_dir = _tmp30_;
		_tmp31_ = origin_dirs;
		_tmp32_ = dir_index;
		_tmp33_ = g_list_nth_data (_tmp31_, _tmp32_);
		_tmp34_ = _g_object_ref0 ((GFile*) _tmp33_);
		cur_origin_dir = _tmp34_;
		_tmp35_ = cur_target_dir;
		_tmp36_ = cur_origin_dir;
		if (!g_file_equal (_tmp35_, _tmp36_)) {
			_g_object_unref0 (cur_origin_dir);
			_g_object_unref0 (cur_target_dir);
			break;
		}
		_tmp37_ = dir_index;
		dir_index = _tmp37_ + 1;
		_g_object_unref0 (cur_origin_dir);
		_g_object_unref0 (cur_target_dir);
	}
	_tmp38_ = dir_index;
	nb_common_dirs = _tmp38_;
	_tmp39_ = g_strdup ("");
	relative_path = _tmp39_;
	_tmp40_ = origin_dirs;
	_tmp41_ = nb_common_dirs;
	nb_remaining_origin_dirs = g_list_length (_tmp40_) - _tmp41_;
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp42_ = FALSE;
			_tmp42_ = TRUE;
			while (TRUE) {
				guint _tmp44_;
				guint _tmp45_;
				const gchar* _tmp46_;
				gchar* _tmp47_;
				if (!_tmp42_) {
					guint _tmp43_;
					_tmp43_ = i;
					i = _tmp43_ + 1;
				}
				_tmp42_ = FALSE;
				_tmp44_ = i;
				_tmp45_ = nb_remaining_origin_dirs;
				if (!(_tmp44_ < _tmp45_)) {
					break;
				}
				_tmp46_ = relative_path;
				_tmp47_ = g_strconcat (_tmp46_, "../", NULL);
				_g_free0 (relative_path);
				relative_path = _tmp47_;
			}
		}
	}
	{
		guint i = 0U;
		guint _tmp48_;
		_tmp48_ = nb_common_dirs;
		i = _tmp48_;
		{
			gboolean _tmp49_ = FALSE;
			_tmp49_ = TRUE;
			while (TRUE) {
				guint _tmp51_;
				GList* _tmp52_;
				GFile* cur_target_dir = NULL;
				GList* _tmp53_;
				guint _tmp54_;
				gconstpointer _tmp55_;
				GFile* _tmp56_;
				const gchar* _tmp57_;
				GFile* _tmp58_;
				gchar* _tmp59_;
				gchar* _tmp60_;
				gchar* _tmp61_;
				gchar* _tmp62_;
				gchar* _tmp63_;
				if (!_tmp49_) {
					guint _tmp50_;
					_tmp50_ = i;
					i = _tmp50_ + 1;
				}
				_tmp49_ = FALSE;
				_tmp51_ = i;
				_tmp52_ = target_dirs;
				if (!(_tmp51_ < g_list_length (_tmp52_))) {
					break;
				}
				_tmp53_ = target_dirs;
				_tmp54_ = i;
				_tmp55_ = g_list_nth_data (_tmp53_, _tmp54_);
				_tmp56_ = _g_object_ref0 ((GFile*) _tmp55_);
				cur_target_dir = _tmp56_;
				_tmp57_ = relative_path;
				_tmp58_ = cur_target_dir;
				_tmp59_ = g_file_get_basename (_tmp58_);
				_tmp60_ = _tmp59_;
				_tmp61_ = g_strconcat (_tmp60_, "/", NULL);
				_tmp62_ = _tmp61_;
				_tmp63_ = g_strconcat (_tmp57_, _tmp62_, NULL);
				_g_free0 (relative_path);
				relative_path = _tmp63_;
				_g_free0 (_tmp62_);
				_g_free0 (_tmp60_);
				_g_object_unref0 (cur_target_dir);
			}
		}
	}
	_tmp64_ = relative_path;
	_tmp65_ = g_file_get_basename (target);
	_tmp66_ = _tmp65_;
	_tmp67_ = g_strconcat (_tmp64_, _tmp66_, NULL);
	_g_free0 (relative_path);
	relative_path = _tmp67_;
	_g_free0 (_tmp66_);
	result = relative_path;
	__g_list_free__g_object_unref0_0 (origin_dirs);
	__g_list_free__g_object_unref0_0 (target_dirs);
	_g_object_unref0 (target_parent);
	_g_object_unref0 (origin_dir);
	return result;
}


/*************************************************************************/
GtkScrolledWindow*
utils_add_scrollbar (GtkWidget* child)
{
	GtkScrolledWindow* result = NULL;
	GtkScrolledWindow* sw = NULL;
	GtkScrolledWindow* _tmp0_;
	g_return_val_if_fail (child != NULL, NULL);
	_tmp0_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	g_object_ref_sink (_tmp0_);
	sw = _tmp0_;
	gtk_container_add ((GtkContainer*) sw, child);
	result = sw;
	return result;
}


static void
_vala_GtkTreePath_free (GtkTreePath* self)
{
	g_boxed_free (gtk_tree_path_get_type (), self);
}


gboolean
utils_tree_model_iter_prev (GtkTreeModel* model, 
                            GtkTreeIter* iter)
{
	gboolean result = FALSE;
	GtkTreePath* path = NULL;
	GtkTreeIter _tmp0_;
	GtkTreePath* _tmp1_;
	GtkTreePath* _tmp2_;
	g_return_val_if_fail (model != NULL, FALSE);
	g_return_val_if_fail (iter != NULL, FALSE);
	_tmp0_ = *iter;
	_tmp1_ = gtk_tree_model_get_path (model, &_tmp0_);
	path = _tmp1_;
	_tmp2_ = path;
	if (gtk_tree_path_prev (_tmp2_)) {
		gboolean ret = FALSE;
		GtkTreePath* _tmp3_;
		GtkTreeIter _tmp4_ = {0};
		gboolean _tmp5_;
		_tmp3_ = path;
		_tmp5_ = gtk_tree_model_get_iter (model, &_tmp4_, _tmp3_);
		*iter = _tmp4_;
		ret = _tmp5_;
		result = ret;
		__vala_GtkTreePath_free0 (path);
		return result;
	}
	result = FALSE;
	__vala_GtkTreePath_free0 (path);
	return result;
}


gint
utils_get_selected_row (GtkTreeView* view, 
                        GtkTreeIter* iter)
{
	GtkTreeIter _vala_iter = {0};
	gint result = 0;
	GtkTreeSelection* select = NULL;
	GtkTreeSelection* _tmp0_;
	GtkTreeSelection* _tmp1_;
	GtkTreeSelection* _tmp2_;
	GtkTreeIter _tmp3_ = {0};
	gboolean _tmp4_;
	g_return_val_if_fail (view != NULL, 0);
	_tmp0_ = gtk_tree_view_get_selection (view);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	select = _tmp1_;
	_tmp2_ = select;
	_tmp4_ = gtk_tree_selection_get_selected (_tmp2_, NULL, &_tmp3_);
	_vala_iter = _tmp3_;
	if (_tmp4_) {
		GtkTreeModel* model = NULL;
		GtkTreeModel* _tmp5_;
		GtkTreeModel* _tmp6_;
		GtkTreePath* path = NULL;
		GtkTreeModel* _tmp7_;
		GtkTreeIter _tmp8_;
		GtkTreePath* _tmp9_;
		GtkTreePath* _tmp10_;
		gint _tmp11_;
		gint* _tmp12_;
		gint _tmp13_;
		_tmp5_ = gtk_tree_view_get_model (view);
		_tmp6_ = _g_object_ref0 (_tmp5_);
		model = _tmp6_;
		_tmp7_ = model;
		_tmp8_ = _vala_iter;
		_tmp9_ = gtk_tree_model_get_path (_tmp7_, &_tmp8_);
		path = _tmp9_;
		_tmp10_ = path;
		_tmp12_ = gtk_tree_path_get_indices_with_depth (_tmp10_, &_tmp11_);
		_tmp13_ = _tmp12_[0];
		result = _tmp13_;
		__vala_GtkTreePath_free0 (path);
		_g_object_unref0 (model);
		_g_object_unref0 (select);
		if (iter) {
			*iter = _vala_iter;
		}
		return result;
	}
	result = -1;
	_g_object_unref0 (select);
	if (iter) {
		*iter = _vala_iter;
	}
	return result;
}


GtkWindow*
utils_get_toplevel_window (GtkWidget* widget)
{
	GtkWindow* result = NULL;
	GtkWidget* toplevel = NULL;
	GtkWidget* _tmp0_;
	GtkWidget* _tmp1_;
	g_return_val_if_fail (widget != NULL, NULL);
	_tmp0_ = gtk_widget_get_toplevel (widget);
	toplevel = _tmp0_;
	_tmp1_ = toplevel;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, gtk_window_get_type ())) {
		GtkWidget* _tmp2_;
		_tmp2_ = toplevel;
		result = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, gtk_window_get_type ()) ? ((GtkWindow*) _tmp2_) : NULL;
		return result;
	}
	result = NULL;
	return result;
}


/*************************************************************************/
void
utils_flush_queue (void)
{
	while (TRUE) {
		if (!gtk_events_pending ()) {
			break;
		}
		gtk_main_iteration ();
	}
}



