/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 8; tab-width: 8 -*- */
/* egg-asn1.h - ASN.1/DER parsing and encoding routines

   Copyright (C) 2009 Stefan Walter

   The Gnome Keyring Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The Gnome Keyring Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the Gnome Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.

   Author: Stef Walter <stef@memberwebs.com>
*/

#ifndef EGG_ASN1X_H_
#define EGG_ASN1X_H_

#include <glib.h>

#include <libtasn1.h>


#ifndef HAVE_EGG_ALLOCATOR
typedef void* (*EggAllocator) (void* p, gsize);
#define HAVE_EGG_ALLOCATOR
#endif

typedef gboolean (*EggAsn1xEncoder) (gpointer data, guchar *buf, gsize n_buf);

GNode*              egg_asn1x_create                 (const ASN1_ARRAY_TYPE *defs,
                                                      const gchar *type);

void                egg_asn1x_dump                   (GNode *asn);

void                egg_asn1x_clear                  (GNode *asn);

gboolean            egg_asn1x_decode                 (GNode *asn,
                                                      gconstpointer data,
                                                      gsize n_data);

gboolean            egg_asn1x_validate               (GNode *asn);

gpointer            egg_asn1x_encode                 (GNode *asn,
                                                      EggAllocator allocator,
                                                      gsize *n_data);

const gchar*        egg_asn1x_message                (GNode *asn);

GNode*              egg_asn1x_node                   (GNode *asn,
                                                      ...) G_GNUC_NULL_TERMINATED;

gboolean            egg_asn1x_get_boolean            (GNode *node,
                                                      gboolean *value);

gboolean            egg_asn1x_set_boolean            (GNode *node,
                                                      gboolean value);

gboolean            egg_asn1x_get_integer_as_ulong   (GNode *node,
                                                      gulong *value);

gboolean            egg_asn1x_set_integer_as_ulong   (GNode *node,
                                                      gulong value);

gconstpointer       egg_asn1x_get_raw_value          (GNode *node,
                                                      gsize *n_content);

gboolean            egg_asn1x_set_raw_value          (GNode *node,
                                                      gsize length,
                                                      EggAsn1xEncoder encoder,
                                                      gpointer user_data,
                                                      GDestroyNotify destroy);

guchar*             egg_asn1x_get_string_as_raw      (GNode *node,
                                                      EggAllocator allocator,
                                                      gsize *n_string);

gboolean            egg_asn1x_set_string_as_raw      (GNode *node,
                                                      guchar *data,
                                                      gsize n_data,
                                                      GDestroyNotify destroy);

gchar*              egg_asn1x_get_string_as_utf8     (GNode *node,
                                                      EggAllocator allocator);

gboolean            egg_asn1x_set_string_as_utf8     (GNode *node,
                                                      gchar *data,
                                                      GDestroyNotify destroy);

glong               egg_asn1x_get_time_as_long       (GNode *node);

glong               egg_asn1x_set_time_as_long       (GNode *node);

GQuark              egg_asn1x_get_oid_as_quark       (GNode *node);

gboolean            egg_asn1x_set_oid_as_quark       (GNode *node,
                                                      GQuark oid);

gchar*              egg_asn1x_get_oid_as_string      (GNode *node);

gboolean            egg_asn1x_set_oid_as_string      (GNode *node,
                                                      const gchar *oid);

void                egg_asn1x_destroy                (gpointer asn);

#endif /*EGG_ASN1X_H_*/
