; Aisleriot - yukon.scm
; Copyright (C) 1998 Rosanna Yuen <rwsy@mit.edu>

(define (new-game)
  (initialize-playing-area)

					;set up the cards
  (make-standard-deck)
  (shuffle-deck)
  
					;set up the board
  (add-normal-slot DECK)
  (add-blank-slot)
  (add-extended-slot '() down)
  (add-extended-slot '() down)
  (add-extended-slot '() down)
  (add-extended-slot '() down)
  (add-extended-slot '() down)
  (add-extended-slot '() down)
  (add-extended-slot '() down)
  (add-carriage-return-slot)
  (add-normal-slot '())
  (add-carriage-return-slot)
  (add-normal-slot '())
  (add-carriage-return-slot)
  (add-normal-slot '())


  (deal-cards 0 '(1 2 3 4 5 6 7 2 3 4 5 6 7 3 4 5 6 7 4 5 6 7 5 6 7 6 7 7))

  (flip-top-card 1)
  (flip-top-card 2)
  (flip-top-card 3)
  (flip-top-card 4)
  (flip-top-card 5)
  (flip-top-card 6)
  (flip-top-card 7)

  (deal-cards 0 '(2 3 4 5 6 7))
  (flip-top-card 2)
  (flip-top-card 3)
  (flip-top-card 4)
  (flip-top-card 5)
  (flip-top-card 6)
  (flip-top-card 7)
  (deal-cards 0 '(2 3 4 5 6 7))
  (flip-top-card 2)
  (flip-top-card 3)
  (flip-top-card 4)
  (flip-top-card 5)
  (flip-top-card 6)
  (flip-top-card 7)
  (deal-cards 0 '(2 3 4 5 6 7))
  (flip-top-card 2)
  (flip-top-card 3)
  (flip-top-card 4)
  (flip-top-card 5)
  (flip-top-card 6)
  (flip-top-card 7)
  (deal-cards 0 '(2 3 4 5 6 7))
  (flip-top-card 2)
  (flip-top-card 3)
  (flip-top-card 4)
  (flip-top-card 5)
  (flip-top-card 6)
  (flip-top-card 7)

  (list 9 4))

(define (button-pressed slot-id card-list)
  (if (and card-list
	   (> slot-id 0)
	   (< slot-id 8)
	   (is-visible? (car (reverse card-list))))
      #t
      #f))
      
(define (complete-transaction start-slot card-list end-slot)
  (move-n-cards! start-slot end-slot card-list)
  (if (or (= end-slot 0)
	  (> end-slot 7))
      (add-to-score! 1))
  (if (not (empty-slot? start-slot))
      (make-visible-top-card start-slot)))

(define (button-released start-slot card-list end-slot)
  (cond ((and (= (length card-list) 1)
	      (or (= end-slot 0)
		  (> end-slot 7)))
	 (cond ((and (= (get-value (car card-list)) ace)
		     (empty-slot? end-slot))
		(complete-transaction start-slot card-list end-slot))
	       ((and (not (empty-slot? end-slot))
		     (= (get-suit (get-top-card end-slot))
			(get-suit (car card-list)))
		     (= (+ 1 (get-value (get-top-card end-slot)))
			(get-value (car card-list))))
		(complete-transaction start-slot card-list end-slot))
	       (#t #f)))
	((and (> end-slot 0)
	      (< end-slot 8))
	 (cond ((and (empty-slot? end-slot)
		     (= (get-value (car (reverse card-list))) king))
		(complete-transaction start-slot card-list end-slot))
	       ((empty-slot? end-slot) #f)
	       ((and (eq? (is-black? (car (reverse card-list)))
			  (is-red? (get-top-card end-slot)))
		     (= (get-value (get-top-card end-slot))
			(+ 1 (get-value (car (reverse card-list))))))
		(complete-transaction start-slot card-list end-slot))
	       (#t #f)))
	(#t #f)))

(define (button-clicked slot-id)
  #f)

(define (button-double-clicked slot)
  (cond ((or (empty-slot? slot)
	     (= slot 0)
	     (> slot 7))
	 #f)
	((= (get-value (get-top-card slot)) ace)
	 (let ((top-card (get-top-card slot)))
	   (remove-card slot)
	   (cond ((empty-slot? 0)
		  (complete-transaction slot (list top-card) 0))
		 ((empty-slot? 8)
		  (complete-transaction slot (list top-card) 8))
		 ((empty-slot? 9)
		  (complete-transaction slot (list top-card) 9))
		 (#t
		  (complete-transaction slot (list top-card) 10)))))
      	((and (not (empty-slot? 0))
	      (= (get-suit (get-top-card 0))
		 (get-suit (get-top-card slot)))
	      (= (+ 1 (get-value (get-top-card 0)))
		 (get-value (get-top-card slot))))
	 (let ((top-card (get-top-card slot)))
	   (remove-card slot)
	   (complete-transaction slot (list top-card) 0)))
	((and (not (empty-slot? 8))
	      (= (get-suit (get-top-card 8))
		 (get-suit (get-top-card slot)))
	      (= (+ 1 (get-value (get-top-card 8)))
		 (get-value (get-top-card slot))))
	 (let ((top-card (get-top-card slot)))
	   (remove-card slot)
	   (complete-transaction slot (list top-card) 8)))
	((and (not (empty-slot? 9))
	      (= (get-suit (get-top-card 9))
		 (get-suit (get-top-card slot)))
	      (= (+ 1 (get-value (get-top-card 9)))
		 (get-value (get-top-card slot))))
	 (let ((top-card (get-top-card slot)))
	   (remove-card slot)
	   (complete-transaction slot (list top-card) 9)))
	((and (not (empty-slot? 10))
	      (= (get-suit (get-top-card 10))
		 (get-suit (get-top-card slot)))
	      (= (+ 1 (get-value (get-top-card 10)))
		 (get-value (get-top-card slot))))
	 (let ((top-card (get-top-card slot)))
	   (remove-card slot)
	   (complete-transaction slot (list top-card) 10)))
	(#t #f)))

(define (game-over)
  (if (and (= 13 (length (get-cards 0)))
	   (= 13 (length (get-cards 8)))
	   (= 13 (length (get-cards 9)))
	   (= 13 (length (get-cards 10))))
      #f
      #t))

(define (game-won)
  (if (and (= 13 (length (get-cards 0)))
	   (= 13 (length (get-cards 8)))
	   (= 13 (length (get-cards 9)))
	   (= 13 (length (get-cards 10))))
      #t
      #f))

(define (get-hint)
  #f)

(define (get-options) #f)

(define (apply-options options) #f)

(define (timeout) #f)

(set-lambda new-game button-pressed button-released button-clicked button-double-clicked game-over game-won get-hint get-options apply-options timeout)
