/* GNOME-DB Components
 * Copyright (C) 2000-2002 The GNOME Foundation.
 *
 * AUTHORS:
 *	Rodrigo Moya <rodrigo@gnome-db.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include <locale.h>

#include <libgda/libgda.h>
#include "gnome-db-intl.h"
#include "components-database.h"
#include "components-manager.h"

static GdaServer *component_factory = NULL;

static void initialize_component_factory (gpointer user_data);

int
main (int argc, char *argv[])
{

	setlocale (LC_ALL, "");
	bindtextdomain (GETTEXT_PACKAGE, GNOMEDB_LOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);

	/* initialize application */
	gnome_db_init ("gnome-db-components", VERSION, argc, argv);

	/* run application */
	gnome_db_main_run ((GdaInitFunc) initialize_component_factory, NULL);

	return 0;
}

/*
 * Callbacks
 */

static void
last_client_gone_cb (GdaServer *server, gpointer user_data)
{
	gda_log_message (_("No more clients. Terminating..."));
	gnome_db_main_quit ();
}

static void
last_component_unregistered_cb (GdaServer *server, gpointer user_data)
{
	gda_log_message (_("All components have been unregistered!! This shouldn't happen"));
}

/*
 * Private functions
 */

static void
initialize_component_factory (gpointer user_data)
{
	component_factory = gda_server_new ("OAFIID:GNOME_Database_UIComponentFactory");

	g_signal_connect (G_OBJECT (component_factory), "last_component_unregistered",
			  G_CALLBACK (last_component_unregistered_cb), NULL);
	g_signal_connect (G_OBJECT (component_factory), "last_client_gone",
			  G_CALLBACK (last_client_gone_cb), NULL);

	gda_server_register_component (component_factory,
				       GNOME_DB_ID_DATABASE,
				       COMPONENTS_TYPE_DATABASE);
	gda_server_register_component (component_factory,
				       GNOME_DB_ID_MANAGER,
				       COMPONENTS_TYPE_MANAGER);
}
