/*  GNOME-DB Front End
 *  Copyrigth (C) 2000 Rodrigo Moya
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <gnomedb-fe.h>

static guint prepare_app (void);

/*
 * Variables
 */
GtkWidget* glb_mainwin = NULL;

/* menu and toolbar verbs */
BonoboUIVerb frontend_verbs [] = {
	BONOBO_UI_VERB ("FileNewDatabase", fe_new_database_cb),
#if defined(HAVE_PERL)
	BONOBO_UI_VERB ("FileOpenPerlScript", fe_run_perl_cb),
#endif
	BONOBO_UI_VERB ("FileExit", fe_quit_cb),

	BONOBO_UI_VERB ("EditCut", fe_do_cut_clipboard_cb),
	BONOBO_UI_VERB ("EditCopy", fe_do_copy_clipboard_cb),
	BONOBO_UI_VERB ("EditPaste", fe_do_paste_clipboard_cb),
	BONOBO_UI_VERB ("ViewShortcutBar", fe_show_shortcut_bar_cb),

	BONOBO_UI_VERB ("ToolsSettings", fe_preferences_cb),

	BONOBO_UI_VERB ("HelpAbout", fe_about_cb),
	BONOBO_UI_VERB ("HelpLibgdaManual", fe_open_libgda_manual_cb),
	BONOBO_UI_VERB ("HelpGnomeDbManual", fe_open_gnome_db_manual_cb),
	BONOBO_UI_VERB ("HelpSubmitBug", gnome_db_submit_bug_cb),

	BONOBO_UI_VERB_END
};

int
main (int argc, char *argv[])
{
	gchar *icon_file;

	bindtextdomain (PACKAGE, GNOMELOCALEDIR);
	textdomain (PACKAGE);
	
	gnome_db_init("gnomedb-fe", VERSION, argc, argv);
	fe_config_load();
	
	icon_file = gnome_pixmap_file("gnome-db.png");
	gnome_window_icon_set_default_from_file(icon_file);

	/* run application */
	gnome_db_main((GtkFunction) prepare_app);
	g_free((gpointer) icon_file);

	return 0;
}

static guint
prepare_app (void)
{
	glb_mainwin = gnome_db_window_new ("gnomedb-fe",
					   GNOMEDB_DATADIR,
					   "gnomedb-fe.xml",
					   frontend_verbs,
					   NULL);
	gtk_signal_connect (GTK_OBJECT(glb_mainwin),
			    "close",
			    GTK_SIGNAL_FUNC(fe_quit_cb),
			    NULL);

	gnome_db_window_set_contents (GNOME_DB_WINDOW (glb_mainwin), fe_workarea_create ());
	gnome_db_window_show (GNOME_DB_WINDOW (glb_mainwin));

	/* set UI saved options */
	if (gda_config_get_boolean (GNOMEDB_FE_CONFIG_KEY_SAVE_WINDOW_POS))
		gnome_db_load_window_config ("MainWindow", glb_mainwin);

	if (gda_config_get_boolean (GNOMEDB_FE_CONFIG_KEY_SHOW_SHORTCUT_BAR))
		fe_workarea_show_shortcut ();
	else
		fe_workarea_hide_shortcut ();

	return FALSE;
}
