/* GNOME DB Front End
 * Copyright (C) 2000 Rodrigo Moya
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "gnomedb-fe.h"
#include "e-hpaned.h"

static GtkWidget* workarea = NULL;
static GtkWidget* workarea_shortcut = NULL;
static GtkWidget* workarea_notebook = NULL;

/*
 * Private functions
 */
static void
notebook_page_changed_cb (GtkNotebook *notebook, GtkNotebookPage *page, guint page_num, gpointer data)
{
	GtkWidget* w;

	g_return_if_fail(GTK_IS_NOTEBOOK(notebook));

	w = gtk_notebook_get_nth_page(notebook, page_num);
	if (GTK_IS_WIDGET(w)) gnome_db_control_widget_activate(GNOME_DB_CONTROL_WIDGET(w));
}

/*
 * Public functions
 */
GtkWidget *
fe_workarea_create (void)
{
	gchar* str;

	if (!GTK_IS_WIDGET(workarea)) {
		GtkWidget* dock_item;
		GList*     components;
      
		workarea = e_hpaned_new();
      
		/* add shortcut bar */
		workarea_shortcut = gnome_db_shortcut_new();
		e_paned_add1(E_PANED(workarea), workarea_shortcut);

		/* add buttons for all found components */
		components = gnome_db_config_get_shell_components();
		if (components) {
			GList*                  node;
			GnomeDbConfigComponent* com;
          
			for (node = g_list_first(components);
			     node != NULL;
			     node = g_list_next(node)) {
				com = (GnomeDbConfigComponent *) node->data;
				str = g_strdup_printf("%s/%s",
						      GNOMEDB_FE_CONFIG_SECTION_LOAD,
						      gnome_db_config_component_get_name(com));
				if (gda_config_has_key(str)) {
					gnome_db_shortcut_append(
						GNOME_DB_SHORTCUT(workarea_shortcut),
						gnome_db_config_component_get_description(com),
						gnome_db_config_component_get_name(com),
						gnome_db_config_component_get_icon(com),
						GTK_SIGNAL_FUNC(fe_activate_component_cb),
						g_strdup(gnome_db_config_component_get_name(com)));
				}
				g_free((gpointer) str);
			}
			gnome_db_config_component_free_list(components);
		}

		/* add notebook */
		workarea_notebook = gnome_db_new_notebook_widget();
		gtk_notebook_set_show_border(GTK_NOTEBOOK(workarea_notebook), FALSE);
		gtk_notebook_set_show_tabs(GTK_NOTEBOOK(workarea_notebook), FALSE);
		gtk_notebook_popup_disable(GTK_NOTEBOOK(workarea_notebook));
		e_paned_add2(E_PANED(workarea), workarea_notebook);
	}

	/* create the tab for the manager */
	if (gda_config_has_key(GNOMEDB_FE_CONFIG_SECTION_LOAD "/" GNOME_DB_OAFIID_CONNECTION))
		fe_activate_component_cb(NULL, GNOME_DB_OAFIID_CONNECTION);
	gtk_widget_show_all(workarea);

	return workarea;
}

void
fe_workarea_add_tab (GtkWidget *tab, const gchar *label)
{
	g_return_if_fail(GTK_IS_WIDGET(tab));
  
	gtk_notebook_append_page(GTK_NOTEBOOK(workarea_notebook), tab, gtk_label_new(label));
	//fe_workarea_activate_tab(tab);
}

void
fe_workarea_activate_tab (GtkWidget *tab)
{
	GtkWidget* w;
	gint       current;
  
	g_return_if_fail(GTK_IS_WIDGET(tab));
  
	current = gtk_notebook_get_current_page(GTK_NOTEBOOK(workarea_notebook));

	/* first, deactivate current component */
	w = gtk_notebook_get_nth_page(GTK_NOTEBOOK(workarea_notebook), current);
	if (GTK_IS_WIDGET(w)) {
		if (w == tab) return;
		bonobo_window_freeze(BONOBO_WINDOW(glb_mainwin));
		gnome_db_control_widget_deactivate(GNOME_DB_CONTROL_WIDGET(w));
		bonobo_window_thaw(BONOBO_WINDOW(glb_mainwin));
	}
  
	/* activate the new one */
	gtk_notebook_set_page(GTK_NOTEBOOK(workarea_notebook),
			      gtk_notebook_page_num(GTK_NOTEBOOK(workarea_notebook), tab));
	bonobo_window_freeze(BONOBO_WINDOW(glb_mainwin));
	gnome_db_control_widget_activate(GNOME_DB_CONTROL_WIDGET(tab));
	bonobo_window_thaw(BONOBO_WINDOW(glb_mainwin));
}

GtkWidget *
fe_workarea_get_current_tab (void)
{
	gint tab;

	g_return_val_if_fail(GTK_IS_NOTEBOOK(workarea_notebook), NULL);

	tab = gtk_notebook_get_current_page(GTK_NOTEBOOK(workarea_notebook));
	return gtk_notebook_get_nth_page(GTK_NOTEBOOK(workarea_notebook), tab);
}

void
fe_workarea_remove_tab (GtkWidget *tab)
{
	gint       page_num;
	GtkWidget* wid;
  
	g_return_if_fail(GTK_IS_NOTEBOOK(workarea_notebook));
	g_return_if_fail(GTK_IS_WIDGET(tab));
  
	/* deactivate this component */
	page_num = gtk_notebook_page_num(GTK_NOTEBOOK(workarea_notebook), tab);
	gtk_notebook_remove_page(GTK_NOTEBOOK(workarea_notebook), page_num);
	gnome_db_control_widget_deactivate(GNOME_DB_CONTROL_WIDGET(tab));

	/* activate the new component */
	wid = fe_workarea_get_current_tab();
	if (GTK_IS_WIDGET(wid)) {
		//gnome_db_control_widget_activate(GNOME_DB_CONTROL_WIDGET(wid));
	}
}

void
fe_workarea_show_shortcut (void)
{
	gtk_widget_show (workarea_shortcut);
}

void
fe_workarea_hide_shortcut (void)
{
	gtk_widget_hide (workarea_shortcut);
}

gboolean
fe_workarea_shortcut_is_visible (void)
{
	return GTK_WIDGET_VISIBLE (workarea_shortcut);
}
