/* GNOME DB libary
 * Copyright (C) 1999 Rodrigo Moya
 *
 * This Library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This Library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this Library; see the file COPYING.LIB.  If not,
 * write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#if !defined(__gnome_db_designer_h__)
#  define __gnome_db_designer_h__

#include <gtk/gtkctree.h>
#include <gtk/gtkvbox.h>
#include <libgnome/gnome-defs.h>
#include <gda-xml-database.h>

BEGIN_GNOME_DECLS

#define GNOME_DB_TYPE_DESIGNER            (gnome_db_designer_get_type())
#define GNOME_DB_DESIGNER(obj)            GTK_CHECK_CAST(obj, gnome_db_designer_get_type(), GnomeDbDesigner)
#define GNOME_DB_DESIGNER_CLASS(klass)    GTK_CHECK_CLASS_CAST(klass, gnome_db_designer_get_type(), GnomeDbDesignerClass)
#define GNOME_DB_IS_DESIGNER(obj)         GTK_CHECK_TYPE(obj, gnome_db_designer_get_type())
#define GNOME_DB_IS_DESIGNER_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), GNOME_DB_TYPE_DESIGNER))

typedef struct _GnomeDbDesigner        GnomeDbDesigner;
typedef struct _GnomeDbDesignerClass   GnomeDbDesignerClass;
typedef struct _GnomeDbDesignerPrivate GnomeDbDesignerPrivate;

struct _GnomeDbDesigner {
	GtkVBox                 parent;
	GnomeDbDesignerPrivate *priv;
};

struct _GnomeDbDesignerClass {
	GtkVBoxClass parent_class;
};

GtkType         gnome_db_designer_get_type      (void);

GtkWidget*      gnome_db_designer_new           (void);
GtkWidget*      gnome_db_designer_new_from_file (const gchar *filename);
GtkWidget*      gnome_db_designer_new_from_xml  (GdaXmlDatabase *xmldb);

void            gnome_db_designer_load_file     (GnomeDbDesigner *designer, const gchar *filename);
gboolean        gnome_db_designer_save          (GnomeDbDesigner *designer);
void            gnome_db_designer_refresh       (GnomeDbDesigner *designer);

GdaXmlDatabase* gnome_db_designer_get_database  (GnomeDbDesigner *designer);
const gchar*    gnome_db_designer_get_filename  (GnomeDbDesigner *designer);
void            gnome_db_designer_set_filename  (GnomeDbDesigner *designer,
						 const gchar *filename);

END_GNOME_DECLS

#endif
