/* GNOME DB library
 * Copyright (C) 1999-2000 Rodrigo Moya
 *
 * This Library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This Library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this Library; see the file COPYING.LIB.  If not,
 * write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
 
#if !defined(_GNOME_DB_H_)
#  define _GNOME_DB_H_

#include <gda-client.h>

#include <gnome-db-browser.h>
#include <gnome-db-combo.h>
#include <gnome-db-component.h>
#include <gnome-db-config.h>
#include <gnome-db-dataset.h>
#include <gnome-db-control-defprops.h>
#include <gnome-db-control-widget.h>
#include <gnome-db-control.h>
#include <gnome-db-designer.h>
#include <gnome-db-dsn-config.h>
#include <gnome-db-embeddable.h>
#include <gnome-db-entry.h>
#include <gnome-db-error.h>
#include <gnome-db-error-dlg.h>
#include <gnome-db-grid.h>
#include <gnome-db-icon-list.h>
#include <gnome-db-label.h>
#include <gnome-db-list.h>
#include <gnome-db-log-viewer.h>
#include <gnome-db-login.h>
#include <gnome-db-login-dlg.h>
#include <gnome-db-moniker.h>
#include <gnome-db-report.h>
#include <gnome-db-shortcut.h>
#include <gnome-db-util.h>
#include <gnome-db-window.h>

BEGIN_GNOME_DECLS

/*
 * Initialization
 */
void gnome_db_init (const gchar *app_id, const gchar *version, int nargs, char *args[]);
void gnome_db_main (GtkFunction ui_create_func);
#define gnome_db_main_quit() gtk_main_quit()

END_GNOME_DECLS

#endif
