/*  GNOME-DB Components
 *  Copyrigth (C) 2000 Rodrigo Moya
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <gnomedb-com.h>

static GList* last_commands = NULL;
static gint   max_last_command = 100;

GList *
components_config_get_last_commands (void)
{
	if (!last_commands) {
		gint cnt;
		
		/* load last commands */
		for (cnt = max_last_command; cnt > 0; cnt--) {
			gchar* str = g_strdup_printf("%s/Command%d", GNOME_DB_CONFIG_SECTION_LAST_COMMANDS, cnt);
			gchar* sql = gda_config_get_string(str);
			g_free((gpointer) str);
			if (sql) components_config_add_last_command(sql);
		}
	}
	return last_commands;
}

void
components_config_add_last_command (const gchar *cmd)
{
	static gint times_count = 0;
	
	g_return_if_fail(cmd != NULL);
	g_return_if_fail(strlen(cmd) > 1);
	
	/* remove last entry if we've reached "max_sql_command" */
	if (g_list_length(last_commands) >= max_last_command) {
		gchar* tmp;
		GList* node = g_list_last(last_commands);
		tmp = (gchar *) node->data;
		last_commands = g_list_remove(last_commands, node->data);
		g_free((gpointer) tmp);
	}
	last_commands = g_list_prepend(last_commands, g_strdup(cmd));
	
	times_count++;
	if (times_count > 10) {
		gint   cnt;
		GList* node;
		
		/* save list of commands each ten times we're called */
		for (cnt = 1, node = g_list_first(last_commands);
		     node != NULL;
		     node = g_list_next(node), cnt++) {
			gchar* str = g_strdup_printf("%s/Command%d", GNOME_DB_CONFIG_SECTION_LAST_COMMANDS, cnt);
			gda_config_set_string(str, (gchar *) node->data);
			g_free((gpointer) str);
		}
		times_count = 0;
	}
}

