/*  GNOME-DB Builder
 *  Copyrigth (C) 2000 Rodrigo Moya
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include <gnomedb-builder.h>

static guint prepare_app (void);

GnomeDbControl* builder_control = NULL;

int
main (int argc, char *argv) {
	bindtextdomain (PACKAGE, GNOMELOCALEDIR);
	textdomain (PACKAGE);
	
	gnome_db_init("gnomedb-builder", VERSION, argc, argv);
	
	/* run application */
	gnome_db_main((GtkFunction) prepare_app);
	return 0;
}

static guint
prepare_app (void) {
	/* create control factory */
	builder_control = gnome_db_control_new("OAFIID:GNOME_DB_Builder_ControlFactory",
	                                       builder_control_create_instance);
	if (!GNOME_DB_IS_CONTROL(builder_control)) {
		g_error(_("Could not initialize GNOME_DB_Builder control"));
	}
	return FALSE;
}
