/* GNOME DB library
 * Copyright (C) 1999-2000 Rodrigo Moya
 *
 * This Library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This Library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this Library; see the file COPYING.LIB.  If not,
 * write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
 
#if !defined(_GNOME_DB_H_)
#  define _GNOME_DB_H_

#include <gnome.h>

#include <gda-client.h>
#include <gnome-db-component.h>
#include <gnome-db-control-defprops.h>
#include <gnome-db-control-widget.h>
#include <gnome-db-control-instance.h>
#include <gnome-db-control.h>
#include <gnome-db-embeddable.h>
#include <gnome-db-moniker.h>

#include <gnome-db-browser.h>
#include <gnome-db-combo.h>
#include <gnome-db-config.h>
#include <gnome-db-dsn-config.h>
#include <gnome-db-error.h>
#include <gnome-db-error-dlg.h>
#include <gnome-db-grid.h>
#include <gnome-db-icon-list.h>
#include <gnome-db-dataset.h>
#include <gnome-db-log-viewer.h>
#include <gnome-db-list.h>
#include <gnome-db-login.h>
#include <gnome-db-login-dlg.h>
#include <gnome-db-report.h>
#include <gnome-db-designer.h>
#include <gnome-db-shortcut.h>
#include <gnome-db-util.h>
#include <gnome-db-window.h>

BEGIN_GNOME_DECLS

/*
 * Initialization
 */
void gnome_db_init (const gchar *app_id, const gchar *version, int nargs, char *args[]);
void gnome_db_main (GtkFunction ui_create_func);
#define gnome_db_main_quit() gtk_main_quit()

/*
 * Common widgets creation
 */
GtkWidget* gnome_db_new_button_widget             (gchar *);
GtkWidget* gnome_db_new_button_widget_with_pixmap (const gchar *, const gchar *);
GtkWidget* gnome_db_new_check_button_widget       (gchar *, gint );
GtkWidget* gnome_db_new_clist_widget              (gchar *[], gint );
GtkWidget* gnome_db_new_color_picker_widget       (void);
GtkWidget* gnome_db_new_ctree_widget              (gchar *[], gint );
GtkWidget* gnome_db_new_combo_widget              (void);
GtkWidget* gnome_db_new_entry_widget              (gint , gboolean );
GtkWidget* gnome_db_new_file_entry_widget         (const gchar *history_id);
GtkWidget* gnome_db_new_file_viewer_widget        (const gchar *file);
GtkWidget* gnome_db_new_font_picker_widget        (void);
GtkWidget* gnome_db_new_frame_widget              (const gchar *label);
GtkWidget* gnome_db_new_grid_widget               (Gda_Recordset *recset);
GtkWidget* gnome_db_new_icon_widget               (const gchar *);
GtkWidget* gnome_db_new_icon_list_widget          (void);
GtkWidget* gnome_db_new_label_widget              (const gchar *);
GtkWidget* gnome_db_new_menu_item_widget          (GtkMenu *menu, const gchar *label);
GtkWidget* gnome_db_new_notebook_widget           (void);
GtkWidget* gnome_db_new_option_menu_widget        (void);
GtkWidget* gnome_db_new_progress_bar_widget       (void);
GtkWidget* gnome_db_new_radio_button_widget       (const gchar *, GtkRadioButton *);
GtkWidget* gnome_db_new_scrolled_window_widget    (void);
GtkWidget* gnome_db_new_status_bar_widget         (void);
GtkWidget* gnome_db_new_table_widget              (guint cols, guint rows, gboolean homogenous);
GtkWidget* gnome_db_new_text_widget               (void);
GtkWidget* gnome_db_new_toolbar_widget            (GtkOrientation orientation,
                                                   GtkToolbarStyle style,
                                                   GnomeUIInfo uiinfo[],
                                                   gpointer user_data);
GtkWidget* gnome_db_new_tree_widget               (void);

/*
 * Repo IDs of the different GNOME-DB components
 */
#define GNOME_DB_REPO_COMPONENT       "IDL:BonoboControl/gnome-db-component:1.0"
#define GNOME_DB_REPO_CONTROL         "IDL:BonoboControl/gnome-db-control:1.0"
#define GNOME_DB_REPO_SHELL_COMPONENT "IDL:BonoboControl/gnome-db-shell-component:1.0"
#define GNOME_DB_REPO_LOG_VIEWER      "IDL:BonoboControl/gnome-db-log:1.0"
#define GNOME_DB_REPO_MANAGER         "IDL:BonoboControl/gnome-db-manager:1.0"
#define GNOME_DB_REPO_CONNECTION      "IDL:BonoboControl/gnome-db-connection:1.0"
#define GNOME_DB_REPO_HELP_VIEWER     "IDL:BonoboControl/gnome-db-help-viewer:1.0"
#define GNOME_DB_REPO_DESIGNER        "IDL:BonoboControl/gnome-db-designer:1.0"

#define GNOME_DB_OAFIID_LOG_VIEWER  "OAFIID:control:gnome-db-log:721d97c9-0a64-4722-9f28-7b6bdc595120"
#define GNOME_DB_OAFIID_MANAGER     "OAFIID:control:gnome-db-manager:69c316f9-944f-4a7d-8637-0fa545439138"
#define GNOME_DB_OAFIID_CONNECTION  "OAFIID:control:gnome-db-connection:c6967e5e-035e-48ff-9983-87966d81a0e2"
#define GNOME_DB_OAFIID_HELP_VIEWER "OAFIID:control:gnome-db-help-viewer:a792ef6d-162e-4846-96d9-8c0eda62f965"
#define GNOME_DB_OAFIID_DESIGNER    "OAFIID:control:gnome-db-designer:a85a2539-19e2-46fb-8cd4-fc2ddb03b034"

#define GNOME_DB_OAFIID_MONIKER_DATABASE_FACTORY "OAFIID:DatabaseMonikerFactory:70a47938-d4cd-4fae-a80b-699416dffba7"
#define GNOME_DB_OAFIID_MONIKER_DATABASE         "OAFIID:DatabaseMoniker:70a47938-d4cd-4fae-a80b-699416dffba7"

/*
 * Configuration sections
 */
#define GNOME_DB_CONFIG_SECTION_DESIGNER         "/gnome-db/Designer"
#define GNOME_DB_CONFIG_SECTION_HELP_VIEWER      "/gnome-db/HelpViewer"
#define GNOME_DB_CONFIG_SECTION_HELP_VIEWER_DOCS "/gnome-db/HelpViewer/Docs"
#define GNOME_DB_CONFIG_SECTION_LAST_CONNECTIONS "/gnome-db/LastConnections"
#define GNOME_DB_CONFIG_SECTION_LAST_COMMANDS    "/gnome-db/LastCommands"

#define GNOME_DB_CONFIG_KEY_HELP_VIEWER_HOME "/gnome-db/HelpViewer/Home"

END_GNOME_DECLS

#endif
