/* GNOME DB library
 * Copyright (C) 1999 Rodrigo Moya
 *
 * This Library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This Library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this Library; see the file COPYING.LIB.  If not,
 * write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#if !defined(__gnome_db_dsn_config_h__)
#  define __gnome_db_dsn_config_h__

BEGIN_GNOME_DECLS

#define GNOME_DB_TYPE_DSN_CONFIG            (gnome_db_dsn_config_get_type())
#define GNOME_DB_DSN_CONFIG(obj)            GTK_CHECK_CAST (obj, GNOME_DB_TYPE_DSN_CONFIG, GnomeDbDsnConfig)
#define GNOME_DB_DSN_CONFIG_CLASS(klass)    GTK_CHECK_CLASS_CAST (klass, GNOME_DB_TYPE_DSN_CONFIG, GnomeDbDsnConfigClass)
#define GNOME_DB_IS_DSN_CONFIG(obj)         GTK_CHECK_TYPE (obj, GNOME_DB_TYPE_DSN_CONFIG)
#define GNOME_DB_IS_DSN_CONFIG_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), GNOME_DB_TYPE_DSN_CONFIG))

typedef struct _GnomeDbDsnConfig      GnomeDbDsnConfig;
typedef struct _GnomeDbDsnConfigClass GnomeDbDsnConfigClass;

struct _GnomeDbDsnConfig
{
  GtkVBox    vbox;

  /* private */
  GtkWidget* gda_name_entry;
  GtkWidget* provider_entry;
  GtkWidget* dsn_entry;
  GtkWidget* description_entry;
  GtkWidget* user_entry;
  GtkWidget* config_entry;
  GtkWidget* global_button;
};

struct _GnomeDbDsnConfigClass
{
  GtkVBoxClass parent_class;
};

guint        gnome_db_dsn_config_get_type (void);
GtkWidget*   gnome_db_dsn_config_new      (const gchar *name);

void         gnome_db_dsn_config_clear    (GnomeDbDsnConfig *dsnconf);
gboolean     gnome_db_dsn_config_save     (GnomeDbDsnConfig *dsnconf);
gboolean     gnome_db_dsn_config_remove   (GnomeDbDsnConfig *dsnconf);

const gchar* gnome_db_dsn_config_get_name (GnomeDbDsnConfig *dsnconf);
void         gnome_db_dsn_config_set_name (GnomeDbDsnConfig *dsnconf, const gchar *name);

END_GNOME_DECLS

#endif
