/*  GNOME-DB Components
 *  Copyrigth (C) 2000 Rodrigo Moya
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "gnomedb-com.h"

static GdaConnectionPool* connection_pool = NULL;

/*
 * Callbacks
 */
static void
cnc_error_cb (GdaConnectionPool *pool, GdaConnection *cnc, GList *error_list, gpointer data)
{
	GtkWidget* error_dialog = NULL;

	g_return_if_fail(GDA_IS_CONNECTION_POOL(pool));
	g_return_if_fail(GDA_IS_CONNECTION(cnc));

	error_dialog = gnome_db_error_dialog_new (_("Error Viewer"));
	gnome_db_error_dialog_show_errors (GNOME_DB_ERROR_DIALOG (error_dialog),
	                                   error_list);
}

/*
 * Public functions
 */
GdaConnection *
components_connection_open (const gchar *name, const gchar *user, const gchar *password)
{
	GdaConnection* cnc;
	
	g_return_val_if_fail(name != NULL, NULL);

	connection_pool = components_connection_get_pool();

	/* open connection */
	cnc = gda_connection_pool_open_connection(connection_pool,
	                                          name,
	                                          user,
	                                          password);

	return (cnc);
}

void
components_connection_close (GdaConnection *cnc)
{
	g_return_if_fail(GDA_IS_CONNECTION(cnc));

	gda_connection_pool_close_connection(components_connection_get_pool(), cnc);
}

GdaConnectionPool *
components_connection_get_pool (void)
{
	if (!GDA_IS_CONNECTION_POOL (connection_pool)) {
		connection_pool = gda_connection_pool_new ();
		gtk_signal_connect (GTK_OBJECT (connection_pool),
				    "error",
				    GTK_SIGNAL_FUNC(cnc_error_cb),
				    NULL);
	}

	return connection_pool;
}
