/* GDA Manager
 * Copyright (C) 1998,1999 Michael Lausch
 * Copyright (C) 2000 Rodrigo Moya
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "gnomedb-mgr.h"

static void view_log_entry_cb    (GtkWidget *w, gpointer data);
static void view_provider_log_cb (GtkWidget *w, gpointer data);

static GtkWidget*  l_providers_tab = NULL;
static GnomeUIInfo providerstoolbar[] =
{
  { GNOME_APP_UI_ITEM, N_("Logs"), N_("View provider log"),
    view_provider_log_cb, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_MAIL, 0, 0, NULL },
  GNOMEUIINFO_SEPARATOR,
  { GNOME_APP_UI_ITEM, N_("New"), N_("Install a new GDA provider"),
    NULL, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_NEW, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("Edit"), N_("Edit selected provider"),
    NULL, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_PREF, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("Remove"), N_("Remove selected provider"),
    NULL, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_TRASH, 0, 0, NULL },
  GNOMEUIINFO_END
};
static GnomeUIInfo logviewertoolbar[] =
{
  { GNOME_APP_UI_ITEM, N_("View"), N_("View selected entry"),
    view_log_entry_cb, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_PROP, 0, 0, NULL },
  GNOMEUIINFO_END
};

/*
 * Private functions
 */
static void
fill_provider_list (GtkCList *clist)
{
  gchar* empty_string = "";
  gchar* row[4];
  GList* provider_list;
  GList* node;

  g_return_if_fail(GTK_IS_CLIST(clist));

  gtk_clist_freeze(clist);
  provider_list = gda_provider_list();
  node = g_list_first(provider_list);
  while (node)
    {
#if !defined(USING_OAF)
      gchar* type_exe = "exe";
      gchar* type_lib = "shlib";
      gchar* type_relay = "relay";
#endif

      Gda_Provider* provider = (Gda_Provider *) node->data;
      if (provider)
        {
          row[0] = GDA_PROVIDER_NAME(provider);
#if defined(USING_OAF)
          row[1] = GDA_PROVIDER_TYPE(provider);
#else
          if (GDA_PROVIDER_TYPE(provider) == GOAD_SERVER_EXE) row[1] = type_exe;
          else if (GDA_PROVIDER_TYPE(provider) == GOAD_SERVER_SHLIB) row[1] = type_lib;
	  else if (GDA_PROVIDER_TYPE(provider) == GOAD_SERVER_RELAY) row[1] = type_relay;
          else row[1] = empty_string;
#endif
          row[2] = GDA_PROVIDER_COMMENT(provider);
          row[3] = GDA_PROVIDER_LOCATION(provider);

          gtk_clist_append(GTK_CLIST(clist), (const gchar **) row);
        }
      node = g_list_next(node);
    }
  gda_provider_free_list(provider_list);
  gtk_clist_thaw(clist);
}

static void
view_log_entry_cb (GtkWidget *widget, gpointer data)
{
  g_return_if_fail(GNOME_DB_IS_LOG_VIEWER(data));
  gnome_db_log_viewer_show_current(GNOME_DB_LOG_VIEWER(data));
}

static void
view_provider_log_cb (GtkWidget *widget, gpointer data)
{
  GList* selected;

  g_return_if_fail(GTK_IS_CLIST(data));

  selected = GTK_CLIST(data)->selection;
  if (selected)
    {
      gchar* provider = 0;

      guint row = GPOINTER_TO_INT(selected->data);
      gtk_clist_get_text(GTK_CLIST(data), row, 0, &provider);
      if (provider)
        {
	  GtkWidget* dialog;
	  GtkWidget* table;
       	  GtkWidget* log_viewer;
	  GtkWidget* toolbar;
#if defined(USING_OAF)
	  gchar* filename = g_strdup_printf("/tmp/%s.log", provider);
#else
	  gchar* filename = g_strdup_printf("/tmp/%s-srv.log", provider);
#endif

	  /* create dialog */
	  dialog = gnome_dialog_new(filename, GNOME_STOCK_BUTTON_CLOSE, NULL);
	  gtk_widget_set_usize(dialog, 550, 300);
	  table = gnome_db_new_table_widget(2, 1, FALSE);
	  gtk_box_pack_start(GTK_BOX(GNOME_DIALOG(dialog)->vbox), table, 1, 1, 0);

	  log_viewer = gnome_db_log_viewer_new();
	  gtk_widget_show(log_viewer);
	  gtk_table_attach(GTK_TABLE(table), log_viewer, 0, 1, 0, 1,
			   GTK_FILL | GTK_SHRINK | GTK_EXPAND,
			   GTK_FILL | GTK_SHRINK | GTK_EXPAND,
			   3, 3);
	  gnome_db_log_viewer_load_file(GNOME_DB_LOG_VIEWER(log_viewer), filename);

	  toolbar = gnome_db_new_toolbar_widget(GTK_ORIENTATION_VERTICAL,
					      GTK_TOOLBAR_BOTH,
					      logviewertoolbar,
					      (gpointer) log_viewer);
	  gtk_table_attach(GTK_TABLE(table), toolbar, 1, 2, 0, 1, GTK_FILL, GTK_FILL, 3, 3);

	  /* run dialog */
	  g_free((gpointer) filename);
	  gtk_widget_show(dialog);
        }
    }
}

void
manager_gda_init_providers (void)
{
  static gboolean initialized = FALSE;
  GtkWidget* scroll;
  GtkWidget* clist;
  GtkWidget* frame;
  GtkWidget* toolbar;
  gchar*     col_titles[4] = { N_("Name"), N_("Type"), N_("Comments"), N_("Location") };

  if (!initialized)
    {
      /* add notebook tab */
      l_providers_tab = gnome_db_new_table_widget(4, 3, FALSE);
      gtk_notebook_append_page(GTK_NOTEBOOK(glb_Notebook),
			       l_providers_tab,
			       gtk_label_new(_("Providers")));
      scroll = gnome_db_new_scrolled_window_widget();
      gtk_table_attach(GTK_TABLE(l_providers_tab), scroll, 0, 3, 0, 3,
		       GTK_SHRINK | GTK_FILL | GTK_EXPAND,
		       GTK_SHRINK | GTK_FILL | GTK_EXPAND,
		       3, 3);
      clist = gnome_db_new_clist_widget(col_titles, 4);
      fill_provider_list(GTK_CLIST(clist));
      gtk_container_add(GTK_CONTAINER(scroll), clist);
      
      toolbar = gnome_db_new_toolbar_widget(GTK_ORIENTATION_VERTICAL,
					  GTK_TOOLBAR_BOTH,
					  providerstoolbar,
					  (gpointer) clist);
      gtk_table_attach(GTK_TABLE(l_providers_tab), toolbar, 3, 4, 0, 3, GTK_FILL, GTK_FILL, 3, 3);
    }
  manager_gda_activate_providers();
}

void
manager_gda_activate_providers (void)
{
  gtk_notebook_set_page(GTK_NOTEBOOK(glb_Notebook),
			gtk_notebook_page_num(GTK_NOTEBOOK(glb_Notebook),
					      l_providers_tab));
}
