/* GNOME DB libary
 * Copyright (C) 1998,1999 Michael Lausch
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __gda_dblogindlg_h__
#define __gda_dblogindlg_h__ 1

#include <gnome.h>
#include <gda-connection.h>
#include "gnome-db-error-dlg.h"
#include "gnome-db-login.h"

BEGIN_GNOME_DECLS

#define GNOME_DB_TYPE_LOGINDLG            (gnome_db_logindlg_get_type())
#define GNOME_DB_LOGINDLG(obj)            (GTK_CHECK_CAST((obj), GNOME_DB_TYPE_LOGINDLG, GnomeDbLoginDlg))
#define GNOME_DB_LOGINDLG_CLASS(klass)    (GTK_CHECK_CLASS_CAST ((klass), GNOME_DB_TYPE_LOGINDLG, GnomeDbLoginDlgClass))
#define GNOME_DB_IS_LOGINDLG(obj)         GTK_CHECK_TYPE(obj, GNOME_DB_TYPE_LOGINDLG)
#define GNOME_DB_IS_LOGINDLG_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), GNOME_DB_TYPE_LOGINDLG))

typedef struct _GnomeDbLoginDlg           GnomeDbLoginDlg;
typedef struct _GnomeDbLoginDlgClass      GnomeDbLoginDlgClass;

struct _GnomeDbLoginDlg
{
  GnomeDialog      dialog;
  GnomeDbLogin*    login;
  GnomeDbErrorDlg* error;
};

struct _GnomeDbLoginDlgClass
{
  GnomeDialogClass parent_class;
  void             (*login)(GnomeDbLoginDlg* login);
  void             (*cancel)(GnomeDbLoginDlg* login);
};

guint      gnome_db_logindlg_get_type (void);

GtkWidget* gnome_db_logindlg_new      (GnomeDbLogin* login, gchar* title);
void       gnome_db_logindlg_popup    (GnomeDbLoginDlg* dialog);
void       gnome_db_logindlg_free     (GnomeDbLoginDlg* dialog);

END_GNOME_DECLS

#endif
