/* GNOME DB components libary
 * Copyright (C) 2000 Rodrigo Moya
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#if !defined(__gnome_db_embeddable_h__)
#  define __gnome_db_embeddable_h__

#include <gnome.h>
#include <bonobo.h>

BEGIN_GNOME_DECLS

#define GNOME_DB_TYPE_EMBEDDABLE            (gnome_db_embeddable_get_type())
#define GNOME_DB_EMBEDDABLE(obj)            GTK_CHECK_CAST(obj, GNOME_DB_TYPE_EMBEDDABLE, GnomeDbEmbeddable)
#define GNOME_DB_EMBEDDABLE_CLASS(klass)    GTK_CHECK_CLASS_CAST(klass, GNOME_DB_TYPE_EMBEDDABLE, GnomeDbEmbeddableClass)
#define GNOME_DB_IS_EMBEDDABLE(obj)         GTK_CHECK_TYPE(obj, GNOME_DB_TYPE_EMBEDDABLE)
#define GNOME_DB_IS_EMBEDDABLE_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), GNOME_DB_TYPE_EMBEDDABLE))

typedef struct _GnomeDbEmbeddable      GnomeDbEmbeddable;
typedef struct _GnomeDbEmbeddableClass GnomeDbEmbeddableClass;

struct _GnomeDbEmbeddable
{
  BonoboObject bonobo_object;
};

struct _GnomeDbEmbeddableClass
{
  BonoboObjectClass object_class;
};

GtkType gnome_db_embeddable_get_type (void);

#endif