/*  GNOME-DB Front End
 *  Copyrigth (C) 2000 Rodrigo Moya
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <gnomedb-fe.h>

static void close_service_manager_cb (GtkWidget *w, FE_ServiceManagerInfo *service_info);
static void refresh_service_list_cb  (GtkWidget *w, FE_ServiceManagerInfo *service_info);

GnomeUIInfo glb_servicemgr_toolbox[] =
{
  { GNOME_APP_UI_ITEM, N_("Start"), N_("Start selected service"),
    NULL, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_PIXMAP_OPEN, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("Stop"), N_("Stop selected service"),
    NULL, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_PIXMAP_STOP, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("Refresh"), N_("Refresh service list"),
    refresh_service_list_cb, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_PIXMAP_REFRESH, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("Close"), N_("Close database designer"),
    close_service_manager_cb, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_PIXMAP_CLOSE, 0, 0, NULL },
  GNOMEUIINFO_END
};

/*
 * Private functions
 */
static void
fill_service_list (FE_ServiceManagerInfo *service_info)
{
  OAF_ServerInfoList* servlist;
  CORBA_Environment   ev;
  
  g_return_if_fail(service_info != NULL);
  g_return_if_fail(GTK_IS_CLIST(service_info->service_list));
  
  /* get list of available services */
  CORBA_exception_init(&ev);
  servlist = oaf_query("repo_ids.has('IDL:GDA/ConnectionFactory:1.0') OR "
                       "repo_ids.has('IDL:BonoboControl/gnome-db-component:1.0')", NULL, &ev);
  
  /* fill in the on-screen list */
  gnome_db_clear_clist(GTK_CLIST(service_info->service_list));
  gtk_clist_freeze(GTK_CLIST(service_info->service_list));
  if (servlist)
    {
      gint i;
      
      for (i = 0; i < servlist->_length; i++)
        {
          gchar* row[3];
          
          row[0] = "";
          row[1] = servlist->_buffer[i].iid;
# if defined(USING_OLD_OAF)
	     row[2] = gda_corba_get_oaf_attribute(servlist->_buffer[i].attrs, "description");
# else
	     row[2] = gda_corba_get_oaf_attribute(servlist->_buffer[i].props, "description");
# endif
          gtk_clist_append(GTK_CLIST(service_info->service_list), row);
          g_free((gpointer) row[2]);
        }
    }
  else gnome_db_show_error(_("No services available"));
  gtk_clist_thaw(GTK_CLIST(service_info->service_list));
  CORBA_exception_free(&ev);
}

/*
 * Callbacks
 */
static void
close_service_manager_cb (GtkWidget *w, FE_ServiceManagerInfo *service_info)
{
  g_return_if_fail(service_info != NULL);
  
  fe_workarea_remove_tab(service_info->container);
  g_free((gpointer) service_info);
}

static void
refresh_service_list_cb (GtkWidget *w, FE_ServiceManagerInfo *service_info)
{
  g_return_if_fail(service_info != NULL);
  fill_service_list(service_info);
}

/*
 * Public functions
 */
FE_ServiceManagerInfo *
fe_service_manager_open (void)
{
  FE_ServiceManagerInfo* service_info;
  GtkWidget*             scroll;
  GtkWidget*             frame;
  const gchar*           clist_titles[] = { "", _("Name"), _("Description") };
  
  service_info = g_new0(FE_ServiceManagerInfo, 1);
  service_info->container = gnome_db_new_table_widget(2, 2, FALSE);
  
  /* add service list */
  scroll = gnome_db_new_scrolled_window_widget();
  gtk_table_attach(GTK_TABLE(service_info->container), scroll, 0, 2, 0, 1,
                   GTK_FILL | GTK_EXPAND | GTK_SHRINK,
                   GTK_FILL | GTK_EXPAND | GTK_SHRINK,
                   3, 3);
  service_info->service_list = gnome_db_new_clist_widget(clist_titles, 3);
  gtk_container_add(GTK_CONTAINER(scroll), service_info->service_list);
  fill_service_list(service_info);
  
  frame = gnome_db_new_frame_widget(_("Description"));
  gtk_table_attach(GTK_TABLE(service_info->container), frame, 0, 1, 1, 2,
                   GTK_FILL | GTK_EXPAND | GTK_SHRINK,
                   GTK_FILL | GTK_EXPAND | GTK_SHRINK,
                   3, 3);

  scroll = gnome_db_new_scrolled_window_widget();
  gtk_table_attach(GTK_TABLE(service_info->container), scroll, 1, 2, 1, 2,
                   GTK_FILL | GTK_EXPAND | GTK_SHRINK,
                   GTK_FILL | GTK_EXPAND | GTK_SHRINK,
                   3, 3);
  service_info->iid_list = gnome_db_new_clist_widget(NULL, 1);
  gtk_container_add(GTK_CONTAINER(scroll), service_info->iid_list);
  
  return service_info;
}