/*  GNOME-DB Front End
 *  Copyrigth (C) 2000 Rodrigo Moya
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <gnomedb-fe.h>

static guint prepare_app (void);

/*
 * Variables
 */
GtkWidget* glb_mainwin = NULL;
GnomeUIInfo filemenu[] =
{
  { GNOME_APP_UI_ITEM, N_("Open Connection..."), N_("Open a connection to a data source"),
    fe_open_connection_cb, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_CONVERT, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("Disconnect"), N_("Close current connection"),
    fe_close_connection_cb, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_STOP, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("Disconnect all"), N_("Close all connections"),
    fe_close_all_connections_cb, NULL, NULL, GNOME_APP_PIXMAP_NONE,
    NULL, 0, 0, NULL },
  GNOMEUIINFO_SEPARATOR,
  GNOMEUIINFO_MENU_PRINT_SETUP_ITEM(gnome_db_print_setup_dlg_cb, NULL),
  GNOMEUIINFO_SEPARATOR,
  { GNOME_APP_UI_ITEM, N_("Quit"), N_("Exit application"),
    fe_quit_cb, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_EXIT, 0, 0, NULL },
  GNOMEUIINFO_END
};
GnomeUIInfo databasemenu[] =
{
  { GNOME_APP_UI_ITEM, N_("SQL Window"), N_("SQL window"),
    fe_activate_connection_sql_cb, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_EXEC, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("Batch"), N_("Batch commands window"),
    fe_activate_connection_batch_cb, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_TIMER, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("Query Designer"), N_("Query designer"),
    NULL, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_INDEX, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("Browser"), N_("Browse database"),
    fe_activate_connection_browser_cb, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_PROP, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("Export"), N_("Export database"),
    NULL, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_REDO, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("Import"), N_("Import data into current database"),
    NULL, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_UNDO, 0, 0, NULL },
  GNOMEUIINFO_SEPARATOR,
  { GNOME_APP_UI_ITEM, N_("Begin transaction"), N_("Begin transaction"),
    fe_begin_transaction_cb, NULL, NULL, GNOME_APP_PIXMAP_NONE,
    NULL, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("Commit"), N_("Commit transaction"),
    fe_commit_transaction_cb, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_SAVE, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("Rollback"), N_("Discard all changes"),
    fe_rollback_transaction_cb, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_REVERT, 0, 0, NULL },
  GNOMEUIINFO_SEPARATOR,
  { GNOME_APP_UI_ITEM, N_("Connection Properties"), N_("View connection properties"),
    fe_view_connection_props_cb, NULL, NULL, GNOME_APP_PIXMAP_NONE,
    NULL, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("Configure"), N_("Configure underlying database"),
    fe_open_connection_config_cb, NULL, NULL, GNOME_APP_PIXMAP_NONE,
    NULL, 0, 0, NULL },
  GNOMEUIINFO_END
};
GnomeUIInfo toolsmenu[] =
{
  { GNOME_APP_UI_ITEM, N_("View logs"), N_("View the different logs"),
    fe_open_log_cb, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_MAIL, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("Database designer"), N_("Open the database designer"),
    fe_open_designer_cb, NULL, NULL, GNOME_APP_PIXMAP_NONE,
    NULL, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("Service manager"), N_("View service activity"),
    fe_open_service_manager_cb, NULL, NULL, GNOME_APP_PIXMAP_NONE,
    NULL, 0, 0, NULL },
  GNOMEUIINFO_SEPARATOR,
  { GNOME_APP_UI_ITEM, N_("GNOME-DB Manager"), N_("The GNOME-DB configuration tool"),
    fe_run_app_cb, "gnomedb-mgr", NULL, GNOME_APP_PIXMAP_NONE,
    NULL, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("GNOME-DB Builder"), N_("The GNOME-DB Development Environment"),
    fe_run_app_cb, "gnomedb-builder", NULL, GNOME_APP_PIXMAP_NONE,
    NULL, 0, 0, NULL },
  GNOMEUIINFO_END
};
GnomeUIInfo optionsmenu[] =
{
  { GNOME_APP_UI_ITEM, N_("Preferences..."), N_("Configure user preferences"),
    fe_open_config_cb, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_PREF, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("Data sources..."), N_("Configure GDA data sources"),
    fe_open_dsnconfig_cb, NULL, NULL, GNOME_APP_PIXMAP_NONE,
    NULL, 0, 0, NULL },
  GNOMEUIINFO_SEPARATOR,
  { GNOME_APP_UI_ITEM, N_("Save options"), N_("Save current configuration"),
    fe_save_config_cb, NULL, NULL, GNOME_APP_PIXMAP_NONE,
    NULL, 0, 0, NULL },
  GNOMEUIINFO_END
};
GnomeUIInfo helpmenu[] =
{
  { GNOME_APP_UI_ITEM, N_("About gnome-db..."), N_("About this program"),
    fe_about_cb, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_ABOUT, 0, 0, NULL },
  GNOMEUIINFO_SEPARATOR,
  { GNOME_APP_UI_ITEM, N_("Submit bug report"), N_("About this program"),
    gnome_db_submit_bug_cb, NULL, NULL, GNOME_APP_PIXMAP_NONE,
    NULL, 0, 0, NULL },
  GNOMEUIINFO_END
};
GnomeUIInfo mainmenu[] =
{
  GNOMEUIINFO_SUBTREE(N_("File"), filemenu),
  GNOMEUIINFO_SUBTREE(N_("Database"), databasemenu),
  GNOMEUIINFO_SUBTREE(N_("Tools"), toolsmenu),
  GNOMEUIINFO_SUBTREE(N_("Options"), optionsmenu),
  GNOMEUIINFO_SUBTREE(N_("Help"), helpmenu),
  GNOMEUIINFO_END
};
static GnomeUIInfo toolbar[] =
{
  { GNOME_APP_UI_ITEM, N_("Connect"), N_("Open a connection to a data source"),
    fe_open_connection_cb, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_CONVERT, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("Logs"), N_("View logs"),
    fe_open_log_cb, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_MAIL, 0, 0, NULL },
  GNOMEUIINFO_SEPARATOR,
  { GNOME_APP_UI_ITEM, N_("Preferences"), N_("Configure user preferences"),
    fe_open_config_cb, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_PREF, 0, 0, NULL },
  GNOMEUIINFO_SEPARATOR,
  { GNOME_APP_UI_ITEM, N_("Quit"), N_("Exit Application"),
    fe_quit_cb, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_EXIT, 0, 0, NULL },
  GNOMEUIINFO_END
};

int
main (int argc, char *argv[])
{
  bindtextdomain (PACKAGE, GNOMELOCALEDIR);
  textdomain (PACKAGE);
  
  gnome_db_init("gnomedb-fe", VERSION, argc, argv);
  fe_config_load();
    
  /* run application */
  gnome_db_main((GtkFunction) prepare_app);
  return 0;
}

static guint
prepare_app (void)
{
  glb_mainwin = gnome_db_container_new("gnomedb-fe", mainmenu, toolbar, NULL);
  gtk_signal_connect(GTK_OBJECT(glb_mainwin),
                     "close",
                     GTK_SIGNAL_FUNC(fe_quit_cb),
                     NULL);

  /* load configuration */
  gnome_db_load_window_config("MainWindow", gnome_db_container_get_widget(glb_mainwin));

  gnome_db_container_set_contents(GNOME_DB_CONTAINER(glb_mainwin), fe_workarea_create());
  gnome_db_container_show(GNOME_DB_CONTAINER(glb_mainwin));

  return FALSE;
}