/*  GNOME-DB Front End
 *  Copyrigth (C) 2000 Rodrigo Moya
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <gnomedb-fe.h>

typedef struct
{
  GtkWidget* dsnlist;
  GtkWidget* config;
} FE_DsnConfigInfo;

/*
 * Private functions
 */
static void
fill_dsn_list (GtkCList *clist)
{
  GList* dsnlist;
  GList* node;
  
  g_return_if_fail(GTK_IS_CLIST(clist));
  
  gnome_db_clear_clist(clist);
  dsnlist = node = gda_dsn_list();
  while (node)
    {
      gchar*   row[2];
      Gda_Dsn* dsn;
      
      dsn = (Gda_Dsn *) node->data;
      row[0] = "";
      row[1] = GDA_DSN_GDA_NAME(dsn);
      gtk_clist_append(clist, row);
      
      node = g_list_next(node);
    }
  gda_dsn_free_list(dsnlist);
}

/*
 * Callbacks
 */
static void
delete_dsn_cb (GtkButton *button, FE_DsnConfigInfo *dialog_info)
{
  g_return_if_fail(dialog_info != NULL);
  gnome_db_dsn_config_remove(GNOME_DB_DSN_CONFIG(dialog_info->config));
  fill_dsn_list(GTK_CLIST(dialog_info->dsnlist));
}

static void
new_dsn_cb (GtkButton *button, FE_DsnConfigInfo *dialog_info)
{
  g_return_if_fail(dialog_info != NULL);
  gnome_db_dsn_config_clear(GNOME_DB_DSN_CONFIG(dialog_info->config));
}

static void
save_dsn_cb (GtkButton *button, FE_DsnConfigInfo *dialog_info)
{
  g_return_if_fail(dialog_info != NULL);
  gnome_db_dsn_config_save(GNOME_DB_DSN_CONFIG(dialog_info->config));
  fill_dsn_list(GTK_CLIST(dialog_info->dsnlist));
}

static void
select_dsn_cb (GtkCList *clist,
               gint row,
               gint column,
               GdkEventButton *event,
               FE_DsnConfigInfo *dialog_info)
{
  gchar* txt = NULL;
  
  g_return_if_fail(GTK_IS_CLIST(clist));
  g_return_if_fail(dialog_info != NULL);
  
  if (gtk_clist_get_text(clist, row, 1, &txt))
    {
      gnome_db_dsn_config_set_name(GNOME_DB_DSN_CONFIG(dialog_info->config), txt);
    }
}

/*
 * Public functions
 */
void
fe_config_open_dsn (void)
{
  GtkWidget*        dialog;
  GtkWidget*        frame;
  GtkWidget*        table;
  GtkWidget*        scroll;
  GtkWidget*        button;
  FE_DsnConfigInfo* dialog_info;
  
  /* create data structure */
  dialog_info = g_new0(FE_DsnConfigInfo, 1);
  
  /* create dialog box */
  dialog = gnome_dialog_new(_("Data Sources"),
                            GNOME_STOCK_BUTTON_CLOSE,
                            NULL);
  gtk_widget_set_usize(dialog, 450, 300);
  frame = gnome_db_new_frame_widget(NULL);
  gtk_box_pack_start(GTK_BOX(GNOME_DIALOG(dialog)->vbox), frame, 1, 1, 0);
  table = gnome_db_new_table_widget(4, 2, FALSE);
  gtk_container_add(GTK_CONTAINER(frame), table);
  
  scroll = gnome_db_new_scrolled_window_widget();
  dialog_info->dsnlist = gnome_db_new_clist_widget(NULL, 2);
  gtk_signal_connect(GTK_OBJECT(dialog_info->dsnlist),
                     "select-row",
                     GTK_SIGNAL_FUNC(select_dsn_cb),
                     (gpointer) dialog_info);
  fill_dsn_list(GTK_CLIST(dialog_info->dsnlist));
  gtk_container_add(GTK_CONTAINER(scroll), dialog_info->dsnlist);
  gtk_table_attach(GTK_TABLE(table), scroll, 0, 1, 0, 2,
                   GTK_FILL | GTK_SHRINK | GTK_EXPAND,
                   GTK_FILL | GTK_SHRINK | GTK_EXPAND,
                   3, 3);
                   
  button = gnome_db_new_button_widget_with_pixmap(_("New"), GNOME_STOCK_MENU_NEW);
  gtk_table_attach(GTK_TABLE(table), button, 1, 2, 0, 1, GTK_FILL, GTK_FILL, 3, 3);
  gtk_signal_connect(GTK_OBJECT(button),
                     "clicked",
                     GTK_SIGNAL_FUNC(new_dsn_cb),
                     (gpointer) dialog_info);
  button = gnome_db_new_button_widget_with_pixmap(_("Delete"), GNOME_STOCK_MENU_TRASH);
  gtk_table_attach(GTK_TABLE(table), button, 2, 3, 0, 1, GTK_FILL, GTK_FILL, 3, 3);
  gtk_signal_connect(GTK_OBJECT(button),
                     "clicked",
                     GTK_SIGNAL_FUNC(delete_dsn_cb),
                     (gpointer) dialog_info);
  button = gnome_db_new_button_widget_with_pixmap(_("Save"), GNOME_STOCK_MENU_SAVE);
  gtk_table_attach(GTK_TABLE(table), button, 3, 4, 0, 1, GTK_FILL, GTK_FILL, 3, 3);
  gtk_signal_connect(GTK_OBJECT(button),
                     "clicked",
                     GTK_SIGNAL_FUNC(save_dsn_cb),
                     (gpointer) dialog_info);
  
  dialog_info->config = gnome_db_dsn_config_new(NULL);
  gtk_widget_show(dialog_info->config);
  gtk_table_attach(GTK_TABLE(table), dialog_info->config, 1, 4, 1, 2,
                   GTK_FILL | GTK_SHRINK | GTK_EXPAND,
                   GTK_FILL | GTK_SHRINK | GTK_EXPAND,
                   3, 3);
  
  /* run the dialog */
  gnome_dialog_run_and_close(GNOME_DIALOG(dialog));
  
  g_free((gpointer) dialog_info);
}