/*  GNOME-DB Front End
 *  Copyrigth (C) 2000 Rodrigo Moya
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <gnomedb-fe.h>

static void close_designer_cb (GtkWidget *w, FE_DesignerInfo *design_info);
static void open_designer_cb  (GtkWidget *w, FE_DesignerInfo *design_info);
static void revert_changes_cb (GtkWidget *w, FE_DesignerInfo *design_info);
static void save_designer_cb  (GtkWidget *w, FE_DesignerInfo *design_info);

GnomeUIInfo glb_designer_toolbox[] =
{
  { GNOME_APP_UI_ITEM, N_("Open"), N_("Load design from disk"),
    open_designer_cb, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_PIXMAP_OPEN, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("Save"), N_("Save design to disk"),
    save_designer_cb, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_PIXMAP_SAVE, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("Revert"), N_("Revert to last saved version"),
    revert_changes_cb, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_PIXMAP_UNDO, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("Close"), N_("Close database designer"),
    close_designer_cb, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_PIXMAP_CLOSE, 0, 0, NULL },
  GNOMEUIINFO_END
};

/*
 * Private functions
 */

/*
 * Callbacks
 */
static void
close_designer_cb (GtkWidget *w, FE_DesignerInfo *design_info)
{
  g_return_if_fail(design_info != NULL);
  
  fe_workarea_remove_tab(design_info->container);
  if (design_info->filename) g_free((gpointer) design_info->filename);
  g_free((gpointer) design_info);
}

static void
open_designer_cb (GtkWidget *w, FE_DesignerInfo *design_info)
{
  gchar* filename;
  
  g_return_if_fail(design_info != NULL);
  
  filename = gnome_db_select_file(_("Open XML database"));
  if (filename)
    {
      gnome_db_designer_load_file(GNOME_DB_DESIGNER(design_info->designer), filename);
      gnome_db_container_set_status(GNOME_DB_CONTAINER(glb_mainwin),
                                    _("Loaded file %s"), filename);
      design_info->filename = filename;
    }
}

static void
revert_changes_cb (GtkWidget *w, FE_DesignerInfo *design_info)
{
  g_return_if_fail(design_info != NULL);
  
  /* if we've got the filename, then there was a previously loaded/saved database */
  if (design_info->filename)
    {
      gnome_db_designer_load_file(GNOME_DB_DESIGNER(design_info->designer),
                                  design_info->filename);
      gnome_db_container_set_status(GNOME_DB_CONTAINER(glb_mainwin),
                                    _("%s reverted to previously saved version"),
                                    design_info->filename);
    }
}

static void
save_designer_cb (GtkWidget *w, FE_DesignerInfo *design_info)
{
  gboolean change_name = FALSE;
  gchar*   filename;
  
  g_return_if_fail(design_info != NULL);
  
  if (!(filename = design_info->filename))
    {
      change_name = TRUE;
      filename = gnome_db_select_file(_("Save Database"));
      if (!filename) return;
    }
  gda_xml_file_to_file(GDA_XML_FILE(gnome_db_designer_get_database(design_info->designer)),
                       filename);
  gnome_db_container_set_status(GNOME_DB_CONTAINER(glb_mainwin),
                                _("Loaded database from %s"), filename);
                       
  /* update file name if changed */
  if (change_name)
    {
      g_free((gpointer) design_info->filename);
      design_info->filename = filename;
    }
}

/*
 * Public functions
 */
FE_DesignerInfo *
fe_designer_open (void)
{
  FE_DesignerInfo* design_info;
  GtkWidget*       table;
  
  design_info = g_new0(FE_DesignerInfo, 1);
  design_info->container = gnome_db_new_frame_widget(NULL);
  table = gnome_db_new_table_widget(1, 2, FALSE);
  gtk_container_add(GTK_CONTAINER(design_info->container), table);
  
  design_info->designer = gnome_db_designer_new();
  gtk_widget_show(design_info->designer);
  gtk_table_attach(GTK_TABLE(table), design_info->designer, 0, 1, 1, 2,
                   GTK_FILL | GTK_SHRINK | GTK_EXPAND,
                   GTK_FILL | GTK_SHRINK | GTK_EXPAND,
                   3, 3);
                   
  return design_info;
}
