/*  GNOME-DB Front End
 *  Copyrigth (C) 2000 Rodrigo Moya
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <gnomedb-fe.h>

static GList* last_commands = NULL;
static gint   max_last_command = 100;

/*
 * Public functions
 */
void
fe_config_add_sql_command (const gchar *sql)
{
  g_return_if_fail(sql != NULL);
  g_return_if_fail(strlen(sql) > 1);
  
  /* remove last entry if we've reached "max_sql_command" */
  if (g_list_length(last_commands) >= max_last_command)
    {
      gchar* tmp;
      GList* node = g_list_last(last_commands);
      tmp = (gchar *) node->data;
      last_commands = g_list_remove(last_commands, node->data);
      g_free((gpointer) tmp);
    }
  last_commands = g_list_prepend(last_commands, g_strdup(sql));
}

GList *
fe_config_get_last_commands (void)
{
  return g_list_first(last_commands);
}

void
fe_config_load (void)
{
  gint cnt;
  
  /* load last commands */
  for (cnt = max_last_command; cnt > 0; cnt--)
    {
      gchar* str = g_strdup_printf("%s/Command%d", GNOMEDB_FE_CONFIG_SECTION_LAST_COMMANDS, cnt);
      gchar* sql = gda_config_get_string(str);
      g_free((gpointer) str);
      if (sql) fe_config_add_sql_command(sql);
    }
}

void
fe_config_save (void)
{
  gint   cnt;
  GList* node;

  /* save UI stuff */
  gnome_db_save_window_config("MainWindow",
                              gnome_db_container_get_widget(GNOME_DB_CONTAINER(glb_mainwin)));

  /* save last commands */
  for (cnt = 1, node = g_list_first(last_commands);
       node != NULL;
       node = g_list_next(node), cnt++)
    {
      gchar* str = g_strdup_printf("%s/Command%d", GNOMEDB_FE_CONFIG_SECTION_LAST_COMMANDS, cnt);
      gda_config_set_string(str, (gchar *) node->data);
      g_free((gpointer) str);
    }
  
  gda_config_commit();
}
