/*  GNOME-DB Components
 *  Copyrigth (C) 2000 Rodrigo Moya
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <gnomedb-com.h>

static GnomeDbControl* export_control = NULL;

/*
 * Callbacks
 */
static GtkWidget *
export_create_widget_cb (void)
{
}

static void
export_new_instance_cb (GnomeDbControl *control,
                         GnomeDbControlInstance *control_instance,
                         gpointer user_data)
{
  g_return_if_fail(GNOME_DB_IS_CONTROL(control));
  g_return_if_fail(control_instance != NULL);
  
  /* create control instance properties */
}

static void
export_set_property_cb (GnomeDbControl *control,
                        GnomeDbControlInstance *control_instance,
                        const gchar *name,
                        gpointer user_data)
{
  g_return_if_fail(GNOME_DB_IS_CONTROL(control));
  g_return_if_fail(control_instance != NULL);
  g_return_if_fail(name != NULL);
}

/*
 * Public functions
 */
void
components_export_init (void)
{
  if (!GNOME_DB_IS_CONTROL(export_control))
    {
      gchar* oafiid;

      oafiid = g_strdup("control-factory:gnome-db-export");
      
      /* register factory */
      export_control = gnome_db_control_new(oafiid, export_create_widget_cb);
      if (GNOME_DB_IS_CONTROL(export_control))
        {
          gtk_signal_connect(GTK_OBJECT(export_control),
                             "new_instance",
                             export_new_instance_cb,
                             NULL);
          gtk_signal_connect(GTK_OBJECT(export_control),
                             "set_property",
                             export_set_property_cb,
                             NULL);
        }
      else g_error(_("Could not initialize %s component"), oafiid);
      
      g_free((gpointer) oafiid);
    }
}