/* contacts-app.c generated by valac 0.18.0, the Vala compiler
 * generated from contacts-app.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: t; c-basic-offset: 2; tab-width: 8 -*- */
/*
 * Copyright (C) 2011 Alexander Larsson <alexl@redhat.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <folks/folks.h>
#include <glib/gi18n-lib.h>
#include <folks/folks-eds.h>
#include <contacts-esd-setup.h>
#include <libedataserver/libedataserver.h>
#include <config.h>
#include <gtk-notification.h>
#include <float.h>
#include <math.h>
#include <pango/pango.h>
#include <gee.h>


#define CONTACTS_TYPE_APP (contacts_app_get_type ())
#define CONTACTS_APP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_APP, ContactsApp))
#define CONTACTS_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_APP, ContactsAppClass))
#define CONTACTS_IS_APP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_APP))
#define CONTACTS_IS_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_APP))
#define CONTACTS_APP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_APP, ContactsAppClass))

typedef struct _ContactsApp ContactsApp;
typedef struct _ContactsAppClass ContactsAppClass;
typedef struct _ContactsAppPrivate ContactsAppPrivate;

#define CONTACTS_TYPE_WINDOW (contacts_window_get_type ())
#define CONTACTS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_WINDOW, ContactsWindow))
#define CONTACTS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_WINDOW, ContactsWindowClass))
#define CONTACTS_IS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_WINDOW))
#define CONTACTS_IS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_WINDOW))
#define CONTACTS_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_WINDOW, ContactsWindowClass))

typedef struct _ContactsWindow ContactsWindow;
typedef struct _ContactsWindowClass ContactsWindowClass;

#define CONTACTS_TYPE_STORE (contacts_store_get_type ())
#define CONTACTS_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_STORE, ContactsStore))
#define CONTACTS_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_STORE, ContactsStoreClass))
#define CONTACTS_IS_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_STORE))
#define CONTACTS_IS_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_STORE))
#define CONTACTS_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_STORE, ContactsStoreClass))

typedef struct _ContactsStore ContactsStore;
typedef struct _ContactsStoreClass ContactsStoreClass;

#define CONTACTS_TYPE_LIST_PANE (contacts_list_pane_get_type ())
#define CONTACTS_LIST_PANE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_LIST_PANE, ContactsListPane))
#define CONTACTS_LIST_PANE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_LIST_PANE, ContactsListPaneClass))
#define CONTACTS_IS_LIST_PANE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_LIST_PANE))
#define CONTACTS_IS_LIST_PANE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_LIST_PANE))
#define CONTACTS_LIST_PANE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_LIST_PANE, ContactsListPaneClass))

typedef struct _ContactsListPane ContactsListPane;
typedef struct _ContactsListPaneClass ContactsListPaneClass;

#define CONTACTS_TYPE_CONTACT_PANE (contacts_contact_pane_get_type ())
#define CONTACTS_CONTACT_PANE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_CONTACT_PANE, ContactsContactPane))
#define CONTACTS_CONTACT_PANE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_CONTACT_PANE, ContactsContactPaneClass))
#define CONTACTS_IS_CONTACT_PANE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_CONTACT_PANE))
#define CONTACTS_IS_CONTACT_PANE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_CONTACT_PANE))
#define CONTACTS_CONTACT_PANE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_CONTACT_PANE, ContactsContactPaneClass))

typedef struct _ContactsContactPane ContactsContactPane;
typedef struct _ContactsContactPaneClass ContactsContactPaneClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define CONTACTS_TYPE_CONTACT (contacts_contact_get_type ())
#define CONTACTS_CONTACT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_CONTACT, ContactsContact))
#define CONTACTS_CONTACT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_CONTACT, ContactsContactClass))
#define CONTACTS_IS_CONTACT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_CONTACT))
#define CONTACTS_IS_CONTACT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_CONTACT))
#define CONTACTS_CONTACT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_CONTACT, ContactsContactClass))

typedef struct _ContactsContact ContactsContact;
typedef struct _ContactsContactClass ContactsContactClass;
typedef struct _ContactsListPanePrivate ContactsListPanePrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block1Data Block1Data;
typedef struct _ContactsContactPrivate ContactsContactPrivate;
typedef struct _Block2Data Block2Data;
typedef struct _ContactsAppShowIndividualData ContactsAppShowIndividualData;
typedef struct _Block3Data Block3Data;
typedef struct _Block4Data Block4Data;
typedef struct _Block5Data Block5Data;
typedef struct _ContactsAppShowByEmailData ContactsAppShowByEmailData;

#define CONTACTS_TYPE_NEW_CONTACT_DIALOG (contacts_new_contact_dialog_get_type ())
#define CONTACTS_NEW_CONTACT_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_NEW_CONTACT_DIALOG, ContactsNewContactDialog))
#define CONTACTS_NEW_CONTACT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_NEW_CONTACT_DIALOG, ContactsNewContactDialogClass))
#define CONTACTS_IS_NEW_CONTACT_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_NEW_CONTACT_DIALOG))
#define CONTACTS_IS_NEW_CONTACT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_NEW_CONTACT_DIALOG))
#define CONTACTS_NEW_CONTACT_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_NEW_CONTACT_DIALOG, ContactsNewContactDialogClass))

typedef struct _ContactsNewContactDialog ContactsNewContactDialog;
typedef struct _ContactsNewContactDialogClass ContactsNewContactDialogClass;

#define CONTACTS_TYPE_LINK_OPERATION (contacts_link_operation_get_type ())
#define CONTACTS_LINK_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_LINK_OPERATION, ContactsLinkOperation))
#define CONTACTS_LINK_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_LINK_OPERATION, ContactsLinkOperationClass))
#define CONTACTS_IS_LINK_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_LINK_OPERATION))
#define CONTACTS_IS_LINK_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_LINK_OPERATION))
#define CONTACTS_LINK_OPERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_LINK_OPERATION, ContactsLinkOperationClass))

typedef struct _ContactsLinkOperation ContactsLinkOperation;
typedef struct _ContactsLinkOperationClass ContactsLinkOperationClass;

#define CONTACTS_TYPE_SETUP_WINDOW (contacts_setup_window_get_type ())
#define CONTACTS_SETUP_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_SETUP_WINDOW, ContactsSetupWindow))
#define CONTACTS_SETUP_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_SETUP_WINDOW, ContactsSetupWindowClass))
#define CONTACTS_IS_SETUP_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_SETUP_WINDOW))
#define CONTACTS_IS_SETUP_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_SETUP_WINDOW))
#define CONTACTS_SETUP_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_SETUP_WINDOW, ContactsSetupWindowClass))

typedef struct _ContactsSetupWindow ContactsSetupWindow;
typedef struct _ContactsSetupWindowClass ContactsSetupWindowClass;
typedef struct _Block6Data Block6Data;
typedef struct _ContactsSetupWindowPrivate ContactsSetupWindowPrivate;
typedef struct _Block7Data Block7Data;
typedef struct _Block8Data Block8Data;
typedef struct _Block9Data Block9Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))

struct _ContactsApp {
	GtkApplication parent_instance;
	ContactsAppPrivate * priv;
	GSettings* settings;
	ContactsWindow* window;
	ContactsStore* contacts_store;
};

struct _ContactsAppClass {
	GtkApplicationClass parent_class;
};

struct _ContactsAppPrivate {
	ContactsListPane* list_pane;
	ContactsContactPane* contacts_pane;
	GtkOverlay* overlay;
};

struct _ContactsListPane {
	GtkFrame parent_instance;
	ContactsListPanePrivate * priv;
	GtkEntry* filter_entry;
};

struct _ContactsListPaneClass {
	GtkFrameClass parent_class;
};

struct _Block1Data {
	int _ref_count_;
	ContactsApp * self;
	gchar* id;
	gpointer _async_data_;
};

typedef gboolean (*ContactsStoreContactMatcher) (ContactsContact* c, void* user_data);
struct _ContactsContact {
	GObject parent_instance;
	ContactsContactPrivate * priv;
	ContactsStore* store;
	gboolean is_main;
	FolksPresenceType presence_type;
	gchar* presence_message;
	gboolean is_phone;
	FolksIndividual* individual;
};

struct _ContactsContactClass {
	GObjectClass parent_class;
};

struct _Block2Data {
	int _ref_count_;
	Block1Data * _data1_;
	GtkMessageDialog* dialog;
};

struct _ContactsAppShowIndividualData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	ContactsApp* self;
	gchar* id;
	Block1Data* _data1_;
	const gchar* _tmp0_;
	ContactsStore* _tmp1_;
	ContactsContact* _tmp2_;
	ContactsContact* contact;
	ContactsContact* _tmp3_;
	ContactsListPane* _tmp4_;
	ContactsContact* _tmp5_;
	ContactsContactPane* _tmp6_;
	ContactsContact* _tmp7_;
	Block2Data* _data2_;
	ContactsApp* _tmp8_;
	ContactsWindow* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	GtkMessageDialog* _tmp12_;
	GtkMessageDialog* _tmp13_;
	const gchar* _tmp14_;
	GtkMessageDialog* _tmp15_;
	GtkMessageDialog* _tmp16_;
};

struct _Block3Data {
	int _ref_count_;
	ContactsApp * self;
	GtkDialog* dialog;
	GtkTreeView* tree_view;
	GtkListStore* store;
};

struct _Block4Data {
	int _ref_count_;
	ContactsApp * self;
	gchar* email_address;
	gpointer _async_data_;
};

struct _Block5Data {
	int _ref_count_;
	Block4Data * _data4_;
	GtkMessageDialog* dialog;
};

struct _ContactsAppShowByEmailData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	ContactsApp* self;
	gchar* email_address;
	Block4Data* _data4_;
	const gchar* _tmp0_;
	ContactsStore* _tmp1_;
	ContactsContact* _tmp2_;
	ContactsContact* contact;
	ContactsContact* _tmp3_;
	ContactsListPane* _tmp4_;
	ContactsContact* _tmp5_;
	ContactsContactPane* _tmp6_;
	ContactsContact* _tmp7_;
	Block5Data* _data5_;
	ContactsApp* _tmp8_;
	ContactsWindow* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	GtkMessageDialog* _tmp12_;
	GtkMessageDialog* _tmp13_;
	const gchar* _tmp14_;
	GtkMessageDialog* _tmp15_;
	GtkMessageDialog* _tmp16_;
};

struct _Block6Data {
	int _ref_count_;
	ContactsApp * self;
	ContactsSetupWindow* setup;
};

struct _ContactsSetupWindow {
	GtkWindow parent_instance;
	ContactsSetupWindowPrivate * priv;
	gboolean succeeded;
	GtkLabel* title_label;
	GtkGrid* content_grid;
};

struct _ContactsSetupWindowClass {
	GtkWindowClass parent_class;
};

struct _Block7Data {
	int _ref_count_;
	ContactsApp * self;
	gulong id;
	guint id2;
};

struct _Block8Data {
	int _ref_count_;
	ContactsApp * self;
	GtkNotification* notification;
	gboolean really_delete;
	ContactsContact* contact;
};

struct _Block9Data {
	int _ref_count_;
	ContactsApp * self;
	GtkNotification* notification;
	ContactsLinkOperation* operation;
};


static gpointer contacts_app_parent_class = NULL;
extern ContactsApp* contacts_app_app;
ContactsApp* contacts_app_app = NULL;
static gchar* contacts_app_individual_id;
static gchar* contacts_app_individual_id = NULL;
static gchar* contacts_app_email_address;
static gchar* contacts_app_email_address = NULL;

GType contacts_app_get_type (void) G_GNUC_CONST;
GType contacts_window_get_type (void) G_GNUC_CONST;
GType contacts_store_get_type (void) G_GNUC_CONST;
GType contacts_list_pane_get_type (void) G_GNUC_CONST;
GType contacts_contact_pane_get_type (void) G_GNUC_CONST;
#define CONTACTS_APP_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CONTACTS_TYPE_APP, ContactsAppPrivate))
enum  {
	CONTACTS_APP_DUMMY_PROPERTY
};
static gboolean contacts_app_window_delete_event (ContactsApp* self, GdkEventAny* event);
GType contacts_contact_get_type (void) G_GNUC_CONST;
void contacts_contact_pane_show_contact (ContactsContactPane* self, ContactsContact* new_contact, gboolean edit, gboolean show_matches);
static gboolean contacts_app_window_key_press_event (ContactsApp* self, GdkEventKey* event);
void contacts_utils_grab_entry_focus_no_select (GtkEntry* entry);
static void contacts_app_selection_changed (ContactsApp* self, ContactsContact* new_selection);
void contacts_app_show_contact (ContactsApp* self, ContactsContact* contact);
void contacts_list_pane_select_contact (ContactsListPane* self, ContactsContact* contact, gboolean ignore_change);
static void contacts_app_show_individual_data_free (gpointer _data);
void contacts_app_show_individual (ContactsApp* self, const gchar* id, GAsyncReadyCallback _callback_, gpointer _user_data_);
void contacts_app_show_individual_finish (ContactsApp* self, GAsyncResult* _res_);
static gboolean contacts_app_show_individual_co (ContactsAppShowIndividualData* _data_);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
void contacts_store_find_contact (ContactsStore* self, ContactsStoreContactMatcher matcher, void* matcher_target, GAsyncReadyCallback _callback_, gpointer _user_data_);
ContactsContact* contacts_store_find_contact_finish (ContactsStore* self, GAsyncResult* _res_);
static gboolean __lambda93_ (Block1Data* _data1_, ContactsContact* c);
static gboolean ___lambda93__contacts_store_contact_matcher (ContactsContact* c, gpointer self);
static void contacts_app_show_individual_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void ___lambda94_ (Block2Data* _data2_, gint id);
static void ____lambda94__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
void contacts_app_change_address_book (ContactsApp* self);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
FolksPersonaStore** contacts_app_get_eds_address_books (int* result_length1);
gchar* contacts_contact_format_persona_store_name (FolksPersonaStore* store);
FolksIndividualAggregator* contacts_store_get_aggregator (ContactsStore* self);
static void __lambda95_ (Block3Data* _data3_, gint response);
void contacts_store_refresh (ContactsStore* self);
static void ___lambda95__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
void contacts_app_show_help (ContactsApp* self);
void contacts_app_show_about (ContactsApp* self);
static void contacts_app_show_by_email_data_free (gpointer _data);
void contacts_app_show_by_email (ContactsApp* self, const gchar* email_address, GAsyncReadyCallback _callback_, gpointer _user_data_);
void contacts_app_show_by_email_finish (ContactsApp* self, GAsyncResult* _res_);
static gboolean contacts_app_show_by_email_co (ContactsAppShowByEmailData* _data_);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static gboolean __lambda96_ (Block4Data* _data4_, ContactsContact* c);
gboolean contacts_contact_has_email (ContactsContact* self, const gchar* email_address);
static gboolean ___lambda96__contacts_store_contact_matcher (ContactsContact* c, gpointer self);
static void contacts_app_show_by_email_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static void ___lambda97_ (Block5Data* _data5_, gint id);
static void ____lambda97__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
static void contacts_app_create_window (ContactsApp* self);
static void __lambda98_ (ContactsApp* self);
static void ___lambda98__g_simple_action_activate (GSimpleAction* _sender, GVariant* parameter, gpointer self);
static void __lambda99_ (ContactsApp* self);
static void ___lambda99__g_simple_action_activate (GSimpleAction* _sender, GVariant* parameter, gpointer self);
static void __lambda100_ (ContactsApp* self);
static void ___lambda100__g_simple_action_activate (GSimpleAction* _sender, GVariant* parameter, gpointer self);
static void __lambda101_ (ContactsApp* self);
static void ___lambda101__g_simple_action_activate (GSimpleAction* _sender, GVariant* parameter, gpointer self);
ContactsWindow* contacts_window_new (GtkApplication* app);
ContactsWindow* contacts_window_construct (GType object_type, GtkApplication* app);
static gboolean _contacts_app_window_delete_event_gtk_widget_delete_event (GtkWidget* _sender, GdkEventAny* event, gpointer self);
static gboolean _contacts_app_window_key_press_event_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self);
static void __lambda102_ (ContactsApp* self, GtkToolButton* button);
ContactsNewContactDialog* contacts_new_contact_dialog_new (ContactsStore* contacts_store, ContactsWindow* parent);
ContactsNewContactDialog* contacts_new_contact_dialog_construct (GType object_type, ContactsStore* contacts_store, ContactsWindow* parent);
GType contacts_new_contact_dialog_get_type (void) G_GNUC_CONST;
static void ___lambda102__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self);
ContactsListPane* contacts_list_pane_new (ContactsStore* contacts_store);
ContactsListPane* contacts_list_pane_construct (GType object_type, ContactsStore* contacts_store);
static void _contacts_app_selection_changed_contacts_list_pane_selection_changed (ContactsListPane* _sender, ContactsContact* contact, gpointer self);
ContactsContactPane* contacts_contact_pane_new (ContactsStore* contacts_store);
ContactsContactPane* contacts_contact_pane_construct (GType object_type, ContactsStore* contacts_store);
static void contacts_app_delete_contact (ContactsApp* self, ContactsContact* contact);
static void _contacts_app_delete_contact_contacts_contact_pane_will_delete (ContactsContactPane* _sender, ContactsContact* contact, gpointer self);
GType contacts_link_operation_get_type (void) G_GNUC_CONST;
static void contacts_app_contacts_linked (ContactsApp* self, const gchar* main_contact, const gchar* linked_contact, ContactsLinkOperation* operation);
static void _contacts_app_contacts_linked_contacts_contact_pane_contacts_linked (ContactsContactPane* _sender, const gchar* main_contact, const gchar* linked_contact, ContactsLinkOperation* operation, gpointer self);
static void contacts_app_real_startup (GApplication* base);
ContactsStore* contacts_store_new (void);
ContactsStore* contacts_store_construct (GType object_type);
static void contacts_app_show_setup (ContactsApp* self);
GType contacts_setup_window_get_type (void) G_GNUC_CONST;
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
ContactsSetupWindow* contacts_setup_window_new (void);
ContactsSetupWindow* contacts_setup_window_construct (GType object_type);
static void __lambda119_ (Block6Data* _data6_);
static void ___lambda119__gtk_widget_destroy (GtkWidget* _sender, gpointer self);
static void contacts_app_real_activate (GApplication* base);
gboolean contacts_store_get_is_prepared (ContactsStore* self);
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (void * _userdata_);
static void _____lambda120_ (Block7Data* _data7_);
static void ______lambda120__contacts_store_prepared (ContactsStore* _sender, gpointer self);
static gboolean _____lambda121_ (Block7Data* _data7_);
static gboolean ______lambda121__gsource_func (gpointer self);
static void ___lambda122_ (ContactsApp* self);
static void ____lambda122__contacts_store_quiescent (ContactsStore* _sender, gpointer self);
static gboolean ___lambda123_ (ContactsApp* self);
static gboolean ____lambda123__gsource_func (gpointer self);
void contacts_app_show_message (ContactsApp* self, const gchar* message);
static Block8Data* block8_data_ref (Block8Data* _data8_);
static void block8_data_unref (void * _userdata_);
const gchar* contacts_contact_get_display_name (ContactsContact* self);
static void __lambda110_ (Block8Data* _data8_);
void contacts_contact_remove_personas (ContactsContact* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void contacts_contact_remove_personas_finish (ContactsContact* self, GAsyncResult* _res_, GError** error);
static void ___lambda111_ (Block8Data* _data8_);
void contacts_contact_show (ContactsContact* self);
static void ____lambda111__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void ___lambda110__gtk_notification_dismissed (GtkNotification* _sender, gpointer self);
static void __lambda112_ (Block8Data* _data8_);
static void ___lambda112__gtk_button_clicked (GtkButton* _sender, gpointer self);
static Block9Data* block9_data_ref (Block9Data* _data9_);
static void block9_data_unref (void * _userdata_);
static void __lambda113_ (Block9Data* _data9_);
void contacts_link_operation_undo (ContactsLinkOperation* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void contacts_link_operation_undo_finish (ContactsLinkOperation* self, GAsyncResult* _res_);
static void ___lambda113__gtk_button_clicked (GtkButton* _sender, gpointer self);
static gint contacts_app_real_command_line (GApplication* base, GApplicationCommandLine* command_line);
FolksBackendStore* contacts_store_get_backend_store (ContactsStore* self);
static void _vala_array_add1 (FolksPersonaStore*** array, int* length, int* size, FolksPersonaStore* value);
ContactsApp* contacts_app_new (void);
ContactsApp* contacts_app_construct (GType object_type);
static void contacts_app_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const GOptionEntry CONTACTS_APP_options[3] = {{"individual", 'i', 0, G_OPTION_ARG_STRING, &contacts_app_individual_id, "Show contact with this individual id", NULL}, {"email", 'e', 0, G_OPTION_ARG_STRING, &contacts_app_email_address, "Show contact with this email address", NULL}, {NULL}};

static gboolean contacts_app_window_delete_event (ContactsApp* self, GdkEventAny* event) {
	gboolean result = FALSE;
	ContactsContactPane* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = self->priv->contacts_pane;
	contacts_contact_pane_show_contact (_tmp0_, NULL, FALSE, TRUE);
	result = FALSE;
	return result;
}


static gboolean contacts_app_window_key_press_event (ContactsApp* self, GdkEventKey* event) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	GdkEventKey _tmp1_;
	guint _tmp2_;
	guint _tmp3_ = 0U;
	gboolean _tmp6_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp1_ = *event;
	_tmp2_ = _tmp1_.keyval;
	_tmp3_ = gdk_keyval_from_name ("q");
	if (_tmp2_ == _tmp3_) {
		GdkEventKey _tmp4_;
		GdkModifierType _tmp5_;
		_tmp4_ = *event;
		_tmp5_ = _tmp4_.state;
		_tmp0_ = (_tmp5_ & GDK_CONTROL_MASK) != 0;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp6_ = _tmp0_;
	if (_tmp6_) {
		ContactsContactPane* _tmp7_;
		ContactsWindow* _tmp8_;
		_tmp7_ = self->priv->contacts_pane;
		contacts_contact_pane_show_contact (_tmp7_, NULL, FALSE, TRUE);
		_tmp8_ = self->window;
		gtk_widget_destroy ((GtkWidget*) _tmp8_);
	} else {
		gboolean _tmp9_ = FALSE;
		gboolean _tmp10_ = FALSE;
		GdkEventKey _tmp11_;
		guint _tmp12_;
		gboolean _tmp15_;
		gboolean _tmp18_;
		_tmp11_ = *event;
		_tmp12_ = _tmp11_.keyval;
		if (_tmp12_ == ((guint) GDK_KEY_s)) {
			_tmp10_ = TRUE;
		} else {
			GdkEventKey _tmp13_;
			guint _tmp14_;
			_tmp13_ = *event;
			_tmp14_ = _tmp13_.keyval;
			_tmp10_ = _tmp14_ == ((guint) GDK_KEY_f);
		}
		_tmp15_ = _tmp10_;
		if (_tmp15_) {
			GdkEventKey _tmp16_;
			GdkModifierType _tmp17_;
			_tmp16_ = *event;
			_tmp17_ = _tmp16_.state;
			_tmp9_ = (_tmp17_ & GDK_CONTROL_MASK) != 0;
		} else {
			_tmp9_ = FALSE;
		}
		_tmp18_ = _tmp9_;
		if (_tmp18_) {
			ContactsListPane* _tmp19_;
			GtkEntry* _tmp20_;
			_tmp19_ = self->priv->list_pane;
			_tmp20_ = _tmp19_->filter_entry;
			contacts_utils_grab_entry_focus_no_select (_tmp20_);
		} else {
			gboolean _tmp21_ = FALSE;
			gboolean _tmp22_ = FALSE;
			gboolean _tmp23_ = FALSE;
			gboolean _tmp24_ = FALSE;
			gboolean _tmp25_ = FALSE;
			gboolean _tmp26_ = FALSE;
			GdkEventKey _tmp27_;
			gint _tmp28_;
			gboolean _tmp32_;
			gboolean _tmp35_;
			gboolean _tmp38_;
			gboolean _tmp41_;
			gboolean _tmp44_;
			gboolean _tmp47_;
			_tmp27_ = *event;
			_tmp28_ = _tmp27_.length;
			if (_tmp28_ >= 1) {
				GdkEventKey _tmp29_;
				guint _tmp30_;
				guint32 _tmp31_ = 0U;
				_tmp29_ = *event;
				_tmp30_ = _tmp29_.keyval;
				_tmp31_ = gdk_keyval_to_unicode (_tmp30_);
				_tmp26_ = _tmp31_ != ((guint32) 0);
			} else {
				_tmp26_ = FALSE;
			}
			_tmp32_ = _tmp26_;
			if (_tmp32_) {
				GdkEventKey _tmp33_;
				GdkModifierType _tmp34_;
				_tmp33_ = *event;
				_tmp34_ = _tmp33_.state;
				_tmp25_ = (_tmp34_ & GDK_CONTROL_MASK) == 0;
			} else {
				_tmp25_ = FALSE;
			}
			_tmp35_ = _tmp25_;
			if (_tmp35_) {
				GdkEventKey _tmp36_;
				GdkModifierType _tmp37_;
				_tmp36_ = *event;
				_tmp37_ = _tmp36_.state;
				_tmp24_ = (_tmp37_ & GDK_MOD1_MASK) == 0;
			} else {
				_tmp24_ = FALSE;
			}
			_tmp38_ = _tmp24_;
			if (_tmp38_) {
				GdkEventKey _tmp39_;
				guint _tmp40_;
				_tmp39_ = *event;
				_tmp40_ = _tmp39_.keyval;
				_tmp23_ = _tmp40_ != ((guint) GDK_KEY_Escape);
			} else {
				_tmp23_ = FALSE;
			}
			_tmp41_ = _tmp23_;
			if (_tmp41_) {
				GdkEventKey _tmp42_;
				guint _tmp43_;
				_tmp42_ = *event;
				_tmp43_ = _tmp42_.keyval;
				_tmp22_ = _tmp43_ != ((guint) GDK_KEY_Tab);
			} else {
				_tmp22_ = FALSE;
			}
			_tmp44_ = _tmp22_;
			if (_tmp44_) {
				GdkEventKey _tmp45_;
				guint _tmp46_;
				_tmp45_ = *event;
				_tmp46_ = _tmp45_.keyval;
				_tmp21_ = _tmp46_ != ((guint) GDK_KEY_BackSpace);
			} else {
				_tmp21_ = FALSE;
			}
			_tmp47_ = _tmp21_;
			if (_tmp47_) {
				ContactsListPane* _tmp48_;
				GtkEntry* _tmp49_;
				ContactsWindow* _tmp50_;
				GdkEventKey _tmp51_;
				_tmp48_ = self->priv->list_pane;
				_tmp49_ = _tmp48_->filter_entry;
				contacts_utils_grab_entry_focus_no_select (_tmp49_);
				_tmp50_ = self->window;
				_tmp51_ = *event;
				gtk_window_propagate_key_event ((GtkWindow*) _tmp50_, &_tmp51_);
			}
		}
	}
	result = FALSE;
	return result;
}


static void contacts_app_selection_changed (ContactsApp* self, ContactsContact* new_selection) {
	ContactsContactPane* _tmp0_;
	ContactsContact* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->contacts_pane;
	_tmp1_ = new_selection;
	contacts_contact_pane_show_contact (_tmp0_, _tmp1_, FALSE, FALSE);
}


void contacts_app_show_contact (ContactsApp* self, ContactsContact* contact) {
	ContactsListPane* _tmp0_;
	ContactsContact* _tmp1_;
	ContactsContactPane* _tmp2_;
	ContactsContact* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->list_pane;
	_tmp1_ = contact;
	contacts_list_pane_select_contact (_tmp0_, _tmp1_, FALSE);
	_tmp2_ = self->priv->contacts_pane;
	_tmp3_ = contact;
	contacts_contact_pane_show_contact (_tmp2_, _tmp3_, FALSE, TRUE);
}


static void contacts_app_show_individual_data_free (gpointer _data) {
	ContactsAppShowIndividualData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (ContactsAppShowIndividualData, _data_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void contacts_app_show_individual (ContactsApp* self, const gchar* id, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	ContactsAppShowIndividualData* _data_;
	ContactsApp* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	_data_ = g_slice_new0 (ContactsAppShowIndividualData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, contacts_app_show_individual);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, contacts_app_show_individual_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = id;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 (_data_->id);
	_data_->id = _tmp2_;
	contacts_app_show_individual_co (_data_);
}


void contacts_app_show_individual_finish (ContactsApp* self, GAsyncResult* _res_) {
	ContactsAppShowIndividualData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		ContactsApp * self;
		self = _data1_->self;
		_g_free0 (_data1_->id);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}


static gboolean __lambda93_ (Block1Data* _data1_, ContactsContact* c) {
	ContactsApp * self;
	gboolean result = FALSE;
	ContactsContact* _tmp0_;
	FolksIndividual* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	self = _data1_->self;
	g_return_val_if_fail (c != NULL, FALSE);
	_tmp0_ = c;
	_tmp1_ = _tmp0_->individual;
	_tmp2_ = folks_individual_get_id (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _data1_->id;
	result = g_strcmp0 (_tmp3_, _tmp4_) == 0;
	return result;
}


static gboolean ___lambda93__contacts_store_contact_matcher (ContactsContact* c, gpointer self) {
	gboolean result;
	result = __lambda93_ (self, c);
	return result;
}


static void contacts_app_show_individual_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	ContactsAppShowIndividualData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	contacts_app_show_individual_co (_data_);
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}


static void block2_data_unref (void * _userdata_) {
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		ContactsApp * self;
		self = _data2_->_data1_->self;
		_g_object_unref0 (_data2_->dialog);
		block1_data_unref (_data2_->_data1_);
		_data2_->_data1_ = NULL;
		g_slice_free (Block2Data, _data2_);
	}
}


static void ___lambda94_ (Block2Data* _data2_, gint id) {
	Block1Data* _data1_;
	ContactsApp * self;
	GtkMessageDialog* _tmp0_;
	_data1_ = _data2_->_data1_;
	self = _data1_->self;
	_tmp0_ = _data2_->dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp0_);
}


static void ____lambda94__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
	___lambda94_ (self, response_id);
}


static gboolean contacts_app_show_individual_co (ContactsAppShowIndividualData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data1_ = g_slice_new0 (Block1Data);
	_data_->_data1_->_ref_count_ = 1;
	_data_->_data1_->self = g_object_ref (_data_->self);
	_data_->_tmp0_ = _data_->id;
	_g_free0 (_data_->_data1_->id);
	_data_->_data1_->id = _data_->_tmp0_;
	_data_->_data1_->_async_data_ = _data_;
	_data_->_tmp1_ = _data_->self->contacts_store;
	_data_->_state_ = 1;
	contacts_store_find_contact (_data_->_tmp1_, ___lambda93__contacts_store_contact_matcher, _data_->_data1_, contacts_app_show_individual_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = contacts_store_find_contact_finish (_data_->_tmp1_, _data_->_res_);
	_data_->contact = _data_->_tmp2_;
	_data_->_tmp3_ = _data_->contact;
	if (_data_->_tmp3_ != NULL) {
		_data_->_tmp4_ = _data_->self->priv->list_pane;
		_data_->_tmp5_ = _data_->contact;
		contacts_list_pane_select_contact (_data_->_tmp4_, _data_->_tmp5_, FALSE);
		_data_->_tmp6_ = _data_->self->priv->contacts_pane;
		_data_->_tmp7_ = _data_->contact;
		contacts_contact_pane_show_contact (_data_->_tmp6_, _data_->_tmp7_, FALSE, TRUE);
	} else {
		_data_->_data2_ = g_slice_new0 (Block2Data);
		_data_->_data2_->_ref_count_ = 1;
		_data_->_data2_->_data1_ = block1_data_ref (_data_->_data1_);
		_data_->_tmp8_ = contacts_app_app;
		_data_->_tmp9_ = _data_->_tmp8_->window;
		_data_->_tmp10_ = NULL;
		_data_->_tmp10_ = _ ("No contact with id %s found");
		_data_->_tmp11_ = _data_->_data1_->id;
		_data_->_tmp12_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) _data_->_tmp9_, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE, _data_->_tmp10_, _data_->_tmp11_);
		g_object_ref_sink (_data_->_tmp12_);
		_data_->_data2_->dialog = _data_->_tmp12_;
		_data_->_tmp13_ = _data_->_data2_->dialog;
		_data_->_tmp14_ = NULL;
		_data_->_tmp14_ = _ ("Contact not found");
		gtk_window_set_title ((GtkWindow*) _data_->_tmp13_, _data_->_tmp14_);
		_data_->_tmp15_ = _data_->_data2_->dialog;
		gtk_widget_show ((GtkWidget*) _data_->_tmp15_);
		_data_->_tmp16_ = _data_->_data2_->dialog;
		g_signal_connect_data ((GtkDialog*) _data_->_tmp16_, "response", (GCallback) ____lambda94__gtk_dialog_response, block2_data_ref (_data_->_data2_), (GClosureNotify) block2_data_unref, 0);
		block2_data_unref (_data_->_data2_);
		_data_->_data2_ = NULL;
	}
	_g_object_unref0 (_data_->contact);
	block1_data_unref (_data_->_data1_);
	_data_->_data1_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}


static void block3_data_unref (void * _userdata_) {
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		ContactsApp * self;
		self = _data3_->self;
		_g_object_unref0 (_data3_->store);
		_g_object_unref0 (_data3_->tree_view);
		_g_object_unref0 (_data3_->dialog);
		_g_object_unref0 (self);
		g_slice_free (Block3Data, _data3_);
	}
}


static void __lambda95_ (Block3Data* _data3_, gint response) {
	ContactsApp * self;
	gint _tmp0_;
	GtkDialog* _tmp14_;
	self = _data3_->self;
	_tmp0_ = response;
	if (_tmp0_ == ((gint) GTK_RESPONSE_OK)) {
		FolksPersonaStore* selected_store = NULL;
		GtkTreeIter iter2 = {0};
		GtkTreeView* _tmp1_;
		GtkTreeSelection* _tmp2_ = NULL;
		GtkTreeIter _tmp3_ = {0};
		gboolean _tmp4_ = FALSE;
		_tmp1_ = _data3_->tree_view;
		_tmp2_ = gtk_tree_view_get_selection (_tmp1_);
		_tmp4_ = gtk_tree_selection_get_selected (_tmp2_, NULL, &_tmp3_);
		iter2 = _tmp3_;
		if (_tmp4_) {
			GtkListStore* _tmp5_;
			GtkTreeIter _tmp6_;
			FolksPersonaStore* _tmp7_;
			EdsfPersonaStore* _tmp8_;
			EdsfPersonaStore* e_store;
			ESourceRegistry* _tmp9_;
			EdsfPersonaStore* _tmp10_;
			ESource* _tmp11_;
			ESource* _tmp12_;
			ContactsStore* _tmp13_;
			_tmp5_ = _data3_->store;
			_tmp6_ = iter2;
			gtk_tree_model_get ((GtkTreeModel*) _tmp5_, &_tmp6_, 1, &selected_store, -1);
			_tmp7_ = selected_store;
			_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, EDSF_TYPE_PERSONA_STORE) ? ((EdsfPersonaStore*) _tmp7_) : NULL);
			e_store = _tmp8_;
			_tmp9_ = eds_source_registry;
			_tmp10_ = e_store;
			_tmp11_ = edsf_persona_store_get_source (_tmp10_);
			_tmp12_ = _tmp11_;
			e_source_registry_set_default_address_book (_tmp9_, _tmp12_);
			_tmp13_ = self->contacts_store;
			contacts_store_refresh (_tmp13_);
			_g_object_unref0 (e_store);
		}
		_g_object_unref0 (selected_store);
	}
	_tmp14_ = _data3_->dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp14_);
}


static void ___lambda95__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
	__lambda95_ (self, response_id);
}


void contacts_app_change_address_book (ContactsApp* self) {
	Block3Data* _data3_;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* title;
	ContactsWindow* _tmp2_;
	const gchar* _tmp3_ = NULL;
	GtkDialog* _tmp4_;
	GtkDialog* _tmp5_;
	GtkDialog* _tmp6_;
	GtkTreeView* _tmp7_;
	GtkListStore* _tmp8_;
	GtkTreeView* _tmp9_;
	GtkListStore* _tmp10_;
	GtkTreeView* _tmp11_;
	GtkTreeView* _tmp12_;
	GtkTreeSelection* _tmp13_ = NULL;
	GtkTreeViewColumn* _tmp14_;
	GtkTreeViewColumn* column;
	GtkTreeView* _tmp15_;
	GtkTreeViewColumn* _tmp16_;
	GtkCellRendererText* _tmp17_;
	GtkCellRendererText* renderer;
	GtkTreeViewColumn* _tmp18_;
	GtkCellRendererText* _tmp19_;
	GtkTreeViewColumn* _tmp20_;
	GtkCellRendererText* _tmp21_;
	GtkScrolledWindow* _tmp22_;
	GtkScrolledWindow* scrolled;
	GtkScrolledWindow* _tmp23_;
	GtkScrolledWindow* _tmp24_;
	GtkScrolledWindow* _tmp25_;
	GtkScrolledWindow* _tmp26_;
	GtkScrolledWindow* _tmp27_;
	GtkScrolledWindow* _tmp28_;
	GtkTreeView* _tmp29_;
	GtkGrid* _tmp30_;
	GtkGrid* grid;
	GtkGrid* _tmp31_;
	GtkGrid* _tmp32_;
	const gchar* _tmp33_;
	GtkLabel* _tmp34_;
	GtkLabel* l;
	GtkLabel* _tmp35_;
	GtkGrid* _tmp36_;
	GtkLabel* _tmp37_;
	GtkGrid* _tmp38_;
	GtkScrolledWindow* _tmp39_;
	GtkDialog* _tmp40_;
	GtkBox* _tmp41_ = NULL;
	GtkBox* _tmp42_;
	GtkBox* box;
	GtkBox* _tmp43_;
	GtkGrid* _tmp44_;
	GtkGrid* _tmp45_;
	GtkTreeIter iter = {0};
	gint _tmp46_ = 0;
	FolksPersonaStore** _tmp47_ = NULL;
	GtkDialog* _tmp66_;
	GtkDialog* _tmp67_;
	g_return_if_fail (self != NULL);
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_data3_->self = g_object_ref (self);
	_tmp0_ = _ ("Change Address Book");
	_tmp1_ = g_strdup (_tmp0_);
	title = _tmp1_;
	_tmp2_ = self->window;
	_tmp3_ = _ ("Select");
	_tmp4_ = (GtkDialog*) gtk_dialog_new_with_buttons ("", (GtkWindow*) G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, CONTACTS_TYPE_WINDOW, ContactsWindow), GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT, GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, _tmp3_, GTK_RESPONSE_OK, NULL);
	g_object_ref_sink (_tmp4_);
	_data3_->dialog = _tmp4_;
	_tmp5_ = _data3_->dialog;
	gtk_window_set_resizable ((GtkWindow*) _tmp5_, FALSE);
	_tmp6_ = _data3_->dialog;
	gtk_dialog_set_default_response (_tmp6_, (gint) GTK_RESPONSE_OK);
	_tmp7_ = (GtkTreeView*) gtk_tree_view_new ();
	g_object_ref_sink (_tmp7_);
	_data3_->tree_view = _tmp7_;
	_tmp8_ = gtk_list_store_new (2, G_TYPE_STRING, FOLKS_TYPE_PERSONA_STORE);
	_data3_->store = _tmp8_;
	_tmp9_ = _data3_->tree_view;
	_tmp10_ = _data3_->store;
	gtk_tree_view_set_model (_tmp9_, (GtkTreeModel*) _tmp10_);
	_tmp11_ = _data3_->tree_view;
	gtk_tree_view_set_headers_visible (_tmp11_, FALSE);
	_tmp12_ = _data3_->tree_view;
	_tmp13_ = gtk_tree_view_get_selection (_tmp12_);
	gtk_tree_selection_set_mode (_tmp13_, GTK_SELECTION_BROWSE);
	_tmp14_ = gtk_tree_view_column_new ();
	g_object_ref_sink (_tmp14_);
	column = _tmp14_;
	_tmp15_ = _data3_->tree_view;
	_tmp16_ = column;
	gtk_tree_view_append_column (_tmp15_, _tmp16_);
	_tmp17_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp17_);
	renderer = _tmp17_;
	_tmp18_ = column;
	_tmp19_ = renderer;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp18_, (GtkCellRenderer*) _tmp19_, FALSE);
	_tmp20_ = column;
	_tmp21_ = renderer;
	gtk_cell_layout_add_attribute ((GtkCellLayout*) _tmp20_, (GtkCellRenderer*) _tmp21_, "text", 0);
	_tmp22_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	g_object_ref_sink (_tmp22_);
	scrolled = _tmp22_;
	_tmp23_ = scrolled;
	gtk_widget_set_size_request ((GtkWidget*) _tmp23_, 340, 300);
	_tmp24_ = scrolled;
	gtk_scrolled_window_set_policy (_tmp24_, GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);
	_tmp25_ = scrolled;
	gtk_widget_set_vexpand ((GtkWidget*) _tmp25_, TRUE);
	_tmp26_ = scrolled;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp26_, TRUE);
	_tmp27_ = scrolled;
	gtk_scrolled_window_set_shadow_type (_tmp27_, GTK_SHADOW_IN);
	_tmp28_ = scrolled;
	_tmp29_ = _data3_->tree_view;
	gtk_container_add ((GtkContainer*) _tmp28_, (GtkWidget*) _tmp29_);
	_tmp30_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp30_);
	grid = _tmp30_;
	_tmp31_ = grid;
	gtk_orientable_set_orientation ((GtkOrientable*) _tmp31_, GTK_ORIENTATION_VERTICAL);
	_tmp32_ = grid;
	gtk_grid_set_row_spacing (_tmp32_, (guint) 6);
	_tmp33_ = title;
	_tmp34_ = (GtkLabel*) gtk_label_new (_tmp33_);
	g_object_ref_sink (_tmp34_);
	l = _tmp34_;
	_tmp35_ = l;
	gtk_widget_set_halign ((GtkWidget*) _tmp35_, GTK_ALIGN_START);
	_tmp36_ = grid;
	_tmp37_ = l;
	gtk_container_add ((GtkContainer*) _tmp36_, (GtkWidget*) _tmp37_);
	_tmp38_ = grid;
	_tmp39_ = scrolled;
	gtk_container_add ((GtkContainer*) _tmp38_, (GtkWidget*) _tmp39_);
	_tmp40_ = _data3_->dialog;
	_tmp41_ = gtk_dialog_get_content_area (_tmp40_);
	_tmp42_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp41_, GTK_TYPE_BOX) ? ((GtkBox*) _tmp41_) : NULL);
	box = _tmp42_;
	_tmp43_ = box;
	_tmp44_ = grid;
	gtk_box_pack_start (_tmp43_, (GtkWidget*) _tmp44_, TRUE, TRUE, (guint) 0);
	_tmp45_ = grid;
	gtk_container_set_border_width ((GtkContainer*) _tmp45_, (guint) 6);
	_tmp47_ = contacts_app_get_eds_address_books (&_tmp46_);
	{
		FolksPersonaStore** persona_store_collection = NULL;
		gint persona_store_collection_length1 = 0;
		gint _persona_store_collection_size_ = 0;
		gint persona_store_it = 0;
		persona_store_collection = _tmp47_;
		persona_store_collection_length1 = _tmp46_;
		for (persona_store_it = 0; persona_store_it < _tmp46_; persona_store_it = persona_store_it + 1) {
			FolksPersonaStore* _tmp48_;
			FolksPersonaStore* persona_store = NULL;
			_tmp48_ = _g_object_ref0 (persona_store_collection[persona_store_it]);
			persona_store = _tmp48_;
			{
				FolksPersonaStore* _tmp49_;
				gchar* _tmp50_ = NULL;
				gchar* name;
				GtkListStore* _tmp51_;
				GtkTreeIter _tmp52_ = {0};
				GtkListStore* _tmp53_;
				GtkTreeIter _tmp54_;
				const gchar* _tmp55_;
				FolksPersonaStore* _tmp56_;
				FolksPersonaStore* _tmp57_;
				ContactsStore* _tmp58_;
				FolksIndividualAggregator* _tmp59_;
				FolksIndividualAggregator* _tmp60_;
				FolksPersonaStore* _tmp61_;
				FolksPersonaStore* _tmp62_;
				_tmp49_ = persona_store;
				_tmp50_ = contacts_contact_format_persona_store_name (_tmp49_);
				name = _tmp50_;
				_tmp51_ = _data3_->store;
				gtk_list_store_append (_tmp51_, &_tmp52_);
				iter = _tmp52_;
				_tmp53_ = _data3_->store;
				_tmp54_ = iter;
				_tmp55_ = name;
				_tmp56_ = persona_store;
				gtk_list_store_set (_tmp53_, &_tmp54_, 0, _tmp55_, 1, _tmp56_, -1);
				_tmp57_ = persona_store;
				_tmp58_ = self->contacts_store;
				_tmp59_ = contacts_store_get_aggregator (_tmp58_);
				_tmp60_ = _tmp59_;
				_tmp61_ = folks_individual_aggregator_get_primary_store (_tmp60_);
				_tmp62_ = _tmp61_;
				if (_tmp57_ == _tmp62_) {
					GtkTreeView* _tmp63_;
					GtkTreeSelection* _tmp64_ = NULL;
					GtkTreeIter _tmp65_;
					_tmp63_ = _data3_->tree_view;
					_tmp64_ = gtk_tree_view_get_selection (_tmp63_);
					_tmp65_ = iter;
					gtk_tree_selection_select_iter (_tmp64_, &_tmp65_);
				}
				_g_free0 (name);
				_g_object_unref0 (persona_store);
			}
		}
		persona_store_collection = (_vala_array_free (persona_store_collection, persona_store_collection_length1, (GDestroyNotify) g_object_unref), NULL);
	}
	_tmp66_ = _data3_->dialog;
	gtk_widget_show_all ((GtkWidget*) _tmp66_);
	_tmp67_ = _data3_->dialog;
	g_signal_connect_data (_tmp67_, "response", (GCallback) ___lambda95__gtk_dialog_response, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
	_g_object_unref0 (box);
	_g_object_unref0 (l);
	_g_object_unref0 (grid);
	_g_object_unref0 (scrolled);
	_g_object_unref0 (renderer);
	_g_object_unref0 (column);
	_g_free0 (title);
	block3_data_unref (_data3_);
	_data3_ = NULL;
}


void contacts_app_show_help (ContactsApp* self) {
	ContactsWindow* _tmp0_;
	GdkScreen* _tmp1_ = NULL;
	guint32 _tmp2_ = 0U;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->window;
	_tmp1_ = gtk_window_get_screen ((GtkWindow*) _tmp0_);
	_tmp2_ = gtk_get_current_event_time ();
	gtk_show_uri (_tmp1_, "help:gnome-help/contacts", _tmp2_, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


void contacts_app_show_about (ContactsApp* self) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar** _tmp2_ = NULL;
	gchar** authors;
	gint authors_length1;
	gint _authors_size_;
	gchar* _tmp3_;
	gchar** _tmp4_ = NULL;
	gchar** artists;
	gint artists_length1;
	gint _artists_size_;
	ContactsWindow* _tmp5_;
	const gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup ("Alexander Larsson <alexl@redhat.com>");
	_tmp1_ = g_strdup ("Erick Pérez Castellanos <erick.red@gmail.com>");
	_tmp2_ = g_new0 (gchar*, 2 + 1);
	_tmp2_[0] = _tmp0_;
	_tmp2_[1] = _tmp1_;
	authors = _tmp2_;
	authors_length1 = 2;
	_authors_size_ = authors_length1;
	_tmp3_ = g_strdup ("Allan Day <allanpday@gmail.com>");
	_tmp4_ = g_new0 (gchar*, 1 + 1);
	_tmp4_[0] = _tmp3_;
	artists = _tmp4_;
	artists_length1 = 1;
	_artists_size_ = artists_length1;
	_tmp5_ = self->window;
	_tmp6_ = _ ("translator-credits");
	_tmp7_ = _ ("GNOME Contacts");
	_tmp8_ = _ ("About GNOME Contacts");
	_tmp9_ = _ ("Contact Management Application");
	gtk_show_about_dialog ((GtkWindow*) _tmp5_, "artists", artists, "authors", authors, "translator-credits", _tmp6_, "program-name", _tmp7_, "title", _tmp8_, "comments", _tmp9_, "copyright", "Copyright 2011 Red Hat, Inc.", "license-type", GTK_LICENSE_GPL_2_0, "logo-icon-name", "x-office-address-book", "version", PACKAGE_VERSION, "website", "https://live.gnome.org/Contacts", "wrap-license", TRUE, NULL);
	artists = (_vala_array_free (artists, artists_length1, (GDestroyNotify) g_free), NULL);
	authors = (_vala_array_free (authors, authors_length1, (GDestroyNotify) g_free), NULL);
}


static void contacts_app_show_by_email_data_free (gpointer _data) {
	ContactsAppShowByEmailData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (ContactsAppShowByEmailData, _data_);
}


void contacts_app_show_by_email (ContactsApp* self, const gchar* email_address, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	ContactsAppShowByEmailData* _data_;
	ContactsApp* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	_data_ = g_slice_new0 (ContactsAppShowByEmailData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, contacts_app_show_by_email);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, contacts_app_show_by_email_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = email_address;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 (_data_->email_address);
	_data_->email_address = _tmp2_;
	contacts_app_show_by_email_co (_data_);
}


void contacts_app_show_by_email_finish (ContactsApp* self, GAsyncResult* _res_) {
	ContactsAppShowByEmailData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static Block4Data* block4_data_ref (Block4Data* _data4_) {
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}


static void block4_data_unref (void * _userdata_) {
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		ContactsApp * self;
		self = _data4_->self;
		_g_free0 (_data4_->email_address);
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}


static gboolean __lambda96_ (Block4Data* _data4_, ContactsContact* c) {
	ContactsApp * self;
	gboolean result = FALSE;
	ContactsContact* _tmp0_;
	const gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	self = _data4_->self;
	g_return_val_if_fail (c != NULL, FALSE);
	_tmp0_ = c;
	_tmp1_ = _data4_->email_address;
	_tmp2_ = contacts_contact_has_email (_tmp0_, _tmp1_);
	result = _tmp2_;
	return result;
}


static gboolean ___lambda96__contacts_store_contact_matcher (ContactsContact* c, gpointer self) {
	gboolean result;
	result = __lambda96_ (self, c);
	return result;
}


static void contacts_app_show_by_email_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	ContactsAppShowByEmailData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	contacts_app_show_by_email_co (_data_);
}


static Block5Data* block5_data_ref (Block5Data* _data5_) {
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}


static void block5_data_unref (void * _userdata_) {
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		ContactsApp * self;
		self = _data5_->_data4_->self;
		_g_object_unref0 (_data5_->dialog);
		block4_data_unref (_data5_->_data4_);
		_data5_->_data4_ = NULL;
		g_slice_free (Block5Data, _data5_);
	}
}


static void ___lambda97_ (Block5Data* _data5_, gint id) {
	Block4Data* _data4_;
	ContactsApp * self;
	GtkMessageDialog* _tmp0_;
	_data4_ = _data5_->_data4_;
	self = _data4_->self;
	_tmp0_ = _data5_->dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp0_);
}


static void ____lambda97__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
	___lambda97_ (self, response_id);
}


static gboolean contacts_app_show_by_email_co (ContactsAppShowByEmailData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data4_ = g_slice_new0 (Block4Data);
	_data_->_data4_->_ref_count_ = 1;
	_data_->_data4_->self = g_object_ref (_data_->self);
	_data_->_tmp0_ = _data_->email_address;
	_g_free0 (_data_->_data4_->email_address);
	_data_->_data4_->email_address = _data_->_tmp0_;
	_data_->_data4_->_async_data_ = _data_;
	_data_->_tmp1_ = _data_->self->contacts_store;
	_data_->_state_ = 1;
	contacts_store_find_contact (_data_->_tmp1_, ___lambda96__contacts_store_contact_matcher, _data_->_data4_, contacts_app_show_by_email_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = contacts_store_find_contact_finish (_data_->_tmp1_, _data_->_res_);
	_data_->contact = _data_->_tmp2_;
	_data_->_tmp3_ = _data_->contact;
	if (_data_->_tmp3_ != NULL) {
		_data_->_tmp4_ = _data_->self->priv->list_pane;
		_data_->_tmp5_ = _data_->contact;
		contacts_list_pane_select_contact (_data_->_tmp4_, _data_->_tmp5_, FALSE);
		_data_->_tmp6_ = _data_->self->priv->contacts_pane;
		_data_->_tmp7_ = _data_->contact;
		contacts_contact_pane_show_contact (_data_->_tmp6_, _data_->_tmp7_, FALSE, TRUE);
	} else {
		_data_->_data5_ = g_slice_new0 (Block5Data);
		_data_->_data5_->_ref_count_ = 1;
		_data_->_data5_->_data4_ = block4_data_ref (_data_->_data4_);
		_data_->_tmp8_ = contacts_app_app;
		_data_->_tmp9_ = _data_->_tmp8_->window;
		_data_->_tmp10_ = NULL;
		_data_->_tmp10_ = _ ("No contact with email address %s found");
		_data_->_tmp11_ = _data_->_data4_->email_address;
		_data_->_tmp12_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) _data_->_tmp9_, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE, _data_->_tmp10_, _data_->_tmp11_);
		g_object_ref_sink (_data_->_tmp12_);
		_data_->_data5_->dialog = _data_->_tmp12_;
		_data_->_tmp13_ = _data_->_data5_->dialog;
		_data_->_tmp14_ = NULL;
		_data_->_tmp14_ = _ ("Contact not found");
		gtk_window_set_title ((GtkWindow*) _data_->_tmp13_, _data_->_tmp14_);
		_data_->_tmp15_ = _data_->_data5_->dialog;
		gtk_widget_show ((GtkWidget*) _data_->_tmp15_);
		_data_->_tmp16_ = _data_->_data5_->dialog;
		g_signal_connect_data ((GtkDialog*) _data_->_tmp16_, "response", (GCallback) ____lambda97__gtk_dialog_response, block5_data_ref (_data_->_data5_), (GClosureNotify) block5_data_unref, 0);
		block5_data_unref (_data_->_data5_);
		_data_->_data5_ = NULL;
	}
	_g_object_unref0 (_data_->contact);
	block4_data_unref (_data_->_data4_);
	_data_->_data4_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void __lambda98_ (ContactsApp* self) {
	ContactsWindow* _tmp0_;
	_tmp0_ = self->window;
	gtk_widget_destroy ((GtkWidget*) _tmp0_);
}


static void ___lambda98__g_simple_action_activate (GSimpleAction* _sender, GVariant* parameter, gpointer self) {
	__lambda98_ (self);
}


static void __lambda99_ (ContactsApp* self) {
	contacts_app_show_help (self);
}


static void ___lambda99__g_simple_action_activate (GSimpleAction* _sender, GVariant* parameter, gpointer self) {
	__lambda99_ (self);
}


static void __lambda100_ (ContactsApp* self) {
	contacts_app_show_about (self);
}


static void ___lambda100__g_simple_action_activate (GSimpleAction* _sender, GVariant* parameter, gpointer self) {
	__lambda100_ (self);
}


static void __lambda101_ (ContactsApp* self) {
	contacts_app_change_address_book (self);
}


static void ___lambda101__g_simple_action_activate (GSimpleAction* _sender, GVariant* parameter, gpointer self) {
	__lambda101_ (self);
}


static gboolean _contacts_app_window_delete_event_gtk_widget_delete_event (GtkWidget* _sender, GdkEventAny* event, gpointer self) {
	gboolean result;
	result = contacts_app_window_delete_event (self, event);
	return result;
}


static gboolean _contacts_app_window_key_press_event_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self) {
	gboolean result;
	result = contacts_app_window_key_press_event (self, event);
	return result;
}


static void __lambda102_ (ContactsApp* self, GtkToolButton* button) {
	ContactsStore* _tmp0_;
	ContactsWindow* _tmp1_;
	ContactsNewContactDialog* _tmp2_;
	ContactsNewContactDialog* dialog;
	g_return_if_fail (button != NULL);
	_tmp0_ = self->contacts_store;
	_tmp1_ = self->window;
	_tmp2_ = contacts_new_contact_dialog_new (_tmp0_, _tmp1_);
	g_object_ref_sink (_tmp2_);
	dialog = _tmp2_;
	gtk_widget_show_all ((GtkWidget*) dialog);
	_g_object_unref0 (dialog);
}


static void ___lambda102__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self) {
	__lambda102_ (self, _sender);
}


static void _contacts_app_selection_changed_contacts_list_pane_selection_changed (ContactsListPane* _sender, ContactsContact* contact, gpointer self) {
	contacts_app_selection_changed (self, contact);
}


static void _contacts_app_delete_contact_contacts_contact_pane_will_delete (ContactsContactPane* _sender, ContactsContact* contact, gpointer self) {
	contacts_app_delete_contact (self, contact);
}


static void _contacts_app_contacts_linked_contacts_contact_pane_contacts_linked (ContactsContactPane* _sender, const gchar* main_contact, const gchar* linked_contact, ContactsLinkOperation* operation, gpointer self) {
	contacts_app_contacts_linked (self, main_contact, linked_contact, operation);
}


static void contacts_app_create_window (ContactsApp* self) {
	GSimpleAction* _tmp0_;
	GSimpleAction* action;
	GSimpleAction* _tmp1_;
	GSimpleAction* _tmp2_;
	GSimpleAction* _tmp3_;
	GSimpleAction* _tmp4_;
	GSimpleAction* _tmp5_;
	GSimpleAction* _tmp6_;
	GSimpleAction* _tmp7_;
	GSimpleAction* _tmp8_;
	GSimpleAction* _tmp9_;
	GSimpleAction* _tmp10_;
	GSimpleAction* _tmp11_;
	GtkBuilder* _tmp12_;
	GtkBuilder* builder;
	ContactsWindow* _tmp14_;
	ContactsWindow* _tmp15_;
	ContactsWindow* _tmp16_;
	const gchar* _tmp17_ = NULL;
	ContactsWindow* _tmp18_;
	ContactsWindow* _tmp19_;
	ContactsWindow* _tmp20_;
	ContactsWindow* _tmp21_;
	GtkGrid* _tmp22_;
	GtkGrid* grid;
	GtkToolbar* _tmp23_;
	GtkToolbar* toolbar;
	GtkToolbar* _tmp24_;
	GtkToolbar* _tmp25_;
	GtkStyleContext* _tmp26_ = NULL;
	GtkToolbar* _tmp27_;
	GtkStyleContext* _tmp28_ = NULL;
	GtkToolbar* _tmp29_;
	GtkToolbar* _tmp30_;
	GtkToolbar* _tmp31_;
	const gchar* _tmp32_ = NULL;
	GtkToolButton* _tmp33_;
	GtkToolButton* add_button;
	GtkToolbar* _tmp34_;
	GtkToolbar* _tmp35_;
	GtkToolbar* _tmp36_;
	GtkToolbar* _tmp37_;
	GtkStyleContext* _tmp38_ = NULL;
	GtkToolbar* _tmp39_;
	GtkToolbar* _tmp40_;
	GtkToolbar* _tmp41_;
	ContactsWindow* _tmp42_;
	GtkOverlay* _tmp43_;
	GdkRGBA _tmp44_ = {0};
	GdkRGBA transparent;
	GtkOverlay* _tmp45_;
	GdkRGBA _tmp46_;
	GtkOverlay* _tmp47_;
	GtkAlignment* _tmp48_;
	GtkAlignment* _tmp49_;
	GtkOverlay* _tmp50_;
	ContactsStore* _tmp51_;
	ContactsListPane* _tmp52_;
	ContactsListPane* _tmp53_;
	ContactsListPane* _tmp54_;
	ContactsStore* _tmp55_;
	ContactsContactPane* _tmp56_;
	ContactsContactPane* _tmp57_;
	ContactsContactPane* _tmp58_;
	ContactsContactPane* _tmp59_;
	ContactsContactPane* _tmp60_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_simple_action_new ("quit", NULL);
	action = _tmp0_;
	_tmp1_ = action;
	g_signal_connect_object (_tmp1_, "activate", (GCallback) ___lambda98__g_simple_action_activate, self, 0);
	_tmp2_ = action;
	g_action_map_add_action ((GActionMap*) self, (GAction*) _tmp2_);
	_tmp3_ = g_simple_action_new ("help", NULL);
	_g_object_unref0 (action);
	action = _tmp3_;
	_tmp4_ = action;
	g_signal_connect_object (_tmp4_, "activate", (GCallback) ___lambda99__g_simple_action_activate, self, 0);
	_tmp5_ = action;
	g_action_map_add_action ((GActionMap*) self, (GAction*) _tmp5_);
	_tmp6_ = g_simple_action_new ("about", NULL);
	_g_object_unref0 (action);
	action = _tmp6_;
	_tmp7_ = action;
	g_signal_connect_object (_tmp7_, "activate", (GCallback) ___lambda100__g_simple_action_activate, self, 0);
	_tmp8_ = action;
	g_action_map_add_action ((GActionMap*) self, (GAction*) _tmp8_);
	_tmp9_ = g_simple_action_new ("change_book", NULL);
	_g_object_unref0 (action);
	action = _tmp9_;
	_tmp10_ = action;
	g_signal_connect_object (_tmp10_, "activate", (GCallback) ___lambda101__g_simple_action_activate, self, 0);
	_tmp11_ = action;
	g_action_map_add_action ((GActionMap*) self, (GAction*) _tmp11_);
	_tmp12_ = gtk_builder_new ();
	builder = _tmp12_;
	gtk_builder_set_translation_domain (builder, GETTEXT_PACKAGE);
	{
		GObject* _tmp13_ = NULL;
		gtk_builder_add_from_resource (builder, "/org/gnome/contacts/app-menu.ui", &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
		_tmp13_ = gtk_builder_get_object (builder, "app-menu");
		gtk_application_set_app_menu ((GtkApplication*) self, G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, g_menu_model_get_type (), GMenuModel));
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error_);
		_inner_error_ = NULL;
		g_warning ("contacts-app.vala:235: Failed to parsing ui file");
	}
	__finally0:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (builder);
		_g_object_unref0 (action);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp14_ = contacts_window_new ((GtkApplication*) self);
	g_object_ref_sink (_tmp14_);
	_g_object_unref0 (self->window);
	self->window = _tmp14_;
	_tmp15_ = self->window;
	gtk_window_set_application ((GtkWindow*) _tmp15_, (GtkApplication*) self);
	_tmp16_ = self->window;
	_tmp17_ = _ ("Contacts");
	gtk_window_set_title ((GtkWindow*) _tmp16_, _tmp17_);
	_tmp18_ = self->window;
	gtk_window_set_default_size ((GtkWindow*) _tmp18_, 888, 600);
	_tmp19_ = self->window;
	gtk_window_set_hide_titlebar_when_maximized ((GtkWindow*) _tmp19_, TRUE);
	_tmp20_ = self->window;
	g_signal_connect_object ((GtkWidget*) _tmp20_, "delete-event", (GCallback) _contacts_app_window_delete_event_gtk_widget_delete_event, self, 0);
	_tmp21_ = self->window;
	g_signal_connect_object ((GtkWidget*) _tmp21_, "key-press-event", (GCallback) _contacts_app_window_key_press_event_gtk_widget_key_press_event, self, G_CONNECT_AFTER);
	_tmp22_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp22_);
	grid = _tmp22_;
	_tmp23_ = (GtkToolbar*) gtk_toolbar_new ();
	g_object_ref_sink (_tmp23_);
	toolbar = _tmp23_;
	_tmp24_ = toolbar;
	gtk_toolbar_set_icon_size (_tmp24_, GTK_ICON_SIZE_MENU);
	_tmp25_ = toolbar;
	_tmp26_ = gtk_widget_get_style_context ((GtkWidget*) _tmp25_);
	gtk_style_context_add_class (_tmp26_, GTK_STYLE_CLASS_MENUBAR);
	_tmp27_ = toolbar;
	_tmp28_ = gtk_widget_get_style_context ((GtkWidget*) _tmp27_);
	gtk_style_context_add_class (_tmp28_, "contacts-left-toolbar");
	_tmp29_ = toolbar;
	gtk_widget_set_vexpand ((GtkWidget*) _tmp29_, FALSE);
	_tmp30_ = toolbar;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp30_, FALSE);
	_tmp31_ = toolbar;
	gtk_grid_attach (grid, (GtkWidget*) _tmp31_, 0, 0, 1, 1);
	_tmp32_ = _ ("New");
	_tmp33_ = (GtkToolButton*) gtk_tool_button_new (NULL, _tmp32_);
	g_object_ref_sink (_tmp33_);
	add_button = _tmp33_;
	gtk_widget_set_margin_left ((GtkWidget*) add_button, 4);
	gtk_tool_item_set_is_important ((GtkToolItem*) add_button, TRUE);
	_tmp34_ = toolbar;
	gtk_container_add ((GtkContainer*) _tmp34_, (GtkWidget*) add_button);
	g_signal_connect_object (add_button, "clicked", (GCallback) ___lambda102__gtk_tool_button_clicked, self, 0);
	_tmp35_ = (GtkToolbar*) gtk_toolbar_new ();
	g_object_ref_sink (_tmp35_);
	_g_object_unref0 (toolbar);
	toolbar = _tmp35_;
	_tmp36_ = toolbar;
	gtk_toolbar_set_icon_size (_tmp36_, GTK_ICON_SIZE_MENU);
	_tmp37_ = toolbar;
	_tmp38_ = gtk_widget_get_style_context ((GtkWidget*) _tmp37_);
	gtk_style_context_add_class (_tmp38_, GTK_STYLE_CLASS_MENUBAR);
	_tmp39_ = toolbar;
	gtk_widget_set_vexpand ((GtkWidget*) _tmp39_, FALSE);
	_tmp40_ = toolbar;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp40_, TRUE);
	_tmp41_ = toolbar;
	gtk_grid_attach (grid, (GtkWidget*) _tmp41_, 1, 0, 1, 1);
	_tmp42_ = self->window;
	gtk_container_add ((GtkContainer*) _tmp42_, (GtkWidget*) grid);
	_tmp43_ = (GtkOverlay*) gtk_overlay_new ();
	g_object_ref_sink (_tmp43_);
	_g_object_unref0 (self->priv->overlay);
	self->priv->overlay = _tmp43_;
	_tmp44_.red = (gdouble) 0;
	_tmp44_.green = (gdouble) 0;
	_tmp44_.blue = (gdouble) 0;
	_tmp44_.alpha = (gdouble) 0;
	transparent = _tmp44_;
	_tmp45_ = self->priv->overlay;
	_tmp46_ = transparent;
	gtk_widget_override_background_color ((GtkWidget*) _tmp45_, 0, &_tmp46_);
	_tmp47_ = self->priv->overlay;
	_tmp48_ = (GtkAlignment*) gtk_alignment_new ((gfloat) 0, (gfloat) 0, (gfloat) 0, (gfloat) 0);
	g_object_ref_sink (_tmp48_);
	_tmp49_ = _tmp48_;
	gtk_container_add ((GtkContainer*) _tmp47_, (GtkWidget*) _tmp49_);
	_g_object_unref0 (_tmp49_);
	_tmp50_ = self->priv->overlay;
	gtk_grid_attach (grid, (GtkWidget*) _tmp50_, 0, 1, 2, 1);
	_tmp51_ = self->contacts_store;
	_tmp52_ = contacts_list_pane_new (_tmp51_);
	g_object_ref_sink (_tmp52_);
	_g_object_unref0 (self->priv->list_pane);
	self->priv->list_pane = _tmp52_;
	_tmp53_ = self->priv->list_pane;
	g_signal_connect_object (_tmp53_, "selection-changed", (GCallback) _contacts_app_selection_changed_contacts_list_pane_selection_changed, self, 0);
	_tmp54_ = self->priv->list_pane;
	gtk_grid_attach (grid, (GtkWidget*) _tmp54_, 0, 1, 1, 1);
	_tmp55_ = self->contacts_store;
	_tmp56_ = contacts_contact_pane_new (_tmp55_);
	g_object_ref_sink (_tmp56_);
	_g_object_unref0 (self->priv->contacts_pane);
	self->priv->contacts_pane = _tmp56_;
	_tmp57_ = self->priv->contacts_pane;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp57_, TRUE);
	_tmp58_ = self->priv->contacts_pane;
	g_signal_connect_object (_tmp58_, "will-delete", (GCallback) _contacts_app_delete_contact_contacts_contact_pane_will_delete, self, 0);
	_tmp59_ = self->priv->contacts_pane;
	g_signal_connect_object (_tmp59_, "contacts-linked", (GCallback) _contacts_app_contacts_linked_contacts_contact_pane_contacts_linked, self, 0);
	_tmp60_ = self->priv->contacts_pane;
	gtk_grid_attach (grid, (GtkWidget*) _tmp60_, 1, 1, 1, 1);
	gtk_widget_show_all ((GtkWidget*) grid);
	_g_object_unref0 (add_button);
	_g_object_unref0 (toolbar);
	_g_object_unref0 (grid);
	_g_object_unref0 (builder);
	_g_object_unref0 (action);
}


static void contacts_app_real_startup (GApplication* base) {
	ContactsApp * self;
	ContactsStore* _tmp0_;
	self = (ContactsApp*) base;
	contacts_ensure_eds_accounts ();
	_tmp0_ = contacts_store_new ();
	_g_object_unref0 (self->contacts_store);
	self->contacts_store = _tmp0_;
	G_APPLICATION_CLASS (contacts_app_parent_class)->startup ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, GTK_TYPE_APPLICATION, GtkApplication));
}


static Block6Data* block6_data_ref (Block6Data* _data6_) {
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}


static void block6_data_unref (void * _userdata_) {
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		ContactsApp * self;
		self = _data6_->self;
		_g_object_unref0 (_data6_->setup);
		_g_object_unref0 (self);
		g_slice_free (Block6Data, _data6_);
	}
}


static void __lambda119_ (Block6Data* _data6_) {
	ContactsApp * self;
	gboolean _tmp0_;
	self = _data6_->self;
	gtk_widget_destroy ((GtkWidget*) _data6_->setup);
	_tmp0_ = _data6_->setup->succeeded;
	if (_tmp0_) {
		g_application_activate ((GApplication*) self);
	}
}


static void ___lambda119__gtk_widget_destroy (GtkWidget* _sender, gpointer self) {
	__lambda119_ (self);
}


static void contacts_app_show_setup (ContactsApp* self) {
	Block6Data* _data6_;
	ContactsSetupWindow* _tmp0_;
	g_return_if_fail (self != NULL);
	_data6_ = g_slice_new0 (Block6Data);
	_data6_->_ref_count_ = 1;
	_data6_->self = g_object_ref (self);
	_tmp0_ = contacts_setup_window_new ();
	g_object_ref_sink (_tmp0_);
	_data6_->setup = _tmp0_;
	gtk_window_set_application ((GtkWindow*) _data6_->setup, (GtkApplication*) self);
	g_signal_connect_data ((GtkWidget*) _data6_->setup, "destroy", (GCallback) ___lambda119__gtk_widget_destroy, block6_data_ref (_data6_), (GClosureNotify) block6_data_unref, 0);
	gtk_widget_show ((GtkWidget*) _data6_->setup);
	block6_data_unref (_data6_);
	_data6_ = NULL;
}


static Block7Data* block7_data_ref (Block7Data* _data7_) {
	g_atomic_int_inc (&_data7_->_ref_count_);
	return _data7_;
}


static void block7_data_unref (void * _userdata_) {
	Block7Data* _data7_;
	_data7_ = (Block7Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
		ContactsApp * self;
		self = _data7_->self;
		_g_object_unref0 (self);
		g_slice_free (Block7Data, _data7_);
	}
}


static void _____lambda120_ (Block7Data* _data7_) {
	ContactsApp * self;
	ContactsStore* _tmp0_;
	gulong _tmp1_;
	guint _tmp2_;
	self = _data7_->self;
	contacts_app_show_setup (self);
	_tmp0_ = self->contacts_store;
	_tmp1_ = _data7_->id;
	g_signal_handler_disconnect ((GObject*) _tmp0_, _tmp1_);
	_tmp2_ = _data7_->id2;
	g_source_remove (_tmp2_);
	g_application_release ((GApplication*) self);
}


static void ______lambda120__contacts_store_prepared (ContactsStore* _sender, gpointer self) {
	_____lambda120_ (self);
}


static gboolean _____lambda121_ (Block7Data* _data7_) {
	ContactsApp * self;
	gboolean result = FALSE;
	ContactsStore* _tmp0_;
	gulong _tmp1_;
	self = _data7_->self;
	contacts_app_show_setup (self);
	_tmp0_ = self->contacts_store;
	_tmp1_ = _data7_->id;
	g_signal_handler_disconnect ((GObject*) _tmp0_, _tmp1_);
	g_application_release ((GApplication*) self);
	result = FALSE;
	return result;
}


static gboolean ______lambda121__gsource_func (gpointer self) {
	gboolean result;
	result = _____lambda121_ (self);
	return result;
}


static void ___lambda122_ (ContactsApp* self) {
	ContactsApp* _tmp0_;
	ContactsWindow* _tmp1_;
	_tmp0_ = contacts_app_app;
	_tmp1_ = _tmp0_->window;
	gtk_widget_show ((GtkWidget*) _tmp1_);
}


static void ____lambda122__contacts_store_quiescent (ContactsStore* _sender, gpointer self) {
	___lambda122_ (self);
}


static gboolean ___lambda123_ (ContactsApp* self) {
	gboolean result = FALSE;
	ContactsApp* _tmp0_;
	ContactsWindow* _tmp1_;
	_tmp0_ = contacts_app_app;
	_tmp1_ = _tmp0_->window;
	gtk_widget_show ((GtkWidget*) _tmp1_);
	result = FALSE;
	return result;
}


static gboolean ____lambda123__gsource_func (gpointer self) {
	gboolean result;
	result = ___lambda123_ (self);
	return result;
}


static void contacts_app_real_activate (GApplication* base) {
	ContactsApp * self;
	ContactsWindow* _tmp0_;
	self = (ContactsApp*) base;
	_tmp0_ = self->window;
	if (_tmp0_ == NULL) {
		GSettings* _tmp1_;
		gboolean _tmp2_ = FALSE;
		ContactsStore* _tmp9_;
		_tmp1_ = self->settings;
		_tmp2_ = g_settings_get_boolean (_tmp1_, "did-initial-setup");
		if (!_tmp2_) {
			ContactsStore* _tmp3_;
			gboolean _tmp4_;
			gboolean _tmp5_;
			_tmp3_ = self->contacts_store;
			_tmp4_ = contacts_store_get_is_prepared (_tmp3_);
			_tmp5_ = _tmp4_;
			if (_tmp5_) {
				contacts_app_show_setup (self);
			} else {
				Block7Data* _data7_;
				ContactsStore* _tmp6_;
				gulong _tmp7_ = 0UL;
				guint _tmp8_ = 0U;
				_data7_ = g_slice_new0 (Block7Data);
				_data7_->_ref_count_ = 1;
				_data7_->self = g_object_ref (self);
				g_application_hold ((GApplication*) self);
				_data7_->id = (gulong) 0;
				_data7_->id2 = (guint) 0;
				_tmp6_ = self->contacts_store;
				_tmp7_ = g_signal_connect_data (_tmp6_, "prepared", (GCallback) ______lambda120__contacts_store_prepared, block7_data_ref (_data7_), (GClosureNotify) block7_data_unref, 0);
				_data7_->id = _tmp7_;
				_tmp8_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 500, ______lambda121__gsource_func, block7_data_ref (_data7_), block7_data_unref);
				_data7_->id2 = _tmp8_;
				block7_data_unref (_data7_);
				_data7_ = NULL;
			}
			return;
		}
		contacts_app_create_window (self);
		_tmp9_ = self->contacts_store;
		g_signal_connect_object (_tmp9_, "quiescent", (GCallback) ____lambda122__contacts_store_quiescent, self, 0);
		g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 500, ____lambda123__gsource_func, g_object_ref (self), g_object_unref);
	} else {
		ContactsWindow* _tmp10_;
		_tmp10_ = self->window;
		gtk_window_present ((GtkWindow*) _tmp10_);
	}
}


void contacts_app_show_message (ContactsApp* self, const gchar* message) {
	GtkNotification* _tmp0_;
	GtkNotification* notification;
	GtkGrid* _tmp1_;
	GtkGrid* g;
	const gchar* _tmp2_;
	GtkLabel* _tmp3_;
	GtkLabel* l;
	GtkOverlay* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (message != NULL);
	_tmp0_ = (GtkNotification*) gtk_notification_new ();
	g_object_ref_sink (_tmp0_);
	notification = _tmp0_;
	_tmp1_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp1_);
	g = _tmp1_;
	gtk_grid_set_column_spacing (g, (guint) 8);
	_tmp2_ = message;
	_tmp3_ = (GtkLabel*) gtk_label_new (_tmp2_);
	g_object_ref_sink (_tmp3_);
	l = _tmp3_;
	gtk_label_set_line_wrap (l, TRUE);
	gtk_label_set_line_wrap_mode (l, PANGO_WRAP_WORD_CHAR);
	gtk_container_add ((GtkContainer*) notification, (GtkWidget*) l);
	gtk_widget_show_all ((GtkWidget*) notification);
	_tmp4_ = self->priv->overlay;
	gtk_overlay_add_overlay (_tmp4_, (GtkWidget*) notification);
	_g_object_unref0 (l);
	_g_object_unref0 (g);
	_g_object_unref0 (notification);
}


static Block8Data* block8_data_ref (Block8Data* _data8_) {
	g_atomic_int_inc (&_data8_->_ref_count_);
	return _data8_;
}


static void block8_data_unref (void * _userdata_) {
	Block8Data* _data8_;
	_data8_ = (Block8Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data8_->_ref_count_)) {
		ContactsApp * self;
		self = _data8_->self;
		_g_object_unref0 (_data8_->notification);
		_g_object_unref0 (_data8_->contact);
		_g_object_unref0 (self);
		g_slice_free (Block8Data, _data8_);
	}
}


static void ___lambda111_ (Block8Data* _data8_) {
	ContactsApp * self;
	ContactsContact* _tmp0_;
	self = _data8_->self;
	_tmp0_ = _data8_->contact;
	contacts_contact_show (_tmp0_);
}


static void ____lambda111__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	___lambda111_ (self);
	block8_data_unref (self);
}


static void __lambda110_ (Block8Data* _data8_) {
	ContactsApp * self;
	self = _data8_->self;
	if (_data8_->really_delete) {
		ContactsContact* _tmp0_;
		_tmp0_ = _data8_->contact;
		contacts_contact_remove_personas (_tmp0_, ____lambda111__gasync_ready_callback, block8_data_ref (_data8_));
	}
}


static void ___lambda110__gtk_notification_dismissed (GtkNotification* _sender, gpointer self) {
	__lambda110_ (self);
}


static void __lambda112_ (Block8Data* _data8_) {
	ContactsApp * self;
	ContactsContact* _tmp0_;
	ContactsListPane* _tmp1_;
	ContactsContact* _tmp2_;
	ContactsContactPane* _tmp3_;
	ContactsContact* _tmp4_;
	self = _data8_->self;
	_data8_->really_delete = FALSE;
	gtk_notification_dismiss (_data8_->notification);
	_tmp0_ = _data8_->contact;
	contacts_contact_show (_tmp0_);
	_tmp1_ = self->priv->list_pane;
	_tmp2_ = _data8_->contact;
	contacts_list_pane_select_contact (_tmp1_, _tmp2_, FALSE);
	_tmp3_ = self->priv->contacts_pane;
	_tmp4_ = _data8_->contact;
	contacts_contact_pane_show_contact (_tmp3_, _tmp4_, FALSE, TRUE);
}


static void ___lambda112__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	__lambda112_ (self);
}


static void contacts_app_delete_contact (ContactsApp* self, ContactsContact* contact) {
	Block8Data* _data8_;
	ContactsContact* _tmp0_;
	ContactsContact* _tmp1_;
	GtkNotification* _tmp2_;
	GtkGrid* _tmp3_;
	GtkGrid* g;
	const gchar* _tmp4_ = NULL;
	ContactsContact* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_ = NULL;
	gchar* msg;
	GtkButton* _tmp9_;
	GtkButton* b;
	GtkLabel* _tmp10_;
	GtkLabel* _tmp11_;
	GtkOverlay* _tmp12_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (contact != NULL);
	_data8_ = g_slice_new0 (Block8Data);
	_data8_->_ref_count_ = 1;
	_data8_->self = g_object_ref (self);
	_tmp0_ = contact;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data8_->contact);
	_data8_->contact = _tmp1_;
	_tmp2_ = (GtkNotification*) gtk_notification_new ();
	g_object_ref_sink (_tmp2_);
	_data8_->notification = _tmp2_;
	_tmp3_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp3_);
	g = _tmp3_;
	gtk_grid_set_column_spacing (g, (guint) 8);
	gtk_container_add ((GtkContainer*) _data8_->notification, (GtkWidget*) g);
	_tmp4_ = _ ("Contact deleted: \"%s\"");
	_tmp5_ = _data8_->contact;
	_tmp6_ = contacts_contact_get_display_name (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strdup_printf (_tmp4_, _tmp7_);
	msg = _tmp8_;
	_tmp9_ = (GtkButton*) gtk_button_new_from_stock (GTK_STOCK_UNDO);
	g_object_ref_sink (_tmp9_);
	b = _tmp9_;
	_tmp10_ = (GtkLabel*) gtk_label_new (msg);
	g_object_ref_sink (_tmp10_);
	_tmp11_ = _tmp10_;
	gtk_container_add ((GtkContainer*) g, (GtkWidget*) _tmp11_);
	_g_object_unref0 (_tmp11_);
	gtk_container_add ((GtkContainer*) g, (GtkWidget*) b);
	_data8_->really_delete = TRUE;
	gtk_widget_show_all ((GtkWidget*) _data8_->notification);
	g_signal_connect_data (_data8_->notification, "dismissed", (GCallback) ___lambda110__gtk_notification_dismissed, block8_data_ref (_data8_), (GClosureNotify) block8_data_unref, 0);
	g_signal_connect_data (b, "clicked", (GCallback) ___lambda112__gtk_button_clicked, block8_data_ref (_data8_), (GClosureNotify) block8_data_unref, 0);
	_tmp12_ = self->priv->overlay;
	gtk_overlay_add_overlay (_tmp12_, (GtkWidget*) _data8_->notification);
	_g_object_unref0 (b);
	_g_free0 (msg);
	_g_object_unref0 (g);
	block8_data_unref (_data8_);
	_data8_ = NULL;
}


static Block9Data* block9_data_ref (Block9Data* _data9_) {
	g_atomic_int_inc (&_data9_->_ref_count_);
	return _data9_;
}


static void block9_data_unref (void * _userdata_) {
	Block9Data* _data9_;
	_data9_ = (Block9Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data9_->_ref_count_)) {
		ContactsApp * self;
		self = _data9_->self;
		_g_object_unref0 (_data9_->notification);
		_g_object_unref0 (_data9_->operation);
		_g_object_unref0 (self);
		g_slice_free (Block9Data, _data9_);
	}
}


static void __lambda113_ (Block9Data* _data9_) {
	ContactsApp * self;
	GtkNotification* _tmp0_;
	ContactsLinkOperation* _tmp1_;
	self = _data9_->self;
	_tmp0_ = _data9_->notification;
	gtk_notification_dismiss (_tmp0_);
	_tmp1_ = _data9_->operation;
	contacts_link_operation_undo (_tmp1_, NULL, NULL);
}


static void ___lambda113__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	__lambda113_ (self);
}


static void contacts_app_contacts_linked (ContactsApp* self, const gchar* main_contact, const gchar* linked_contact, ContactsLinkOperation* operation) {
	Block9Data* _data9_;
	ContactsLinkOperation* _tmp0_;
	ContactsLinkOperation* _tmp1_;
	GtkNotification* _tmp2_;
	GtkGrid* _tmp3_;
	GtkGrid* g;
	GtkGrid* _tmp4_;
	GtkNotification* _tmp5_;
	GtkGrid* _tmp6_;
	gchar* msg = NULL;
	const gchar* _tmp7_;
	GtkButton* _tmp15_;
	GtkButton* b;
	GtkGrid* _tmp16_;
	const gchar* _tmp17_;
	GtkLabel* _tmp18_;
	GtkLabel* _tmp19_;
	GtkGrid* _tmp20_;
	GtkNotification* _tmp21_;
	GtkOverlay* _tmp22_;
	GtkNotification* _tmp23_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (linked_contact != NULL);
	g_return_if_fail (operation != NULL);
	_data9_ = g_slice_new0 (Block9Data);
	_data9_->_ref_count_ = 1;
	_data9_->self = g_object_ref (self);
	_tmp0_ = operation;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data9_->operation);
	_data9_->operation = _tmp1_;
	_tmp2_ = (GtkNotification*) gtk_notification_new ();
	g_object_ref_sink (_tmp2_);
	_data9_->notification = _tmp2_;
	_tmp3_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp3_);
	g = _tmp3_;
	_tmp4_ = g;
	gtk_grid_set_column_spacing (_tmp4_, (guint) 8);
	_tmp5_ = _data9_->notification;
	_tmp6_ = g;
	gtk_container_add ((GtkContainer*) _tmp5_, (GtkWidget*) _tmp6_);
	_tmp7_ = main_contact;
	if (_tmp7_ != NULL) {
		const gchar* _tmp8_ = NULL;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		gchar* _tmp11_ = NULL;
		_tmp8_ = _ ("%s linked to %s");
		_tmp9_ = main_contact;
		_tmp10_ = linked_contact;
		_tmp11_ = g_strdup_printf (_tmp8_, _tmp9_, _tmp10_);
		_g_free0 (msg);
		msg = _tmp11_;
	} else {
		const gchar* _tmp12_ = NULL;
		const gchar* _tmp13_;
		gchar* _tmp14_ = NULL;
		_tmp12_ = _ ("%s linked to the contact");
		_tmp13_ = linked_contact;
		_tmp14_ = g_strdup_printf (_tmp12_, _tmp13_);
		_g_free0 (msg);
		msg = _tmp14_;
	}
	_tmp15_ = (GtkButton*) gtk_button_new_from_stock (GTK_STOCK_UNDO);
	g_object_ref_sink (_tmp15_);
	b = _tmp15_;
	_tmp16_ = g;
	_tmp17_ = msg;
	_tmp18_ = (GtkLabel*) gtk_label_new (_tmp17_);
	g_object_ref_sink (_tmp18_);
	_tmp19_ = _tmp18_;
	gtk_container_add ((GtkContainer*) _tmp16_, (GtkWidget*) _tmp19_);
	_g_object_unref0 (_tmp19_);
	_tmp20_ = g;
	gtk_container_add ((GtkContainer*) _tmp20_, (GtkWidget*) b);
	_tmp21_ = _data9_->notification;
	gtk_widget_show_all ((GtkWidget*) _tmp21_);
	g_signal_connect_data (b, "clicked", (GCallback) ___lambda113__gtk_button_clicked, block9_data_ref (_data9_), (GClosureNotify) block9_data_unref, 0);
	_tmp22_ = self->priv->overlay;
	_tmp23_ = _data9_->notification;
	gtk_overlay_add_overlay (_tmp22_, (GtkWidget*) _tmp23_);
	_g_object_unref0 (b);
	_g_free0 (msg);
	_g_object_unref0 (g);
	block9_data_unref (_data9_);
	_data9_ = NULL;
}


static gint contacts_app_real_command_line (GApplication* base, GApplicationCommandLine* command_line) {
	ContactsApp * self;
	gint result = 0;
	GApplicationCommandLine* _tmp0_;
	gint _tmp1_ = 0;
	gchar** _tmp2_ = NULL;
	gchar** args;
	gint args_length1;
	gint _args_size_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	gchar** _args;
	gint _args_length1;
	gint __args_size_;
	GOptionContext* _tmp4_;
	GOptionContext* context;
	GOptionContext* _tmp5_;
	GOptionContext* _tmp6_;
	GOptionContext* _tmp7_;
	GOptionGroup* _tmp8_ = NULL;
	const gchar* _tmp12_;
	const gchar* _tmp15_;
	GError * _inner_error_ = NULL;
	self = (ContactsApp*) base;
	g_return_val_if_fail (command_line != NULL, 0);
	_tmp0_ = command_line;
	_tmp2_ = g_application_command_line_get_arguments (_tmp0_, &_tmp1_);
	args = _tmp2_;
	args_length1 = _tmp1_;
	_args_size_ = args_length1;
	_tmp3_ = args;
	_tmp3__length1 = args_length1;
	_args = _tmp3_;
	_args_length1 = _tmp3__length1;
	__args_size_ = _args_length1;
	_tmp4_ = g_option_context_new ("— contact management");
	context = _tmp4_;
	_tmp5_ = context;
	g_option_context_add_main_entries (_tmp5_, CONTACTS_APP_options, GETTEXT_PACKAGE);
	_tmp6_ = context;
	g_option_context_set_translation_domain (_tmp6_, GETTEXT_PACKAGE);
	_tmp7_ = context;
	_tmp8_ = gtk_get_option_group (TRUE);
	g_option_context_add_group (_tmp7_, _tmp8_);
	_g_free0 (contacts_app_individual_id);
	contacts_app_individual_id = NULL;
	_g_free0 (contacts_app_email_address);
	contacts_app_email_address = NULL;
	{
		GOptionContext* _tmp9_;
		_tmp9_ = context;
		g_option_context_parse (_tmp9_, &_args_length1, &_args, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		GError* _tmp10_;
		const gchar* _tmp11_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp10_ = e;
		_tmp11_ = _tmp10_->message;
		g_printerr ("Unable to parse: %s\n", _tmp11_);
		result = 1;
		_g_error_free0 (e);
		_g_option_context_free0 (context);
		args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	__finally1:
	if (_inner_error_ != NULL) {
		_g_option_context_free0 (context);
		args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	g_application_activate ((GApplication*) self);
	_tmp12_ = contacts_app_individual_id;
	if (_tmp12_ != NULL) {
		ContactsApp* _tmp13_;
		const gchar* _tmp14_;
		_tmp13_ = contacts_app_app;
		_tmp14_ = contacts_app_individual_id;
		contacts_app_show_individual (_tmp13_, _tmp14_, NULL, NULL);
	}
	_tmp15_ = contacts_app_email_address;
	if (_tmp15_ != NULL) {
		ContactsApp* _tmp16_;
		const gchar* _tmp17_;
		_tmp16_ = contacts_app_app;
		_tmp17_ = contacts_app_email_address;
		contacts_app_show_by_email (_tmp16_, _tmp17_, NULL, NULL);
	}
	result = 0;
	_g_option_context_free0 (context);
	args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


static void _vala_array_add1 (FolksPersonaStore*** array, int* length, int* size, FolksPersonaStore* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (FolksPersonaStore*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


FolksPersonaStore** contacts_app_get_eds_address_books (int* result_length1) {
	FolksPersonaStore** result = NULL;
	FolksPersonaStore** _tmp0_ = NULL;
	FolksPersonaStore** stores;
	gint stores_length1;
	gint _stores_size_;
	FolksPersonaStore** _tmp34_;
	gint _tmp34__length1;
	_tmp0_ = g_new0 (FolksPersonaStore*, 0 + 1);
	stores = _tmp0_;
	stores_length1 = 0;
	_stores_size_ = stores_length1;
	{
		ContactsApp* _tmp1_;
		ContactsStore* _tmp2_;
		FolksBackendStore* _tmp3_;
		FolksBackendStore* _tmp4_;
		GeeMap* _tmp5_;
		GeeMap* _tmp6_;
		GeeCollection* _tmp7_;
		GeeCollection* _tmp8_;
		GeeCollection* _tmp9_;
		GeeIterator* _tmp10_ = NULL;
		GeeIterator* _tmp11_;
		GeeIterator* _backend_it;
		_tmp1_ = contacts_app_app;
		_tmp2_ = _tmp1_->contacts_store;
		_tmp3_ = contacts_store_get_backend_store (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = folks_backend_store_get_enabled_backends (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = gee_map_get_values (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = _tmp8_;
		_tmp10_ = gee_iterable_iterator ((GeeIterable*) _tmp9_);
		_tmp11_ = _tmp10_;
		_g_object_unref0 (_tmp9_);
		_backend_it = _tmp11_;
		while (TRUE) {
			GeeIterator* _tmp12_;
			gboolean _tmp13_ = FALSE;
			GeeIterator* _tmp14_;
			gpointer _tmp15_ = NULL;
			FolksBackend* backend;
			_tmp12_ = _backend_it;
			_tmp13_ = gee_iterator_next (_tmp12_);
			if (!_tmp13_) {
				break;
			}
			_tmp14_ = _backend_it;
			_tmp15_ = gee_iterator_get (_tmp14_);
			backend = (FolksBackend*) _tmp15_;
			{
				FolksBackend* _tmp16_;
				GeeMap* _tmp17_;
				GeeMap* _tmp18_;
				GeeCollection* _tmp19_;
				GeeCollection* _tmp20_;
				GeeCollection* _tmp21_;
				GeeIterator* _tmp22_ = NULL;
				GeeIterator* _tmp23_;
				GeeIterator* _persona_store_it;
				_tmp16_ = backend;
				_tmp17_ = folks_backend_get_persona_stores (_tmp16_);
				_tmp18_ = _tmp17_;
				_tmp19_ = gee_map_get_values (_tmp18_);
				_tmp20_ = _tmp19_;
				_tmp21_ = _tmp20_;
				_tmp22_ = gee_iterable_iterator ((GeeIterable*) _tmp21_);
				_tmp23_ = _tmp22_;
				_g_object_unref0 (_tmp21_);
				_persona_store_it = _tmp23_;
				while (TRUE) {
					GeeIterator* _tmp24_;
					gboolean _tmp25_ = FALSE;
					GeeIterator* _tmp26_;
					gpointer _tmp27_ = NULL;
					FolksPersonaStore* persona_store;
					FolksPersonaStore* _tmp28_;
					const gchar* _tmp29_;
					const gchar* _tmp30_;
					_tmp24_ = _persona_store_it;
					_tmp25_ = gee_iterator_next (_tmp24_);
					if (!_tmp25_) {
						break;
					}
					_tmp26_ = _persona_store_it;
					_tmp27_ = gee_iterator_get (_tmp26_);
					persona_store = (FolksPersonaStore*) _tmp27_;
					_tmp28_ = persona_store;
					_tmp29_ = folks_persona_store_get_type_id (_tmp28_);
					_tmp30_ = _tmp29_;
					if (g_strcmp0 (_tmp30_, "eds") == 0) {
						FolksPersonaStore** _tmp31_;
						gint _tmp31__length1;
						FolksPersonaStore* _tmp32_;
						FolksPersonaStore* _tmp33_;
						_tmp31_ = stores;
						_tmp31__length1 = stores_length1;
						_tmp32_ = persona_store;
						_tmp33_ = _g_object_ref0 (_tmp32_);
						_vala_array_add1 (&stores, &stores_length1, &_stores_size_, _tmp33_);
					}
					_g_object_unref0 (persona_store);
				}
				_g_object_unref0 (_persona_store_it);
			}
			_g_object_unref0 (backend);
		}
		_g_object_unref0 (_backend_it);
	}
	_tmp34_ = stores;
	_tmp34__length1 = stores_length1;
	if (result_length1) {
		*result_length1 = _tmp34__length1;
	}
	result = _tmp34_;
	return result;
}


ContactsApp* contacts_app_construct (GType object_type) {
	ContactsApp * self = NULL;
	ContactsApp* _tmp0_;
	GSettings* _tmp1_;
	self = (ContactsApp*) g_object_new (object_type, "application-id", "org.gnome.Contacts", "flags", G_APPLICATION_HANDLES_COMMAND_LINE, NULL);
	_tmp0_ = _g_object_ref0 (self);
	_g_object_unref0 (contacts_app_app);
	contacts_app_app = _tmp0_;
	_tmp1_ = g_settings_new ("org.gnome.Contacts");
	_g_object_unref0 (self->settings);
	self->settings = _tmp1_;
	return self;
}


ContactsApp* contacts_app_new (void) {
	return contacts_app_construct (CONTACTS_TYPE_APP);
}


static void contacts_app_class_init (ContactsAppClass * klass) {
	contacts_app_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ContactsAppPrivate));
	G_APPLICATION_CLASS (klass)->startup = contacts_app_real_startup;
	G_APPLICATION_CLASS (klass)->activate = contacts_app_real_activate;
	G_APPLICATION_CLASS (klass)->command_line = contacts_app_real_command_line;
	G_OBJECT_CLASS (klass)->finalize = contacts_app_finalize;
}


static void contacts_app_instance_init (ContactsApp * self) {
	self->priv = CONTACTS_APP_GET_PRIVATE (self);
}


static void contacts_app_finalize (GObject* obj) {
	ContactsApp * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONTACTS_TYPE_APP, ContactsApp);
	_g_object_unref0 (self->settings);
	_g_object_unref0 (self->window);
	_g_object_unref0 (self->contacts_store);
	_g_object_unref0 (self->priv->list_pane);
	_g_object_unref0 (self->priv->contacts_pane);
	_g_object_unref0 (self->priv->overlay);
	G_OBJECT_CLASS (contacts_app_parent_class)->finalize (obj);
}


GType contacts_app_get_type (void) {
	static volatile gsize contacts_app_type_id__volatile = 0;
	if (g_once_init_enter (&contacts_app_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ContactsAppClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) contacts_app_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ContactsApp), 0, (GInstanceInitFunc) contacts_app_instance_init, NULL };
		GType contacts_app_type_id;
		contacts_app_type_id = g_type_register_static (GTK_TYPE_APPLICATION, "ContactsApp", &g_define_type_info, 0);
		g_once_init_leave (&contacts_app_type_id__volatile, contacts_app_type_id);
	}
	return contacts_app_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



