/* Glom
 *
 * Copyright (C) 2001-2004 Murray Cumming
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef NOTEBOOK_FIND_H
#define NOTEBOOK_FIND_H

#include "../mode_data/notebook_data.h"
#include "box_data_list_find.h"
#include "box_data_details_find.h"

namespace Glom
{

class Notebook_Find : public Notebook_Glom
{
public: 
  Notebook_Find();
  virtual ~Notebook_Find();

  virtual bool init_db_details(const Glib::ustring& table_name);

  void set_current_view(Notebook_Data::dataview view);

  /** Emitted when the user has entered a find critera that
   * should be used to find and display records.
   * @param find_criteria The SQL where clause.
   */
  sigc::signal<void, Glib::ustring> signal_find_criteria;

protected:


  //Signal handlers:
  virtual void on_page_find_criteria(const Glib::ustring& where_clause);

  //Member widgets:
  Box_Data_List_Find m_Box_List;
  Box_Data_Details_Find m_Box_Details;

  guint m_iPage_Details, m_iPage_List;
};

} //namespace Glom

#endif
