/*  Glimmer - gnome-file-selector.h
 *  This library is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Library General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <libgnomevfs/gnome-vfs-types.h>
#include <libgnomevfs/gnome-vfs-uri.h>

#include <gnome.h>
#include <sys/stat.h>
#include <unistd.h>

#ifndef _GNOME_FILE_SELECTOR_H_
#define _GNOME_FILE_SELECTOR_H_

#ifdef __cplusplus
extern "C" {
#endif

#define GNOME_TYPE_FILELIST (gnome_file_selector_get_type())
#define GNOME_FILE_SELECTOR(obj) (GTK_CHECK_CAST((obj), GNOME_TYPE_FILELIST, GnomeFileSelector))
#define GNOME_FILE_SELECTOR_CLASS(klass) (GTK_CHECK_CLASS_CAST((klass), GNOME_TYPE_FILELIST, GnomeFileSelectorClass))
#define GNOME_IS_FILELIST(obj) (GTK_CHECK_TYPE((obj), GNOME_TYPE_FILELIST))
#define GNOME_IS_FILELIST_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), GNOME_TYPE_FILELIST))

typedef enum
{
   GNOME_FILE_SELECTOR_SINGLE,
   GNOME_FILE_SELECTOR_MULTIPLE
} GnomeFileSelectorType;

typedef struct _GnomeFileSelector GnomeFileSelector;
typedef struct _GnomeFileSelectorClass GnomeFileSelectorClass;

struct _GnomeFileSelector {
   GtkWindow window;
   GtkWidget *back_button;
   GtkWidget *forward_button;
   GtkWidget *create_button;
   GtkWidget *delete_button;
   GtkWidget *rename_button;
   GtkWidget *dots_toggle;
   GtkWidget *details_toggle;
   GtkWidget *history_combo;
   GtkWidget *directory_list;
   GtkWidget *file_selector;
   GtkWidget *filter_entry;
   GtkWidget *selection_entry;
   GtkWidget *ok_button;
   GtkWidget *cancel_button;
   GnomePixmap *folder;
   GnomePixmap *file;
   GnomeFileSelectorType type;
   gboolean show_dots;
   gboolean show_details;
   gint history_max;

   gchar *path;
   GList *history;
   gint history_position;
   gint selected_row;
   gchar *entry_text;
   GHashTable *pixmaps;
};

struct _GnomeFileSelectorClass {
   GtkWindowClass parent_class;
};

GtkType gnome_file_selector_get_type(void);

/* make a new widget */
GtkWidget* gnome_file_selector_new(GnomeFileSelectorType type, gboolean show_dots, gboolean show_details);

/* start it off with a particular path */
GtkWidget *gnome_file_selector_new_with_path(gchar *path, GnomeFileSelectorType type, gboolean show_dots, gboolean show_details);

/* This function is only good for save dialogs now */
/* get the current selection...make sure to free it with g_free() */
gchar *gnome_file_selector_get_filename(GnomeFileSelector *file_selector);
GnomeVFSURI *gnome_file_selector_get_uri(GnomeFileSelector *file_selector);
GList *gnome_file_selector_get_uri_list(GnomeFileSelector *file_selector);
gchar *gnome_file_selector_get_path(GnomeFileSelector *file_selector);

void gnome_file_selector_set_title(GnomeFileSelector *file_selector, gchar *title);
gboolean gnome_file_selector_set_dir(GnomeFileSelector *file_selector, gchar *path);

void gnome_file_selector_set_show_dots(GnomeFileSelector *file_selector, gboolean show_dots);
gboolean gnome_file_selector_show_dots(GnomeFileSelector *file_selector);

void gnome_file_selector_set_show_details(GnomeFileSelector *file_selector, gboolean show_details);
gboolean gnome_file_selector_show_details(GnomeFileSelector *file_selector);

void gnome_file_selector_set_history_max(GnomeFileSelector *file_selector, gint history_max);
gint gnome_file_selector_history_max(GnomeFileSelector *file_selector);

gboolean gnome_file_selector_history_add_string(GnomeFileSelector *file_selector, gchar *string);
#ifdef __cplusplus /* cpp compatibility */
}
#endif
#endif
