/*  Glimmer - mdi-routines.c
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <libgnomevfs/gnome-vfs-types.h>
#include <libgnomevfs/gnome-vfs-uri.h>

#include "declarations.h"
#include "mdi-routines.h"
#include "file-io.h"
#include "main.h"
#include "menus.h"
#include "misc.h"
#include "settings.h"
#include "signals.h"
#include "toolbar.h"
#include "widgets/gdsfile.h"
#include "widgets/gdstearaway.h"

void gds_file_ask_focus(GtkWidget *widget, GdsFile *gds_file);
void undo_changed(GtkWidget *widget, GdsFile *gds_file);
void editor_window_focused(GtkWidget *widget, GdkEventFocus *event, GdsFile *file);

GtkStyle *normal_style = NULL;
GtkStyle *changed_style = NULL;

GdsFile *construct_file(GnomeVFSURI *uri)
{
   GdsFile *new_file;
   GdsFile *back_file;

   if(!normal_style) init_label_styles(window->style);
   if(!general_preferences.use_gtk_theme)
   {
      extext_style->text[GTK_STATE_NORMAL] = general_preferences.fg;
      extext_style->bg[GTK_STATE_NORMAL] = general_preferences.bg;
      extext_style->bg[GTK_STATE_SELECTED] = general_preferences.s_bg;
      extext_style->bg[GTK_STATE_PRELIGHT] = general_preferences.bm_bg;
      extext_style->bg[GTK_STATE_INSENSITIVE] = general_preferences.gutter_bg;
      extext_style->bg_pixmap[GTK_STATE_NORMAL] = general_preferences.bg_pixmap ? general_preferences.bg_pixmap->pixmap : NULL;
   }
   
   new_file = (GdsFile *)gds_file_new(uri, general_preferences.full_filenames);
   new_file->props.dir = gnome_vfs_uri_get_host_path(uri);
   gtk_signal_connect(GTK_OBJECT(new_file->tear_away), "window_focused", GTK_SIGNAL_FUNC(file_change), new_file);
   gtk_signal_connect(GTK_OBJECT(new_file->tear_away), "attached", GTK_SIGNAL_FUNC(file_change), new_file);
   gtk_signal_connect(GTK_OBJECT(new_file->text), "undo_changed", GTK_SIGNAL_FUNC(undo_changed), new_file);
   gtk_signal_connect(GTK_OBJECT(new_file->text), "move_to_column", GTK_SIGNAL_FUNC(file_pos_changed), 0);
   gtk_signal_connect(GTK_OBJECT(new_file->text), "focus_in_event", GTK_SIGNAL_FUNC(editor_window_focused), new_file);
   gtk_widget_set_style(new_file->text, extext_style);
   gtk_extext_set_tab_width(GTK_EXTEXT(new_file->text), general_preferences.spaces);
   gtk_extext_set_use_tab_stops(GTK_EXTEXT(new_file->text), general_preferences.tab_stops);
   gtk_widget_show(GTK_WIDGET(new_file));
   files_list = g_list_append(files_list, (gpointer)new_file);
   total_files++;
   gtk_signal_connect(GTK_OBJECT(new_file->menu_item), "activate", GTK_SIGNAL_FUNC(gds_file_focus_with_raise), new_file);
   gtk_menu_append(GTK_MENU(docsmenu), new_file->menu_item);
   new_file->props.bracketmatch = general_preferences.bracketmatch;
   new_file->props.auto_indent = general_preferences.auto_indent;
   new_file->props.use_spaces = general_preferences.use_spaces;
   new_file->props.spaces = general_preferences.spaces;
   back_file = cur_file;
   cur_file = new_file;
#ifdef WITH_PYTHON
   app_emit_scripting_signal("open-file");
#endif
   cur_file = back_file;
   gtk_notebook_append_page(GTK_NOTEBOOK(files_book), new_file->tear_away, new_file->nb_label);
   gtk_widget_realize(new_file->text);
   gds_editor_set_style(GDS_EDITOR(new_file->text), extext_style);
   gtk_extext_set_draw_numbers(GTK_EXTEXT(new_file->text), general_preferences.draw_numbers);
   gtk_extext_set_draw_pixmaps(GTK_EXTEXT(new_file->text), general_preferences.draw_pixmaps);
   gtk_extext_set_cursor_blink(GTK_EXTEXT(new_file->text), general_preferences.cursor_blink);
   gtk_extext_set_full_selection(GTK_EXTEXT(new_file->text), general_preferences.full_selection);
   gtk_extext_set_select_line(GTK_EXTEXT(new_file->text), general_preferences.select_line);
   cur_page = g_list_length(GTK_NOTEBOOK(files_book)->children) - 1;
   if(total_files > 1) gtk_notebook_set_page(GTK_NOTEBOOK(files_book), cur_page);
   cur_file->changed_set = TRUE;
   set_label_colors(new_file);
   return(new_file);
}

void gds_file_ask_focus(GtkWidget *widget, GdsFile *gds_file)
{
   file_change(NULL, gds_file);
}

void gds_file_focus_with_raise(GtkWidget *widget, GdsFile *gds_file)
{
   if(GDS_TEAR_AWAY(gds_file->tear_away)->torn)
   {
      gdk_window_raise(GDS_TEAR_AWAY(gds_file->tear_away)->new_parent->window);
      gtk_widget_grab_focus(gds_file->text);
   }
   else file_change(NULL, gds_file);
}

void file_pos_changed(GtkWidget *widget, gint pos, gpointer data)
{
   GtkExText *text;
   GdsEditor *gds_editor;
   gchar line_string[128];
   gint length;
   gint line;
   gint lines;
   gint col;
   gchar cur_char;

   if(cur_file != NULL)
   {
      text = GTK_EXTEXT(cur_file->text);
      gds_editor = GDS_EDITOR(cur_file->text);
      col = text->column_number;
      pos = text->current_pos;
      length = text->length;
      line = text->line_number+1;
      lines = GTK_EXTEXT(cur_file->text)->line_count + 1;
      if(pos >= 0 && pos <= text->length && text->length > 0)
         cur_char = GTK_EXTEXT_INDEX(text, pos);
      else
         cur_char = 0;
      g_snprintf(line_string, sizeof(line_string), _("Line: %d / %d Col: %d Byte: %d / %d Value: %d"), line, lines, col, pos, length, cur_char);
      gtk_entry_set_text(GTK_ENTRY(cur_file->file_data), line_string);

      if(pos > 0)
      {
         cur_char = GTK_EXTEXT_INDEX(text, pos-1);
         if(cur_char < 1 || !strchr("<{[()]}>", cur_char) || length < 1)
            gtk_widget_set_sensitive(search_menu_match, FALSE);
         else
            gtk_widget_set_sensitive(search_menu_match, TRUE);

         cur_char = GTK_EXTEXT_INDEX(text, pos);
         if(cur_char < 1 || !strchr("{[()]}", cur_char) || length < 1)
            gtk_widget_set_sensitive(search_menu_select, FALSE);
         else
            gtk_widget_set_sensitive(search_menu_select, TRUE);
      }
      else
      {
         gtk_widget_set_sensitive(search_menu_match, FALSE);
         gtk_widget_set_sensitive(search_menu_select, FALSE);
      }
      
      set_label_colors(cur_file);
      set_length_depends(length);
   }
}

void set_length_depends(gint length)
{
   if(length > 0)
   {
      gtk_widget_set_sensitive(file_menu_print, TRUE);
      gtk_widget_set_sensitive(file_menu_print_preview, TRUE);
   }
   else
   {
      gtk_widget_set_sensitive(file_menu_print, FALSE);
      gtk_widget_set_sensitive(file_menu_print_preview, FALSE);
   }
}

void undo_changed(GtkWidget *widget, GdsFile *gds_file)
{
   if(gtk_extext_undo_is_empty(GTK_EXTEXT(gds_file->text)))
   {
      gtk_widget_set_sensitive(edit_menu_undo, FALSE);
      gtk_widget_set_sensitive(editbar_undo, FALSE);
   }
   else
   {
      gtk_widget_set_sensitive(edit_menu_undo, TRUE);
      gtk_widget_set_sensitive(editbar_undo, TRUE);
   }
   if(gtk_extext_redo_is_empty(GTK_EXTEXT(gds_file->text)))
   {
      gtk_widget_set_sensitive(edit_menu_redo, FALSE);
      gtk_widget_set_sensitive(editbar_redo, FALSE);
   }
   else
   {
      gtk_widget_set_sensitive(edit_menu_redo, TRUE);
      gtk_widget_set_sensitive(editbar_redo, TRUE);
   }
   gtk_signal_emit_by_name(GTK_OBJECT(gds_file->text), "move_to_column", 0);
}

void editor_window_focused(GtkWidget *widget, GdkEventFocus *event, GdsFile *file)
{
   if(file)
   {
      if (GDS_TEAR_AWAY(file->tear_away)->torn) return;
      if(file != cur_file) file_change(NULL, file);
   }
}

void init_label_styles(GtkStyle *style)
{
   int i;
   if(!normal_style)
   {
      normal_style = gtk_style_copy(style);
      gtk_style_ref(normal_style);
      changed_style = gtk_style_copy(style);
      gtk_style_ref(changed_style);
   }
   for(i = 0; i < 5; i++)
   {
      normal_style->fg[i].red = general_preferences.nb_normal.red;
      normal_style->fg[i].green = general_preferences.nb_normal.green;
      normal_style->fg[i].blue = general_preferences.nb_normal.blue;
      changed_style->fg[i].red = general_preferences.nb_changed.red;
      changed_style->fg[i].green = general_preferences.nb_changed.green;
      changed_style->fg[i].blue = general_preferences.nb_changed.blue;
   }
   gdk_colormap_alloc_color(gdk_colormap_get_system (), &normal_style->fg[GTK_STATE_NORMAL], TRUE, TRUE);
   gdk_colormap_alloc_color(gdk_colormap_get_system (), &changed_style->fg[GTK_STATE_NORMAL], TRUE, TRUE);
}

void destroy_label_styles(void)
{
   gtk_style_unref(normal_style);
   gtk_style_unref(changed_style);
}

void set_label_colors(GdsFile *file)
{
   GdsEditor *editor;
   GtkWidget *label;

   editor = GDS_EDITOR(file->text);
   if(editor->changed && !file->changed_set)
   {
      file->changed_set = TRUE;
      label = GTK_BIN(file->menu_item)->child;
      gtk_widget_set_style(label, changed_style);
      gtk_widget_set_style(file->nb_label, changed_style);
   }
   else if(!editor->changed && file->changed_set)
   {
      file->changed_set = FALSE;
      label = GTK_BIN(file->menu_item)->child;
      gtk_widget_set_style(label, normal_style);
      gtk_widget_set_style(file->nb_label, normal_style);
   }
}
