/*  Glimmer - findbar.c
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "declarations.h"
#include "findbar.h"
#include "main.h"
#include "misc.h"
#include "searches.h"
#include "settings.h"
#include "widgets/gdsfile.h"

static void check_find_button_cb(GtkWidget* widget, GtkWidget *target);

GtkWidget *findbar = NULL;
GtkWidget *find_combo;
GtkWidget *find_entry;
static GList *find_history = NULL;

void make_find_toolbar(void)
{
   GtkWidget *find_button;
   GtkWidget *pixmapwid;

   findbar = gtk_toolbar_new(GTK_ORIENTATION_HORIZONTAL, GTK_TOOLBAR_ICONS);
   gtk_container_set_border_width(GTK_CONTAINER(findbar), 2);
   gtk_toolbar_set_button_relief(GTK_TOOLBAR(findbar), GTK_RELIEF_NONE);
   gtk_widget_show(findbar);

   find_combo = gtk_combo_new();
   gtk_widget_set_usize(find_combo, 250, 23);
   gtk_combo_disable_activate(GTK_COMBO(find_combo));
   gtk_combo_set_case_sensitive(GTK_COMBO(find_combo), TRUE);
   gtk_toolbar_append_widget(GTK_TOOLBAR(findbar), find_combo, _("Find Text"), NULL);
   find_entry = GTK_COMBO(find_combo)->entry;
   gtk_signal_connect(GTK_OBJECT(find_entry), "activate", GTK_SIGNAL_FUNC(execute_find_cb), NULL);
   find_combo_set_history(build_glist_from_file("find.hist", general_preferences.history));
   gtk_widget_show(find_combo);
   gtk_toolbar_append_space(GTK_TOOLBAR(findbar));
   pixmapwid = gnome_stock_pixmap_widget_at_size(window, GNOME_STOCK_PIXMAP_SEARCH, 24, 24);
   find_button = gtk_toolbar_append_item(GTK_TOOLBAR(findbar), 0, _("Find some text."), 0, pixmapwid, GTK_SIGNAL_FUNC(execute_find_cb), 0);
   gtk_widget_set_sensitive(find_button, FALSE);
   gtk_signal_connect(GTK_OBJECT(find_entry), "changed", GTK_SIGNAL_FUNC(check_find_button_cb), find_button);
   gnome_app_add_docked(GNOME_APP(app), findbar, "FindBar", GNOME_DOCK_ITEM_BEH_NORMAL | GNOME_DOCK_ITEM_BEH_NEVER_VERTICAL, GNOME_DOCK_TOP, 2, 6, 0);
}

void execute_find_cb(GtkWidget* widget, gpointer data)
{
   GtkExText *extext;
   GtkExTextMatch m;
   gchar *text;
   extext = GTK_EXTEXT(cur_file->text);

   text = gtk_entry_get_text(GTK_ENTRY(find_entry));
   if(strlen(text)>0)
   {
      gboolean found;
      found = find_text(extext, extext->current_pos, extext->length, text, case_sensitive, search_style, TRUE, &m);
      add_string_to_file("find.hist", text);
      find_combo_add_string(text);
      gtk_widget_grab_focus(GTK_WIDGET(extext));
      if(!found) display_message("Text not found.", FLASH);
   }
}

static void check_find_button_cb(GtkWidget* widget, GtkWidget *target)
{
   gchar *text;
   text = gtk_entry_get_text(GTK_ENTRY(find_entry));
   if(strlen(text) > 0)
      gtk_widget_set_sensitive(target, TRUE);
   else
      gtk_widget_set_sensitive(target, FALSE);
}

void find_combo_set_history(GList *history)
{
   if(history == NULL) return;
   find_history = history;
   gtk_combo_set_popdown_strings(GTK_COMBO(find_combo), find_history);
   gtk_entry_set_text(GTK_ENTRY(find_entry), "");
}

gboolean find_combo_add_string(gchar *string)
{
   gint pos;
   gpointer temp;
   GList *ptr;
   gboolean success = FALSE;
   pos = check_list_for_string(find_history, string);
   if(pos)
   {
      temp = g_list_nth_data(find_history, pos-1);
      find_history = g_list_remove(find_history, temp);
   }
   else
   {
      temp = g_new(char, strlen(string)+1);
      strcpy((gchar *)temp, string);
   }

   find_history = g_list_prepend(find_history, temp);

   while(g_list_length(find_history) > general_preferences.history)
   {
      ptr = g_list_nth(find_history, g_list_length(find_history)-1);
      if(ptr)
      {
         temp = ptr->data;
         find_history = g_list_remove(find_history, ptr->data);
         g_free(ptr->data);
      }
   }
   gtk_combo_set_popdown_strings(GTK_COMBO(find_combo), find_history);
   return(success);
}
