/*
 * Text manipulation plugin
 *
 * Author:
 *   JP Rosevear (jpr@arcavia.com)
 */

#include <libgide/libgide.h>
#include "text-delete.h"

void
text_delete_to_bof(
	GtkWidget*			widget,
	gpointer			data
)
{
	GideTool*			tool = (GideTool*)data;

	gide_delete_text(tool, 0, gide_get_cursor_pos(tool));
}

void
text_delete_to_eof(
	GtkWidget*			widget,
	gpointer			data
)
{
	GideTool*			tool = (GideTool*)data;

	gide_delete_text(tool, gide_get_cursor_pos(tool), gide_get_document_length(tool));
}

static glong
get_end_of_line(
	GideTool*			tool,
	glong				point
)
{
	static glong			eol;

	for(eol = point; eol < gide_get_document_length(tool); eol++)
	{
		if(gide_get_document_chars(tool, eol, eol + 1 )[0] == '\n' )
		{
			break;
		}
	}

	if(eol < 0)
	{
		eol = 0;
	}
	else if(eol > gide_get_document_length(tool))
	{
		eol = gide_get_document_length(tool);
	}

	return eol;
}

static glong
get_begin_of_line(
	GideTool*			tool,
	glong				point
)
{
	static glong			bol;
	gchar*				ch;

	for(bol = point; bol > 0; bol--)
	{
		ch = gide_get_document_chars(tool, bol, bol - 1); 
		if(ch[0] == '\n')
		{
			break;
		}
	}

	if(bol < 0)
	{
		bol = 0;
	}
	else if(bol > gide_get_document_length(tool))
	{
		bol = gide_get_document_length(tool);
	}

	return bol;
}

void
text_delete_to_bol(
	GtkWidget*			widget,
	gpointer			data
)
{
	GideTool*			tool = (GideTool*)data;

	gide_delete_text(tool, gide_get_cursor_pos(tool), get_begin_of_line(tool,
		gide_get_cursor_pos(tool)));
}

void
text_delete_to_eol(
	GtkWidget*			widget,
	gpointer			data
)
{
	GideTool*			tool = (GideTool*)data;

	gide_delete_text(tool, gide_get_cursor_pos(tool), get_end_of_line(tool,
		gide_get_cursor_pos(tool)));
}
