/*
 * gIDE sample plugin
 *
 * Demonstrates the basics of how to write a plugin for gIDE.
 */

#include <config.h>

#include <liboaf/liboaf.h>
#include <libgide/libgide.h>
#include <unistd.h>
#include <sys/stat.h>
#include <gdl/GDL.h>

#define SAMPLE_COMPONENT_IID "OAFIID:GNOME_Development_Plugin:sample"

/*
 * Insert the text "Hello, World!" in the current document
 */
static void
hello_world (GtkWidget *widget, gpointer data )
{
	GideTool *tool = GIDE_TOOL (data);

	gide_insert_text_at_cursor (tool, "Hello, world!\n");
}

/*
 * Define the verbs in this plugin
 */
static BonoboUIVerb verbs[] = {
	BONOBO_UI_UNSAFE_VERB ("HelloWorld", hello_world),
	BONOBO_UI_VERB_END
};

/*
 * Boilerplate initialization function
 */
static gboolean
impl_init (GideTool *tool, gpointer closure)
{
	BonoboUIComponent *uic;
	CORBA_Environment ev;

	g_return_val_if_fail (tool != NULL, FALSE);
	g_return_val_if_fail (GIDE_IS_TOOL (tool), FALSE);

	CORBA_exception_init (&ev);

	uic = bonobo_ui_component_new ("gide-sample-plugin");
	bonobo_ui_component_set_container (uic, tool->ui_container);
	bonobo_ui_util_set_ui (uic, GIDE_DATADIR, 
			       "gide-sample-plugin.xml",
			       "gide-sample-plugin");

	bonobo_ui_component_add_verb_list_with_data (uic, verbs, tool);

	CORBA_exception_free(&ev);

	return TRUE;
}

/*
 * Boilerplace cleanup function
 */
static void
impl_cleanup (GideTool *tool, gpointer closure)
{
}

/*
 * Boilerplate creation function
 */
static CORBA_Object
make_object (PortableServer_POA poa, const char* iid, gpointer impl_ptr, CORBA_Environment *ev)
{
	GideTool *tool;

	tool = gide_tool_new (impl_init, impl_cleanup, NULL);

	oaf_plugin_use (poa, impl_ptr);

	return BONOBO_OBJREF (tool->props);
}

/*
 * List of plugins
 */
static const OAFPluginObject plugin_list[] =
{
	{
		SAMPLE_COMPONENT_IID,
		make_object
	},
	{
		NULL
	}
};

/*
 * Plugin description
 */
const OAFPlugin OAF_Plugin_info = {
	plugin_list,
	"gIDE Sample Plugin"
};

