/* $Header: /cvs/gnome/gIDE/src/gI_tree.c,v 1.6 2000/04/19 12:51:32 jpr Exp $ */
/* gIDE
 * Copyright (C) 1998-2000 Steffen Kern
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "gide.h"
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>
#include "gI_functions.h"
#include "gI_tree.h"
#include "gI_common.h"


/* ignore-list */
static gchar*							functionarray[MAXFUNC];

/* globals */
GtkWidget*								tree_window = NULL;
static GtkWidget*						main_tree;
static GtkWidget*						root_tree;
static GtkWidget*						root_item;
static GtkWidget*						sub_tree;
static gchar							org_line[MAXLEN];
static glong							fuc = -1;
static glong							fic = 0;
static gchar*							filearray[MAXLEN];
static glong							maxrec = 0;

/* Prototypes for local functions */
static void tree_window_destroy(GtkWidget* widget, gpointer data);
static glong gen_tree(gchar* file);
static glong c_parse_line(gchar* buf, glong line, glong recursive);
static glong get_function_name(gchar* key, c_status* c_status, glong modus,
	glong recursive, glong line, glong prototype);
static glong strip_shit_1(gchar* dest, gchar* source);
static glong strip_shit_2(gchar* dest, gchar* source);
static glong follow_function(gchar* function);
static glong find_function(FILE* file, gchar* function, glong line);


/* local functions */
static void
tree_window_destroy(
	GtkWidget*							widget,
	gpointer							data
)
{
	gtk_widget_destroy(tree_window);
	tree_window = NULL;
}


static glong
gen_tree(
	gchar*								infile
)
{
	gchar								buf[MAXLEN];
	glong								i;
	glong								line = 0;
	c_status							c_status;
	FILE*								file;

	/* root item */
	root_item = gtk_tree_item_new_with_label(infile);
	gtk_tree_append(GTK_TREE(root_tree), root_item);

	main_tree = gtk_tree_new();
	gtk_tree_item_set_subtree(GTK_TREE_ITEM(root_item), main_tree);
	gtk_widget_show(main_tree);

	if(maxrec > 0)
	{
		printf("Max. Depth Level: %-2ld\n", maxrec);
	}

	file = fopen(infile, "r");
	if(file == NULL)
	{
		printf("ERROR: can't open file %s\n", infile);
		return -1;
	}

	init_cstatus(&c_status);

	while(!feof(file))
	{
		fgets(buf, sizeof(buf), file);
		if(feof(file))
		{
			break;
		}
		for(i = 0; i <= strlen(buf); i++)
		{
			c_parse_special(buf, i, &c_status);
		}
	}

	if(c_status.comment)
	{
		gI_error_dialog("ERROR: base parsing failed, unfinished comment");
		return -1;
	}

	if(c_status.curly_brackets || c_status.round_brackets ||
		c_status.square_brackets)
	{
		printf("\nERROR: base parsing failed, brackets don't match: %ld, %ld, %ld\n",
			c_status.curly_brackets, c_status.round_brackets, c_status.square_brackets);
		return -1;
	}

	/* Re-Init */
	rewind(file);
	init_cstatus(&c_status);

	while(!feof(file))
	{
		fgets(buf, sizeof(buf), file);
		line++;
		if(feof(file))
		{
			break;
		}
		c_parse_line(buf, line, 0);
	}

	return 1;
}


static glong
c_parse_line(
	gchar*								buf,
	glong								line,
	glong								recursive
)
{
	gchar								key[MAXLEN];
	glong								kc = 0;
	glong								i;
	static c_status						c_status;

	/* backup the complete original line */
	strcpy(org_line, buf);

	/* parse... */
	for(i = 0; i < strlen(buf); i++)
	{
		c_parse_special(buf, i, &c_status);

		if(c_status.comment || c_status.hyph || c_status.dhyph)
		{
			continue;
		}

		/* abort parsing, if in recursive mode and we left the function */
		if(recursive > 0 && !c_status.curly_brackets)
		{
			return 2;
		}

		switch(buf[i])
		{
		case '(':
			if(kc != 0)
			{
				key[kc] = '\0';
				kc = 0;

				if(!recursive)
				{
					if(c_status.curly_brackets)
					{
						get_function_name(key, &c_status, 1, 0, line, -1);
					}
					else
					{
						get_function_name(key, &c_status, 0, 0, line, -1);
					}
				}
				else
				{
					get_function_name(key, &c_status, 1, recursive, line, -1);
				}

			}
			break;

		case ')':
		case ';':
		case '=':
		case ' ':
		case '\t':
		case '/':
		case '*':
		case '+':
		case '-':
			kc = 0;
			break;

		default:
			key[kc] = buf[i];
			kc++;
			break;
		}
	}

	return 1;
}


static glong
get_function_name(
	gchar*								key,
	c_status*							c_status,
	glong								modus,
	glong								recursive,
	glong								line,
	glong								prototype
)
{
	gchar*								wild_ptr;
	glong								hit = 0;
	glong								len = 0;
	glong								i;
	gchar								function_from_array[MAXLEN];
	gchar								function_from_source[MAXLEN];
	GtkWidget*							item;
	gchar								str[MAXLEN];

	/* clean-up */
	strip_shit_1(key, key);
	strip_shit_2(key, key);

	/* skip functions that are in the array */
	for(i = 0; i <= fuc; i++)
	{
		strcpy(function_from_array, functionarray[i]);
		wild_ptr = strchr(function_from_array, '%');
		if(wild_ptr)
		{
			*wild_ptr = '\0';
			len = strlen(function_from_array);
			strcpy(function_from_source, key);
			function_from_source[len] = '\0';
			if(!strcmp(function_from_source, function_from_array))
			{
				hit = 1;
			}
		}
		else
		{
			if(!strcmp(key, functionarray[i]))
			{
				hit = 1;
			}
		}
	}

	/* show functions, defines & prototypes */
	if(!hit && !isempty(key))
	{
		if(modus == 1)
		{
			if(recursive > 0)
			{
				if(strstr(org_line, "#define"))
				{
				}
				else
				{
					if(recursive > 1)
					{
						for(i = 0; i < recursive; i++)
						{
							printf("  ");
						}
					}

					g_snprintf(str, MAXLEN, "%s [%ld]", key, line);
					item = gtk_tree_item_new_with_label(str);
					gtk_tree_append(GTK_TREE(sub_tree), item);
					gtk_widget_show(item);
					if(recursive >= maxrec)
					{
						recursive = -1;
					}
					if(recursive != -1)
					{
						follow_function(key);
					}
				}
			}
			else
			{
				if(strstr(org_line, "#define"))
				{
				}
				else
				{
					g_snprintf(str, MAXLEN, "%s [%ld]", key, line);
					item = gtk_tree_item_new_with_label(str);
					gtk_tree_append(GTK_TREE(sub_tree), item);
					gtk_widget_show(item);
					if(recursive >= maxrec)
					{
						recursive = -1;
					}
					if(recursive != -1)
					{
						follow_function(key);
					}
				}
			}
		}
		else
		{
			/* arschbloede prototype erkennung */
			if(strstr(org_line, ");"))
			{
/*				strcpy(buf, bak); */
				return 0;
			}
			else
			{
				g_snprintf(str, MAXLEN, "%s [%ld]", key, line);
				item = gtk_tree_item_new_with_label(str);
				gtk_tree_append(GTK_TREE(main_tree), item);
				sub_tree = gtk_tree_new();
				gtk_tree_item_set_subtree(GTK_TREE_ITEM(item), sub_tree);
				gtk_widget_show(item);

				return 0;
			}
		}
	}

	return 1;
}


static glong
strip_shit_1(
	gchar*								dest,
	gchar*								source
)
{
	while(*source)
	{
		switch(*source)
		{
		case '!':
			source++;
			break;

		case '*':
			source++;
			break;

		case '&':
			source++;
			break;

		default:
			*dest = *source;
			dest++;
			source++;
		}
	}

	*dest = '\0';

	return 1;
}


static glong
strip_shit_2(
	gchar*								dest,
	gchar*								source
)
{
	gchar*								ptr;
	gchar*								ptr2;
	gchar*								ptr3;
	gchar*								ptr4;
	gchar*								ptr5;
	gchar*								ptr6;

	ptr = strrchr(source, ',');
	if(ptr)
	{
		ptr++;
		strcpy(dest, ptr++);
	}
	else
	{
		strcpy(dest, source);
	}

	ptr2 = strchr(dest, '<');
	if(ptr2)
	{
		ptr2++;
		strcpy(dest, ptr2++);
	}

	ptr3 = strchr(dest, '>');
	if(ptr3)
	{
		ptr3++;
		strcpy(dest, ptr3++);
	}

	ptr4 = strrchr(dest, '{');
	if(ptr4)
	{
		ptr4++;
		strcpy(dest, ptr4++);
	}

	ptr5 = strrchr(dest, '}');
	if(ptr5)
	{
		ptr5++;
		strcpy(dest, ptr5++);
	}

	ptr6 = strrchr(dest, '[');
	if(ptr6)
	{
		ptr6++;
		strcpy(dest, ptr6++);
	}

	return 1;
}


static glong
follow_function(
	gchar*								function
)
{
	glong								i;
	glong								found = 0;
	FILE*								file = NULL;
	glong								line = 0;
	gchar								buf[1024];
	glong								recursive = 0;

	for(i = 0; i < fic; i++)
	{
		file = fopen(filearray[i], "r");
		if(!file)
		{
			continue;
		}

		found = find_function(file, function, line);
		if(found)
		{
			break;
		}
	}

	if(found)
	{
		recursive++;
		while(!feof(file))
		{
			fgets(buf, sizeof(buf), file);
			if(feof(file))
			{
				break;
			}

			line++;
			if(c_parse_line(buf, line, recursive) != 1)
			{
				return 0;
			}
		}
	}

	fclose(file);

	return 1;
}


static glong
find_function(
	FILE*								file,
	gchar*								function,
	glong								line
)
{
	gchar								key[MAXLEN];
	gchar								buf[MAXLEN];
	gchar								line_backup[MAXLEN];
	glong								kc = 0;
	glong								i;
	c_status							c_status_find;

	while(!feof(file))
	{
		fgets(buf, sizeof(buf), file);
		if(feof(file))
		{
			break;
		}

		strcpy(line_backup, buf);

		line++;

		for(i = 0; i < strlen(buf); i++)
		{
			c_parse_special(buf, i, &c_status_find);

			if(c_status_find.comment || c_status_find.hyph || c_status_find.dhyph)
			{
				continue;
			}

			switch(buf[i])
			{
			case '(':
				if(kc != 0)
				{
					key[kc] = '\0';
					kc = 0;

					if(!c_status_find.curly_brackets)
					{
						strip_shit_1(key, key);
						strip_shit_2(key, key);
						if(!strcmp(key, function))
						{
							while(!strchr(buf, '{'))
							{
								fgets(buf, sizeof(buf), file);
							}
							return 1;
						}
					}
				}
				break;

			case ')':
			case ';':
			case '=':
			case ' ':
			case '\t':
			case '/':
			case '*':
			case '+':
			case '-':
				kc = 0;
				break;

			default:
				key[kc] = buf[i];
				kc++;
				break;
			}
		}
	}

	return 0;
}


/* public functions */
void
show_tree(
	GtkWidget*							widget,
	gpointer							data
)
{
	GtkWidget*							vbox;
	GtkWidget*							scrolled;
	GideDocument*						document;
	glong								i;
	FILE*								funcfile;
	gchar								buf[MAXLEN];
	gchar								funcfilewp[MAXLEN];
	gchar*								ptr;

	if(tree_window)
	{
		return;
	}

	tree_window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_widget_set_usize(tree_window, 400, 400);
	gtk_window_set_title(GTK_WINDOW(tree_window), "Tree");
	gtk_signal_connect(GTK_OBJECT(tree_window ), "destroy",
		GTK_SIGNAL_FUNC(tree_window_destroy), NULL);

	vbox = gtk_vbox_new(FALSE, 0);
	gtk_container_add(GTK_CONTAINER(tree_window), vbox);
	gtk_widget_show(vbox);

	scrolled = gtk_scrolled_window_new(NULL, NULL);
	gtk_container_add(GTK_CONTAINER(vbox), scrolled);
	gtk_widget_show(scrolled);

	root_tree = gtk_tree_new();
	gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(scrolled), root_tree);
	gtk_widget_show(root_tree);

	/* parse function file */
	if(isempty(cfg->ign_file))
	{
		g_snprintf(funcfilewp, MAXLEN, "%s/%s", gide_path, FUNC_IGN_FILE);
	}
	else
	{
		g_snprintf(funcfilewp, MAXLEN, "%s/%s", gide_path, cfg->ign_file);
	}
	funcfile = fopen(funcfilewp, "r");
	if(funcfile)
	{
		printf("functions.ignore found\n");
		fuc = -1;
		while(fgets(buf, sizeof(buf), funcfile))
		{
			fuc++;
			functionarray[fuc] = (gchar*)malloc((strlen(buf) + 1) * sizeof(gchar));
			ptr = strchr(buf, '\n');
			if(ptr)
			{
				*ptr = '\0';
			}
			strcpy(functionarray[fuc], buf);
		}
		fclose(funcfile);
		printf("%ld functions read\n", fuc + 1);
	}

	for(i = 0; i < g_list_length(main_window->documents); i++)
	{
		document = GIDE_DOCUMENT(g_list_nth_data(main_window->documents, i));

		if(!document)
		{
			continue;
		}

		if(!document->filename)
		{
			continue;
		}

		if(gen_tree(document->filename) != 1)
		{
/*
			gtk_widget_destroy(tree_window);
			tree_window = NULL;
			return;
*/
		}
	}

	gtk_tree_item_expand(GTK_TREE_ITEM(root_item));
	gtk_widget_show(root_item);

	gtk_widget_show(tree_window);
}
