/* $Header: /cvs/gnome/gIDE/src/gI_toolbar.c,v 1.6 2000/04/19 12:51:32 jpr Exp $ */
/* gIDE
 * Copyright (C) 1998-2000 Steffen Kern
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <config.h>
#include "gide.h"
#include <gdk/gdkkeysyms.h>
#include <stdio.h>
#include <string.h>
#include "gI_file.h"
#include "gI_edit.h"
#include "gI_search.h"
#include "gI_prefs.h"
#include "gI_toolbar.h"
#include "gI_hilite.h"
#include "gI_help.h"

/*
 * The two following declarations are related. If you change one, change the
 * other as well! The orders have to remain the same or the default
 * toolbar will look very strange.
 */
static GnomeUIInfo defaultButtons[] = {
	GNOMEUIINFO_ITEM_STOCK(N_("New"), N_("New file"),
		file_new, GNOME_STOCK_PIXMAP_NEW),
	GNOMEUIINFO_ITEM_STOCK(N_("Open"), N_("Open file"),
		file_open, GNOME_STOCK_PIXMAP_OPEN),
	GNOMEUIINFO_ITEM_STOCK(N_("Close"), N_("Close current file"),
		file_close, GNOME_STOCK_PIXMAP_CLOSE),
	GNOMEUIINFO_ITEM_STOCK(N_("Save"), N_("Save current file"),
		file_save, GNOME_STOCK_PIXMAP_SAVE),
	GNOMEUIINFO_ITEM_STOCK(N_("Save All"), N_("Save all open files"),
		file_save, GNOME_STOCK_PIXMAP_SAVE),
	GNOMEUIINFO_ITEM_STOCK(N_("Print"), N_("Print current file"),
		file_print, GNOME_STOCK_PIXMAP_PRINT),
	GNOMEUIINFO_ITEM_STOCK(N_("Revert"), N_("Reload current file"),
		file_reload, GNOME_STOCK_PIXMAP_REFRESH),
	GNOMEUIINFO_ITEM_STOCK(N_("Undo"), N_("Undo last change"),
		edit_undo, GNOME_STOCK_PIXMAP_UNDO),
	GNOMEUIINFO_ITEM_STOCK(N_("Redo"), N_("Redo last undo"),
		edit_redo, GNOME_STOCK_PIXMAP_REDO),
	GNOMEUIINFO_ITEM_STOCK(N_("Cut"), N_("Cut selection"),
		edit_cut, GNOME_STOCK_PIXMAP_CUT),
	GNOMEUIINFO_ITEM_STOCK(N_("Copy"), N_("Copy selection"),
		edit_copy, GNOME_STOCK_PIXMAP_COPY),
	GNOMEUIINFO_ITEM_STOCK(N_("Paste"), N_("Paste clipboard"),
		edit_paste, GNOME_STOCK_PIXMAP_PASTE),
	GNOMEUIINFO_ITEM_STOCK(N_("Search"), N_("Search"),
		search_search, GNOME_STOCK_PIXMAP_SEARCH),
	GNOMEUIINFO_ITEM_STOCK(N_("Preferences"), N_("Edit preferences"),
		show_preferences, GNOME_STOCK_PIXMAP_PREFERENCES),
	GNOMEUIINFO_ITEM_STOCK(N_("Help"), N_("Help"),
		show_help, GNOME_STOCK_PIXMAP_HELP),
	GNOMEUIINFO_ITEM_STOCK(N_("Exit"), N_("Exit gIDE"),
		file_exit, GNOME_STOCK_PIXMAP_EXIT),
	GNOMEUIINFO_SEPARATOR,
	GNOMEUIINFO_END
};
enum { GI_BTN_NEW = 0, GI_BTN_OPEN, GI_BTN_CLOSE, GI_BTN_SAVE, GI_BTN_SAVEALL,
	GI_BTN_PRINT, GI_BTN_REVERT, GI_BTN_UNDO, GI_BTN_REDO, GI_BTN_CUT,
	GI_BTN_COPY, GI_BTN_PASTE, GI_BTN_SEARCH, GI_BTN_PREFS, GI_BTN_HELP,
	GI_BTN_EXIT, GI_BTN_SEP, GI_BTN_END };

/*
 * Create the toolbar
 */
void
gI_toolbar_create(
	GtkWidget*							app
)
{
	GnomeDockItem*						dockitem;

	/* Destroy the existing toolbar */
	dockitem = gnome_app_get_dock_item_by_name(GNOME_APP(app),
		GNOME_APP_TOOLBAR_NAME);
	if(dockitem)
	{
		gtk_widget_destroy(GTK_WIDGET(dockitem));
	}

	/*
	 * First, check to see whether custom toolbar is enabled.
	 * If it is, find out which buttons are enabled and then compile the
	 * structure and display the toolbar
	 */
	if(cfg->toolbar_custom)
	{
		glong							i;
		gint							j;

		GnomeUIInfo*					toolbar;

		toolbar = g_new0(GnomeUIInfo, cfg->toolbar_custom_items_no + 1);
		for(i = 0; i < cfg->toolbar_custom_items_no; i++)
		{
			for(j = 0; defaultButtons[j].type != GNOME_APP_UI_ENDOFINFO; j++)
			{
				if(!strcmp(cfg->toolbar_custom_items[i], "Space"))
				{
					toolbar[i] = defaultButtons[GI_BTN_SEP];
					break;
				}
				if(defaultButtons[j].type != GNOME_APP_UI_ITEM)
				{
					continue;
				}
				if(!strcmp(cfg->toolbar_custom_items[i],
					defaultButtons[j].label))
				{
					toolbar[i] = defaultButtons[j];
					break;
				}
			}
		}
		toolbar[i] = defaultButtons[GI_BTN_END];

		gnome_app_create_toolbar_with_data(GNOME_APP(app), toolbar, app);
		g_free(toolbar);
	}
	else if(cfg->toolbar)
	{
		/*
		 * If the custom toolbar is not enabled complete and display the
		 * real toolbar
		 */
		GnomeUIInfo						toolbar[18];

		toolbar[0] = defaultButtons[GI_BTN_NEW];
		toolbar[1] = defaultButtons[GI_BTN_OPEN];
		toolbar[2] = defaultButtons[GI_BTN_REVERT];
		toolbar[3] = defaultButtons[GI_BTN_SAVE];
		toolbar[4] = defaultButtons[GI_BTN_PRINT];
		toolbar[5] = defaultButtons[GI_BTN_CLOSE];
		toolbar[6] = defaultButtons[GI_BTN_SEP];
		toolbar[7] = defaultButtons[GI_BTN_UNDO];
		toolbar[8] = defaultButtons[GI_BTN_REDO];
		toolbar[9] = defaultButtons[GI_BTN_SEP];
		toolbar[10] = defaultButtons[GI_BTN_SEARCH];
		toolbar[11] = defaultButtons[GI_BTN_SEP];
		toolbar[12] = defaultButtons[GI_BTN_CUT];
		toolbar[13] = defaultButtons[GI_BTN_COPY];
		toolbar[14] = defaultButtons[GI_BTN_PASTE];
		toolbar[15] = defaultButtons[GI_BTN_SEP];
		toolbar[16] = defaultButtons[GI_BTN_EXIT];
		toolbar[17] = defaultButtons[GI_BTN_END];

		gnome_app_create_toolbar_with_data(GNOME_APP(app), toolbar, app);
	}
}
