/* gIDE
 * Copyright (C) 1999-2000 Tom Dyas (tdyas@romulus.rutgers.edu)
 *
 * Additional Functions and Cleanups:
 *    Dom Lachowicz (dominicl@seas.upenn.edu)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
 
#ifndef GIDE_PLUGIN_H
#define GIDE_PLUGIN_H

/* Forward references for structures.  */
typedef struct _PluginData PluginData;

#include <gmodule.h>
#include "gI_commands.h"

typedef enum {
	PLUGIN_OK,
	PLUGIN_ERROR,	/* Display an error */
	PLUGIN_QUIET_ERROR /* Plugin has already displayed an error */
} PluginInitResult;

typedef PluginInitResult (*PluginInitFn) (CommandContext *, PluginData *);
typedef void             (*PluginCleanupFn) (PluginData *);
typedef int              (*PluginCanUnloadFn) (PluginData *);

extern GList *plugin_list;

/* Each plugin must have this one function */
extern PluginInitResult init_plugin (CommandContext *cmd, PluginData *pd);

void           plugins_init          (CommandContext *context);
PluginData    *plugin_load           (CommandContext *context,
				      const gchar *filename);
void           plugin_unload         (CommandContext *context, PluginData *pd);

gboolean       plugin_version_mismatch  (CommandContext *cmd, PluginData *pd,
					 char const * const plugin_version);

void           *plugin_data_set_user_data (PluginData *pd, void *user_data);
void           *plugin_data_get_user_data (PluginData *pd);

gboolean       plugin_data_init      (PluginData *pd, PluginCanUnloadFn can_unload_fn,
				      PluginCleanupFn cleanup_fn,
				      const gchar *title, const gchar *descr);

const gchar    *plugin_data_get_filename (PluginData *pd);
const gchar    *plugin_data_get_title    (PluginData *pd);
const gchar    *plugin_data_get_descr    (PluginData *pd);

#endif /* GIDE_PLUGIN_H */
