/* $Header: /cvs/gnome/gIDE/src/gI_compile.h,v 1.6 2000/04/16 04:59:56 jpr Exp $ */
/* gIDE
 * Copyright (C) 1998-2000 Steffen Kern
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef GI_COMPILE_H
#define GI_COMPILE_H

#include "gide.h"
#include <stdio.h>

/*
 * Prototypes for 'gI_compile.c'
 */
gI_compile_window *gI_compile_window_new( gchar *title );
void gI_compile_window_destroy( GtkWidget *widget, GideDocument *document );
void compile_compile_exec( GtkWidget *widget, gpointer data );
void compile_compile_obj( GtkWidget *widget, gpointer data );
void compile_make( GtkWidget *widget, gpointer data );
void compile_link( GtkWidget *widget, gpointer data );
void show_compiling( GideDocument *current,
		     gI_compile_window *compile_window );

#ifdef USE_FORK_CODE
void cancel_compiling( GtkWidget *widget, GideDocument *current );
#endif

gint check_file_open( gchar *filename );
gint get_point_from_line( gint tline );
gint get_line_from_point( gint tpoint );
glong goto_file( gchar *filename );
void goto_point( gint line );
void goto_line( gint line );
void jump_to_source( gchar *listitem );
void compile_list_select( GtkWidget *widget, gint row, gint column,
			  GdkEventButton *bevent, GideDocument *document );

#define COMPILE_EXEC 1
#define COMPILE_OBJ 2

#define COMPILE_LINK 3

#define COMPILE_SYNTAX 4

typedef struct _udata udata;
struct _udata
{
	gint file;
	gchar *filename;
	GideDocument *doc;
	gint input_id;
};
void update_compile_list( udata *update_data );
glong get_total_lines( GtkWidget *text );
gchar *build_comp_string( GideDocument *document, gchar *targetfile,
			  gchar *fifoname, glong type );
gchar *match_cset_fpat( gI_comp_set *cset, gchar *filename );
gchar *parse_cmdline( gchar *cmdline, gI_comp_set *cset,
		      GideDocument *document, gchar *targetfile, glong type );
gI_comp_set *get_comp_set_from_filename( gchar *filename );
void compile_syntax_check( GtkWidget *widget, gpointer data );

#ifdef USE_FORK_CODE
typedef struct _pdata pdata;
struct _pdata
{
	gint pid;
	udata *update_data;
};

void table_assoc( gint pid, udata *update_data );
udata *table_lookup( gint pid );
void table_rassoc( udata *data );

void build_comp_string_fork( gchar *str, gchar **argv );
#endif

#define MAX_LINE_LENGTH 100

#endif

