/* $Header: /cvs/gnome/gIDE/src/gI_cfgfiles.c,v 1.6 2000/04/22 17:23:00 jpr Exp $ */
/* gIDE
 * Copyright (C) 1998-2000 Steffen Kern
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 * (c) 1999 by Craig McGregor <cmcgregor@clear.net.nz>
 * with modifications by Steffen Kern <alfi@rocks.pn.org> 
 */


#include <config.h>
#include <glib.h>
#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <dirent.h>
#include "gI_cfgfiles.h"


/*
 * FIXME: only copy the needed files (ie, copy only scheme or
 * old-style configuration files).
 */

/*
 * FIXME: popup dialog and show the copy process with
 * progress-bar et al.
 */

/*
 * gI_get_cfgfiles()
 */
void gI_get_cfgfiles( gchar *src, gchar *dest )
{
	DIR *directory;
	struct dirent* direntry;
	FILE *f_src;
	FILE *f_dest;
	gchar src_name[256], dest_name[256];
	void *buffer;
	gint bytesread;
		
	directory = opendir( src );
	if( !directory )
	{
		g_print( "Error opening directory '%s' in gI_get_cfgfiles()\n", src );
		return;
	}
	
	rewinddir( directory );	

	buffer = (void*) g_malloc0( 2048 );

	while( (direntry = readdir( directory )) )
	{
		/* Skip . and .. */
		if( !strcmp( direntry->d_name, ".." ) ) continue;
		if( !strcmp( direntry->d_name, "." ) ) continue;

#ifndef HAVE_GUILE
		if( strstr( direntry->d_name, ".scm" ) ) continue;
#endif
		if( !strcmp( direntry->d_name, "README" ) ) continue;

		sprintf( src_name, "%s/%s", src, direntry->d_name );
		sprintf( dest_name, "%s/%s", dest, direntry->d_name );

		/* Copy files */
		g_print("%s --> %s\n", src_name, dest_name );
		f_src = fopen( src_name, "r" );
		f_dest = fopen( dest_name, "w" );
		if( !f_src || !f_dest )
			continue;

		while( !feof( f_src ) )
		{
			bytesread = fread( buffer, 1, 2048, f_src );
			fwrite( buffer, 1, bytesread, f_dest );
		}

		/* close files */
		fclose( f_src );
		fclose( f_dest );
	}

	g_free( buffer );

	closedir( directory );
}

