/* $Header: /cvs/gnome/gIDE/src/gI_about.c,v 1.7 2000/04/16 04:59:56 jpr Exp $ */
/* gIDE
 * Copyright (C) 1998-2000 Steffen Kern
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <config.h>
#include <gnome.h>
#include <string.h>
#include "gI_about.h"

static void about_destroy( GtkWidget *widget, GtkWidget **about )
{
	if( about )
	{
		*about = NULL;
	}
}



void about_gide( GtkWidget *widget, gpointer data )
{
	static GtkWidget *about = NULL;
	static gchar *authors[] =
		{ "Steffen Kern",
		  "JP Rosevear",
		  "Dirk Vangestel", 
		  "Thomas Mailund Jensen",
		  "Aaron Walker",
		  "Alexis Mikhailov",
		  "Dave Smith",
		  "Elladan",
		  "Joshua Thomas Green",
		  "Manuel Estrada",
		  "Mikael Hermansson",
		  "Paul Duran",
		  "The Bear",
		  "Tomi Petteri Pakarinen",
		  NULL };

	if( about )
		return;

	about = gnome_about_new( "gIDE - Integrated Development Environment",
				 VERSION,
				 "(C) 1998-2000 the Free Software Foundation",
				 (const gchar **) authors,
				 _("A C/C++ Integrated Development Environment for the GNOME desktop."), NULL );
	gtk_signal_connect( GTK_OBJECT( about ), "destroy",
                            GTK_SIGNAL_FUNC( about_destroy ), (gpointer) &about );
	gtk_widget_show( about );
}



void about_help( GtkWidget *widget, gpointer data )
{
	static GtkWidget *about_help = NULL;

	if( about_help )
		return;

	about_help = gnome_ok_dialog( _("The gIDE help is not fully implemented.") );
	gtk_window_set_title( GTK_WINDOW( about_help ), "About Help" );
	gtk_signal_connect( GTK_OBJECT( about_help ), "destroy",
                            GTK_SIGNAL_FUNC( about_destroy ), (gpointer) &about_help );

	gtk_widget_show (about_help);
}


