/*
 * Text manipulation plugin
 *
 * Author:
 *   JP Rosevear (jpr@arcavia.com)
 */
#include <gnome.h>

#include "../../src/gI_plugin.h"
#include "../../src/gide.h"
#include "../../src/gI_tools.h"
#include "../../src/gI_common.h"
#include "plugin_text_replace.h"

void
plugin_text_replace_tab_spaces( Tool *tool, ToolState *state )
{
	GtkWidget *dlg;
	gint spaces;

	static void _edit_repl_tab_spaces ( gchar * str, gpointer data)
	{
		gint i,j;
		gchar *c;

		if( !str || isempty( str )) {
			return;
		}

		spaces = atol( str );
		g_print( str );

		for(i=1; i<=(gI_text_get_length( state->document )); i++)
		{
			c = gtk_editable_get_chars( GTK_EDITABLE( state->document ), i-1, i );
			if( *c == '\t' )
			{
				gtk_editable_delete_text( GTK_EDITABLE( state->document ), i-1, i );
				gtk_editable_set_position( GTK_EDITABLE( state->document ), i-1 );

				for(j=0; j<spaces; j++) {
					gI_document_insert( state->document, NULL, NULL, NULL, " ", 1 );
				}
				i += (spaces - 1);
			}
			g_free( c );
		}
	};

	g_return_if_fail( state->document );

	spaces = gI_text_default_tab_width( state->document );
	dlg = gnome_request_dialog( FALSE,
	                            _("Number of Spaces per TAB ?"),
	                            "4",   /* FIXME: strToInt( spaces), buy a C book ? */
	                            3,     /* max. of chars */
	                            _edit_repl_tab_spaces,
	                            NULL,  /* data */
	                            NULL); /* parent */

	gnome_dialog_run_and_close( GNOME_DIALOG( dlg ) );
}




