// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GEGLMM_BUFFER_H
#define _GEGLMM_BUFFER_H


#include <glibmm.h>

/* libgeglmm - a C++ wrapper for libgegl
 *
 * (c) 2008 Hubert Figuiere
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.
 */


#include <babl/babl.h>
#include <gegl.h>
#include <glibmm/refptr.h>
#include <geglmm/rectangle.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GeglBuffer GeglBuffer;
typedef struct _GeglBufferClass GeglBufferClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gegl
{ class Buffer_Class; } // namespace Gegl
namespace Gegl
{

/** @addtogroup geglmmEnums Enums and Flags */

/**
 * @ingroup geglmmEnums
 */
enum Interpolation
{
  INTERPOLATION_NEAREST,
  INTERPOLATION_LINEAR,
  INTERPOLATION_CUBIC,
  INTERPOLATION_LANCZOS,
  INTERPOLATION_YAFR
};


class Buffer
	: public Glib::Object
{
	
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Buffer CppObjectType;
  typedef Buffer_Class CppClassType;
  typedef GeglBuffer BaseObjectType;
  typedef GeglBufferClass BaseClassType;

private:  friend class Buffer_Class;
  static CppClassType buffer_class_;

private:
  // noncopyable
  Buffer(const Buffer&);
  Buffer& operator=(const Buffer&);

protected:
  explicit Buffer(const Glib::ConstructParams& construct_params);
  explicit Buffer(GeglBuffer* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Buffer();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GeglBuffer*       gobj()       { return reinterpret_cast<GeglBuffer*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GeglBuffer* gobj() const { return reinterpret_cast<GeglBuffer*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GeglBuffer* gobj_copy();

private:

protected:
    Buffer(const Rectangle & extent, const Babl * format);
    //	_WRAP_CTOR(Buffer(const Rectangle & extent, const Babl *format), gegl_buffer_new) //TODO: Add an overload if format can be NULL, and use a const & for this one.

public:
	
  static Glib::RefPtr<Buffer> create(const Rectangle & extent, const Babl * format);
 //TODO: Add an overload if format can be NULL, and use a const & for this one.
    
  static Glib::RefPtr<Buffer> create_from_file(const Glib::ustring&);

	
  Glib::RefPtr<Buffer> create_sub_buffer(const Rectangle & extent); //TODO: Should this be const?
	
  void destroy();
	
  Rectangle get_extent() const;
	
  void set_extent(const Rectangle &);


  void save(const Glib::ustring &, const Rectangle &) const;
    void save(const Glib::ustring &) const;
    
  void flush();

    
  void clear(const Rectangle &);
    
  const Babl* get_format();

	// TODO macros
	//x
	//y
	//width
	//height
	//pixel_count

	//TODO: Add an overload if format can be NULL, and use a const & for this one.
	
  void get(double scale, const Rectangle & rect, const Babl *format, void * dest, int rowstride) const;

	//TODO: Add an overload if format can be NULL, and use a const & for this one.
	
  void set(const Rectangle & rect, const Babl *format, void *src, int rowstride);
	
  void copy(const Rectangle & src_rect, const Glib::RefPtr<Buffer> & dest, const Rectangle & dest_rect);
	
  Glib::RefPtr<Buffer> dup() const;

	//TODO: Add an overload if format can be NULL, and use a const & for this one.
	
  void sample(double x, double y, double scale, void *dest, const Babl* format, Interpolation interpolation);
	
  void sample_cleanup();
	
  static Interpolation interpolation_from_string(const Glib::ustring & string);

 
  /**
   * @par Prototype:
   * <tt>void on_my_%changed(const Rectangle & r)</tt>
   */

  Glib::SignalProxy1< void,const Rectangle & > signal_changed();


  gpointer* linear_open(const Rectangle &r, gint & rowstride, const Babl *format);
    
  void linear_close(gpointer linear);

	// Properties
	#ifdef GLIBMM_PROPERTIES_ENABLED
/** size of a single pixel in bytes.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<int> property_px_size() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


	#ifdef GLIBMM_PROPERTIES_ENABLED
/** total amount of pixels in image (width x height).
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<int> property_pixels() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


	#ifdef GLIBMM_PROPERTIES_ENABLED
/** pixel width of buffer.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<int> property_width() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** pixel width of buffer.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<int> property_width() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

	#ifdef GLIBMM_PROPERTIES_ENABLED
/** pixel height of buffer.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<int> property_height() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** pixel height of buffer.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<int> property_height() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

	#ifdef GLIBMM_PROPERTIES_ENABLED
/** local origin's offset relative to source origin.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<int> property_x() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** local origin's offset relative to source origin.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<int> property_x() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

	#ifdef GLIBMM_PROPERTIES_ENABLED
/** local origin's offset relative to source origin.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<int> property_y() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** local origin's offset relative to source origin.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<int> property_y() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

	#ifdef GLIBMM_PROPERTIES_ENABLED
/** pixel width of abyss.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<int> property_abyss_width() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


	#ifdef GLIBMM_PROPERTIES_ENABLED
/** pixel height of abyss.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<int> property_abyss_height() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


	#ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<int> property_abyss_x() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


	#ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<int> property_abyss_y() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


	#ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<int> property_shift_x() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


	#ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<int> property_shift_y() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


	#ifdef GLIBMM_PROPERTIES_ENABLED
/** babl format.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Babl*> property_format() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** babl format.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Babl*> property_format() const;
#endif //#GLIBMM_PROPERTIES_ENABLED
	

public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};


}


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gegl::Buffer
   */
  Glib::RefPtr<Gegl::Buffer> wrap(GeglBuffer* object, bool take_copy = false);
}


#endif /* _GEGLMM_BUFFER_H */

