from gazpacho.unittest import common

import gtk

class GtkWindowTest(common.GazpachoTest):
        
    def testCreation(self):
        gwidget = self.create_gwidget('GtkWindow')
        self.assertEqual(gtk.Window, type(gwidget.gtk_widget))

    def testProperty(self):
        gwidget = self.create_gwidget('GtkWindow')
        prop = gwidget.get_glade_property('title')
        prop.set('Window Title Test')
        self.assertEqual(gwidget.gtk_widget.get_title(), 'Window Title Test')

    def testSavingLoading(self):
        gwidget = self.create_gwidget('GtkWindow')
        prop = gwidget.get_glade_property('visible')
        prop.set(False)
        self.project.add_widget(gwidget.gtk_widget)
        self.project.save(__file__+'.glade')

        self.app.open_project(__file__+'.glade')
