# Copyright (C) 2004,2005 by SICEm S.L. and Imendio
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

from gazpacho.loader import tags
from gazpacho.widgetclass import WidgetClass
from gazpacho.path import catalogs_dir
from gazpacho.widgetregistry import widget_registry
from gazpacho.l10n import _

import os.path

import xml.dom.minidom

def load_all():
    # clear previous loaded classes
    widget_registry.clean()
    catalogs = []

    try:
        dir_list = os.listdir(catalogs_dir)
    except:
        print ('Unable to open'), catalogs_dir
        return catalogs

    for file in dir_list:

        if file[-4:] != '.xml':
            continue

        try:
            catalog = load_catalog(file)
        except ValueError:
            print('Unable to load catalog file')
            return catalogs

        if catalog is not None:
            catalogs.append(catalog)

    return catalogs

def load_catalog(filename):
    try:
        f = file(os.path.join(catalogs_dir, filename))
    except:
        raise ValueError('Unable to open %s') % filename


    dom = xml.dom.minidom.parse(f)
    f.close()
    root_node = dom.firstChild

    if root_node.nodeName != tags.GLADE_CATALOG:
        print 'Node %s is not %s' % (root_node.nodeName, tags.GLADE_CATALOG)
        return None

    catalog = Catalog()
    catalog.title = root_node.getAttribute(tags.NAME)
    catalog.base_library = root_node.getAttribute(tags.LIBRARY)

    for child in root_node.childNodes:
        if child.nodeName == tags.GLADE_WIDGET_CLASSES:
            for class_node in child.childNodes:
                if class_node.nodeName == tags.GLADE_WIDGET_CLASS:
                    widget_class = WidgetClass(class_node, catalog.base_library)
                    if widget_class is not None:
                        catalog.widget_classes.append(widget_class)
            
        elif child.nodeName == tags.GLADE_WIDGET_GROUP:
            widget_group = WidgetGroup(child)
            if widget_group is not None:
                catalog.widget_groups.append(widget_group)

    return catalog

def load_classes(catalog, node):
    for child in node.childNodes:
        if child.nodeName == tags.GLADE_WIDGET_CLASS:
            widget_class = WidgetClass(child, catalog.base_library)
            if widget_clas is not None:
                catalog.widget_classes.append(widget_class)

class WidgetGroup(list):
    def __init__(self, node):
        # Do some parsing
        self._name = ''
        self._title = ''

        self.load(node)

    def get_name(self):
        return self._name

    def set_name(self, name):
        self._name = name

    def get_title(self):
        return self._title

    def set_title(self, title):
        self._title = title

    name = property(get_name, set_name)
    title = property(get_title, set_title)

    def load(self, node):
        self._name = node.getAttribute(tags.NAME)
        self._title = node.getAttribute(tags.TITLE)

        for child in node.childNodes:
            if child.nodeName != tags.GLADE_WIDGET_CLASS_REF:
                continue

            name = child.getAttribute(tags.NAME)
            widget_class = widget_registry.get_by_name(name)
            if widget_class is not None:
                self.append (widget_class)
            else:
                print 'could not load widget_class'

class Catalog:
    def __init__(self):
        self._title = ''
        self._library = ''
        self.widget_classes = []
        self.widget_groups = []

    def get_title(self):
        return self._title

    def set_title(self, value):
        self._title = value

    title = property(get_title, set_title)

    def get_library(self):
        return self._library

    def set_library(self, library):
        self._library = library

    library = property(get_library, set_library)

    def __repr__(self):
        return 'Catalog->' + self._title
