from utils.Observable import Observable
import desktop

import gtk
import time



#
# Class for reporting when the wallpaper image has changed.
#
class BGWatcher(Observable):

    OBS_CHANGE_BG = 0



    def __init__(self):

        self.__old_bg = 0
        self.__last_update = 0

        gtk.timeout_add(50, self.__check_bg)



    def __check_bg(self):

        try:
            id = desktop.get_wallpaper_id()
            if (id != self.__old_bg):
                self.__last_update = str(time.time())
                gtk.timeout_add(500, self.__notify_update, self.__last_update)
                #gtk.idle_add(self.__notify_update, self.__last_update)
            self.__old_bg = id

        except StandardError, e:
            if (self.__old_bg):
                self.__last_update = str(time.time())
                gtk.timeout_add(500, self.__notify_update, self.__last_update)
                #gtk.idle_add(self.__notify_update, self.__last_update)
                self.__old_bg = 0

        return gtk.TRUE



    def __notify_update(self, timestamp):

        if (timestamp != self.__last_update): return
        self.update_observer(self.OBS_CHANGE_BG)

        return gtk.FALSE
