from utils.Observable import Observable

import gconf


#
# Configuration backend that uses GConf.
#
class GConfBackend(Observable):

    OBS_UPDATE = 0


    def __init__(self, path):

        self.__path = path
        self.__client = gconf.client_get_default()
        self.__client.add_dir(self.__path, gconf.CLIENT_PRELOAD_RECURSIVE)
        self.__client.notify_add(path, self.__on_notify)

        self.__handlers = {}



    #
    # Observer function for the GConf registry.
    #
    def __on_notify(self, client, cid, entry, err):

        key = entry.get_key().split("/")[-2:]
        value = entry.get_value()
        if (value):
            self.update_observer(self.OBS_UPDATE, key, value.get_string())



    def __on_watch(self, client, cid, entry, err):

        key = entry.get_key().split("/")[-2:]
        value = entry.get_value().get_string()
        handler = self.__handlers.get(entry.get_key())
        if (handler): handler(key, value)



    def set(self, *args):

        args = list(args)
        v = gconf.Value(gconf.VALUE_STRING)
        v.set_string(args[-1])
        path = "/".join([self.__path] + args[:-1])
        self.__client.set(path, v)



    def get(self, *args):

        args = list(args)
        path = "/".join([self.__path] + args)
        v = self.__client.get(path)
        if (v):
            return v.get_string()
        else:
            return ""



    def watch(self, *args):

        args = list(args)
        handler = args[-1]
        path = "/".join([self.__path] + args[:-1])
        self.__client.notify_add(path, self.__on_watch)
        self.__handlers[path] = handler



    #
    # Removes the given folder from GConf.
    #
    def clear(self, folder):

        path = self.__path + "/" + folder
        entries = self.__client.all_entries(path)
        for e in entries:
            self.__client.unset(e.get_key())
            
        self.__client.unset(self.__path + "/" + folder)
