/* ai.c generated by valac 0.24.0.112-bbf5, the Vala compiler
 * generated from ai.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright © 2014 Nikhar Agrawal
 *
 * This file is part of Four-in-a-row.
 *
 * Four-in-a-row is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * Four-in-a-row is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Four-in-a-row.  If not, see <http://www.gnu.org/licenses/>.*/
/*Here NEG_INF is supposed to be the lowest possible int value. int.MIN
MAX_HEURIST_VALUE is the maximum value that the heuristic functions can return.
It is returned when AI wins. -1*MAX_HEURIST_VALUE is returned when Human wins
MAX_HEURIST_VALUE < NEG_INF/plies */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include "ai.h"
#include <stdio.h>
#include <gobject/gvaluecollector.h>


#define TYPE_PLAYER (player_get_type ())

#define TYPE_DIFFICULTY (difficulty_get_type ())
#define _decision_tree_unref0(var) ((var == NULL) ? NULL : (var = (decision_tree_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _ParamSpecDecisionTree ParamSpecDecisionTree;

typedef enum  {
	PLAYER_NONE,
	PLAYER_HUMAN,
	PLAYER_AI
} Player;

typedef enum  {
	DIFFICULTY_EASY,
	DIFFICULTY_MEDIUM,
	DIFFICULTY_HARD
} Difficulty;

struct _DecisionTreePrivate {
	Player* board;
	gint board_length1;
	gint board_length2;
	gint plies;
	Player last_moving_player;
	gint next_move_in_column;
	Difficulty level;
};

struct _ParamSpecDecisionTree {
	GParamSpec parent_instance;
};


static gpointer decision_tree_parent_class = NULL;

#define NEG_INF (-100000)
#define MAX_HEURIST_VALUE 10000
#define BOARD_ROWS 6
#define BOARD_COLUMNS 7
GType player_get_type (void) G_GNUC_CONST;
GType difficulty_get_type (void) G_GNUC_CONST;
gint playgame (const gchar* moves_until_now);
#define DECISION_TREE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_DECISION_TREE, DecisionTreePrivate))
enum  {
	DECISION_TREE_DUMMY_PROPERTY
};
static gint decision_tree_negamax (DecisionTree* self, gint height, gint alpha, gint beta);
static gboolean decision_tree_board_full (DecisionTree* self);
static gint decision_tree_heurist (DecisionTree* self);
static gboolean decision_tree_move (DecisionTree* self, gint i);
static gint decision_tree_victory (DecisionTree* self, gint i);
static void decision_tree_unmove (DecisionTree* self, gint i);
static gint decision_tree_vertical_win (DecisionTree* self, gint i, gint j);
static gint decision_tree_horizontal_win (DecisionTree* self, gint i, gint j);
static gint decision_tree_backward_diagonal_win (DecisionTree* self, gint i, gint j);
static gint decision_tree_forward_diagonal_win (DecisionTree* self, gint i, gint j);
static gint decision_tree_immediate_win (DecisionTree* self, Player p);
static void decision_tree_set_level (DecisionTree* self, const gchar* vstr);
static gint decision_tree_heurist_easy (DecisionTree* self);
static gint decision_tree_heurist_medium (DecisionTree* self);
static gint decision_tree_heurist_hard (DecisionTree* self);
static gint decision_tree_count_3_in_a_row (DecisionTree* self, Player p);
static gboolean decision_tree_all_adjacent_empty (DecisionTree* self, gint i, gint j);
static void decision_tree_finalize (DecisionTree* obj);


GType player_get_type (void) {
	static volatile gsize player_type_id__volatile = 0;
	if (g_once_init_enter (&player_type_id__volatile)) {
		static const GEnumValue values[] = {{PLAYER_NONE, "PLAYER_NONE", "none"}, {PLAYER_HUMAN, "PLAYER_HUMAN", "human"}, {PLAYER_AI, "PLAYER_AI", "ai"}, {0, NULL, NULL}};
		GType player_type_id;
		player_type_id = g_enum_register_static ("Player", values);
		g_once_init_leave (&player_type_id__volatile, player_type_id);
	}
	return player_type_id__volatile;
}


GType difficulty_get_type (void) {
	static volatile gsize difficulty_type_id__volatile = 0;
	if (g_once_init_enter (&difficulty_type_id__volatile)) {
		static const GEnumValue values[] = {{DIFFICULTY_EASY, "DIFFICULTY_EASY", "easy"}, {DIFFICULTY_MEDIUM, "DIFFICULTY_MEDIUM", "medium"}, {DIFFICULTY_HARD, "DIFFICULTY_HARD", "hard"}, {0, NULL, NULL}};
		GType difficulty_type_id;
		difficulty_type_id = g_enum_register_static ("Difficulty", values);
		g_once_init_leave (&difficulty_type_id__volatile, difficulty_type_id);
	}
	return difficulty_type_id__volatile;
}


gint playgame (const gchar* moves_until_now) {
	gint result = 0;
	DecisionTree* t = NULL;
	DecisionTree* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	g_return_val_if_fail (moves_until_now != NULL, 0);
	_tmp0_ = decision_tree_new ();
	t = _tmp0_;
	_tmp1_ = moves_until_now;
	_tmp2_ = decision_tree_playgame (t, _tmp1_);
	result = _tmp2_;
	_decision_tree_unref0 (t);
	return result;
}


DecisionTree* decision_tree_construct (GType object_type) {
	DecisionTree* self = NULL;
	self = (DecisionTree*) g_type_create_instance (object_type);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_ = 0;
				if (!_tmp0_) {
					gint _tmp1_ = 0;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				if (!(_tmp2_ < BOARD_ROWS)) {
					break;
				}
				{
					gint j = 0;
					j = 0;
					{
						gboolean _tmp3_ = FALSE;
						_tmp3_ = TRUE;
						while (TRUE) {
							gint _tmp5_ = 0;
							Player* _tmp6_ = NULL;
							gint _tmp6__length1 = 0;
							gint _tmp6__length2 = 0;
							gint _tmp7_ = 0;
							gint _tmp8_ = 0;
							Player _tmp9_ = 0;
							if (!_tmp3_) {
								gint _tmp4_ = 0;
								_tmp4_ = j;
								j = _tmp4_ + 1;
							}
							_tmp3_ = FALSE;
							_tmp5_ = j;
							if (!(_tmp5_ < BOARD_COLUMNS)) {
								break;
							}
							_tmp6_ = self->priv->board;
							_tmp6__length1 = self->priv->board_length1;
							_tmp6__length2 = self->priv->board_length2;
							_tmp7_ = i;
							_tmp8_ = j;
							_tmp6_[(_tmp7_ * _tmp6__length2) + _tmp8_] = PLAYER_NONE;
							_tmp9_ = _tmp6_[(_tmp7_ * _tmp6__length2) + _tmp8_];
						}
					}
				}
			}
		}
	}
	return self;
}


DecisionTree* decision_tree_new (void) {
	return decision_tree_construct (TYPE_DECISION_TREE);
}


void decision_tree_print_board (DecisionTree* self) {
	FILE* _tmp12_ = NULL;
	g_return_if_fail (self != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_ = 0;
				FILE* _tmp11_ = NULL;
				if (!_tmp0_) {
					gint _tmp1_ = 0;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				if (!(_tmp2_ < BOARD_ROWS)) {
					break;
				}
				{
					gint j = 0;
					j = 0;
					{
						gboolean _tmp3_ = FALSE;
						_tmp3_ = TRUE;
						while (TRUE) {
							gint _tmp5_ = 0;
							FILE* _tmp6_ = NULL;
							Player* _tmp7_ = NULL;
							gint _tmp7__length1 = 0;
							gint _tmp7__length2 = 0;
							gint _tmp8_ = 0;
							gint _tmp9_ = 0;
							Player _tmp10_ = 0;
							if (!_tmp3_) {
								gint _tmp4_ = 0;
								_tmp4_ = j;
								j = _tmp4_ + 1;
							}
							_tmp3_ = FALSE;
							_tmp5_ = j;
							if (!(_tmp5_ < BOARD_COLUMNS)) {
								break;
							}
							_tmp6_ = stdout;
							_tmp7_ = self->priv->board;
							_tmp7__length1 = self->priv->board_length1;
							_tmp7__length2 = self->priv->board_length2;
							_tmp8_ = i;
							_tmp9_ = j;
							_tmp10_ = _tmp7_[(_tmp8_ * _tmp7__length2) + _tmp9_];
							fprintf (_tmp6_, "%d\t", (gint) _tmp10_);
						}
					}
				}
				_tmp11_ = stdout;
				fprintf (_tmp11_, "\n");
			}
		}
	}
	_tmp12_ = stdout;
	fprintf (_tmp12_, "\n");
}


static gint decision_tree_negamax (DecisionTree* self, gint height, gint alpha, gint beta) {
	gint result = 0;
	gboolean _tmp0_ = FALSE;
	gint _tmp1_ = 0;
	gint max = 0;
	gint next = 0;
	gint _tmp34_ = 0;
	gint _tmp35_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp1_ = height;
	if (_tmp1_ == 0) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp2_ = FALSE;
		_tmp2_ = decision_tree_board_full (self);
		_tmp0_ = _tmp2_;
	}
	if (_tmp0_) {
		Player _tmp3_ = 0;
		_tmp3_ = self->priv->last_moving_player;
		if (_tmp3_ == PLAYER_HUMAN) {
			gint _tmp4_ = 0;
			_tmp4_ = decision_tree_heurist (self);
			result = _tmp4_;
			return result;
		} else {
			Player _tmp5_ = 0;
			_tmp5_ = self->priv->last_moving_player;
			if (_tmp5_ == PLAYER_AI) {
				gint _tmp6_ = 0;
				_tmp6_ = decision_tree_heurist (self);
				result = (-1) * _tmp6_;
				return result;
			} else {
				result = 0;
				return result;
			}
		}
	}
	max = NEG_INF;
	next = -1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp7_ = FALSE;
			_tmp7_ = TRUE;
			while (TRUE) {
				gint _tmp9_ = 0;
				gint _tmp10_ = 0;
				gboolean _tmp11_ = FALSE;
				if (!_tmp7_) {
					gint _tmp8_ = 0;
					_tmp8_ = i;
					i = _tmp8_ + 1;
				}
				_tmp7_ = FALSE;
				_tmp9_ = i;
				if (!(_tmp9_ < BOARD_COLUMNS)) {
					break;
				}
				_tmp10_ = i;
				_tmp11_ = decision_tree_move (self, _tmp10_);
				if (_tmp11_) {
					gint temp = 0;
					Player _tmp12_ = 0;
					gint _tmp19_ = 0;
					gint _tmp24_ = 0;
					gint _tmp25_ = 0;
					gint _tmp26_ = 0;
					gint _tmp29_ = 0;
					gint _tmp30_ = 0;
					gint _tmp32_ = 0;
					gint _tmp33_ = 0;
					_tmp12_ = self->priv->last_moving_player;
					if (_tmp12_ == PLAYER_HUMAN) {
						gint _tmp13_ = 0;
						gint _tmp14_ = 0;
						gint _tmp15_ = 0;
						_tmp13_ = i;
						_tmp14_ = decision_tree_victory (self, _tmp13_);
						_tmp15_ = height;
						temp = ((-1) * _tmp14_) * _tmp15_;
					} else {
						gint _tmp16_ = 0;
						gint _tmp17_ = 0;
						gint _tmp18_ = 0;
						_tmp16_ = i;
						_tmp17_ = decision_tree_victory (self, _tmp16_);
						_tmp18_ = height;
						temp = _tmp17_ * _tmp18_;
					}
					_tmp19_ = temp;
					if (_tmp19_ == 0) {
						gint _tmp20_ = 0;
						gint _tmp21_ = 0;
						gint _tmp22_ = 0;
						gint _tmp23_ = 0;
						_tmp20_ = height;
						_tmp21_ = beta;
						_tmp22_ = alpha;
						_tmp23_ = decision_tree_negamax (self, _tmp20_ - 1, (-1) * _tmp21_, (-1) * _tmp22_);
						temp = (-1) * _tmp23_;
					}
					_tmp24_ = i;
					decision_tree_unmove (self, _tmp24_);
					_tmp25_ = temp;
					_tmp26_ = max;
					if (_tmp25_ > _tmp26_) {
						gint _tmp27_ = 0;
						gint _tmp28_ = 0;
						_tmp27_ = i;
						next = _tmp27_;
						_tmp28_ = temp;
						max = _tmp28_;
					}
					_tmp29_ = temp;
					_tmp30_ = alpha;
					if (_tmp29_ > _tmp30_) {
						gint _tmp31_ = 0;
						_tmp31_ = temp;
						alpha = _tmp31_;
					}
					_tmp32_ = alpha;
					_tmp33_ = beta;
					if (_tmp32_ >= _tmp33_) {
						break;
					}
				}
			}
		}
	}
	_tmp34_ = height;
	_tmp35_ = self->priv->plies;
	if (_tmp34_ == _tmp35_) {
		gint _tmp36_ = 0;
		_tmp36_ = next;
		self->priv->next_move_in_column = _tmp36_;
	}
	result = max;
	return result;
}


static gint decision_tree_victory (DecisionTree* self, gint i) {
	gint result = 0;
	gint cell = 0;
	gint temp = 0;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
	gint _tmp13_ = 0;
	gint _tmp14_ = 0;
	gint _tmp15_ = 0;
	gint _tmp16_ = 0;
	gint _tmp17_ = 0;
	gint _tmp18_ = 0;
	gint _tmp19_ = 0;
	gint _tmp20_ = 0;
	gint _tmp21_ = 0;
	gint _tmp22_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	{
		gboolean _tmp0_ = FALSE;
		cell = 0;
		_tmp0_ = TRUE;
		while (TRUE) {
			gboolean _tmp2_ = FALSE;
			gint _tmp3_ = 0;
			if (!_tmp0_) {
				gint _tmp1_ = 0;
				_tmp1_ = cell;
				cell = _tmp1_ + 1;
			}
			_tmp0_ = FALSE;
			_tmp3_ = cell;
			if (_tmp3_ < BOARD_ROWS) {
				Player* _tmp4_ = NULL;
				gint _tmp4__length1 = 0;
				gint _tmp4__length2 = 0;
				gint _tmp5_ = 0;
				gint _tmp6_ = 0;
				Player _tmp7_ = 0;
				_tmp4_ = self->priv->board;
				_tmp4__length1 = self->priv->board_length1;
				_tmp4__length2 = self->priv->board_length2;
				_tmp5_ = cell;
				_tmp6_ = i;
				_tmp7_ = _tmp4_[(_tmp5_ * _tmp4__length2) + _tmp6_];
				_tmp2_ = _tmp7_ == PLAYER_NONE;
			} else {
				_tmp2_ = FALSE;
			}
			if (!_tmp2_) {
				break;
			}
		}
	}
	temp = 0;
	_tmp8_ = cell;
	_tmp9_ = i;
	_tmp10_ = decision_tree_vertical_win (self, _tmp8_, _tmp9_);
	temp = _tmp10_;
	_tmp11_ = temp;
	if (_tmp11_ != 0) {
		result = temp;
		return result;
	}
	_tmp12_ = cell;
	_tmp13_ = i;
	_tmp14_ = decision_tree_horizontal_win (self, _tmp12_, _tmp13_);
	temp = _tmp14_;
	_tmp15_ = temp;
	if (_tmp15_ != 0) {
		result = temp;
		return result;
	}
	_tmp16_ = cell;
	_tmp17_ = i;
	_tmp18_ = decision_tree_backward_diagonal_win (self, _tmp16_, _tmp17_);
	temp = _tmp18_;
	_tmp19_ = temp;
	if (_tmp19_ != 0) {
		result = temp;
		return result;
	}
	_tmp20_ = cell;
	_tmp21_ = i;
	_tmp22_ = decision_tree_forward_diagonal_win (self, _tmp20_, _tmp21_);
	temp = _tmp22_;
	result = temp;
	return result;
}


static gint decision_tree_forward_diagonal_win (DecisionTree* self, gint i, gint j) {
	gint result = 0;
	gint count = 0;
	gint _tmp30_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	count = 0;
	{
		gint k = 0;
		gint _tmp0_ = 0;
		gint l = 0;
		gint _tmp1_ = 0;
		_tmp0_ = i;
		k = _tmp0_;
		_tmp1_ = j;
		l = _tmp1_;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp8_ = 0;
				if (!_tmp2_) {
					gint _tmp3_ = 0;
					gint _tmp4_ = 0;
					gint _tmp5_ = 0;
					_tmp3_ = k;
					k = _tmp3_ - 1;
					_tmp4_ = l;
					l = _tmp4_ + 1;
					_tmp5_ = count;
					count = _tmp5_ + 1;
				}
				_tmp2_ = FALSE;
				_tmp8_ = k;
				if (_tmp8_ >= 0) {
					gint _tmp9_ = 0;
					_tmp9_ = l;
					_tmp7_ = _tmp9_ < BOARD_COLUMNS;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					Player* _tmp10_ = NULL;
					gint _tmp10__length1 = 0;
					gint _tmp10__length2 = 0;
					gint _tmp11_ = 0;
					gint _tmp12_ = 0;
					Player _tmp13_ = 0;
					Player _tmp14_ = 0;
					_tmp10_ = self->priv->board;
					_tmp10__length1 = self->priv->board_length1;
					_tmp10__length2 = self->priv->board_length2;
					_tmp11_ = k;
					_tmp12_ = l;
					_tmp13_ = _tmp10_[(_tmp11_ * _tmp10__length2) + _tmp12_];
					_tmp14_ = self->priv->last_moving_player;
					_tmp6_ = _tmp13_ == _tmp14_;
				} else {
					_tmp6_ = FALSE;
				}
				if (!_tmp6_) {
					break;
				}
			}
		}
	}
	{
		gint k = 0;
		gint _tmp15_ = 0;
		gint l = 0;
		gint _tmp16_ = 0;
		_tmp15_ = i;
		k = _tmp15_ + 1;
		_tmp16_ = j;
		l = _tmp16_ - 1;
		{
			gboolean _tmp17_ = FALSE;
			_tmp17_ = TRUE;
			while (TRUE) {
				gboolean _tmp21_ = FALSE;
				gboolean _tmp22_ = FALSE;
				gint _tmp23_ = 0;
				if (!_tmp17_) {
					gint _tmp18_ = 0;
					gint _tmp19_ = 0;
					gint _tmp20_ = 0;
					_tmp18_ = k;
					k = _tmp18_ + 1;
					_tmp19_ = l;
					l = _tmp19_ - 1;
					_tmp20_ = count;
					count = _tmp20_ + 1;
				}
				_tmp17_ = FALSE;
				_tmp23_ = k;
				if (_tmp23_ < BOARD_ROWS) {
					gint _tmp24_ = 0;
					_tmp24_ = l;
					_tmp22_ = _tmp24_ >= 0;
				} else {
					_tmp22_ = FALSE;
				}
				if (_tmp22_) {
					Player* _tmp25_ = NULL;
					gint _tmp25__length1 = 0;
					gint _tmp25__length2 = 0;
					gint _tmp26_ = 0;
					gint _tmp27_ = 0;
					Player _tmp28_ = 0;
					Player _tmp29_ = 0;
					_tmp25_ = self->priv->board;
					_tmp25__length1 = self->priv->board_length1;
					_tmp25__length2 = self->priv->board_length2;
					_tmp26_ = k;
					_tmp27_ = l;
					_tmp28_ = _tmp25_[(_tmp26_ * _tmp25__length2) + _tmp27_];
					_tmp29_ = self->priv->last_moving_player;
					_tmp21_ = _tmp28_ == _tmp29_;
				} else {
					_tmp21_ = FALSE;
				}
				if (!_tmp21_) {
					break;
				}
			}
		}
	}
	_tmp30_ = count;
	if (_tmp30_ >= 4) {
		Player _tmp31_ = 0;
		_tmp31_ = self->priv->last_moving_player;
		if (_tmp31_ == PLAYER_HUMAN) {
			result = (-1) * MAX_HEURIST_VALUE;
			return result;
		} else {
			result = MAX_HEURIST_VALUE;
			return result;
		}
	}
	result = 0;
	return result;
}


static gint decision_tree_backward_diagonal_win (DecisionTree* self, gint i, gint j) {
	gint result = 0;
	gint count = 0;
	gint _tmp30_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	count = 0;
	{
		gint k = 0;
		gint _tmp0_ = 0;
		gint l = 0;
		gint _tmp1_ = 0;
		_tmp0_ = i;
		k = _tmp0_;
		_tmp1_ = j;
		l = _tmp1_;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp8_ = 0;
				if (!_tmp2_) {
					gint _tmp3_ = 0;
					gint _tmp4_ = 0;
					gint _tmp5_ = 0;
					_tmp3_ = k;
					k = _tmp3_ - 1;
					_tmp4_ = l;
					l = _tmp4_ - 1;
					_tmp5_ = count;
					count = _tmp5_ + 1;
				}
				_tmp2_ = FALSE;
				_tmp8_ = k;
				if (_tmp8_ >= 0) {
					gint _tmp9_ = 0;
					_tmp9_ = l;
					_tmp7_ = _tmp9_ >= 0;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					Player* _tmp10_ = NULL;
					gint _tmp10__length1 = 0;
					gint _tmp10__length2 = 0;
					gint _tmp11_ = 0;
					gint _tmp12_ = 0;
					Player _tmp13_ = 0;
					Player _tmp14_ = 0;
					_tmp10_ = self->priv->board;
					_tmp10__length1 = self->priv->board_length1;
					_tmp10__length2 = self->priv->board_length2;
					_tmp11_ = k;
					_tmp12_ = l;
					_tmp13_ = _tmp10_[(_tmp11_ * _tmp10__length2) + _tmp12_];
					_tmp14_ = self->priv->last_moving_player;
					_tmp6_ = _tmp13_ == _tmp14_;
				} else {
					_tmp6_ = FALSE;
				}
				if (!_tmp6_) {
					break;
				}
			}
		}
	}
	{
		gint k = 0;
		gint _tmp15_ = 0;
		gint l = 0;
		gint _tmp16_ = 0;
		_tmp15_ = i;
		k = _tmp15_ + 1;
		_tmp16_ = j;
		l = _tmp16_ + 1;
		{
			gboolean _tmp17_ = FALSE;
			_tmp17_ = TRUE;
			while (TRUE) {
				gboolean _tmp21_ = FALSE;
				gboolean _tmp22_ = FALSE;
				gint _tmp23_ = 0;
				if (!_tmp17_) {
					gint _tmp18_ = 0;
					gint _tmp19_ = 0;
					gint _tmp20_ = 0;
					_tmp18_ = k;
					k = _tmp18_ + 1;
					_tmp19_ = l;
					l = _tmp19_ + 1;
					_tmp20_ = count;
					count = _tmp20_ + 1;
				}
				_tmp17_ = FALSE;
				_tmp23_ = k;
				if (_tmp23_ < BOARD_ROWS) {
					gint _tmp24_ = 0;
					_tmp24_ = l;
					_tmp22_ = _tmp24_ < BOARD_COLUMNS;
				} else {
					_tmp22_ = FALSE;
				}
				if (_tmp22_) {
					Player* _tmp25_ = NULL;
					gint _tmp25__length1 = 0;
					gint _tmp25__length2 = 0;
					gint _tmp26_ = 0;
					gint _tmp27_ = 0;
					Player _tmp28_ = 0;
					Player _tmp29_ = 0;
					_tmp25_ = self->priv->board;
					_tmp25__length1 = self->priv->board_length1;
					_tmp25__length2 = self->priv->board_length2;
					_tmp26_ = k;
					_tmp27_ = l;
					_tmp28_ = _tmp25_[(_tmp26_ * _tmp25__length2) + _tmp27_];
					_tmp29_ = self->priv->last_moving_player;
					_tmp21_ = _tmp28_ == _tmp29_;
				} else {
					_tmp21_ = FALSE;
				}
				if (!_tmp21_) {
					break;
				}
			}
		}
	}
	_tmp30_ = count;
	if (_tmp30_ >= 4) {
		Player _tmp31_ = 0;
		_tmp31_ = self->priv->last_moving_player;
		if (_tmp31_ == PLAYER_HUMAN) {
			result = (-1) * MAX_HEURIST_VALUE;
			return result;
		} else {
			result = MAX_HEURIST_VALUE;
			return result;
		}
	}
	result = 0;
	return result;
}


static gint decision_tree_horizontal_win (DecisionTree* self, gint i, gint j) {
	gint result = 0;
	gint count = 0;
	gint _tmp22_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	count = 0;
	{
		gint k = 0;
		gint _tmp0_ = 0;
		_tmp0_ = j;
		k = _tmp0_;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gboolean _tmp4_ = FALSE;
				gint _tmp5_ = 0;
				if (!_tmp1_) {
					gint _tmp2_ = 0;
					gint _tmp3_ = 0;
					_tmp2_ = k;
					k = _tmp2_ - 1;
					_tmp3_ = count;
					count = _tmp3_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp5_ = k;
				if (_tmp5_ >= 0) {
					Player* _tmp6_ = NULL;
					gint _tmp6__length1 = 0;
					gint _tmp6__length2 = 0;
					gint _tmp7_ = 0;
					gint _tmp8_ = 0;
					Player _tmp9_ = 0;
					Player _tmp10_ = 0;
					_tmp6_ = self->priv->board;
					_tmp6__length1 = self->priv->board_length1;
					_tmp6__length2 = self->priv->board_length2;
					_tmp7_ = i;
					_tmp8_ = k;
					_tmp9_ = _tmp6_[(_tmp7_ * _tmp6__length2) + _tmp8_];
					_tmp10_ = self->priv->last_moving_player;
					_tmp4_ = _tmp9_ == _tmp10_;
				} else {
					_tmp4_ = FALSE;
				}
				if (!_tmp4_) {
					break;
				}
			}
		}
	}
	{
		gint k = 0;
		gint _tmp11_ = 0;
		_tmp11_ = j;
		k = _tmp11_ + 1;
		{
			gboolean _tmp12_ = FALSE;
			_tmp12_ = TRUE;
			while (TRUE) {
				gboolean _tmp15_ = FALSE;
				gint _tmp16_ = 0;
				if (!_tmp12_) {
					gint _tmp13_ = 0;
					gint _tmp14_ = 0;
					_tmp13_ = k;
					k = _tmp13_ + 1;
					_tmp14_ = count;
					count = _tmp14_ + 1;
				}
				_tmp12_ = FALSE;
				_tmp16_ = k;
				if (_tmp16_ < BOARD_COLUMNS) {
					Player* _tmp17_ = NULL;
					gint _tmp17__length1 = 0;
					gint _tmp17__length2 = 0;
					gint _tmp18_ = 0;
					gint _tmp19_ = 0;
					Player _tmp20_ = 0;
					Player _tmp21_ = 0;
					_tmp17_ = self->priv->board;
					_tmp17__length1 = self->priv->board_length1;
					_tmp17__length2 = self->priv->board_length2;
					_tmp18_ = i;
					_tmp19_ = k;
					_tmp20_ = _tmp17_[(_tmp18_ * _tmp17__length2) + _tmp19_];
					_tmp21_ = self->priv->last_moving_player;
					_tmp15_ = _tmp20_ == _tmp21_;
				} else {
					_tmp15_ = FALSE;
				}
				if (!_tmp15_) {
					break;
				}
			}
		}
	}
	_tmp22_ = count;
	if (_tmp22_ >= 4) {
		Player _tmp23_ = 0;
		_tmp23_ = self->priv->last_moving_player;
		if (_tmp23_ == PLAYER_HUMAN) {
			result = (-1) * MAX_HEURIST_VALUE;
			return result;
		} else {
			result = MAX_HEURIST_VALUE;
			return result;
		}
	}
	result = 0;
	return result;
}


static gint decision_tree_vertical_win (DecisionTree* self, gint i, gint j) {
	gint result = 0;
	gint count = 0;
	gint _tmp11_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	count = 0;
	{
		gint k = 0;
		gint _tmp0_ = 0;
		_tmp0_ = i;
		k = _tmp0_;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gboolean _tmp4_ = FALSE;
				gint _tmp5_ = 0;
				if (!_tmp1_) {
					gint _tmp2_ = 0;
					gint _tmp3_ = 0;
					_tmp2_ = k;
					k = _tmp2_ + 1;
					_tmp3_ = count;
					count = _tmp3_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp5_ = k;
				if (_tmp5_ < BOARD_ROWS) {
					Player* _tmp6_ = NULL;
					gint _tmp6__length1 = 0;
					gint _tmp6__length2 = 0;
					gint _tmp7_ = 0;
					gint _tmp8_ = 0;
					Player _tmp9_ = 0;
					Player _tmp10_ = 0;
					_tmp6_ = self->priv->board;
					_tmp6__length1 = self->priv->board_length1;
					_tmp6__length2 = self->priv->board_length2;
					_tmp7_ = k;
					_tmp8_ = j;
					_tmp9_ = _tmp6_[(_tmp7_ * _tmp6__length2) + _tmp8_];
					_tmp10_ = self->priv->last_moving_player;
					_tmp4_ = _tmp9_ == _tmp10_;
				} else {
					_tmp4_ = FALSE;
				}
				if (!_tmp4_) {
					break;
				}
			}
		}
	}
	_tmp11_ = count;
	if (_tmp11_ >= 4) {
		Player _tmp12_ = 0;
		_tmp12_ = self->priv->last_moving_player;
		if (_tmp12_ == PLAYER_HUMAN) {
			result = (-1) * MAX_HEURIST_VALUE;
			return result;
		} else {
			result = MAX_HEURIST_VALUE;
			return result;
		}
	}
	result = 0;
	return result;
}


static gboolean decision_tree_board_full (DecisionTree* self) {
	gboolean result = FALSE;
	gboolean empty = FALSE;
	gboolean _tmp6_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	empty = FALSE;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_ = 0;
				Player* _tmp3_ = NULL;
				gint _tmp3__length1 = 0;
				gint _tmp3__length2 = 0;
				gint _tmp4_ = 0;
				Player _tmp5_ = 0;
				if (!_tmp0_) {
					gint _tmp1_ = 0;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				if (!(_tmp2_ < BOARD_COLUMNS)) {
					break;
				}
				_tmp3_ = self->priv->board;
				_tmp3__length1 = self->priv->board_length1;
				_tmp3__length2 = self->priv->board_length2;
				_tmp4_ = i;
				_tmp5_ = _tmp3_[(0 * _tmp3__length2) + _tmp4_];
				if (_tmp5_ == PLAYER_NONE) {
					empty = TRUE;
					break;
				}
			}
		}
	}
	_tmp6_ = empty;
	result = !_tmp6_;
	return result;
}


static gboolean decision_tree_move (DecisionTree* self, gint i) {
	gboolean result = FALSE;
	gint cell = 0;
	gint _tmp8_ = 0;
	gboolean _tmp9_ = FALSE;
	Player _tmp10_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		gboolean _tmp0_ = FALSE;
		cell = BOARD_ROWS - 1;
		_tmp0_ = TRUE;
		while (TRUE) {
			gboolean _tmp2_ = FALSE;
			gint _tmp3_ = 0;
			if (!_tmp0_) {
				gint _tmp1_ = 0;
				_tmp1_ = cell;
				cell = _tmp1_ - 1;
			}
			_tmp0_ = FALSE;
			_tmp3_ = cell;
			if (_tmp3_ >= 0) {
				Player* _tmp4_ = NULL;
				gint _tmp4__length1 = 0;
				gint _tmp4__length2 = 0;
				gint _tmp5_ = 0;
				gint _tmp6_ = 0;
				Player _tmp7_ = 0;
				_tmp4_ = self->priv->board;
				_tmp4__length1 = self->priv->board_length1;
				_tmp4__length2 = self->priv->board_length2;
				_tmp5_ = cell;
				_tmp6_ = i;
				_tmp7_ = _tmp4_[(_tmp5_ * _tmp4__length2) + _tmp6_];
				_tmp2_ = _tmp7_ != PLAYER_NONE;
			} else {
				_tmp2_ = FALSE;
			}
			if (!_tmp2_) {
				break;
			}
		}
	}
	_tmp8_ = cell;
	if (_tmp8_ < 0) {
		result = FALSE;
		return result;
	}
	_tmp10_ = self->priv->last_moving_player;
	if (_tmp10_ == PLAYER_NONE) {
		_tmp9_ = TRUE;
	} else {
		Player _tmp11_ = 0;
		_tmp11_ = self->priv->last_moving_player;
		_tmp9_ = _tmp11_ == PLAYER_HUMAN;
	}
	if (_tmp9_) {
		Player* _tmp12_ = NULL;
		gint _tmp12__length1 = 0;
		gint _tmp12__length2 = 0;
		gint _tmp13_ = 0;
		gint _tmp14_ = 0;
		Player _tmp15_ = 0;
		_tmp12_ = self->priv->board;
		_tmp12__length1 = self->priv->board_length1;
		_tmp12__length2 = self->priv->board_length2;
		_tmp13_ = cell;
		_tmp14_ = i;
		_tmp12_[(_tmp13_ * _tmp12__length2) + _tmp14_] = PLAYER_AI;
		_tmp15_ = _tmp12_[(_tmp13_ * _tmp12__length2) + _tmp14_];
		self->priv->last_moving_player = PLAYER_AI;
	} else {
		Player* _tmp16_ = NULL;
		gint _tmp16__length1 = 0;
		gint _tmp16__length2 = 0;
		gint _tmp17_ = 0;
		gint _tmp18_ = 0;
		Player _tmp19_ = 0;
		_tmp16_ = self->priv->board;
		_tmp16__length1 = self->priv->board_length1;
		_tmp16__length2 = self->priv->board_length2;
		_tmp17_ = cell;
		_tmp18_ = i;
		_tmp16_[(_tmp17_ * _tmp16__length2) + _tmp18_] = PLAYER_HUMAN;
		_tmp19_ = _tmp16_[(_tmp17_ * _tmp16__length2) + _tmp18_];
		self->priv->last_moving_player = PLAYER_HUMAN;
	}
	result = TRUE;
	return result;
}


static void decision_tree_unmove (DecisionTree* self, gint i) {
	gint cell = 0;
	Player* _tmp8_ = NULL;
	gint _tmp8__length1 = 0;
	gint _tmp8__length2 = 0;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	Player _tmp11_ = 0;
	Player _tmp12_ = 0;
	g_return_if_fail (self != NULL);
	{
		gboolean _tmp0_ = FALSE;
		cell = BOARD_ROWS - 1;
		_tmp0_ = TRUE;
		while (TRUE) {
			gboolean _tmp2_ = FALSE;
			gint _tmp3_ = 0;
			if (!_tmp0_) {
				gint _tmp1_ = 0;
				_tmp1_ = cell;
				cell = _tmp1_ - 1;
			}
			_tmp0_ = FALSE;
			_tmp3_ = cell;
			if (_tmp3_ >= 0) {
				Player* _tmp4_ = NULL;
				gint _tmp4__length1 = 0;
				gint _tmp4__length2 = 0;
				gint _tmp5_ = 0;
				gint _tmp6_ = 0;
				Player _tmp7_ = 0;
				_tmp4_ = self->priv->board;
				_tmp4__length1 = self->priv->board_length1;
				_tmp4__length2 = self->priv->board_length2;
				_tmp5_ = cell;
				_tmp6_ = i;
				_tmp7_ = _tmp4_[(_tmp5_ * _tmp4__length2) + _tmp6_];
				_tmp2_ = _tmp7_ != PLAYER_NONE;
			} else {
				_tmp2_ = FALSE;
			}
			if (!_tmp2_) {
				break;
			}
		}
	}
	_tmp8_ = self->priv->board;
	_tmp8__length1 = self->priv->board_length1;
	_tmp8__length2 = self->priv->board_length2;
	_tmp9_ = cell;
	_tmp10_ = i;
	_tmp8_[((_tmp9_ + 1) * _tmp8__length2) + _tmp10_] = PLAYER_NONE;
	_tmp11_ = _tmp8_[((_tmp9_ + 1) * _tmp8__length2) + _tmp10_];
	_tmp12_ = self->priv->last_moving_player;
	if (_tmp12_ == PLAYER_AI) {
		self->priv->last_moving_player = PLAYER_HUMAN;
	} else {
		Player _tmp13_ = 0;
		_tmp13_ = self->priv->last_moving_player;
		if (_tmp13_ == PLAYER_HUMAN) {
			self->priv->last_moving_player = PLAYER_AI;
		}
	}
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_ = 0L;
	gchar _tmp1_ = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


void decision_tree_update_board (DecisionTree* self, const gchar* vstr) {
	const gchar* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	Player move = 0;
	const gchar* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (vstr != NULL);
	self->priv->next_move_in_column = -1;
	_tmp0_ = vstr;
	_tmp1_ = strlen (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == 2) {
		return;
	}
	_tmp3_ = vstr;
	_tmp4_ = strlen (_tmp3_);
	_tmp5_ = _tmp4_;
	if ((_tmp5_ % 2) == 0) {
		move = PLAYER_AI;
	} else {
		move = PLAYER_HUMAN;
	}
	{
		gint i = 0;
		i = 1;
		{
			gboolean _tmp6_ = FALSE;
			_tmp6_ = TRUE;
			while (TRUE) {
				gint _tmp8_ = 0;
				const gchar* _tmp9_ = NULL;
				gint _tmp10_ = 0;
				gint _tmp11_ = 0;
				gint column = 0;
				const gchar* _tmp12_ = NULL;
				gint _tmp13_ = 0;
				gchar _tmp14_ = '\0';
				gchar* _tmp15_ = NULL;
				gchar* _tmp16_ = NULL;
				gint _tmp17_ = 0;
				gint _tmp18_ = 0;
				gint cell = 0;
				Player* _tmp27_ = NULL;
				gint _tmp27__length1 = 0;
				gint _tmp27__length2 = 0;
				gint _tmp28_ = 0;
				gint _tmp29_ = 0;
				Player _tmp30_ = 0;
				Player _tmp31_ = 0;
				Player _tmp32_ = 0;
				if (!_tmp6_) {
					gint _tmp7_ = 0;
					_tmp7_ = i;
					i = _tmp7_ + 1;
				}
				_tmp6_ = FALSE;
				_tmp8_ = i;
				_tmp9_ = vstr;
				_tmp10_ = strlen (_tmp9_);
				_tmp11_ = _tmp10_;
				if (!(_tmp8_ < (_tmp11_ - 1))) {
					break;
				}
				_tmp12_ = vstr;
				_tmp13_ = i;
				_tmp14_ = string_get (_tmp12_, (glong) _tmp13_);
				_tmp15_ = g_strdup_printf ("%c", _tmp14_);
				_tmp16_ = _tmp15_;
				_tmp17_ = atoi (_tmp16_);
				_tmp18_ = _tmp17_ - 1;
				_g_free0 (_tmp16_);
				column = _tmp18_;
				{
					gboolean _tmp19_ = FALSE;
					cell = BOARD_ROWS - 1;
					_tmp19_ = TRUE;
					while (TRUE) {
						gboolean _tmp21_ = FALSE;
						gint _tmp22_ = 0;
						if (!_tmp19_) {
							gint _tmp20_ = 0;
							_tmp20_ = cell;
							cell = _tmp20_ - 1;
						}
						_tmp19_ = FALSE;
						_tmp22_ = cell;
						if (_tmp22_ >= 0) {
							Player* _tmp23_ = NULL;
							gint _tmp23__length1 = 0;
							gint _tmp23__length2 = 0;
							gint _tmp24_ = 0;
							gint _tmp25_ = 0;
							Player _tmp26_ = 0;
							_tmp23_ = self->priv->board;
							_tmp23__length1 = self->priv->board_length1;
							_tmp23__length2 = self->priv->board_length2;
							_tmp24_ = cell;
							_tmp25_ = column;
							_tmp26_ = _tmp23_[(_tmp24_ * _tmp23__length2) + _tmp25_];
							_tmp21_ = _tmp26_ != PLAYER_NONE;
						} else {
							_tmp21_ = FALSE;
						}
						if (!_tmp21_) {
							break;
						}
					}
				}
				_tmp27_ = self->priv->board;
				_tmp27__length1 = self->priv->board_length1;
				_tmp27__length2 = self->priv->board_length2;
				_tmp28_ = cell;
				_tmp29_ = column;
				_tmp30_ = move;
				_tmp27_[(_tmp28_ * _tmp27__length2) + _tmp29_] = _tmp30_;
				_tmp31_ = _tmp27_[(_tmp28_ * _tmp27__length2) + _tmp29_];
				_tmp32_ = move;
				if (_tmp32_ == PLAYER_HUMAN) {
					move = PLAYER_AI;
				} else {
					move = PLAYER_HUMAN;
				}
			}
		}
	}
	self->priv->last_moving_player = PLAYER_HUMAN;
}


static gint decision_tree_immediate_win (DecisionTree* self, Player p) {
	gint result = 0;
	Player old_last_moving_player = 0;
	Player _tmp0_ = 0;
	Player _tmp1_ = 0;
	Player _tmp12_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->last_moving_player;
	old_last_moving_player = _tmp0_;
	_tmp1_ = p;
	if (_tmp1_ == PLAYER_AI) {
		self->priv->last_moving_player = PLAYER_HUMAN;
	} else {
		self->priv->last_moving_player = PLAYER_AI;
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				gint _tmp4_ = 0;
				gint _tmp5_ = 0;
				gboolean _tmp6_ = FALSE;
				if (!_tmp2_) {
					gint _tmp3_ = 0;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp2_ = FALSE;
				_tmp4_ = i;
				if (!(_tmp4_ < BOARD_COLUMNS)) {
					break;
				}
				_tmp5_ = i;
				_tmp6_ = decision_tree_move (self, _tmp5_);
				if (_tmp6_) {
					gint _tmp7_ = 0;
					gint _tmp8_ = 0;
					gint _tmp11_ = 0;
					_tmp7_ = i;
					_tmp8_ = decision_tree_victory (self, _tmp7_);
					if (_tmp8_ != 0) {
						gint _tmp9_ = 0;
						Player _tmp10_ = 0;
						_tmp9_ = i;
						decision_tree_unmove (self, _tmp9_);
						_tmp10_ = old_last_moving_player;
						self->priv->last_moving_player = _tmp10_;
						result = i;
						return result;
					}
					_tmp11_ = i;
					decision_tree_unmove (self, _tmp11_);
				}
			}
		}
	}
	_tmp12_ = old_last_moving_player;
	self->priv->last_moving_player = _tmp12_;
	result = -1;
	return result;
}


gint decision_tree_playgame (DecisionTree* self, const gchar* vstr) {
	gint result = 0;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gint temp = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (vstr != NULL, 0);
	_tmp0_ = vstr;
	decision_tree_set_level (self, _tmp0_);
	_tmp1_ = vstr;
	decision_tree_update_board (self, _tmp1_);
	_tmp2_ = decision_tree_immediate_win (self, PLAYER_AI);
	temp = _tmp2_;
	_tmp3_ = temp;
	if (_tmp3_ != (-1)) {
		gint _tmp4_ = 0;
		_tmp4_ = temp;
		result = _tmp4_ + 1;
		return result;
	}
	_tmp5_ = decision_tree_immediate_win (self, PLAYER_HUMAN);
	temp = _tmp5_;
	_tmp6_ = temp;
	if (_tmp6_ != (-1)) {
		gint _tmp7_ = 0;
		_tmp7_ = temp;
		result = _tmp7_ + 1;
		return result;
	}
	_tmp8_ = self->priv->plies;
	decision_tree_negamax (self, _tmp8_, NEG_INF, (-1) * NEG_INF);
	_tmp9_ = self->priv->next_move_in_column;
	result = _tmp9_ + 1;
	return result;
}


static gint decision_tree_heurist (DecisionTree* self) {
	gint result = 0;
	Difficulty _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->level;
	if (_tmp0_ == DIFFICULTY_EASY) {
		gint _tmp1_ = 0;
		_tmp1_ = decision_tree_heurist_easy (self);
		result = _tmp1_;
		return result;
	} else {
		Difficulty _tmp2_ = 0;
		_tmp2_ = self->priv->level;
		if (_tmp2_ == DIFFICULTY_MEDIUM) {
			gint _tmp3_ = 0;
			_tmp3_ = decision_tree_heurist_medium (self);
			result = _tmp3_;
			return result;
		} else {
			gint _tmp4_ = 0;
			_tmp4_ = decision_tree_heurist_hard (self);
			result = _tmp4_;
			return result;
		}
	}
}


static gint decision_tree_heurist_easy (DecisionTree* self) {
	gint result = 0;
	gint _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = decision_tree_heurist_hard (self);
	result = (-1) * _tmp0_;
	return result;
}


static gint decision_tree_heurist_medium (DecisionTree* self) {
	gint result = 0;
	gint32 _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_random_int_range ((gint32) 1, (gint32) 49);
	result = (gint) _tmp0_;
	return result;
}


static gint decision_tree_heurist_hard (DecisionTree* self) {
	gint result = 0;
	gint count = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	count = 0;
	_tmp0_ = decision_tree_count_3_in_a_row (self, PLAYER_AI);
	count = _tmp0_;
	_tmp1_ = count;
	_tmp2_ = decision_tree_count_3_in_a_row (self, PLAYER_HUMAN);
	count = _tmp1_ - _tmp2_;
	_tmp3_ = count;
	count = _tmp3_ * 100;
	_tmp4_ = count;
	if (_tmp4_ == 0) {
		gint32 _tmp5_ = 0;
		_tmp5_ = g_random_int_range ((gint32) 1, (gint32) 49);
		count = (gint) _tmp5_;
	}
	result = count;
	return result;
}


static gint decision_tree_count_3_in_a_row (DecisionTree* self, Player p) {
	gint result = 0;
	gint count = 0;
	Player old_last_moving_player = 0;
	Player _tmp0_ = 0;
	Player _tmp1_ = 0;
	Player _tmp27_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	count = 0;
	_tmp0_ = self->priv->last_moving_player;
	old_last_moving_player = _tmp0_;
	_tmp1_ = p;
	self->priv->last_moving_player = _tmp1_;
	{
		gint j = 0;
		j = 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				gint _tmp4_ = 0;
				if (!_tmp2_) {
					gint _tmp3_ = 0;
					_tmp3_ = j;
					j = _tmp3_ + 1;
				}
				_tmp2_ = FALSE;
				_tmp4_ = j;
				if (!(_tmp4_ < BOARD_COLUMNS)) {
					break;
				}
				{
					gint i = 0;
					i = 0;
					{
						gboolean _tmp5_ = FALSE;
						_tmp5_ = TRUE;
						while (TRUE) {
							gint _tmp7_ = 0;
							Player* _tmp8_ = NULL;
							gint _tmp8__length1 = 0;
							gint _tmp8__length2 = 0;
							gint _tmp9_ = 0;
							gint _tmp10_ = 0;
							Player _tmp11_ = 0;
							gint _tmp12_ = 0;
							gint _tmp13_ = 0;
							gboolean _tmp14_ = FALSE;
							Player* _tmp15_ = NULL;
							gint _tmp15__length1 = 0;
							gint _tmp15__length2 = 0;
							gint _tmp16_ = 0;
							gint _tmp17_ = 0;
							Player _tmp18_ = 0;
							Player _tmp19_ = 0;
							gint _tmp20_ = 0;
							gint _tmp21_ = 0;
							Player* _tmp23_ = NULL;
							gint _tmp23__length1 = 0;
							gint _tmp23__length2 = 0;
							gint _tmp24_ = 0;
							gint _tmp25_ = 0;
							Player _tmp26_ = 0;
							if (!_tmp5_) {
								gint _tmp6_ = 0;
								_tmp6_ = i;
								i = _tmp6_ + 1;
							}
							_tmp5_ = FALSE;
							_tmp7_ = i;
							if (!(_tmp7_ < BOARD_ROWS)) {
								break;
							}
							_tmp8_ = self->priv->board;
							_tmp8__length1 = self->priv->board_length1;
							_tmp8__length2 = self->priv->board_length2;
							_tmp9_ = i;
							_tmp10_ = j;
							_tmp11_ = _tmp8_[(_tmp9_ * _tmp8__length2) + _tmp10_];
							if (_tmp11_ != PLAYER_NONE) {
								break;
							}
							_tmp12_ = i;
							_tmp13_ = j;
							_tmp14_ = decision_tree_all_adjacent_empty (self, _tmp12_, _tmp13_);
							if (_tmp14_) {
								continue;
							}
							_tmp15_ = self->priv->board;
							_tmp15__length1 = self->priv->board_length1;
							_tmp15__length2 = self->priv->board_length2;
							_tmp16_ = i;
							_tmp17_ = j;
							_tmp18_ = p;
							_tmp15_[(_tmp16_ * _tmp15__length2) + _tmp17_] = _tmp18_;
							_tmp19_ = _tmp15_[(_tmp16_ * _tmp15__length2) + _tmp17_];
							_tmp20_ = j;
							_tmp21_ = decision_tree_victory (self, _tmp20_);
							if (_tmp21_ != 0) {
								gint _tmp22_ = 0;
								_tmp22_ = count;
								count = _tmp22_ + 1;
							}
							_tmp23_ = self->priv->board;
							_tmp23__length1 = self->priv->board_length1;
							_tmp23__length2 = self->priv->board_length2;
							_tmp24_ = i;
							_tmp25_ = j;
							_tmp23_[(_tmp24_ * _tmp23__length2) + _tmp25_] = PLAYER_NONE;
							_tmp26_ = _tmp23_[(_tmp24_ * _tmp23__length2) + _tmp25_];
						}
					}
				}
			}
		}
	}
	_tmp27_ = old_last_moving_player;
	self->priv->last_moving_player = _tmp27_;
	result = count;
	return result;
}


static gboolean decision_tree_all_adjacent_empty (DecisionTree* self, gint i, gint j) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		gint k = 0;
		k = -1;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_ = 0;
				if (!_tmp0_) {
					gint _tmp1_ = 0;
					_tmp1_ = k;
					k = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = k;
				if (!(_tmp2_ <= 1)) {
					break;
				}
				{
					gint l = 0;
					l = -1;
					{
						gboolean _tmp3_ = FALSE;
						_tmp3_ = TRUE;
						while (TRUE) {
							gint _tmp5_ = 0;
							gboolean _tmp6_ = FALSE;
							gint _tmp7_ = 0;
							gboolean _tmp9_ = FALSE;
							gboolean _tmp10_ = FALSE;
							gboolean _tmp11_ = FALSE;
							gint _tmp12_ = 0;
							gint _tmp13_ = 0;
							if (!_tmp3_) {
								gint _tmp4_ = 0;
								_tmp4_ = l;
								l = _tmp4_ + 1;
							}
							_tmp3_ = FALSE;
							_tmp5_ = l;
							if (!(_tmp5_ <= 1)) {
								break;
							}
							_tmp7_ = k;
							if (_tmp7_ == 0) {
								gint _tmp8_ = 0;
								_tmp8_ = l;
								_tmp6_ = _tmp8_ == 0;
							} else {
								_tmp6_ = FALSE;
							}
							if (_tmp6_) {
								continue;
							}
							_tmp12_ = i;
							_tmp13_ = k;
							if ((_tmp12_ + _tmp13_) >= 0) {
								gint _tmp14_ = 0;
								gint _tmp15_ = 0;
								_tmp14_ = i;
								_tmp15_ = k;
								_tmp11_ = (_tmp14_ + _tmp15_) < BOARD_ROWS;
							} else {
								_tmp11_ = FALSE;
							}
							if (_tmp11_) {
								gint _tmp16_ = 0;
								gint _tmp17_ = 0;
								_tmp16_ = j;
								_tmp17_ = l;
								_tmp10_ = (_tmp16_ + _tmp17_) >= 0;
							} else {
								_tmp10_ = FALSE;
							}
							if (_tmp10_) {
								gint _tmp18_ = 0;
								gint _tmp19_ = 0;
								_tmp18_ = j;
								_tmp19_ = l;
								_tmp9_ = (_tmp18_ + _tmp19_) < BOARD_COLUMNS;
							} else {
								_tmp9_ = FALSE;
							}
							if (_tmp9_) {
								Player* _tmp20_ = NULL;
								gint _tmp20__length1 = 0;
								gint _tmp20__length2 = 0;
								gint _tmp21_ = 0;
								gint _tmp22_ = 0;
								gint _tmp23_ = 0;
								gint _tmp24_ = 0;
								Player _tmp25_ = 0;
								_tmp20_ = self->priv->board;
								_tmp20__length1 = self->priv->board_length1;
								_tmp20__length2 = self->priv->board_length2;
								_tmp21_ = i;
								_tmp22_ = k;
								_tmp23_ = j;
								_tmp24_ = l;
								_tmp25_ = _tmp20_[((_tmp21_ + _tmp22_) * _tmp20__length2) + (_tmp23_ + _tmp24_)];
								if (_tmp25_ != PLAYER_NONE) {
									result = FALSE;
									return result;
								}
							}
						}
					}
				}
			}
		}
	}
	result = TRUE;
	return result;
}


static void decision_tree_set_level (DecisionTree* self, const gchar* vstr) {
	const gchar* _tmp0_ = NULL;
	gchar _tmp1_ = '\0';
	g_return_if_fail (self != NULL);
	g_return_if_fail (vstr != NULL);
	_tmp0_ = vstr;
	_tmp1_ = string_get (_tmp0_, (glong) 0);
	if (_tmp1_ == 'a') {
		self->priv->level = DIFFICULTY_EASY;
		self->priv->plies = 4;
	} else {
		const gchar* _tmp2_ = NULL;
		gchar _tmp3_ = '\0';
		_tmp2_ = vstr;
		_tmp3_ = string_get (_tmp2_, (glong) 0);
		if (_tmp3_ == 'b') {
			self->priv->level = DIFFICULTY_MEDIUM;
			self->priv->plies = 7;
		} else {
			self->priv->level = DIFFICULTY_HARD;
			self->priv->plies = 7;
		}
	}
}


gint decision_tree_playandcheck (DecisionTree* self, const gchar* vstr) {
	gint result = 0;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gint temp = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (vstr != NULL, 0);
	_tmp0_ = vstr;
	decision_tree_set_level (self, _tmp0_);
	_tmp1_ = vstr;
	decision_tree_update_board (self, _tmp1_);
	_tmp2_ = decision_tree_immediate_win (self, PLAYER_AI);
	temp = _tmp2_;
	_tmp3_ = temp;
	if (_tmp3_ != (-1)) {
		result = 1000;
		return result;
	}
	_tmp4_ = decision_tree_immediate_win (self, PLAYER_HUMAN);
	temp = _tmp4_;
	_tmp5_ = temp;
	if (_tmp5_ != (-1)) {
		gint _tmp6_ = 0;
		_tmp6_ = temp;
		result = _tmp6_ + 1;
		return result;
	}
	_tmp7_ = self->priv->plies;
	decision_tree_negamax (self, _tmp7_, NEG_INF, (-1) * NEG_INF);
	_tmp8_ = self->priv->next_move_in_column;
	result = _tmp8_ + 1;
	return result;
}


static void value_decision_tree_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_decision_tree_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		decision_tree_unref (value->data[0].v_pointer);
	}
}


static void value_decision_tree_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = decision_tree_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_decision_tree_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_decision_tree_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		DecisionTree* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = decision_tree_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_decision_tree_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	DecisionTree** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = decision_tree_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_decision_tree (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecDecisionTree* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_DECISION_TREE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_decision_tree (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_DECISION_TREE), NULL);
	return value->data[0].v_pointer;
}


void value_set_decision_tree (GValue* value, gpointer v_object) {
	DecisionTree* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_DECISION_TREE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_DECISION_TREE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		decision_tree_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		decision_tree_unref (old);
	}
}


void value_take_decision_tree (GValue* value, gpointer v_object) {
	DecisionTree* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_DECISION_TREE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_DECISION_TREE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		decision_tree_unref (old);
	}
}


static void decision_tree_class_init (DecisionTreeClass * klass) {
	decision_tree_parent_class = g_type_class_peek_parent (klass);
	DECISION_TREE_CLASS (klass)->finalize = decision_tree_finalize;
	g_type_class_add_private (klass, sizeof (DecisionTreePrivate));
}


static void decision_tree_instance_init (DecisionTree * self) {
	Player* _tmp0_ = NULL;
	self->priv = DECISION_TREE_GET_PRIVATE (self);
	_tmp0_ = g_new0 (Player, BOARD_ROWS * BOARD_COLUMNS);
	self->priv->board = _tmp0_;
	self->priv->board_length1 = BOARD_ROWS;
	self->priv->board_length2 = BOARD_COLUMNS;
	self->priv->plies = 8;
	self->priv->last_moving_player = PLAYER_NONE;
	self->priv->next_move_in_column = -1;
	self->ref_count = 1;
}


static void decision_tree_finalize (DecisionTree* obj) {
	DecisionTree * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DECISION_TREE, DecisionTree);
	self->priv->board = (g_free (self->priv->board), NULL);
}


GType decision_tree_get_type (void) {
	static volatile gsize decision_tree_type_id__volatile = 0;
	if (g_once_init_enter (&decision_tree_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_decision_tree_init, value_decision_tree_free_value, value_decision_tree_copy_value, value_decision_tree_peek_pointer, "p", value_decision_tree_collect_value, "p", value_decision_tree_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (DecisionTreeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) decision_tree_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DecisionTree), 0, (GInstanceInitFunc) decision_tree_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType decision_tree_type_id;
		decision_tree_type_id = g_type_register_fundamental (g_type_fundamental_next (), "DecisionTree", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&decision_tree_type_id__volatile, decision_tree_type_id);
	}
	return decision_tree_type_id__volatile;
}


gpointer decision_tree_ref (gpointer instance) {
	DecisionTree* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void decision_tree_unref (gpointer instance) {
	DecisionTree* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		DECISION_TREE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}



