/* GNOME libraries - Abstract icon list model
 *
 * Copyright (C) 2000 The Free Software Foundation
 *
 * Author: Federico Mena-Quintero <federico@gnu.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef GNOME_ICON_LIST_MODEL_H
#define GNOME_ICON_LIST_MODEL_H

#include <libgnome/gnome-defs.h>
#include <gtk/gtkobject.h>
#include <gdk-pixbuf/gdk-pixbuf.h>

BEGIN_GNOME_DECLS



#define GNOME_TYPE_ICON_LIST_MODEL            (gnome_icon_list_model_get_type ())
#define GNOME_ICON_LIST_MODEL(obj)            (GTK_CHECK_CAST ((obj),			\
					       GNOME_TYPE_ICON_LIST_MODEL,GnomeIconListModel))
#define GNOME_ICON_LIST_MODEL_CLASS(klass)    (GTK_CHECK_CLASS_CAST ((klass),		\
					       GNOME_TYPE_ICON_LIST_MODEL, GnomeIconListModelClass))
#define GNOME_IS_ICON_LIST_MODEL(obj)         (GTK_CHECK_TYPE ((obj),GNOME_TYPE_ICON_LIST_MODEL))
#define GNOME_IS_ICON_LIST_MODEL_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass),		\
					       GNOME_TYPE_ICON_LIST_MODEL))

typedef struct _GnomeIconListModel GnomeIconListModel;
typedef struct _GnomeIconListModelClass GnomeIconListModelClass;

typedef struct _GnomeIconListModelPrivate GnomeIconListModelPrivate;

struct _GnomeIconListModel {
	GtkObject object;
};

struct _GnomeIconListModelClass {
	GtkObjectClass parent_class;

	/* Methods */

	int (* get_length) (GnomeIconListModel *model);
	void (* get_item) (GnomeIconListModel *model, int n, GdkPixbuf **pixbuf, char **caption);

	/* Notification signals */

	void (* interval_changed) (GnomeIconListModel *model, int start, int length);
	void (* interval_added) (GnomeIconListModel *model, int start, int length);
	void (* interval_removed) (GnomeIconListModel *model, int start, int length);
};

GtkType gnome_icon_list_model_get_type (void);

int gnome_icon_list_model_get_length (GnomeIconListModel *model);
void gnome_icon_list_model_get_item (GnomeIconListModel *model, int n,
				     GdkPixbuf **pixbuf, char **caption);

void gnome_icon_list_model_interval_changed (GnomeIconListModel *model, int start, int length);
void gnome_icon_list_model_interval_added (GnomeIconListModel *model, int start, int length);
void gnome_icon_list_model_interval_removed (GnomeIconListModel *model, int start, int length);



END_GNOME_DECLS

#endif
