/* scan.h - 2000/06/16 */
/*
 *  EasyTAG - Tag editor for MP3 and Ogg Vorbis files
 *  Copyright (C) 2000-2003  Jerome Couderc <easytag@gmail.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */


#ifndef __SCAN_H__
#define __SCAN_H__


#include "et_core.h"

/****************
 * Declarations *
 ****************/
GtkWidget *ScannerWindow;


enum
{
    SCANNER_FILL_TAG = 0,
    SCANNER_RENAME_FILE,
    SCANNER_PROCESS_FIELDS
}; // Add a new item : Min and Max values used in Open_ScannerWindow

enum {
    MASK_EDITOR_TEXT,
    MASK_EDITOR_COUNT
};



/**************
 * Prototypes *
 **************/

void   Scan_Select_Mode_And_Run_Scanner     (ET_File *ETFile);
gchar *Scan_Generate_New_Filename_From_Mask       (ET_File *ETFile, gchar *mask, gboolean no_dir_check_or_conversion);
gchar *Scan_Generate_New_Directory_Name_From_Mask (ET_File *ETFile, gchar *mask, gboolean no_dir_check_or_conversion);
void   Scan_Rename_File_Generate_Preview      (void);
void   Scan_Fill_Tag_Generate_Preview         (void);
void   Scan_Rename_Directory_Generate_Preview (void);

void et_scan_show (GtkAction *action, gpointer user_data);

void entry_check_rename_file_mask (GtkEntry *entry, gpointer user_data);

void Scan_Process_Fields_First_Letters_Uppercase (gchar *string);

void Init_ScannerWindow (void);
void Open_ScannerWindow (gint scanner_type);
void ScannerWindow_Apply_Changes (void);

#endif /* __SCAN_H__ */
