/* dconf-schema.c generated by valac, the Vala compiler
 * generated from dconf-schema.vala, do not modify */


#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <libxml/tree.h>
#include <gee.h>
#include <libxml/parser.h>
#include <gio/gio.h>
#include <gobject/gvaluecollector.h>


#define TYPE_SCHEMA_KEY (schema_key_get_type ())
#define SCHEMA_KEY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCHEMA_KEY, SchemaKey))
#define SCHEMA_KEY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCHEMA_KEY, SchemaKeyClass))
#define IS_SCHEMA_KEY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCHEMA_KEY))
#define IS_SCHEMA_KEY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCHEMA_KEY))
#define SCHEMA_KEY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCHEMA_KEY, SchemaKeyClass))

typedef struct _SchemaKey SchemaKey;
typedef struct _SchemaKeyClass SchemaKeyClass;
typedef struct _SchemaKeyPrivate SchemaKeyPrivate;

#define TYPE_SCHEMA (schema_get_type ())
#define SCHEMA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCHEMA, Schema))
#define SCHEMA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCHEMA, SchemaClass))
#define IS_SCHEMA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCHEMA))
#define IS_SCHEMA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCHEMA))
#define SCHEMA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCHEMA, SchemaClass))

typedef struct _Schema Schema;
typedef struct _SchemaClass SchemaClass;
#define _schema_unref0(var) ((var == NULL) ? NULL : (var = (schema_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_variant_type_free0(var) ((var == NULL) ? NULL : (var = (g_variant_type_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _ParamSpecSchemaKey ParamSpecSchemaKey;

#define TYPE_SCHEMA_ENUM_VALUE (schema_enum_value_get_type ())
#define SCHEMA_ENUM_VALUE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCHEMA_ENUM_VALUE, SchemaEnumValue))
#define SCHEMA_ENUM_VALUE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCHEMA_ENUM_VALUE, SchemaEnumValueClass))
#define IS_SCHEMA_ENUM_VALUE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCHEMA_ENUM_VALUE))
#define IS_SCHEMA_ENUM_VALUE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCHEMA_ENUM_VALUE))
#define SCHEMA_ENUM_VALUE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCHEMA_ENUM_VALUE, SchemaEnumValueClass))

typedef struct _SchemaEnumValue SchemaEnumValue;
typedef struct _SchemaEnumValueClass SchemaEnumValueClass;
typedef struct _SchemaEnumValuePrivate SchemaEnumValuePrivate;

#define TYPE_SCHEMA_ENUM (schema_enum_get_type ())
#define SCHEMA_ENUM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCHEMA_ENUM, SchemaEnum))
#define SCHEMA_ENUM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCHEMA_ENUM, SchemaEnumClass))
#define IS_SCHEMA_ENUM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCHEMA_ENUM))
#define IS_SCHEMA_ENUM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCHEMA_ENUM))
#define SCHEMA_ENUM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCHEMA_ENUM, SchemaEnumClass))

typedef struct _SchemaEnum SchemaEnum;
typedef struct _SchemaEnumClass SchemaEnumClass;
#define _schema_enum_unref0(var) ((var == NULL) ? NULL : (var = (schema_enum_unref (var), NULL)))
typedef struct _SchemaEnumPrivate SchemaEnumPrivate;

#define TYPE_SCHEMA_LIST (schema_list_get_type ())
#define SCHEMA_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCHEMA_LIST, SchemaList))
#define SCHEMA_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCHEMA_LIST, SchemaListClass))
#define IS_SCHEMA_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCHEMA_LIST))
#define IS_SCHEMA_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCHEMA_LIST))
#define SCHEMA_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCHEMA_LIST, SchemaListClass))

typedef struct _SchemaList SchemaList;
typedef struct _SchemaListClass SchemaListClass;
#define _schema_list_unref0(var) ((var == NULL) ? NULL : (var = (schema_list_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _ParamSpecSchemaEnum ParamSpecSchemaEnum;
typedef struct _SchemaPrivate SchemaPrivate;
#define _schema_key_unref0(var) ((var == NULL) ? NULL : (var = (schema_key_unref (var), NULL)))
typedef struct _ParamSpecSchema ParamSpecSchema;
typedef struct _SchemaListPrivate SchemaListPrivate;
typedef struct _ParamSpecSchemaList ParamSpecSchemaList;

struct _SchemaKey {
	GTypeInstance parent_instance;
	volatile int ref_count;
	SchemaKeyPrivate * priv;
	Schema* schema;
	char* name;
	char* type;
	GVariant* default_value;
	char* enum_name;
	char* summary;
	char* description;
	char* gettext_domain;
};

struct _SchemaKeyClass {
	GTypeClass parent_class;
	void (*finalize) (SchemaKey *self);
};

struct _ParamSpecSchemaKey {
	GParamSpec parent_instance;
};

struct _SchemaEnumValue {
	GObject parent_instance;
	SchemaEnumValuePrivate * priv;
	SchemaEnum* schema_enum;
	gint index;
	char* nick;
	gint value;
};

struct _SchemaEnumValueClass {
	GObjectClass parent_class;
};

struct _SchemaEnum {
	GTypeInstance parent_instance;
	volatile int ref_count;
	SchemaEnumPrivate * priv;
	SchemaList* list;
	char* id;
	GeeArrayList* values;
};

struct _SchemaEnumClass {
	GTypeClass parent_class;
	void (*finalize) (SchemaEnum *self);
};

struct _ParamSpecSchemaEnum {
	GParamSpec parent_instance;
};

struct _Schema {
	GTypeInstance parent_instance;
	volatile int ref_count;
	SchemaPrivate * priv;
	SchemaList* list;
	char* id;
	char* path;
	GeeHashMap* keys;
};

struct _SchemaClass {
	GTypeClass parent_class;
	void (*finalize) (Schema *self);
};

struct _ParamSpecSchema {
	GParamSpec parent_instance;
};

struct _SchemaList {
	GTypeInstance parent_instance;
	volatile int ref_count;
	SchemaListPrivate * priv;
	GeeArrayList* schemas;
	GeeHashMap* keys;
	GeeHashMap* enums;
};

struct _SchemaListClass {
	GTypeClass parent_class;
	void (*finalize) (SchemaList *self);
};

struct _ParamSpecSchemaList {
	GParamSpec parent_instance;
};


static gpointer schema_key_parent_class = NULL;
static gpointer schema_enum_value_parent_class = NULL;
static gpointer schema_enum_parent_class = NULL;
static gpointer schema_parent_class = NULL;
static gpointer schema_list_parent_class = NULL;

gpointer schema_key_ref (gpointer instance);
void schema_key_unref (gpointer instance);
GParamSpec* param_spec_schema_key (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_schema_key (GValue* value, gpointer v_object);
void value_take_schema_key (GValue* value, gpointer v_object);
gpointer value_get_schema_key (const GValue* value);
GType schema_key_get_type (void);
gpointer schema_ref (gpointer instance);
void schema_unref (gpointer instance);
GParamSpec* param_spec_schema (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_schema (GValue* value, gpointer v_object);
void value_take_schema (GValue* value, gpointer v_object);
gpointer value_get_schema (const GValue* value);
GType schema_get_type (void);
enum  {
	SCHEMA_KEY_DUMMY_PROPERTY
};
SchemaKey* schema_key_new (xmlNode* node, Schema* schema, const char* gettext_domain);
SchemaKey* schema_key_construct (GType object_type, xmlNode* node, Schema* schema, const char* gettext_domain);
static void schema_key_finalize (SchemaKey* obj);
GType schema_enum_value_get_type (void);
gpointer schema_enum_ref (gpointer instance);
void schema_enum_unref (gpointer instance);
GParamSpec* param_spec_schema_enum (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_schema_enum (GValue* value, gpointer v_object);
void value_take_schema_enum (GValue* value, gpointer v_object);
gpointer value_get_schema_enum (const GValue* value);
GType schema_enum_get_type (void);
enum  {
	SCHEMA_ENUM_VALUE_DUMMY_PROPERTY
};
SchemaEnumValue* schema_enum_value_new (SchemaEnum* schema_enum, gint index, const char* nick, gint value);
SchemaEnumValue* schema_enum_value_construct (GType object_type, SchemaEnum* schema_enum, gint index, const char* nick, gint value);
static void schema_enum_value_finalize (GObject* obj);
gpointer schema_list_ref (gpointer instance);
void schema_list_unref (gpointer instance);
GParamSpec* param_spec_schema_list (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_schema_list (GValue* value, gpointer v_object);
void value_take_schema_list (GValue* value, gpointer v_object);
gpointer value_get_schema_list (const GValue* value);
GType schema_list_get_type (void);
enum  {
	SCHEMA_ENUM_DUMMY_PROPERTY
};
SchemaEnum* schema_enum_new (SchemaList* list, xmlNode* node);
SchemaEnum* schema_enum_construct (GType object_type, SchemaList* list, xmlNode* node);
static void schema_enum_finalize (SchemaEnum* obj);
enum  {
	SCHEMA_DUMMY_PROPERTY
};
Schema* schema_new (SchemaList* list, xmlNode* node, const char* gettext_domain);
Schema* schema_construct (GType object_type, SchemaList* list, xmlNode* node, const char* gettext_domain);
static void schema_finalize (Schema* obj);
enum  {
	SCHEMA_LIST_DUMMY_PROPERTY
};
void schema_list_parse_file (SchemaList* self, const char* path);
void schema_list_load_directory (SchemaList* self, const char* dir, GError** error);
SchemaList* schema_list_new (void);
SchemaList* schema_list_construct (GType object_type);
static void schema_list_finalize (SchemaList* obj);
static int _vala_strcmp0 (const char * str1, const char * str2);



static gpointer _schema_ref0 (gpointer self) {
	return self ? schema_ref (self) : NULL;
}


SchemaKey* schema_key_construct (GType object_type, xmlNode* node, Schema* schema, const char* gettext_domain) {
	GError * _inner_error_;
	SchemaKey* self;
	Schema* _tmp0_;
	char* _tmp1_;
	g_return_val_if_fail (schema != NULL, NULL);
	_inner_error_ = NULL;
	self = (SchemaKey*) g_type_create_instance (object_type);
	self->schema = (_tmp0_ = _schema_ref0 (schema), _schema_unref0 (self->schema), _tmp0_);
	self->gettext_domain = (_tmp1_ = g_strdup (gettext_domain), _g_free0 (self->gettext_domain), _tmp1_);
	{
		xmlAttr* prop;
		prop = node->properties;
		{
			gboolean _tmp2_;
			_tmp2_ = TRUE;
			while (TRUE) {
				if (!_tmp2_) {
					prop = prop->next;
				}
				_tmp2_ = FALSE;
				if (!(prop != NULL)) {
					break;
				}
				if (_vala_strcmp0 (prop->name, "name") == 0) {
					char* _tmp3_;
					self->name = (_tmp3_ = g_strdup (prop->children->content), _g_free0 (self->name), _tmp3_);
				} else {
					if (_vala_strcmp0 (prop->name, "type") == 0) {
						char* _tmp4_;
						self->type = (_tmp4_ = g_strdup (prop->children->content), _g_free0 (self->type), _tmp4_);
					} else {
						if (_vala_strcmp0 (prop->name, "enum") == 0) {
							char* _tmp5_;
							char* _tmp6_;
							self->type = (_tmp5_ = g_strdup ("s"), _g_free0 (self->type), _tmp5_);
							self->enum_name = (_tmp6_ = g_strdup (prop->children->content), _g_free0 (self->enum_name), _tmp6_);
						}
					}
				}
			}
		}
	}
	{
		xmlNode* child;
		child = node->children;
		{
			gboolean _tmp7_;
			_tmp7_ = TRUE;
			while (TRUE) {
				if (!_tmp7_) {
					child = child->next;
				}
				_tmp7_ = FALSE;
				if (!(child != NULL)) {
					break;
				}
				if (_vala_strcmp0 (child->name, "default") == 0) {
					{
						GVariantType* _tmp8_;
						GVariant* _tmp9_;
						GVariant* _tmp10_;
						GVariant* _tmp11_;
						_tmp10_ = (_tmp9_ = g_variant_parse (_tmp8_ = g_variant_type_new (self->type), child->children->content, NULL, NULL, &_inner_error_), _g_variant_type_free0 (_tmp8_), _tmp9_);
						if (_inner_error_ != NULL) {
							if (_inner_error_->domain == G_VARIANT_PARSE_ERROR) {
								goto __catch2_g_variant_parse_error;
							}
							g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return NULL;
						}
						self->default_value = (_tmp11_ = _tmp10_, _g_variant_unref0 (self->default_value), _tmp11_);
					}
					goto __finally2;
					__catch2_g_variant_parse_error:
					{
						GError * e;
						e = _inner_error_;
						_inner_error_ = NULL;
						{
							_g_error_free0 (e);
						}
					}
					__finally2:
					if (_inner_error_ != NULL) {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				} else {
					if (_vala_strcmp0 (child->name, "summary") == 0) {
						char* _tmp12_;
						self->summary = (_tmp12_ = g_strdup (child->children->content), _g_free0 (self->summary), _tmp12_);
					} else {
						if (_vala_strcmp0 (child->name, "description") == 0) {
							char* _tmp13_;
							self->description = (_tmp13_ = g_strdup (child->children->content), _g_free0 (self->description), _tmp13_);
						}
					}
				}
			}
		}
	}
	return self;
}


SchemaKey* schema_key_new (xmlNode* node, Schema* schema, const char* gettext_domain) {
	return schema_key_construct (TYPE_SCHEMA_KEY, node, schema, gettext_domain);
}


static void value_schema_key_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_schema_key_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		schema_key_unref (value->data[0].v_pointer);
	}
}


static void value_schema_key_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = schema_key_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_schema_key_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_schema_key_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		SchemaKey* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = schema_key_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_schema_key_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	SchemaKey** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags && G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = schema_key_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_schema_key (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecSchemaKey* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_SCHEMA_KEY), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_schema_key (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SCHEMA_KEY), NULL);
	return value->data[0].v_pointer;
}


void value_set_schema_key (GValue* value, gpointer v_object) {
	SchemaKey* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SCHEMA_KEY));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SCHEMA_KEY));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		schema_key_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		schema_key_unref (old);
	}
}


void value_take_schema_key (GValue* value, gpointer v_object) {
	SchemaKey* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SCHEMA_KEY));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SCHEMA_KEY));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		schema_key_unref (old);
	}
}


static void schema_key_class_init (SchemaKeyClass * klass) {
	schema_key_parent_class = g_type_class_peek_parent (klass);
	SCHEMA_KEY_CLASS (klass)->finalize = schema_key_finalize;
}


static void schema_key_instance_init (SchemaKey * self) {
	self->ref_count = 1;
}


static void schema_key_finalize (SchemaKey* obj) {
	SchemaKey * self;
	self = SCHEMA_KEY (obj);
	_schema_unref0 (self->schema);
	_g_free0 (self->name);
	_g_free0 (self->type);
	_g_variant_unref0 (self->default_value);
	_g_free0 (self->enum_name);
	_g_free0 (self->summary);
	_g_free0 (self->description);
	_g_free0 (self->gettext_domain);
}


GType schema_key_get_type (void) {
	static volatile gsize schema_key_type_id__volatile = 0;
	if (g_once_init_enter (&schema_key_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_schema_key_init, value_schema_key_free_value, value_schema_key_copy_value, value_schema_key_peek_pointer, "p", value_schema_key_collect_value, "p", value_schema_key_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (SchemaKeyClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) schema_key_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SchemaKey), 0, (GInstanceInitFunc) schema_key_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType schema_key_type_id;
		schema_key_type_id = g_type_register_fundamental (g_type_fundamental_next (), "SchemaKey", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&schema_key_type_id__volatile, schema_key_type_id);
	}
	return schema_key_type_id__volatile;
}


gpointer schema_key_ref (gpointer instance) {
	SchemaKey* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void schema_key_unref (gpointer instance) {
	SchemaKey* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		SCHEMA_KEY_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static gpointer _schema_enum_ref0 (gpointer self) {
	return self ? schema_enum_ref (self) : NULL;
}


SchemaEnumValue* schema_enum_value_construct (GType object_type, SchemaEnum* schema_enum, gint index, const char* nick, gint value) {
	SchemaEnumValue * self;
	SchemaEnum* _tmp0_;
	char* _tmp1_;
	g_return_val_if_fail (schema_enum != NULL, NULL);
	g_return_val_if_fail (nick != NULL, NULL);
	self = (SchemaEnumValue*) g_object_new (object_type, NULL);
	self->schema_enum = (_tmp0_ = _schema_enum_ref0 (schema_enum), _schema_enum_unref0 (self->schema_enum), _tmp0_);
	self->index = index;
	self->nick = (_tmp1_ = g_strdup (nick), _g_free0 (self->nick), _tmp1_);
	self->value = value;
	return self;
}


SchemaEnumValue* schema_enum_value_new (SchemaEnum* schema_enum, gint index, const char* nick, gint value) {
	return schema_enum_value_construct (TYPE_SCHEMA_ENUM_VALUE, schema_enum, index, nick, value);
}


static void schema_enum_value_class_init (SchemaEnumValueClass * klass) {
	schema_enum_value_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = schema_enum_value_finalize;
}


static void schema_enum_value_instance_init (SchemaEnumValue * self) {
}


static void schema_enum_value_finalize (GObject* obj) {
	SchemaEnumValue * self;
	self = SCHEMA_ENUM_VALUE (obj);
	_schema_enum_unref0 (self->schema_enum);
	_g_free0 (self->nick);
	G_OBJECT_CLASS (schema_enum_value_parent_class)->finalize (obj);
}


GType schema_enum_value_get_type (void) {
	static volatile gsize schema_enum_value_type_id__volatile = 0;
	if (g_once_init_enter (&schema_enum_value_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SchemaEnumValueClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) schema_enum_value_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SchemaEnumValue), 0, (GInstanceInitFunc) schema_enum_value_instance_init, NULL };
		GType schema_enum_value_type_id;
		schema_enum_value_type_id = g_type_register_static (G_TYPE_OBJECT, "SchemaEnumValue", &g_define_type_info, 0);
		g_once_init_leave (&schema_enum_value_type_id__volatile, schema_enum_value_type_id);
	}
	return schema_enum_value_type_id__volatile;
}


static gpointer _schema_list_ref0 (gpointer self) {
	return self ? schema_list_ref (self) : NULL;
}


SchemaEnum* schema_enum_construct (GType object_type, SchemaList* list, xmlNode* node) {
	SchemaEnum* self;
	SchemaList* _tmp0_;
	g_return_val_if_fail (list != NULL, NULL);
	self = (SchemaEnum*) g_type_create_instance (object_type);
	self->list = (_tmp0_ = _schema_list_ref0 (list), _schema_list_unref0 (self->list), _tmp0_);
	{
		xmlAttr* prop;
		prop = node->properties;
		{
			gboolean _tmp1_;
			_tmp1_ = TRUE;
			while (TRUE) {
				if (!_tmp1_) {
					prop = prop->next;
				}
				_tmp1_ = FALSE;
				if (!(prop != NULL)) {
					break;
				}
				if (_vala_strcmp0 (prop->name, "id") == 0) {
					char* _tmp2_;
					self->id = (_tmp2_ = g_strdup (prop->children->content), _g_free0 (self->id), _tmp2_);
				}
			}
		}
	}
	{
		xmlNode* child;
		child = node->children;
		{
			gboolean _tmp3_;
			_tmp3_ = TRUE;
			while (TRUE) {
				if (!_tmp3_) {
					child = child->next;
				}
				_tmp3_ = FALSE;
				if (!(child != NULL)) {
					break;
				}
				if (_vala_strcmp0 (child->name, "value") == 0) {
					char* nick;
					gint value;
					SchemaEnumValue* schema_value;
					nick = NULL;
					value = -1;
					{
						xmlAttr* prop;
						prop = child->properties;
						{
							gboolean _tmp4_;
							_tmp4_ = TRUE;
							while (TRUE) {
								if (!_tmp4_) {
									prop = prop->next;
								}
								_tmp4_ = FALSE;
								if (!(prop != NULL)) {
									break;
								}
								if (_vala_strcmp0 (prop->name, "value") == 0) {
									value = atoi (prop->children->content);
								} else {
									if (_vala_strcmp0 (prop->name, "nick") == 0) {
										char* _tmp5_;
										nick = (_tmp5_ = g_strdup (prop->children->content), _g_free0 (nick), _tmp5_);
									}
								}
							}
						}
					}
					schema_value = schema_enum_value_new (self, gee_collection_get_size ((GeeCollection*) self->values), nick, value);
					gee_abstract_collection_add ((GeeAbstractCollection*) self->values, schema_value);
					_g_free0 (nick);
					_g_object_unref0 (schema_value);
				}
			}
		}
	}
	return self;
}


SchemaEnum* schema_enum_new (SchemaList* list, xmlNode* node) {
	return schema_enum_construct (TYPE_SCHEMA_ENUM, list, node);
}


static void value_schema_enum_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_schema_enum_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		schema_enum_unref (value->data[0].v_pointer);
	}
}


static void value_schema_enum_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = schema_enum_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_schema_enum_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_schema_enum_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		SchemaEnum* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = schema_enum_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_schema_enum_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	SchemaEnum** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags && G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = schema_enum_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_schema_enum (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecSchemaEnum* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_SCHEMA_ENUM), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_schema_enum (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SCHEMA_ENUM), NULL);
	return value->data[0].v_pointer;
}


void value_set_schema_enum (GValue* value, gpointer v_object) {
	SchemaEnum* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SCHEMA_ENUM));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SCHEMA_ENUM));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		schema_enum_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		schema_enum_unref (old);
	}
}


void value_take_schema_enum (GValue* value, gpointer v_object) {
	SchemaEnum* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SCHEMA_ENUM));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SCHEMA_ENUM));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		schema_enum_unref (old);
	}
}


static void schema_enum_class_init (SchemaEnumClass * klass) {
	schema_enum_parent_class = g_type_class_peek_parent (klass);
	SCHEMA_ENUM_CLASS (klass)->finalize = schema_enum_finalize;
}


static void schema_enum_instance_init (SchemaEnum * self) {
	self->values = gee_array_list_new (TYPE_SCHEMA_ENUM_VALUE, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL);
	self->ref_count = 1;
}


static void schema_enum_finalize (SchemaEnum* obj) {
	SchemaEnum * self;
	self = SCHEMA_ENUM (obj);
	_schema_list_unref0 (self->list);
	_g_free0 (self->id);
	_g_object_unref0 (self->values);
}


GType schema_enum_get_type (void) {
	static volatile gsize schema_enum_type_id__volatile = 0;
	if (g_once_init_enter (&schema_enum_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_schema_enum_init, value_schema_enum_free_value, value_schema_enum_copy_value, value_schema_enum_peek_pointer, "p", value_schema_enum_collect_value, "p", value_schema_enum_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (SchemaEnumClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) schema_enum_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SchemaEnum), 0, (GInstanceInitFunc) schema_enum_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType schema_enum_type_id;
		schema_enum_type_id = g_type_register_fundamental (g_type_fundamental_next (), "SchemaEnum", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&schema_enum_type_id__volatile, schema_enum_type_id);
	}
	return schema_enum_type_id__volatile;
}


gpointer schema_enum_ref (gpointer instance) {
	SchemaEnum* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void schema_enum_unref (gpointer instance) {
	SchemaEnum* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		SCHEMA_ENUM_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


Schema* schema_construct (GType object_type, SchemaList* list, xmlNode* node, const char* gettext_domain) {
	Schema* self;
	SchemaList* _tmp0_;
	g_return_val_if_fail (list != NULL, NULL);
	self = (Schema*) g_type_create_instance (object_type);
	self->list = (_tmp0_ = _schema_list_ref0 (list), _schema_list_unref0 (self->list), _tmp0_);
	{
		xmlAttr* prop;
		prop = node->properties;
		{
			gboolean _tmp1_;
			_tmp1_ = TRUE;
			while (TRUE) {
				if (!_tmp1_) {
					prop = prop->next;
				}
				_tmp1_ = FALSE;
				if (!(prop != NULL)) {
					break;
				}
				if (_vala_strcmp0 (prop->name, "id") == 0) {
					char* _tmp2_;
					self->id = (_tmp2_ = g_strdup (prop->children->content), _g_free0 (self->id), _tmp2_);
				} else {
					if (_vala_strcmp0 (prop->name, "path") == 0) {
						char* _tmp3_;
						self->path = (_tmp3_ = g_strdup (prop->children->content), _g_free0 (self->path), _tmp3_);
					} else {
						if (_vala_strcmp0 (prop->name, "gettext-domain") == 0) {
							gettext_domain = prop->children->content;
						}
					}
				}
			}
		}
	}
	{
		xmlNode* child;
		child = node->children;
		{
			gboolean _tmp4_;
			_tmp4_ = TRUE;
			while (TRUE) {
				SchemaKey* key;
				if (!_tmp4_) {
					child = child->next;
				}
				_tmp4_ = FALSE;
				if (!(child != NULL)) {
					break;
				}
				if (_vala_strcmp0 (child->name, "key") != 0) {
					continue;
				}
				key = schema_key_new (child, self, gettext_domain);
				gee_abstract_map_set ((GeeAbstractMap*) self->keys, key->name, key);
				_schema_key_unref0 (key);
			}
		}
	}
	return self;
}


Schema* schema_new (SchemaList* list, xmlNode* node, const char* gettext_domain) {
	return schema_construct (TYPE_SCHEMA, list, node, gettext_domain);
}


static void value_schema_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_schema_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		schema_unref (value->data[0].v_pointer);
	}
}


static void value_schema_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = schema_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_schema_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_schema_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		Schema* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = schema_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_schema_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	Schema** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags && G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = schema_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_schema (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecSchema* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_SCHEMA), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_schema (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SCHEMA), NULL);
	return value->data[0].v_pointer;
}


void value_set_schema (GValue* value, gpointer v_object) {
	Schema* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SCHEMA));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SCHEMA));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		schema_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		schema_unref (old);
	}
}


void value_take_schema (GValue* value, gpointer v_object) {
	Schema* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SCHEMA));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SCHEMA));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		schema_unref (old);
	}
}


static void schema_class_init (SchemaClass * klass) {
	schema_parent_class = g_type_class_peek_parent (klass);
	SCHEMA_CLASS (klass)->finalize = schema_finalize;
}


static void schema_instance_init (Schema * self) {
	self->keys = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, TYPE_SCHEMA_KEY, (GBoxedCopyFunc) schema_key_ref, schema_key_unref, NULL, NULL, NULL);
	self->ref_count = 1;
}


static void schema_finalize (Schema* obj) {
	Schema * self;
	self = SCHEMA (obj);
	_schema_list_unref0 (self->list);
	_g_free0 (self->id);
	_g_free0 (self->path);
	_g_object_unref0 (self->keys);
}


GType schema_get_type (void) {
	static volatile gsize schema_type_id__volatile = 0;
	if (g_once_init_enter (&schema_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_schema_init, value_schema_free_value, value_schema_copy_value, value_schema_peek_pointer, "p", value_schema_collect_value, "p", value_schema_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (SchemaClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) schema_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Schema), 0, (GInstanceInitFunc) schema_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType schema_type_id;
		schema_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Schema", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&schema_type_id__volatile, schema_type_id);
	}
	return schema_type_id__volatile;
}


gpointer schema_ref (gpointer instance) {
	Schema* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void schema_unref (gpointer instance) {
	Schema* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		SCHEMA_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


void schema_list_parse_file (SchemaList* self, const char* path) {
	xmlDoc* doc;
	xmlNode* root;
	char* gettext_domain;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	doc = xmlParseFile (path);
	if (doc == NULL) {
		return;
	}
	root = xmlDocGetRootElement (doc);
	if (root == NULL) {
		return;
	}
	if (_vala_strcmp0 (root->name, "schemalist") != 0) {
		return;
	}
	gettext_domain = NULL;
	{
		xmlAttr* prop;
		prop = root->properties;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				if (!_tmp0_) {
					prop = prop->next;
				}
				_tmp0_ = FALSE;
				if (!(prop != NULL)) {
					break;
				}
				if (_vala_strcmp0 (prop->name, "gettext-domain") == 0) {
					char* _tmp1_;
					gettext_domain = (_tmp1_ = g_strdup (prop->children->content), _g_free0 (gettext_domain), _tmp1_);
				}
			}
		}
	}
	{
		xmlNode* node;
		node = root->children;
		{
			gboolean _tmp2_;
			_tmp2_ = TRUE;
			while (TRUE) {
				if (!_tmp2_) {
					node = node->next;
				}
				_tmp2_ = FALSE;
				if (!(node != NULL)) {
					break;
				}
				if (_vala_strcmp0 (node->name, "schema") == 0) {
					Schema* schema;
					schema = schema_new (self, node, gettext_domain);
					gee_abstract_collection_add ((GeeAbstractCollection*) self->schemas, schema);
					if (schema->path == NULL) {
						_schema_unref0 (schema);
						continue;
					}
					{
						GeeCollection* _tmp3_;
						GeeIterator* _tmp4_;
						GeeIterator* _key_it;
						_key_it = (_tmp4_ = gee_iterable_iterator ((GeeIterable*) (_tmp3_ = gee_map_get_values ((GeeMap*) schema->keys))), _g_object_unref0 (_tmp3_), _tmp4_);
						while (TRUE) {
							SchemaKey* key;
							char* full_name;
							if (!gee_iterator_next (_key_it)) {
								break;
							}
							key = (SchemaKey*) gee_iterator_get (_key_it);
							full_name = g_strconcat (schema->path, key->name, NULL);
							gee_abstract_map_set ((GeeAbstractMap*) self->keys, full_name, key);
							_schema_key_unref0 (key);
							_g_free0 (full_name);
						}
						_g_object_unref0 (_key_it);
					}
					_schema_unref0 (schema);
				} else {
					if (_vala_strcmp0 (node->name, "enum") == 0) {
						SchemaEnum* _enum_;
						_enum_ = schema_enum_new (self, node);
						gee_abstract_map_set ((GeeAbstractMap*) self->enums, _enum_->id, _enum_);
						_schema_enum_unref0 (_enum_);
					}
				}
			}
		}
	}
	xmlFreeDoc (doc);
	_g_free0 (gettext_domain);
}


void schema_list_load_directory (SchemaList* self, const char* dir, GError** error) {
	GError * _inner_error_;
	GFile* directory;
	GFileEnumerator* i;
	GFileInfo* info;
	g_return_if_fail (self != NULL);
	g_return_if_fail (dir != NULL);
	_inner_error_ = NULL;
	directory = g_file_new_for_path (dir);
	i = g_file_enumerate_children (directory, G_FILE_ATTRIBUTE_STANDARD_NAME, 0, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (directory);
		return;
	}
	info = NULL;
	while (TRUE) {
		GFileInfo* _tmp0_;
		GFileInfo* _tmp1_;
		char* name;
		char* path;
		_tmp0_ = g_file_enumerator_next_file (i, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (directory);
			_g_object_unref0 (i);
			_g_object_unref0 (info);
			return;
		}
		if (!((info = (_tmp1_ = _tmp0_, _g_object_unref0 (info), _tmp1_)) != NULL)) {
			break;
		}
		name = g_strdup (g_file_info_get_name (info));
		if (!g_str_has_suffix (name, ".gschema.xml")) {
			_g_free0 (name);
			continue;
		}
		path = g_build_filename (dir, name, NULL, NULL);
		g_debug ("dconf-schema.vala:235: Loading schema: %s", path);
		schema_list_parse_file (self, path);
		_g_free0 (name);
		_g_free0 (path);
	}
	_g_object_unref0 (directory);
	_g_object_unref0 (i);
	_g_object_unref0 (info);
}


SchemaList* schema_list_construct (GType object_type) {
	SchemaList* self;
	self = (SchemaList*) g_type_create_instance (object_type);
	return self;
}


SchemaList* schema_list_new (void) {
	return schema_list_construct (TYPE_SCHEMA_LIST);
}


static void value_schema_list_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_schema_list_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		schema_list_unref (value->data[0].v_pointer);
	}
}


static void value_schema_list_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = schema_list_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_schema_list_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_schema_list_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		SchemaList* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = schema_list_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_schema_list_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	SchemaList** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags && G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = schema_list_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_schema_list (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecSchemaList* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_SCHEMA_LIST), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_schema_list (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SCHEMA_LIST), NULL);
	return value->data[0].v_pointer;
}


void value_set_schema_list (GValue* value, gpointer v_object) {
	SchemaList* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SCHEMA_LIST));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SCHEMA_LIST));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		schema_list_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		schema_list_unref (old);
	}
}


void value_take_schema_list (GValue* value, gpointer v_object) {
	SchemaList* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SCHEMA_LIST));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SCHEMA_LIST));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		schema_list_unref (old);
	}
}


static void schema_list_class_init (SchemaListClass * klass) {
	schema_list_parent_class = g_type_class_peek_parent (klass);
	SCHEMA_LIST_CLASS (klass)->finalize = schema_list_finalize;
}


static void schema_list_instance_init (SchemaList * self) {
	self->schemas = gee_array_list_new (TYPE_SCHEMA, (GBoxedCopyFunc) schema_ref, schema_unref, NULL);
	self->keys = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, TYPE_SCHEMA_KEY, (GBoxedCopyFunc) schema_key_ref, schema_key_unref, NULL, NULL, NULL);
	self->enums = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, TYPE_SCHEMA_ENUM, (GBoxedCopyFunc) schema_enum_ref, schema_enum_unref, NULL, NULL, NULL);
	self->ref_count = 1;
}


static void schema_list_finalize (SchemaList* obj) {
	SchemaList * self;
	self = SCHEMA_LIST (obj);
	_g_object_unref0 (self->schemas);
	_g_object_unref0 (self->keys);
	_g_object_unref0 (self->enums);
}


GType schema_list_get_type (void) {
	static volatile gsize schema_list_type_id__volatile = 0;
	if (g_once_init_enter (&schema_list_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_schema_list_init, value_schema_list_free_value, value_schema_list_copy_value, value_schema_list_peek_pointer, "p", value_schema_list_collect_value, "p", value_schema_list_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (SchemaListClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) schema_list_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SchemaList), 0, (GInstanceInitFunc) schema_list_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType schema_list_type_id;
		schema_list_type_id = g_type_register_fundamental (g_type_fundamental_next (), "SchemaList", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&schema_list_type_id__volatile, schema_list_type_id);
	}
	return schema_list_type_id__volatile;
}


gpointer schema_list_ref (gpointer instance) {
	SchemaList* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void schema_list_unref (gpointer instance) {
	SchemaList* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		SCHEMA_LIST_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




