/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * This file is part of capuchin-glib. 
 *
 * Copyright (C) Sebastian Pölsterl 2008 <marduk@k-d-w.org>
 * 
 * capuchin-glib is free software.
 * 
 * You may redistribute it and/or modify it under the terms of the
 * GNU General Public License, as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option)
 * any later version.
 * 
 * capuchin-glib is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with capuchin-glib.
 * If not, see <http://www.gnu.org/licenses/>.
 */

#include <capuchin-glib/capuchin-g-plugin-author.h>

struct _CapuchinGPluginAuthorPrivate
{
	gchar* name;
	gchar* email;
};

#define CAPUCHIN_G_PLUGIN_AUTHOR_PRIVATE(o)  (G_TYPE_INSTANCE_GET_PRIVATE ((o), CAPUCHIN_TYPE_G_PLUGIN_AUTHOR, CapuchinGPluginAuthorPrivate))

enum
{
	PROP_0,

	PROP_NAME,
	PROP_EMAIL
};



G_DEFINE_TYPE (CapuchinGPluginAuthor, capuchin_g_plugin_author, G_TYPE_OBJECT);

static void
capuchin_g_plugin_author_init (CapuchinGPluginAuthor *object)
{
	object->priv = CAPUCHIN_G_PLUGIN_AUTHOR_PRIVATE (object);
	object->priv->name = NULL;
	object->priv->email = NULL;
}

static void
capuchin_g_plugin_author_finalize (GObject *object)
{
	CapuchinGPluginAuthor *author;
	
	author = CAPUCHIN_G_PLUGIN_AUTHOR (object);
	
	g_free (author->priv->name);
	g_free (author->priv->email);

	G_OBJECT_CLASS (capuchin_g_plugin_author_parent_class)->finalize (object);
}

static void
capuchin_g_plugin_author_set_property (GObject *object, guint prop_id, const GValue *value, GParamSpec *pspec)
{
	CapuchinGPluginAuthor *author;
	
	g_return_if_fail (CAPUCHIN_IS_G_PLUGIN_AUTHOR (object));
	
	author = CAPUCHIN_G_PLUGIN_AUTHOR (object);

	switch (prop_id)
	{
	case PROP_NAME:
		g_free (author->priv->name);
		author->priv->name = g_value_dup_string (value);
		break;
	case PROP_EMAIL:
		g_free (author->priv->email);
		author->priv->email = g_value_dup_string (value);
		break;
	default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, prop_id, pspec);
		break;
	}
}

static void
capuchin_g_plugin_author_get_property (GObject *object, guint prop_id, GValue *value, GParamSpec *pspec)
{
	CapuchinGPluginAuthor *author;
	
	g_return_if_fail (CAPUCHIN_IS_G_PLUGIN_AUTHOR (object));

	author = CAPUCHIN_G_PLUGIN_AUTHOR (object);
	
	switch (prop_id)
	{
	case PROP_NAME:
		g_value_set_string (value, author->priv->name);
		break;
	case PROP_EMAIL:
		g_value_set_string (value, author->priv->email);
		break;
	default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, prop_id, pspec);
		break;
	}
}

static void
capuchin_g_plugin_author_class_init (CapuchinGPluginAuthorClass *klass)
{
	GObjectClass* object_class = G_OBJECT_CLASS (klass);
	GObjectClass* parent_class = G_OBJECT_CLASS (klass);

	g_type_class_add_private (klass, sizeof (CapuchinGPluginAuthorPrivate));

	object_class->finalize = capuchin_g_plugin_author_finalize;
	object_class->set_property = capuchin_g_plugin_author_set_property;
	object_class->get_property = capuchin_g_plugin_author_get_property;

	g_object_class_install_property (object_class,
	                                 PROP_NAME,
	                                 g_param_spec_string ("name",
	                                                      "Author's name",
	                                                      "The name of the author",
	                                                      NULL,
	                                                      G_PARAM_READABLE | G_PARAM_WRITABLE));

	g_object_class_install_property (object_class,
	                                 PROP_EMAIL,
	                                 g_param_spec_string ("email",
	                                                      "Author's e-mail",
	                                                      "The e-mail of the author",
	                                                      NULL,
	                                                      G_PARAM_READABLE | G_PARAM_WRITABLE));
}

/**
  * capuchin_g_plugin_author_new
  * @name: Author's name
  * @email: Author's e-mail
  * @returns: #CapuchinGPluginAuthor object
  *
  * Create new #CapuchinGPluginAuthor object
  */
CapuchinGPluginAuthor*
capuchin_g_plugin_author_new (const gchar *name, const gchar *email)
{
	CapuchinGPluginAuthor *author;
	
	author = g_object_new (CAPUCHIN_TYPE_G_PLUGIN_AUTHOR,
						   "name", name,
						   "email", email,
						   NULL);
	
	return author;
}
