/*
 * Simple-EFS driver: Block allocation routines
 *
 * Author:
 *   Dietmar Maurer (dm@vlsivie.tuwien.ac.at)
 *
 *
 */

#include "simple.h"

guint32
simple_block_alloc(EFS *efs)
{
	SimpleEFS *sefs;
	guint b,i,j,k,rb,bc,sb;

	g_return_val_if_fail(efs != NULL, 0);

	sefs = (SimpleEFS *)efs->pdata;
	sb = sefs->head.cb/(512*8);
	for (b=sb;b<sefs->bmap.mbc;b++) if (sefs->bmap.fbc[b]>0) {
		for (i=0;i<128;i++) if (sefs->bmap.data[b][i]!=0xffffffff) {
			k = 1<<31;
			for (j=0;j<32;j++) {
				rb = b*512*8+i*32+j;
				if (rb < sefs->head.cb) {
					k=k>>1;
					continue;
				}
				if ((sefs->bmap.data[b][i]&k) == 0) {
					sefs->bmap.data[b][i] |= k;
					sefs->bmap.modified = TRUE;
					sefs->bmap.fbc[b]--;
					bc = sefs->head.block_count;
					sefs->head.block_count = MAX(bc,rb+1);
					return rb;
				}
				k=k>>1;
			}
		}
	}
	
	/* alloc one at the end of the file */

	i = sefs->head.block_count;
	sefs->head.block_count++;
	if (sefs->head.block_count>=(sefs->bmap.mbc*512*8)) {
		sefs->bmap.data[sefs->bmap.mbc] = g_malloc0(512);
		sefs->bmap.fbc[sefs->bmap.mbc] = 512*8;
		sefs->bmap.mbc++;
	}

	b = i/(512*8);
	j = (i%(512*8))/32;
	k = 1 << (31-(i%(512*8))%32);
	
	sefs->bmap.data[b][j] |= k;
	sefs->bmap.modified = TRUE;
	sefs->bmap.fbc[b]--;
	return i;	
}

void   
simple_block_free (EFS *efs, guint32 block)
{
	SimpleEFS *sefs;
	guint b,j,k;

	g_return_if_fail(efs != NULL);
	g_return_if_fail (block != 0);

	sefs = (SimpleEFS *)efs->pdata;

	b = block/(512*8);
	j = (block%(512*8))/32;
	k = 1 << (31-(block%(512*8))%32);

	if (sefs->bmap.data[b]) {
		if (!(sefs->bmap.data[b][j]&k)) {
			printf("block_free: block %d %08x %p not allocated!\n",block,
			       sefs->bmap.data[b][j],&sefs->bmap.data[b][j]);
			return;
		}

		sefs->bmap.data[b][j] &= ~k;
		sefs->bmap.modified = TRUE;
		sefs->bmap.fbc[b]++;
	}
}

gint
simple_write_bmap (EFS *efs)
{
	SimpleEFS *sefs;
	gint i, j, rb, nb, sb;
	EFSCacheEntry *ce;
	guint32 *buf;

	g_return_val_if_fail(efs != NULL, -1);

	sefs = (SimpleEFS *)efs->pdata;

	rb = (sefs->head.block_count+512*8-1)/(512*8);
	sb = 0;

	/* allocate blocks first */
	for (i = 0; i<rb; i++) {
		if (!(nb = simple_block_alloc (efs))) return -1;
		if (!i) sb = nb;
		else if (nb != (sb+i)) return -1;
	}

	for (i = 0; i<rb; i++) {
		if (!(ce = efs_cache_map (efs, sb+i, 0, 0, FALSE))) return -1;
		buf = (guint32 *)ce->data;
		for (j=0;j<128;j++) 
			buf[j] = GUINT32_TO_LE(sefs->bmap.data[i][j]);
		efs_cache_touch(ce, TRUE);
		//efs_unmap (efs, ce);
		//ce->dirty = FALSE;
	}
 
	sefs->head.bmap_start = sb;
	sefs->head.bmap_length= rb;
	sefs->bmap.modified = FALSE;

	return 0;
}

