/*
 * gnome-storage-efs.c: libefs based Storage implementation
 *
 * Author:
 *   Dietmar Maurer (dm@vlsivie.tuwien.ac.at)
 *
 *
 * Problems:
 *
 * do we really need open and create functions? maybe we can use open and
 * a special flag O_CREATE (like in stdio)
 *
 * storage_copy_to: ??? 
 *      idl: copy_to (in string path, in Storage dest, is string new_path)
 *
 * list_contents: bad interface! redesign necessary?
 *
 */

#include <config.h>
#include <efs.h>
#include <storage-modules/gnome-storage-efs.h>
#include <storage-modules/gnome-stream-efs.h>

/*
 * Creates and activates the corba server 
 */
static BonoboStorage *
create_storage_efs_server (const BonoboStorageEFS *storage_efs)
{
	BonoboObject *object = BONOBO_OBJECT(storage_efs);
	POA_Bonobo_Storage *servant;
	Bonobo_Storage corba_storage;
	CORBA_Environment ev;

	servant = (POA_Bonobo_Storage *) g_new0 (BonoboObjectServant, 1);
	servant->vepv = &bonobo_storage_vepv;

	CORBA_exception_init (&ev);
	POA_Bonobo_Storage__init ((PortableServer_Servant) servant, 
				 &ev);
	if (ev._major != CORBA_NO_EXCEPTION){
		g_free (servant);
		CORBA_exception_free (&ev);
		return NULL;
	}
	CORBA_exception_free (&ev);

	corba_storage = bonobo_object_activate_servant(object, servant);
	return bonobo_storage_construct(BONOBO_STORAGE(storage_efs), 
				       corba_storage);
}

static void
bonobo_storage_efs_destroy (GtkObject *object)
{
	BonoboStorageEFS *storage_efs = BONOBO_STORAGE_EFS (object);

	
	if (storage_efs->owner) {
		if (storage_efs->dir) efs_dir_close(storage_efs->dir);
		gtk_object_unref (GTK_OBJECT (storage_efs->owner));    
	} else {
		if (storage_efs->dir) efs_close (storage_efs->dir);
	}
}


static BonoboStream *
real_create_stream (BonoboStorage *storage, const CORBA_char *path, 
		    CORBA_Environment *ev)
{
	BonoboStorageEFS *storage_efs = BONOBO_STORAGE_EFS (storage);

	return bonobo_stream_efs_create (storage_efs, path);
}

static BonoboStream *
real_open_stream (BonoboStorage *storage, const CORBA_char *path, 
		  Bonobo_Storage_OpenMode mode, CORBA_Environment *ev)
{
	BonoboStorageEFS *storage_efs = BONOBO_STORAGE_EFS (storage);
	
	return bonobo_stream_efs_open (storage_efs, path, mode);
}


static BonoboStorage *
real_create_storage (BonoboStorage *storage, const CORBA_char *path, 
		     CORBA_Environment *ev)
{
	BonoboStorageEFS *storage_efs = BONOBO_STORAGE_EFS (storage);
	BonoboStorageEFS *sefs;
	EFSDir *dir;

	if (!(dir=efs_dir_open(storage_efs->dir, path, EFS_CREATE|EFS_EXCL))) {
		CORBA_exception_set(ev, CORBA_USER_EXCEPTION, 
				    ex_Bonobo_Storage_NameExists, NULL);
		return NULL;
	}
	
	sefs = gtk_type_new (bonobo_storage_efs_get_type ());
	sefs->dir = dir;
	sefs->owner = storage;
	gtk_object_ref(GTK_OBJECT(storage));
	create_storage_efs_server(sefs);

	return BONOBO_STORAGE(sefs);
}

static BonoboStorage *
real_open_storage (BonoboStorage *storage, const CORBA_char *path, 
		   CORBA_Environment *ev)
{
	BonoboStorageEFS *storage_efs = BONOBO_STORAGE_EFS (storage);
	BonoboStorageEFS *sefs;
	EFSDir *dir;

	if (!(dir=efs_dir_open(storage_efs->dir, path, 0))) {
		CORBA_exception_set(ev, CORBA_USER_EXCEPTION, 
				    ex_Bonobo_Storage_NotFound, NULL);
		return NULL;
	}

	sefs = gtk_type_new (bonobo_storage_efs_get_type ());
	sefs->dir = dir;
	sefs->owner = storage;
	gtk_object_ref(GTK_OBJECT(storage));
	create_storage_efs_server(sefs);

	return BONOBO_STORAGE(sefs);
}

static void
real_copy_to (BonoboStorage *storage, Bonobo_Storage target, 
	      CORBA_Environment *ev)
{	
	g_warning ("Not yet implemented");
}

static void
real_rename (BonoboStorage *storage, const CORBA_char *path, 
	     const CORBA_char *new_path, CORBA_Environment *ev)
{
	BonoboStorageEFS *storage_efs = BONOBO_STORAGE_EFS (storage);

	if (!efs_rename(storage_efs->dir, path, new_path)) {
		CORBA_exception_set(ev, CORBA_USER_EXCEPTION, 
				    ex_Bonobo_Storage_NotFound, NULL);
	}
}

static void
real_commit (BonoboStorage *storage, CORBA_Environment *ev)
{
	BonoboStorageEFS *storage_efs = BONOBO_STORAGE_EFS (storage);

	if (storage_efs->owner) return;

	efs_commit(storage_efs->dir);
}


static Bonobo_Storage_directory_list *
real_list_contents (BonoboStorage *storage, const CORBA_char *path, 
		    CORBA_Environment *ev)
{
	BonoboStorageEFS *storage_efs = BONOBO_STORAGE_EFS (storage);
	Bonobo_Storage_directory_list *list;
	EFSDirEntry *de;
	EFSDir *dir;
	int i;
	char **buf = NULL;
	char *n1;

	list =  Bonobo_Storage_directory_list__alloc();
	CORBA_sequence_set_release (list, TRUE); 
	buf = CORBA_sequence_CORBA_string_allocbuf(100); /*fixme: max 100*/

	if ((dir = efs_dir_open(storage_efs->dir, path, 0))) {
		i = 0;
		while ((de = efs_dir_read(dir))) {
			n1 = CORBA_string_alloc(strlen(de->name));
			strcpy(n1,de->name);
			buf[i]=n1;
			i++;
		}
		list->_length = i;
		list->_buffer = buf;
		efs_dir_close (dir);
		return list;
	} else {
		CORBA_exception_set(ev, CORBA_USER_EXCEPTION, 
				    ex_Bonobo_Storage_NotFound, NULL);
		return NULL;
	}
}


static void
real_erase (BonoboStorage *storage, const CORBA_char *path,
	    CORBA_Environment *ev)
{
	BonoboStorageEFS *storage_efs = BONOBO_STORAGE_EFS (storage);

	if (!efs_erase (storage_efs->dir, path)) {
		CORBA_exception_set(ev, CORBA_USER_EXCEPTION, 
				    ex_Bonobo_Storage_NotFound, NULL);
	}
}

static void
bonobo_storage_efs_class_init (BonoboStorageEFSClass *class)
{
	GtkObjectClass *object_class = (GtkObjectClass *) class;
	BonoboStorageClass *sclass = BONOBO_STORAGE_CLASS (class);

	sclass->create_stream  = real_create_stream;
	sclass->open_stream    = real_open_stream;

	sclass->create_storage = real_create_storage;
	sclass->open_storage   = real_open_storage;
	sclass->copy_to        = real_copy_to;
	sclass->rename         = real_rename;
	sclass->commit         = real_commit;
	sclass->list_contents  = real_list_contents;
	sclass->erase          = real_erase;

	object_class->destroy = bonobo_storage_efs_destroy;
}

GtkType
bonobo_storage_efs_get_type (void)
{
	static GtkType type = 0;
  
	if (!type){
		GtkTypeInfo info = {
			"IDL:GNOME/StorageEFS:1.0",
			sizeof (BonoboStorageEFS),
			sizeof (BonoboStorageEFSClass),
			(GtkClassInitFunc) bonobo_storage_efs_class_init,
			(GtkObjectInitFunc) NULL,
			NULL, /* reserved 1 */
			NULL, /* reserved 2 */
			(GtkClassInitFunc) NULL
		};

		type = gtk_type_unique (bonobo_storage_get_type (), &info);
	}

	return type;
}

/** 
 * bonobo_storage_efs_open:
 * @path: path to a file that represents the storage
 * @flags: flags
 * @mode: mode
 *
 * Opens a BonoboStorage object in @path. The storage opened is an activated
 * CORBA server for this storage.
 *
 * Returns the BonoboStorage GTK object.
 */
BonoboStorage *
bonobo_storage_efs_open (const gchar *path, gint flags, gint mode)
{
	BonoboStorageEFS *sefs;

	sefs = gtk_type_new (bonobo_storage_efs_get_type ());

	if (!(sefs->dir = efs_open(path, flags, mode))) {
		bonobo_object_destroy (BONOBO_OBJECT (sefs));
		return NULL;
	}
    
	if (!create_storage_efs_server(sefs)) {
		bonobo_object_destroy (BONOBO_OBJECT (sefs));
		return NULL;
	}

	return BONOBO_STORAGE(sefs);
}

/*
 * Shared library entry point
 */
BonoboStorage *
bonobo_storage_driver_open (const gchar *path, gint flags, gint mode)
{
	gint efs_flags = 0;

	if (flags & BONOBO_SS_READ)
		efs_flags |= EFS_READ;
	if (flags & BONOBO_SS_WRITE)
		efs_flags |= EFS_WRITE;
	if (flags & BONOBO_SS_RDWR)
		efs_flags |= EFS_RDWR;
	if (flags & BONOBO_SS_CREATE)
		efs_flags |= EFS_CREATE;
	if (flags & BONOBO_SS_EXCL)
		efs_flags |= EFS_EXCL;
	
	return bonobo_storage_efs_open (path, efs_flags, mode);
}

